#import <Foundation/NSArray.h>
#import <Foundation/NSDictionary.h>
#import <Foundation/NSError.h>
#import <Foundation/NSObject.h>
#import <Foundation/NSSet.h>
#import <Foundation/NSString.h>
#import <Foundation/NSValue.h>

@class LAContext, MultipazASN1, MultipazASN1BitString, MultipazASN1BitStringCompanion, MultipazASN1Boolean, MultipazASN1BooleanCompanion, MultipazASN1Encoding, MultipazASN1EncodingCompanion, MultipazASN1Integer, MultipazASN1IntegerCompanion, MultipazASN1IntegerTag, MultipazASN1Null, MultipazASN1NullCompanion, MultipazASN1Object, MultipazASN1ObjectIdentifier, MultipazASN1ObjectIdentifierCompanion, MultipazASN1OctetString, MultipazASN1OctetStringCompanion, MultipazASN1PrimitiveValue, MultipazASN1Sequence, MultipazASN1SequenceCompanion, MultipazASN1Set, MultipazASN1SetCompanion, MultipazASN1String, MultipazASN1StringCompanion, MultipazASN1StringTag, MultipazASN1TagClass, MultipazASN1TagClassCompanion, MultipazASN1TaggedObject, MultipazASN1TaggedObjectCompanion, MultipazASN1Time, MultipazASN1TimeCompanion, MultipazASN1TimeTag, MultipazAlgorithm, MultipazAlgorithmCompanion, MultipazAndroidAttestationExtensionParserCompanion, MultipazAndroidAttestationExtensionParserSecurityLevel, MultipazAndroidAttestationExtensionParserVerifiedBootState, MultipazArrayBuilder<T>, MultipazAssertion, MultipazAssertionBindingKeys, MultipazAssertionCompanion, MultipazAssertionGenericCbor, MultipazAssertionNonce, MultipazAssertionPoPKey, MultipazAssertionRpcAuth, MultipazBackendEnvironmentCompanion, MultipazBackendEnvironmentKey, MultipazBaseStorage, MultipazBaseStorageCompanion, MultipazBaseStorageSchemaTableSpec, MultipazBaseStorageStoppedClock, MultipazBaseStorageTable, MultipazBatchCreateKeyResult, MultipazBstr, MultipazBstrCompanion, MultipazByteDataReader, MultipazCbor, MultipazCborArray, MultipazCborArrayCompanion, MultipazCborBuilder, MultipazCborDouble, MultipazCborDoubleCompanion, MultipazCborFloat, MultipazCborFloatCompanion, MultipazCborInt, MultipazCborMap, MultipazCborMapCompanion, MultipazClaim, MultipazCloudAttestationExtension, MultipazCloudAttestationExtensionCompanion, MultipazCloudCreateKeySettings, MultipazCloudCreateKeySettingsBuilder, MultipazCloudKeyInfo, MultipazCloudKeyLockedExceptionReason, MultipazCloudSecureArea, MultipazCloudSecureAreaCompanion, MultipazCloudSecureAreaProtocol, MultipazCloudSecureAreaProtocolCheckPassphraseRequest, MultipazCloudSecureAreaProtocolCheckPassphraseResponse, MultipazCloudSecureAreaProtocolCommand, MultipazCloudSecureAreaProtocolCommandCompanion, MultipazCloudSecureAreaProtocolCreateKeyRequest0, MultipazCloudSecureAreaProtocolCreateKeyRequest1, MultipazCloudSecureAreaProtocolCreateKeyResponse0, MultipazCloudSecureAreaProtocolCreateKeyResponse1, MultipazCloudSecureAreaProtocolE2EERequest, MultipazCloudSecureAreaProtocolE2EEResponse, MultipazCloudSecureAreaProtocolE2EESetupRequest0, MultipazCloudSecureAreaProtocolE2EESetupRequest1, MultipazCloudSecureAreaProtocolE2EESetupResponse0, MultipazCloudSecureAreaProtocolE2EESetupResponse1, MultipazCloudSecureAreaProtocolKeyAgreementRequest0, MultipazCloudSecureAreaProtocolKeyAgreementRequest1, MultipazCloudSecureAreaProtocolKeyAgreementResponse0, MultipazCloudSecureAreaProtocolKeyAgreementResponse1, MultipazCloudSecureAreaProtocolRegisterRequest0, MultipazCloudSecureAreaProtocolRegisterRequest1, MultipazCloudSecureAreaProtocolRegisterResponse0, MultipazCloudSecureAreaProtocolRegisterResponse1, MultipazCloudSecureAreaProtocolRegisterStage2Request0, MultipazCloudSecureAreaProtocolRegisterStage2Response0, MultipazCloudSecureAreaProtocolSignRequest0, MultipazCloudSecureAreaProtocolSignRequest1, MultipazCloudSecureAreaProtocolSignResponse0, MultipazCloudSecureAreaProtocolSignResponse1, MultipazCloudUserAuthType, MultipazCloudUserAuthTypeCompanion, MultipazCommandApdu, MultipazCommandApduCompanion, MultipazConstants, MultipazCose, MultipazCoseKey, MultipazCoseKeyCompanion, MultipazCoseLabel, MultipazCoseLabelCompanion, MultipazCoseMac0, MultipazCoseMac0Companion, MultipazCoseNumberLabel, MultipazCoseSign1, MultipazCoseSign1Companion, MultipazCoseTextLabel, MultipazCreateKeySettings, MultipazCredential, MultipazCredentialCompanion, MultipazCredentialForPresentment, MultipazCredentialLoader, MultipazCrypto, MultipazDataItem, MultipazDeviceAssertion, MultipazDeviceAssertionCompanion, MultipazDeviceAttestation, MultipazDeviceAttestationAndroid, MultipazDeviceAttestationCompanion, MultipazDeviceAttestationIos, MultipazDeviceAttestationIosCompanion, MultipazDeviceAttestationJvm, MultipazDeviceAttestationResult, MultipazDeviceAttestationValidationData, MultipazDeviceCheck, MultipazDeviceRequestGenerator, MultipazDeviceRequestParser, MultipazDeviceRequestParserDeviceRequest, MultipazDeviceRequestParserDeviceRequestCompanion, MultipazDeviceRequestParserDocRequest, MultipazDeviceResponseGenerator, MultipazDeviceResponseParser, MultipazDeviceResponseParserDeviceResponse, MultipazDeviceResponseParserDeviceResponseCompanion, MultipazDeviceResponseParserDocument, MultipazDeviceResponseParserDocumentCompanion, MultipazDiagnosticOption, MultipazDigitalCredentialsDefault, MultipazDocument, MultipazDocumentAttribute, MultipazDocumentAttributeType, MultipazDocumentAttributeTypeBlob, MultipazDocumentAttributeTypeBoolean, MultipazDocumentAttributeTypeComplexType, MultipazDocumentAttributeTypeDate, MultipazDocumentAttributeTypeDateTime, MultipazDocumentAttributeTypeNumber, MultipazDocumentAttributeTypePicture, MultipazDocumentAttributeTypeString, MultipazDocumentCannedRequest, MultipazDocumentCompanion, MultipazDocumentEvent, MultipazDocumentGenerator, MultipazDocumentMetadataCompanion, MultipazDocumentRequest, MultipazDocumentRequestDataElement, MultipazDocumentStore, MultipazDocumentStoreCompanion, MultipazDocumentType, MultipazDocumentTypeBuilder, MultipazDocumentTypeRepository, MultipazDocumentUsableCredentialResult, MultipazDocumentUtil, MultipazDrivingLicense, MultipazEUCertificateOfResidence, MultipazEUPersonalID, MultipazEcCurve, MultipazEcCurveCompanion, MultipazEcPrivateKey, MultipazEcPrivateKeyCompanion, MultipazEcPrivateKeyDoubleCoordinate, MultipazEcPrivateKeyOkp, MultipazEcPublicKey, MultipazEcPublicKeyCompanion, MultipazEcPublicKeyDoubleCoordinate, MultipazEcPublicKeyDoubleCoordinateCompanion, MultipazEcPublicKeyOkp, MultipazEcSignature, MultipazEcSignatureCompanion, MultipazEngagementGenerator, MultipazEngagementGeneratorCompanion, MultipazEngagementParserEngagement, MultipazEngagementParserEngagementCompanion, MultipazEphemeralStorage, MultipazEphemeralStorageCompanion, MultipazEphemeralStorageEngine, MultipazEphemeralStorageEngineCompanion, MultipazEphemeralStorageItem, MultipazEphemeralStorageItemCompanion, MultipazFormatStyle, MultipazGenericStorageEngineCompanion, MultipazGermanPersonalID, MultipazHandoverRequestRecord, MultipazHandoverRequestRecordCompanion, MultipazHandoverSelectRecord, MultipazHandoverSelectRecordCompanion, MultipazHexUtil, MultipazHttpTransportCompanion, MultipazHttpTransportConnectionException, MultipazHttpTransportHttpClientException, MultipazIcon, MultipazIndefLengthBstr, MultipazIndefLengthBstrCompanion, MultipazIndefLengthTstr, MultipazIndefLengthTstrCompanion, MultipazIntegerOption, MultipazInvalidRequestException, MultipazInvalidRequestExceptionCompanion, MultipazIssuerNamespaces, MultipazIssuerNamespacesBuilder, MultipazIssuerNamespacesCompanion, MultipazIssuerNamespacesDataElementBuilder, MultipazIssuerNamespacesDataElements, MultipazIssuerSignedItem, MultipazIssuerSignedItemCompanion, MultipazJsonWebEncryption, MultipazJsonWebSignature, MultipazJsonWebSignatureJwsInfo, MultipazKeyAttestation, MultipazKeyAttestationCompanion, MultipazKeyBoundSdJwtVcCredential, MultipazKeyBoundSdJwtVcCredentialCompanion, MultipazKeyInfo, MultipazKeyLockedException, MultipazKeylessSdJwtVcCredential, MultipazKeylessSdJwtVcCredentialCompanion, MultipazKotlinAbstractCoroutineContextElement, MultipazKotlinAbstractCoroutineContextKey<B, E>, MultipazKotlinArray<T>, MultipazKotlinBooleanArray, MultipazKotlinBooleanIterator, MultipazKotlinByteArray, MultipazKotlinByteIterator, MultipazKotlinCancellationException, MultipazKotlinDurationCompanion, MultipazKotlinDurationUnit, MultipazKotlinEnum<E>, MultipazKotlinEnumCompanion, MultipazKotlinError, MultipazKotlinException, MultipazKotlinIllegalArgumentException, MultipazKotlinIllegalStateException, MultipazKotlinIntIterator, MultipazKotlinIntProgression, MultipazKotlinIntProgressionCompanion, MultipazKotlinIntRange, MultipazKotlinIntRangeCompanion, MultipazKotlinKTypeProjection, MultipazKotlinKTypeProjectionCompanion, MultipazKotlinKVariance, MultipazKotlinLongIterator, MultipazKotlinLongProgression, MultipazKotlinLongProgressionCompanion, MultipazKotlinLongRange, MultipazKotlinLongRangeCompanion, MultipazKotlinNothing, MultipazKotlinPair<__covariant A, __covariant B>, MultipazKotlinRandom, MultipazKotlinRandomDefault, MultipazKotlinRuntimeException, MultipazKotlinThrowable, MultipazKotlinUIntProgression, MultipazKotlinUIntProgressionCompanion, MultipazKotlinUIntRange, MultipazKotlinUIntRangeCompanion, MultipazKotlinULongProgression, MultipazKotlinULongProgressionCompanion, MultipazKotlinULongRange, MultipazKotlinULongRangeCompanion, MultipazKotlinUnit, MultipazKotlinx_coroutines_coreCoroutineDispatcher, MultipazKotlinx_coroutines_coreCoroutineDispatcherKey, MultipazKotlinx_datetimeDayOfWeek, MultipazKotlinx_datetimeDayOfWeekNames, MultipazKotlinx_datetimeDayOfWeekNamesCompanion, MultipazKotlinx_datetimeFixedOffsetTimeZone, MultipazKotlinx_datetimeFixedOffsetTimeZoneCompanion, MultipazKotlinx_datetimeInstant, MultipazKotlinx_datetimeInstantCompanion, MultipazKotlinx_datetimeLocalDate, MultipazKotlinx_datetimeLocalDateCompanion, MultipazKotlinx_datetimeLocalDateTime, MultipazKotlinx_datetimeLocalDateTimeCompanion, MultipazKotlinx_datetimeLocalTime, MultipazKotlinx_datetimeLocalTimeCompanion, MultipazKotlinx_datetimeMonth, MultipazKotlinx_datetimeMonthNames, MultipazKotlinx_datetimeMonthNamesCompanion, MultipazKotlinx_datetimePadding, MultipazKotlinx_datetimeTimeZone, MultipazKotlinx_datetimeTimeZoneCompanion, MultipazKotlinx_datetimeUtcOffset, MultipazKotlinx_datetimeUtcOffsetCompanion, MultipazKotlinx_io_bytestringByteString, MultipazKotlinx_io_bytestringByteStringBuilder, MultipazKotlinx_io_bytestringByteStringCompanion, MultipazKotlinx_io_corePath, MultipazKotlinx_serialization_coreSerialKind, MultipazKotlinx_serialization_coreSerializersModule, MultipazKotlinx_serialization_jsonJsonElement, MultipazKotlinx_serialization_jsonJsonElementCompanion, MultipazKtor_client_coreHttpClient, MultipazKtor_client_coreHttpClientCall, MultipazKtor_client_coreHttpClientCallCompanion, MultipazKtor_client_coreHttpClientConfig<T>, MultipazKtor_client_coreHttpClientEngineConfig, MultipazKtor_client_coreHttpReceivePipeline, MultipazKtor_client_coreHttpReceivePipelinePhases, MultipazKtor_client_coreHttpRequestBuilder, MultipazKtor_client_coreHttpRequestBuilderCompanion, MultipazKtor_client_coreHttpRequestData, MultipazKtor_client_coreHttpRequestPipeline, MultipazKtor_client_coreHttpRequestPipelinePhases, MultipazKtor_client_coreHttpResponse, MultipazKtor_client_coreHttpResponseContainer, MultipazKtor_client_coreHttpResponseData, MultipazKtor_client_coreHttpResponsePipeline, MultipazKtor_client_coreHttpResponsePipelinePhases, MultipazKtor_client_coreHttpSendPipeline, MultipazKtor_client_coreHttpSendPipelinePhases, MultipazKtor_client_coreProxyConfig, MultipazKtor_eventsEventDefinition<T>, MultipazKtor_eventsEvents, MultipazKtor_httpContentType, MultipazKtor_httpContentTypeCompanion, MultipazKtor_httpHeaderValueParam, MultipazKtor_httpHeaderValueWithParameters, MultipazKtor_httpHeaderValueWithParametersCompanion, MultipazKtor_httpHeadersBuilder, MultipazKtor_httpHttpMethod, MultipazKtor_httpHttpMethodCompanion, MultipazKtor_httpHttpProtocolVersion, MultipazKtor_httpHttpProtocolVersionCompanion, MultipazKtor_httpHttpStatusCode, MultipazKtor_httpHttpStatusCodeCompanion, MultipazKtor_httpOutgoingContent, MultipazKtor_httpURLBuilder, MultipazKtor_httpURLBuilderCompanion, MultipazKtor_httpURLProtocol, MultipazKtor_httpURLProtocolCompanion, MultipazKtor_httpUrl, MultipazKtor_httpUrlCompanion, MultipazKtor_ioBuffer, MultipazKtor_ioBufferCompanion, MultipazKtor_ioByteReadPacket, MultipazKtor_ioByteReadPacketCompanion, MultipazKtor_ioChunkBuffer, MultipazKtor_ioChunkBufferCompanion, MultipazKtor_ioInput, MultipazKtor_ioInputCompanion, MultipazKtor_ioMemory, MultipazKtor_ioMemoryCompanion, MultipazKtor_utilsAttributeKey<T>, MultipazKtor_utilsGMTDate, MultipazKtor_utilsGMTDateCompanion, MultipazKtor_utilsMonth, MultipazKtor_utilsMonthCompanion, MultipazKtor_utilsPipeline<TSubject, TContext>, MultipazKtor_utilsPipelinePhase, MultipazKtor_utilsStringValuesBuilderImpl, MultipazKtor_utilsTypeInfo, MultipazKtor_utilsWeekDay, MultipazKtor_utilsWeekDayCompanion, MultipazLogger, MultipazLoggerLogPrinterLevel, MultipazMajorType, MultipazMajorTypeCompanion, MultipazMapBuilder<T>, MultipazMdocCannedRequest, MultipazMdocClaim, MultipazMdocConnectionMethod, MultipazMdocConnectionMethodBle, MultipazMdocConnectionMethodBleCompanion, MultipazMdocConnectionMethodCompanion, MultipazMdocConnectionMethodNfc, MultipazMdocConnectionMethodNfcCompanion, MultipazMdocConnectionMethodWifiAware, MultipazMdocConnectionMethodWifiAwareCompanion, MultipazMdocCredential, MultipazMdocCredentialCompanion, MultipazMdocDataElement, MultipazMdocDataElementCompanion, MultipazMdocDocumentType, MultipazMdocDocumentTypeBuilder, MultipazMdocNamespace, MultipazMdocNamespaceBuilder, MultipazMdocNamespaceRequest, MultipazMdocNfcEngagementHelperCompanion, MultipazMdocReaderNfcHandoverResult, MultipazMdocRequest, MultipazMdocRequestedClaim, MultipazMdocRole, MultipazMdocTransport, MultipazMdocTransportFactoryDefault, MultipazMdocTransportOptions, MultipazMdocTransportState, MultipazMdocUtil, MultipazMobileSecurityObjectGenerator, MultipazMobileSecurityObjectGeneratorCompanion, MultipazMobileSecurityObjectParserMobileSecurityObject, MultipazNameSpacedData, MultipazNameSpacedDataBuilder, MultipazNameSpacedDataCompanion, MultipazNdefMessage, MultipazNdefMessageCompanion, MultipazNdefRecord, MultipazNdefRecordCompanion, MultipazNdefRecordTnf, MultipazNfc, MultipazNfcIsoTag, MultipazNfcIsoTagCompanion, MultipazNfcTransportMdocCompanion, MultipazNfcTransportMdocReaderCompanion, MultipazNintCompanion, MultipazNoopCipher, MultipazOID, MultipazOIDCompanion, MultipazOptions, MultipazOriginInfo, MultipazOriginInfoCompanion, MultipazOriginInfoDomain, MultipazOriginInfoDomainCompanion, MultipazPassphraseConstraints, MultipazPassphraseConstraintsCompanion, MultipazPassphraseRequest, MultipazPhotoID, MultipazPresentmentModelCompanion, MultipazPresentmentModelConsentData, MultipazPresentmentModelDismissType, MultipazPresentmentModelState, MultipazPromptModelCompanion, MultipazPromptModelKey, MultipazRequest, MultipazRequestedClaim, MultipazRequester, MultipazResponseApdu, MultipazResponseApduCompanion, MultipazRpcAuthBackendDelegate, MultipazRpcAuthClientSessionCompanion, MultipazRpcAuthClientSessionKey, MultipazRpcAuthContext, MultipazRpcAuthContextCompanion, MultipazRpcAuthContextKey, MultipazRpcAuthError, MultipazRpcAuthException, MultipazRpcAuthExceptionCompanion, MultipazRpcAuthInspectorAssertion, MultipazRpcAuthInspectorAssertionCompanion, MultipazRpcAuthInspectorAssertionNonceAndSession, MultipazRpcDispatcherAuthCompanion, MultipazRpcDispatcherLocal, MultipazRpcDispatcherLocalBuilder, MultipazRpcDispatcherLocalTargetBuilder<StateT>, MultipazRpcExceptionMap, MultipazRpcExceptionMapBuilder, MultipazRpcNotificationsLocalCompanion, MultipazRpcNotificationsLocalPollCompanion, MultipazRpcNotifierCompanion, MultipazRpcNotifierPollCompanion, MultipazRpcPollCompanion, MultipazRpcPollPollKey, MultipazRpcPollPollResult, MultipazRpcReturnCode, MultipazRpcStub, MultipazRpcStubCompanion, MultipazSdJwt, MultipazSdJwtCompanion, MultipazSdJwtKb, MultipazSecureAreaBoundCredential, MultipazSecureAreaBoundCredentialCompanion, MultipazSecureAreaConfiguration, MultipazSecureAreaConfigurationAndroidKeystore, MultipazSecureAreaConfigurationCloud, MultipazSecureAreaConfigurationCompanion, MultipazSecureAreaConfigurationSoftware, MultipazSecureAreaRepository, MultipazSecureAreaRepositoryCompanion, MultipazSecureEnclaveCreateKeySettings, MultipazSecureEnclaveCreateKeySettingsBuilder, MultipazSecureEnclaveSecureArea, MultipazSecureEnclaveSecureAreaCompanion, MultipazSecureEnclaveUserAuthType, MultipazSecureEnclaveUserAuthTypeCompanion, MultipazSecurityException, MultipazServiceParameterRecord, MultipazServiceParameterRecordCompanion, MultipazServiceSelectRecord, MultipazServiceSelectRecordCompanion, MultipazSessionEncryptionCompanion, MultipazSignedVical, MultipazSignedVicalCompanion, MultipazSimple, MultipazSimpleCompanion, MultipazSimpleDocumentMetadata, MultipazSimpleDocumentMetadataCompanion, MultipazSimpleDocumentMetadataData, MultipazSimpleDocumentMetadataDataCompanion, MultipazSinglePromptModel<ParametersT, ResultT>, MultipazSinglePromptModelDialogState<ParametersT, ResultT>, MultipazSoftwareCreateKeySettings, MultipazSoftwareCreateKeySettingsBuilder, MultipazSoftwareKeyInfo, MultipazSoftwareSecureArea, MultipazSoftwareSecureAreaCompanion, MultipazSqliteStorage, MultipazStaticAuthDataParserStaticAuthData, MultipazStorageException, MultipazStorageTableSpec, MultipazStorageTableSpecCompanion, MultipazStringOption, MultipazTaggedCompanion, MultipazTestInterfaceStub, MultipazTestInterfaceStubCompanion, MultipazTestState, MultipazTestStateCompanion, MultipazTnepStatusRecord, MultipazTnepStatusRecordCompanion, MultipazTrustManagerTrustResult, MultipazTrustPoint, MultipazTstr, MultipazTstrCompanion, MultipazUUID, MultipazUUIDCompanion, MultipazUintCompanion, MultipazUtopiaMovieTicket, MultipazUtopiaNaturalization, MultipazVaccinationDocument, MultipazVcCannedRequest, MultipazVcClaim, MultipazVcClaimCompanion, MultipazVcDocumentType, MultipazVcDocumentTypeBuilder, MultipazVcRequest, MultipazVcRequestedClaim, MultipazVcRequestedClaimCompanion, MultipazVehicleRegistration, MultipazVical, MultipazVicalCertificateInfo, MultipazX500Name, MultipazX500NameCompanion, MultipazX509Cert, MultipazX509CertBuilder, MultipazX509CertChain, MultipazX509CertChainCompanion, MultipazX509CertCompanion, MultipazX509Extension, MultipazX509KeyUsage, MultipazX509KeyUsageCompanion, NSData, NSError, NSUUID;

@protocol MultipazBackendEnvironment, MultipazDigitalCredentials, MultipazDocumentMetadata, MultipazHttpTransport, MultipazKeyUnlockData, MultipazKotlinAnnotation, MultipazKotlinAppendable, MultipazKotlinClosedRange, MultipazKotlinComparable, MultipazKotlinContinuation, MultipazKotlinContinuationInterceptor, MultipazKotlinCoroutineContext, MultipazKotlinCoroutineContextElement, MultipazKotlinCoroutineContextKey, MultipazKotlinFunction, MultipazKotlinIterable, MultipazKotlinIterator, MultipazKotlinKAnnotatedElement, MultipazKotlinKClass, MultipazKotlinKClassifier, MultipazKotlinKDeclarationContainer, MultipazKotlinKType, MultipazKotlinMapEntry, MultipazKotlinOpenEndRange, MultipazKotlinSequence, MultipazKotlinSuspendFunction1, MultipazKotlinSuspendFunction2, MultipazKotlinSuspendFunction3, MultipazKotlinSuspendFunction4, MultipazKotlinx_coroutines_coreChildHandle, MultipazKotlinx_coroutines_coreChildJob, MultipazKotlinx_coroutines_coreCoroutineScope, MultipazKotlinx_coroutines_coreDisposableHandle, MultipazKotlinx_coroutines_coreFlow, MultipazKotlinx_coroutines_coreFlowCollector, MultipazKotlinx_coroutines_coreJob, MultipazKotlinx_coroutines_coreMutableSharedFlow, MultipazKotlinx_coroutines_coreMutex, MultipazKotlinx_coroutines_coreParentJob, MultipazKotlinx_coroutines_coreRunnable, MultipazKotlinx_coroutines_coreSelectClause, MultipazKotlinx_coroutines_coreSelectClause0, MultipazKotlinx_coroutines_coreSelectClause2, MultipazKotlinx_coroutines_coreSelectInstance, MultipazKotlinx_coroutines_coreSendChannel, MultipazKotlinx_coroutines_coreSharedFlow, MultipazKotlinx_coroutines_coreStateFlow, MultipazKotlinx_datetimeClock, MultipazKotlinx_datetimeDateTimeFormat, MultipazKotlinx_datetimeDateTimeFormatBuilder, MultipazKotlinx_datetimeDateTimeFormatBuilderWithDate, MultipazKotlinx_datetimeDateTimeFormatBuilderWithDateTime, MultipazKotlinx_datetimeDateTimeFormatBuilderWithTime, MultipazKotlinx_datetimeDateTimeFormatBuilderWithUtcOffset, MultipazKotlinx_serialization_coreCompositeDecoder, MultipazKotlinx_serialization_coreCompositeEncoder, MultipazKotlinx_serialization_coreDecoder, MultipazKotlinx_serialization_coreDeserializationStrategy, MultipazKotlinx_serialization_coreEncoder, MultipazKotlinx_serialization_coreKSerializer, MultipazKotlinx_serialization_coreSerialDescriptor, MultipazKotlinx_serialization_coreSerializationStrategy, MultipazKotlinx_serialization_coreSerializersModuleCollector, MultipazKtor_client_coreHttpClientEngine, MultipazKtor_client_coreHttpClientEngineCapability, MultipazKtor_client_coreHttpClientEngineFactory, MultipazKtor_client_coreHttpClientPlugin, MultipazKtor_client_coreHttpRequest, MultipazKtor_httpHeaders, MultipazKtor_httpHttpMessage, MultipazKtor_httpHttpMessageBuilder, MultipazKtor_httpParameters, MultipazKtor_httpParametersBuilder, MultipazKtor_ioByteReadChannel, MultipazKtor_ioCloseable, MultipazKtor_ioObjectPool, MultipazKtor_ioReadSession, MultipazKtor_utilsAttributes, MultipazKtor_utilsStringValues, MultipazKtor_utilsStringValuesBuilder, MultipazLoggerLogPrinter, MultipazMdocTransportFactory, MultipazPresentmentMechanism, MultipazPresentmentSource, MultipazPromptModel, MultipazRpcAuthInspector, MultipazRpcAuthIssuer, MultipazRpcDispatcher, MultipazRpcNotifications, MultipazRpcNotifier, MultipazRpcPoll, MultipazSdJwtVcCredential, MultipazSecureArea, MultipazSimpleCipher, MultipazSqliteSQLiteConnection, MultipazSqliteSQLiteStatement, MultipazStorage, MultipazStorageEngine, MultipazStorageTable, MultipazTestInterface;

NS_ASSUME_NONNULL_BEGIN
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunknown-warning-option"
#pragma clang diagnostic ignored "-Wincompatible-property-type"
#pragma clang diagnostic ignored "-Wnullability"

#pragma push_macro("_Nullable_result")
#if !__has_feature(nullability_nullable_result)
#undef _Nullable_result
#define _Nullable_result _Nullable
#endif

__attribute__((swift_name("KotlinBase")))
@interface MultipazBase : NSObject
- (instancetype)init __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (void)initialize __attribute__((objc_requires_super));
@end

@interface MultipazBase (MultipazBaseCopying) <NSCopying>
@end

__attribute__((swift_name("KotlinMutableSet")))
@interface MultipazMutableSet<ObjectType> : NSMutableSet<ObjectType>
@end

__attribute__((swift_name("KotlinMutableDictionary")))
@interface MultipazMutableDictionary<KeyType, ObjectType> : NSMutableDictionary<KeyType, ObjectType>
@end

@interface NSError (NSErrorMultipazKotlinException)
@property (readonly) id _Nullable kotlinException;
@end

__attribute__((swift_name("KotlinNumber")))
@interface MultipazNumber : NSNumber
- (instancetype)initWithChar:(char)value __attribute__((unavailable));
- (instancetype)initWithUnsignedChar:(unsigned char)value __attribute__((unavailable));
- (instancetype)initWithShort:(short)value __attribute__((unavailable));
- (instancetype)initWithUnsignedShort:(unsigned short)value __attribute__((unavailable));
- (instancetype)initWithInt:(int)value __attribute__((unavailable));
- (instancetype)initWithUnsignedInt:(unsigned int)value __attribute__((unavailable));
- (instancetype)initWithLong:(long)value __attribute__((unavailable));
- (instancetype)initWithUnsignedLong:(unsigned long)value __attribute__((unavailable));
- (instancetype)initWithLongLong:(long long)value __attribute__((unavailable));
- (instancetype)initWithUnsignedLongLong:(unsigned long long)value __attribute__((unavailable));
- (instancetype)initWithFloat:(float)value __attribute__((unavailable));
- (instancetype)initWithDouble:(double)value __attribute__((unavailable));
- (instancetype)initWithBool:(BOOL)value __attribute__((unavailable));
- (instancetype)initWithInteger:(NSInteger)value __attribute__((unavailable));
- (instancetype)initWithUnsignedInteger:(NSUInteger)value __attribute__((unavailable));
+ (instancetype)numberWithChar:(char)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedChar:(unsigned char)value __attribute__((unavailable));
+ (instancetype)numberWithShort:(short)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedShort:(unsigned short)value __attribute__((unavailable));
+ (instancetype)numberWithInt:(int)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedInt:(unsigned int)value __attribute__((unavailable));
+ (instancetype)numberWithLong:(long)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedLong:(unsigned long)value __attribute__((unavailable));
+ (instancetype)numberWithLongLong:(long long)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedLongLong:(unsigned long long)value __attribute__((unavailable));
+ (instancetype)numberWithFloat:(float)value __attribute__((unavailable));
+ (instancetype)numberWithDouble:(double)value __attribute__((unavailable));
+ (instancetype)numberWithBool:(BOOL)value __attribute__((unavailable));
+ (instancetype)numberWithInteger:(NSInteger)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedInteger:(NSUInteger)value __attribute__((unavailable));
@end

__attribute__((swift_name("KotlinByte")))
@interface MultipazByte : MultipazNumber
- (instancetype)initWithChar:(char)value;
+ (instancetype)numberWithChar:(char)value;
@end

__attribute__((swift_name("KotlinUByte")))
@interface MultipazUByte : MultipazNumber
- (instancetype)initWithUnsignedChar:(unsigned char)value;
+ (instancetype)numberWithUnsignedChar:(unsigned char)value;
@end

__attribute__((swift_name("KotlinShort")))
@interface MultipazShort : MultipazNumber
- (instancetype)initWithShort:(short)value;
+ (instancetype)numberWithShort:(short)value;
@end

__attribute__((swift_name("KotlinUShort")))
@interface MultipazUShort : MultipazNumber
- (instancetype)initWithUnsignedShort:(unsigned short)value;
+ (instancetype)numberWithUnsignedShort:(unsigned short)value;
@end

__attribute__((swift_name("KotlinInt")))
@interface MultipazInt : MultipazNumber
- (instancetype)initWithInt:(int)value;
+ (instancetype)numberWithInt:(int)value;
@end

__attribute__((swift_name("KotlinUInt")))
@interface MultipazUInt : MultipazNumber
- (instancetype)initWithUnsignedInt:(unsigned int)value;
+ (instancetype)numberWithUnsignedInt:(unsigned int)value;
@end

__attribute__((swift_name("KotlinLong")))
@interface MultipazLong : MultipazNumber
- (instancetype)initWithLongLong:(long long)value;
+ (instancetype)numberWithLongLong:(long long)value;
@end

__attribute__((swift_name("KotlinULong")))
@interface MultipazULong : MultipazNumber
- (instancetype)initWithUnsignedLongLong:(unsigned long long)value;
+ (instancetype)numberWithUnsignedLongLong:(unsigned long long)value;
@end

__attribute__((swift_name("KotlinFloat")))
@interface MultipazFloat : MultipazNumber
- (instancetype)initWithFloat:(float)value;
+ (instancetype)numberWithFloat:(float)value;
@end

__attribute__((swift_name("KotlinDouble")))
@interface MultipazDouble : MultipazNumber
- (instancetype)initWithDouble:(double)value;
+ (instancetype)numberWithDouble:(double)value;
@end

__attribute__((swift_name("KotlinBoolean")))
@interface MultipazBoolean : MultipazNumber
- (instancetype)initWithBool:(BOOL)value;
+ (instancetype)numberWithBool:(BOOL)value;
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1")))
@interface MultipazASN1 : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)aSN1 __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazASN1 *shared __attribute__((swift_name("shared")));
- (MultipazASN1Object * _Nullable)decodeDerEncoded:(MultipazKotlinByteArray *)derEncoded __attribute__((swift_name("decode(derEncoded:)")));
- (NSArray<MultipazASN1Object *> *)decodeMultipleDerEncoded:(MultipazKotlinByteArray *)derEncoded __attribute__((swift_name("decodeMultiple(derEncoded:)")));
- (MultipazKotlinByteArray *)encodeObj:(MultipazASN1Object *)obj __attribute__((swift_name("encode(obj:)")));
- (NSString *)printObj:(MultipazASN1Object *)obj __attribute__((swift_name("print(obj:)")));
@end

__attribute__((swift_name("ASN1Object")))
@interface MultipazASN1Object : MultipazBase
@property (readonly) MultipazASN1TagClass *cls __attribute__((swift_name("cls")));
@property (readonly) MultipazASN1Encoding *enc __attribute__((swift_name("enc")));
@property (readonly) int32_t tag __attribute__((swift_name("tag")));
@end

__attribute__((swift_name("ASN1PrimitiveValue")))
@interface MultipazASN1PrimitiveValue : MultipazASN1Object
- (instancetype)initWithTag:(int32_t)tag __attribute__((swift_name("init(tag:)"))) __attribute__((objc_designated_initializer));
@property (readonly) int32_t tag __attribute__((swift_name("tag")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1BitString")))
@interface MultipazASN1BitString : MultipazASN1PrimitiveValue
- (instancetype)initWithBooleanValues:(MultipazKotlinBooleanArray *)booleanValues __attribute__((swift_name("init(booleanValues:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithNumUnusedBits:(int32_t)numUnusedBits value:(MultipazKotlinByteArray *)value __attribute__((swift_name("init(numUnusedBits:value:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithTag:(int32_t)tag __attribute__((swift_name("init(tag:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazASN1BitStringCompanion *companion __attribute__((swift_name("companion")));
- (MultipazKotlinBooleanArray *)asBooleans __attribute__((swift_name("asBooleans()")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t numUnusedBits __attribute__((swift_name("numUnusedBits")));
@property (readonly) MultipazKotlinByteArray *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1BitString.Companion")))
@interface MultipazASN1BitStringCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazASN1BitStringCompanion *shared __attribute__((swift_name("shared")));
- (MultipazASN1BitString *)parseContent:(MultipazKotlinByteArray *)content __attribute__((swift_name("parse(content:)")));
@property (readonly) int32_t TAG_NUMBER __attribute__((swift_name("TAG_NUMBER")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1Boolean")))
@interface MultipazASN1Boolean : MultipazASN1PrimitiveValue
- (instancetype)initWithValue:(BOOL)value __attribute__((swift_name("init(value:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithTag:(int32_t)tag __attribute__((swift_name("init(tag:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazASN1BooleanCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) BOOL value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1Boolean.Companion")))
@interface MultipazASN1BooleanCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazASN1BooleanCompanion *shared __attribute__((swift_name("shared")));
- (MultipazASN1Boolean *)parseContent:(MultipazKotlinByteArray *)content __attribute__((swift_name("parse(content:)")));
@property (readonly) int32_t TAG_NUMBER __attribute__((swift_name("TAG_NUMBER")));
@end

__attribute__((swift_name("KotlinComparable")))
@protocol MultipazKotlinComparable
@required
- (int32_t)compareToOther:(id _Nullable)other __attribute__((swift_name("compareTo(other:)")));
@end

__attribute__((swift_name("KotlinEnum")))
@interface MultipazKotlinEnum<E> : MultipazBase <MultipazKotlinComparable>
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazKotlinEnumCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(E)other __attribute__((swift_name("compareTo(other:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@property (readonly) int32_t ordinal __attribute__((swift_name("ordinal")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1Encoding")))
@interface MultipazASN1Encoding : MultipazKotlinEnum<MultipazASN1Encoding *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazASN1EncodingCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) MultipazASN1Encoding *primitive __attribute__((swift_name("primitive")));
@property (class, readonly) MultipazASN1Encoding *constructed __attribute__((swift_name("constructed")));
+ (MultipazKotlinArray<MultipazASN1Encoding *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazASN1Encoding *> *entries __attribute__((swift_name("entries")));
@property (readonly) int32_t value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1Encoding.Companion")))
@interface MultipazASN1EncodingCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazASN1EncodingCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1Integer")))
@interface MultipazASN1Integer : MultipazASN1PrimitiveValue
- (instancetype)initWithValue:(MultipazKotlinByteArray *)value tag:(int32_t)tag __attribute__((swift_name("init(value:tag:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithLongValue:(int64_t)longValue tag:(int32_t)tag __attribute__((swift_name("init(longValue:tag:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithTag:(int32_t)tag __attribute__((swift_name("init(tag:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazASN1IntegerCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (int64_t)toLong __attribute__((swift_name("toLong()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinByteArray *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1Integer.Companion")))
@interface MultipazASN1IntegerCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazASN1IntegerCompanion *shared __attribute__((swift_name("shared")));
- (MultipazASN1Integer *)fromRandomNumBits:(int32_t)numBits random:(MultipazKotlinRandom *)random __attribute__((swift_name("fromRandom(numBits:random:)")));
- (MultipazASN1Integer *)parseContent:(MultipazKotlinByteArray *)content tag:(int32_t)tag __attribute__((swift_name("parse(content:tag:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1IntegerTag")))
@interface MultipazASN1IntegerTag : MultipazKotlinEnum<MultipazASN1IntegerTag *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) MultipazASN1IntegerTag *integer __attribute__((swift_name("integer")));
@property (class, readonly) MultipazASN1IntegerTag *enumerated __attribute__((swift_name("enumerated")));
+ (MultipazKotlinArray<MultipazASN1IntegerTag *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazASN1IntegerTag *> *entries __attribute__((swift_name("entries")));
@property (readonly) int32_t tag __attribute__((swift_name("tag")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1Null")))
@interface MultipazASN1Null : MultipazASN1PrimitiveValue
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithTag:(int32_t)tag __attribute__((swift_name("init(tag:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazASN1NullCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1Null.Companion")))
@interface MultipazASN1NullCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazASN1NullCompanion *shared __attribute__((swift_name("shared")));
- (MultipazASN1Null *)parseContent:(MultipazKotlinByteArray *)content __attribute__((swift_name("parse(content:)")));
@property (readonly) int32_t TAG_NUMBER __attribute__((swift_name("TAG_NUMBER")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1ObjectIdentifier")))
@interface MultipazASN1ObjectIdentifier : MultipazASN1PrimitiveValue
- (instancetype)initWithOid:(NSString *)oid __attribute__((swift_name("init(oid:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithTag:(int32_t)tag __attribute__((swift_name("init(tag:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazASN1ObjectIdentifierCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *oid __attribute__((swift_name("oid")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1ObjectIdentifier.Companion")))
@interface MultipazASN1ObjectIdentifierCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazASN1ObjectIdentifierCompanion *shared __attribute__((swift_name("shared")));
- (MultipazASN1ObjectIdentifier *)parseContent:(MultipazKotlinByteArray *)content __attribute__((swift_name("parse(content:)")));
@property (readonly) int32_t TAG_NUMBER __attribute__((swift_name("TAG_NUMBER")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1OctetString")))
@interface MultipazASN1OctetString : MultipazASN1PrimitiveValue
- (instancetype)initWithValue:(MultipazKotlinByteArray *)value __attribute__((swift_name("init(value:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithTag:(int32_t)tag __attribute__((swift_name("init(tag:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazASN1OctetStringCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinByteArray *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1OctetString.Companion")))
@interface MultipazASN1OctetStringCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazASN1OctetStringCompanion *shared __attribute__((swift_name("shared")));
- (MultipazASN1OctetString *)parseContent:(MultipazKotlinByteArray *)content __attribute__((swift_name("parse(content:)")));
@property (readonly) int32_t TAG_NUMBER __attribute__((swift_name("TAG_NUMBER")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1RawObject")))
@interface MultipazASN1RawObject : MultipazASN1Object
- (instancetype)initWithCls:(MultipazASN1TagClass *)cls enc:(MultipazASN1Encoding *)enc tag:(int32_t)tag content:(MultipazKotlinByteArray *)content __attribute__((swift_name("init(cls:enc:tag:content:)"))) __attribute__((objc_designated_initializer));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinByteArray *content __attribute__((swift_name("content")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1Sequence")))
@interface MultipazASN1Sequence : MultipazASN1Object
- (instancetype)initWithElements:(NSArray<MultipazASN1Object *> *)elements __attribute__((swift_name("init(elements:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazASN1SequenceCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSArray<MultipazASN1Object *> *elements __attribute__((swift_name("elements")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1Sequence.Companion")))
@interface MultipazASN1SequenceCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazASN1SequenceCompanion *shared __attribute__((swift_name("shared")));
- (MultipazASN1Sequence *)parseContent:(MultipazKotlinByteArray *)content __attribute__((swift_name("parse(content:)")));
@property (readonly) int32_t TAG_NUMBER __attribute__((swift_name("TAG_NUMBER")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1Set")))
@interface MultipazASN1Set : MultipazASN1Object
- (instancetype)initWithElements:(NSArray<MultipazASN1Object *> *)elements __attribute__((swift_name("init(elements:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazASN1SetCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSArray<MultipazASN1Object *> *elements __attribute__((swift_name("elements")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1Set.Companion")))
@interface MultipazASN1SetCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazASN1SetCompanion *shared __attribute__((swift_name("shared")));
- (MultipazASN1Set *)parseContent:(MultipazKotlinByteArray *)content __attribute__((swift_name("parse(content:)")));
@property (readonly) int32_t TAG_NUMBER __attribute__((swift_name("TAG_NUMBER")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1String")))
@interface MultipazASN1String : MultipazASN1PrimitiveValue
- (instancetype)initWithValue:(NSString *)value tag:(int32_t)tag __attribute__((swift_name("init(value:tag:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithTag:(int32_t)tag __attribute__((swift_name("init(tag:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazASN1StringCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1String.Companion")))
@interface MultipazASN1StringCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazASN1StringCompanion *shared __attribute__((swift_name("shared")));
- (MultipazASN1String *)parseContent:(MultipazKotlinByteArray *)content tag:(int32_t)tag __attribute__((swift_name("parse(content:tag:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1StringTag")))
@interface MultipazASN1StringTag : MultipazKotlinEnum<MultipazASN1StringTag *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) MultipazASN1StringTag *utf8String __attribute__((swift_name("utf8String")));
@property (class, readonly) MultipazASN1StringTag *numericString __attribute__((swift_name("numericString")));
@property (class, readonly) MultipazASN1StringTag *printableString __attribute__((swift_name("printableString")));
@property (class, readonly) MultipazASN1StringTag *teletexString __attribute__((swift_name("teletexString")));
@property (class, readonly) MultipazASN1StringTag *videotexString __attribute__((swift_name("videotexString")));
@property (class, readonly) MultipazASN1StringTag *ia5String __attribute__((swift_name("ia5String")));
@property (class, readonly) MultipazASN1StringTag *graphicString __attribute__((swift_name("graphicString")));
@property (class, readonly) MultipazASN1StringTag *visibleString __attribute__((swift_name("visibleString")));
@property (class, readonly) MultipazASN1StringTag *generalString __attribute__((swift_name("generalString")));
@property (class, readonly) MultipazASN1StringTag *universalString __attribute__((swift_name("universalString")));
@property (class, readonly) MultipazASN1StringTag *characterString __attribute__((swift_name("characterString")));
@property (class, readonly) MultipazASN1StringTag *bmpString __attribute__((swift_name("bmpString")));
+ (MultipazKotlinArray<MultipazASN1StringTag *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazASN1StringTag *> *entries __attribute__((swift_name("entries")));
@property (readonly) int32_t tag __attribute__((swift_name("tag")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1TagClass")))
@interface MultipazASN1TagClass : MultipazKotlinEnum<MultipazASN1TagClass *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazASN1TagClassCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) MultipazASN1TagClass *universal __attribute__((swift_name("universal")));
@property (class, readonly) MultipazASN1TagClass *application __attribute__((swift_name("application")));
@property (class, readonly) MultipazASN1TagClass *contextSpecific __attribute__((swift_name("contextSpecific")));
@property (class, readonly) MultipazASN1TagClass *private_ __attribute__((swift_name("private_")));
+ (MultipazKotlinArray<MultipazASN1TagClass *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazASN1TagClass *> *entries __attribute__((swift_name("entries")));
@property (readonly) int32_t value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1TagClass.Companion")))
@interface MultipazASN1TagClassCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazASN1TagClassCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1TaggedObject")))
@interface MultipazASN1TaggedObject : MultipazASN1Object
- (instancetype)initWithCls:(MultipazASN1TagClass *)cls enc:(MultipazASN1Encoding *)enc tag:(int32_t)tag content:(MultipazKotlinByteArray *)content __attribute__((swift_name("init(cls:enc:tag:content:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazASN1TaggedObjectCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinByteArray *content __attribute__((swift_name("content")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1TaggedObject.Companion")))
@interface MultipazASN1TaggedObjectCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazASN1TaggedObjectCompanion *shared __attribute__((swift_name("shared")));
- (MultipazASN1TaggedObject *)parseCls:(MultipazASN1TagClass *)cls enc:(MultipazASN1Encoding *)enc tag:(int32_t)tag content:(MultipazKotlinByteArray *)content __attribute__((swift_name("parse(cls:enc:tag:content:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1Time")))
@interface MultipazASN1Time : MultipazASN1PrimitiveValue
- (instancetype)initWithValue:(MultipazKotlinx_datetimeInstant *)value tag:(int32_t)tag __attribute__((swift_name("init(value:tag:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithTag:(int32_t)tag __attribute__((swift_name("init(tag:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazASN1TimeCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinx_datetimeInstant *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1Time.Companion")))
@interface MultipazASN1TimeCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazASN1TimeCompanion *shared __attribute__((swift_name("shared")));
- (MultipazASN1Time *)parseContent:(MultipazKotlinByteArray *)content tag:(int32_t)tag __attribute__((swift_name("parse(content:tag:)")));
- (MultipazASN1TimeTag *)pickDefaultTagValue:(MultipazKotlinx_datetimeInstant *)value __attribute__((swift_name("pickDefaultTag(value:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ASN1TimeTag")))
@interface MultipazASN1TimeTag : MultipazKotlinEnum<MultipazASN1TimeTag *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) MultipazASN1TimeTag *utcTime __attribute__((swift_name("utcTime")));
@property (class, readonly) MultipazASN1TimeTag *generalizedTime __attribute__((swift_name("generalizedTime")));
+ (MultipazKotlinArray<MultipazASN1TimeTag *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazASN1TimeTag *> *entries __attribute__((swift_name("entries")));
@property (readonly) int32_t tag __attribute__((swift_name("tag")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("OID")))
@interface MultipazOID : MultipazKotlinEnum<MultipazOID *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazOIDCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) MultipazOID *ecPublicKey __attribute__((swift_name("ecPublicKey")));
@property (class, readonly) MultipazOID *ecCurveP256 __attribute__((swift_name("ecCurveP256")));
@property (class, readonly) MultipazOID *ecCurveP384 __attribute__((swift_name("ecCurveP384")));
@property (class, readonly) MultipazOID *ecCurveP521 __attribute__((swift_name("ecCurveP521")));
@property (class, readonly) MultipazOID *ecCurveBrainpoolp256r1 __attribute__((swift_name("ecCurveBrainpoolp256r1")));
@property (class, readonly) MultipazOID *ecCurveBrainpoolp320r1 __attribute__((swift_name("ecCurveBrainpoolp320r1")));
@property (class, readonly) MultipazOID *ecCurveBrainpoolp384r1 __attribute__((swift_name("ecCurveBrainpoolp384r1")));
@property (class, readonly) MultipazOID *ecCurveBrainpoolp512r1 __attribute__((swift_name("ecCurveBrainpoolp512r1")));
@property (class, readonly) MultipazOID *signatureEcdsaSha256 __attribute__((swift_name("signatureEcdsaSha256")));
@property (class, readonly) MultipazOID *signatureEcdsaSha384 __attribute__((swift_name("signatureEcdsaSha384")));
@property (class, readonly) MultipazOID *signatureEcdsaSha512 __attribute__((swift_name("signatureEcdsaSha512")));
@property (class, readonly) MultipazOID *signatureRs256 __attribute__((swift_name("signatureRs256")));
@property (class, readonly) MultipazOID *signatureRs384 __attribute__((swift_name("signatureRs384")));
@property (class, readonly) MultipazOID *signatureRs512 __attribute__((swift_name("signatureRs512")));
@property (class, readonly) MultipazOID *x25519 __attribute__((swift_name("x25519")));
@property (class, readonly) MultipazOID *x448 __attribute__((swift_name("x448")));
@property (class, readonly) MultipazOID *ed25519 __attribute__((swift_name("ed25519")));
@property (class, readonly) MultipazOID *ed448 __attribute__((swift_name("ed448")));
@property (class, readonly) MultipazOID *commonName __attribute__((swift_name("commonName")));
@property (class, readonly) MultipazOID *serialNumber __attribute__((swift_name("serialNumber")));
@property (class, readonly) MultipazOID *countryName __attribute__((swift_name("countryName")));
@property (class, readonly) MultipazOID *localityName __attribute__((swift_name("localityName")));
@property (class, readonly) MultipazOID *stateOrProvinceName __attribute__((swift_name("stateOrProvinceName")));
@property (class, readonly) MultipazOID *organizationName __attribute__((swift_name("organizationName")));
@property (class, readonly) MultipazOID *organizationalUnitName __attribute__((swift_name("organizationalUnitName")));
@property (class, readonly) MultipazOID *x509ExtensionKeyUsage __attribute__((swift_name("x509ExtensionKeyUsage")));
@property (class, readonly) MultipazOID *x509ExtensionExtendedKeyUsage __attribute__((swift_name("x509ExtensionExtendedKeyUsage")));
@property (class, readonly) MultipazOID *x509ExtensionBasicConstraints __attribute__((swift_name("x509ExtensionBasicConstraints")));
@property (class, readonly) MultipazOID *x509ExtensionSubjectKeyIdentifier __attribute__((swift_name("x509ExtensionSubjectKeyIdentifier")));
@property (class, readonly) MultipazOID *x509ExtensionAuthorityKeyIdentifier __attribute__((swift_name("x509ExtensionAuthorityKeyIdentifier")));
@property (class, readonly) MultipazOID *x509ExtensionSubjectAltName __attribute__((swift_name("x509ExtensionSubjectAltName")));
@property (class, readonly) MultipazOID *x509ExtensionIssuerAltName __attribute__((swift_name("x509ExtensionIssuerAltName")));
@property (class, readonly) MultipazOID *x509ExtensionCrlDistributionPoints __attribute__((swift_name("x509ExtensionCrlDistributionPoints")));
@property (class, readonly) MultipazOID *x509ExtensionAndroidKeystoreAttestation __attribute__((swift_name("x509ExtensionAndroidKeystoreAttestation")));
@property (class, readonly) MultipazOID *x509ExtensionAndroidKeystoreProvisioningInformation __attribute__((swift_name("x509ExtensionAndroidKeystoreProvisioningInformation")));
@property (class, readonly) MultipazOID *x509ExtensionMultipazKeyAttestation __attribute__((swift_name("x509ExtensionMultipazKeyAttestation")));
@property (class, readonly) MultipazOID *iso180135MdlDs __attribute__((swift_name("iso180135MdlDs")));
@property (class, readonly) MultipazOID *iso180135MdlReaderAuth __attribute__((swift_name("iso180135MdlReaderAuth")));
+ (MultipazKotlinArray<MultipazOID *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazOID *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString *description_ __attribute__((swift_name("description_")));
@property (readonly) NSString *oid __attribute__((swift_name("oid")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("OID.Companion")))
@interface MultipazOIDCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazOIDCompanion *shared __attribute__((swift_name("shared")));
- (BOOL)isOidStr:(NSString *)str __attribute__((swift_name("isOid(str:)")));
- (MultipazOID * _Nullable)lookupByOidOid:(NSString *)oid __attribute__((swift_name("lookupByOid(oid:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ArrayBuilder")))
@interface MultipazArrayBuilder<T> : MultipazBase
- (instancetype)initWithParent:(T _Nullable)parent array:(MultipazCborArray *)array __attribute__((swift_name("init(parent:array:)"))) __attribute__((objc_designated_initializer));
- (MultipazArrayBuilder<T> *)addValue:(BOOL)value __attribute__((swift_name("add(value:)")));
- (MultipazArrayBuilder<T> *)addValue_:(int8_t)value __attribute__((swift_name("add(value_:)")));
- (MultipazArrayBuilder<T> *)addValue__:(MultipazKotlinByteArray *)value __attribute__((swift_name("add(value__:)")));
- (MultipazArrayBuilder<T> *)addValue___:(double)value __attribute__((swift_name("add(value___:)")));
- (MultipazArrayBuilder<T> *)addValue____:(float)value __attribute__((swift_name("add(value____:)")));
- (MultipazArrayBuilder<T> *)addValue_____:(int32_t)value __attribute__((swift_name("add(value_____:)")));
- (MultipazArrayBuilder<T> *)addValue______:(int64_t)value __attribute__((swift_name("add(value______:)")));
- (MultipazArrayBuilder<T> *)addValue_______:(int16_t)value __attribute__((swift_name("add(value_______:)")));
- (MultipazArrayBuilder<T> *)addValue________:(NSString *)value __attribute__((swift_name("add(value________:)")));
- (MultipazArrayBuilder<T> *)addItem:(MultipazDataItem *)item __attribute__((swift_name("add(item:)")));
- (MultipazArrayBuilder<MultipazArrayBuilder<T> *> *)addArray __attribute__((swift_name("addArray()")));
- (MultipazMapBuilder<MultipazArrayBuilder<T> *> *)addMap __attribute__((swift_name("addMap()")));
- (MultipazArrayBuilder<T> *)addTaggedTagNumber:(int64_t)tagNumber taggedItem:(MultipazDataItem *)taggedItem __attribute__((swift_name("addTagged(tagNumber:taggedItem:)")));
- (MultipazArrayBuilder<T> *)addTaggedEncodedCborEncodedCbor:(MultipazKotlinByteArray *)encodedCbor __attribute__((swift_name("addTaggedEncodedCbor(encodedCbor:)")));
- (MultipazArrayBuilder<T> *)doCopyParent:(T _Nullable)parent array:(MultipazCborArray *)array __attribute__((swift_name("doCopy(parent:array:)")));
- (T _Nullable)end __attribute__((swift_name("end()")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (BOOL)isEmpty __attribute__((swift_name("isEmpty()")));
- (NSString *)description __attribute__((swift_name("description()")));
@end

__attribute__((swift_name("DataItem")))
@interface MultipazDataItem : MultipazBase
- (MultipazDataItem *)getKey:(int64_t)key __attribute__((swift_name("get(key:)")));
- (MultipazDataItem *)getKey_:(NSString *)key __attribute__((swift_name("get(key_:)")));
- (MultipazDataItem *)getKey__:(MultipazDataItem *)key __attribute__((swift_name("get(key__:)")));
- (MultipazDataItem *)getOrDefaultKey:(int64_t)key defaultValue:(MultipazDataItem *)defaultValue __attribute__((swift_name("getOrDefault(key:defaultValue:)")));
- (MultipazDataItem *)getOrDefaultKey:(NSString *)key defaultValue_:(MultipazDataItem *)defaultValue __attribute__((swift_name("getOrDefault(key:defaultValue_:)")));
- (MultipazDataItem *)getOrDefaultKey:(MultipazDataItem *)key defaultValue__:(MultipazDataItem *)defaultValue __attribute__((swift_name("getOrDefault(key:defaultValue__:)")));
- (MultipazDataItem * _Nullable)getOrNullKey:(int64_t)key __attribute__((swift_name("getOrNull(key:)")));
- (MultipazDataItem * _Nullable)getOrNullKey_:(NSString *)key __attribute__((swift_name("getOrNull(key_:)")));
- (MultipazDataItem * _Nullable)getOrNullKey__:(MultipazDataItem *)key __attribute__((swift_name("getOrNull(key__:)")));
- (BOOL)hasKeyKey:(int64_t)key __attribute__((swift_name("hasKey(key:)")));
- (BOOL)hasKeyKey_:(NSString *)key __attribute__((swift_name("hasKey(key_:)")));
- (BOOL)hasKeyKey__:(MultipazDataItem *)key __attribute__((swift_name("hasKey(key__:)")));
@property (readonly) NSArray<MultipazDataItem *> *asArray __attribute__((swift_name("asArray")));
@property (readonly) BOOL asBoolean __attribute__((swift_name("asBoolean")));
@property (readonly) MultipazKotlinByteArray *asBstr __attribute__((swift_name("asBstr")));
@property (readonly) MultipazCoseKey *asCoseKey __attribute__((swift_name("asCoseKey")));
@property (readonly) MultipazCoseLabel *asCoseLabel __attribute__((swift_name("asCoseLabel")));
@property (readonly) MultipazCoseMac0 *asCoseMac0 __attribute__((swift_name("asCoseMac0")));
@property (readonly) MultipazCoseSign1 *asCoseSign1 __attribute__((swift_name("asCoseSign1")));
@property (readonly) MultipazKotlinx_datetimeLocalDate *asDateString __attribute__((swift_name("asDateString")));
@property (readonly) MultipazKotlinx_datetimeInstant *asDateTimeString __attribute__((swift_name("asDateTimeString")));
@property (readonly) double asDouble __attribute__((swift_name("asDouble")));
@property (readonly) float asFloat __attribute__((swift_name("asFloat")));
@property (readonly) NSDictionary<MultipazDataItem *, MultipazDataItem *> *asMap __attribute__((swift_name("asMap")));
@property (readonly) int64_t asNumber __attribute__((swift_name("asNumber")));
@property (readonly) MultipazDataItem *asTagged __attribute__((swift_name("asTagged")));
@property (readonly) MultipazDataItem *asTaggedEncodedCbor __attribute__((swift_name("asTaggedEncodedCbor")));
@property (readonly) NSString *asTstr __attribute__((swift_name("asTstr")));
@property (readonly) MultipazX509Cert *asX509Cert __attribute__((swift_name("asX509Cert")));
@property (readonly) MultipazX509CertChain *asX509CertChain __attribute__((swift_name("asX509CertChain")));
@property (readonly) MultipazMajorType *majorType __attribute__((swift_name("majorType")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Bstr")))
@interface MultipazBstr : MultipazDataItem
- (instancetype)initWithValue:(MultipazKotlinByteArray *)value __attribute__((swift_name("init(value:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazBstrCompanion *companion __attribute__((swift_name("companion")));
- (MultipazBstr *)doCopyValue:(MultipazKotlinByteArray *)value __attribute__((swift_name("doCopy(value:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinByteArray *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Bstr.Companion")))
@interface MultipazBstrCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazBstrCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Cbor")))
@interface MultipazCbor : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)cbor __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazCbor *shared __attribute__((swift_name("shared")));
- (MultipazDataItem *)decodeEncodedCbor:(MultipazKotlinByteArray *)encodedCbor __attribute__((swift_name("decode(encodedCbor:)")));
- (MultipazKotlinPair<MultipazInt *, MultipazDataItem *> *)decodeEncodedCbor:(MultipazKotlinByteArray *)encodedCbor offset:(int32_t)offset __attribute__((swift_name("decode(encodedCbor:offset:)")));
- (MultipazKotlinByteArray *)encodeItem:(MultipazDataItem *)item __attribute__((swift_name("encode(item:)")));
- (NSString *)toDiagnosticsEncodedItem:(MultipazKotlinByteArray *)encodedItem options:(NSSet<MultipazDiagnosticOption *> *)options __attribute__((swift_name("toDiagnostics(encodedItem:options:)")));
- (NSString *)toDiagnosticsItem:(MultipazDataItem *)item options:(NSSet<MultipazDiagnosticOption *> *)options __attribute__((swift_name("toDiagnostics(item:options:)")));
@property (readonly) uint8_t BREAK __attribute__((swift_name("BREAK")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CborArray")))
@interface MultipazCborArray : MultipazDataItem
- (instancetype)initWithItems:(NSMutableArray<MultipazDataItem *> *)items indefiniteLength:(BOOL)indefiniteLength __attribute__((swift_name("init(items:indefiniteLength:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazCborArrayCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) BOOL indefiniteLength __attribute__((swift_name("indefiniteLength")));
@property (readonly) NSMutableArray<MultipazDataItem *> *items __attribute__((swift_name("items")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CborArray.Companion")))
@interface MultipazCborArrayCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazCborArrayCompanion *shared __attribute__((swift_name("shared")));
- (MultipazArrayBuilder<MultipazCborBuilder *> *)builder __attribute__((swift_name("builder()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CborBuilder")))
@interface MultipazCborBuilder : MultipazBase
- (instancetype)initWithItem:(MultipazDataItem *)item __attribute__((swift_name("init(item:)"))) __attribute__((objc_designated_initializer));
- (MultipazDataItem *)build __attribute__((swift_name("build()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CborDouble")))
@interface MultipazCborDouble : MultipazDataItem
- (instancetype)initWithValue:(double)value __attribute__((swift_name("init(value:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazCborDoubleCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) double value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CborDouble.Companion")))
@interface MultipazCborDoubleCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazCborDoubleCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CborFloat")))
@interface MultipazCborFloat : MultipazDataItem
- (instancetype)initWithValue:(float)value __attribute__((swift_name("init(value:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazCborFloatCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) float value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CborFloat.Companion")))
@interface MultipazCborFloatCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazCborFloatCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((swift_name("CborInt")))
@interface MultipazCborInt : MultipazDataItem
- (instancetype)initWithMajorType:(MultipazMajorType *)majorType __attribute__((swift_name("init(majorType:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CborMap")))
@interface MultipazCborMap : MultipazDataItem
- (instancetype)initWithItems:(MultipazMutableDictionary<MultipazDataItem *, MultipazDataItem *> *)items indefiniteLength:(BOOL)indefiniteLength __attribute__((swift_name("init(items:indefiniteLength:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazCborMapCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) BOOL indefiniteLength __attribute__((swift_name("indefiniteLength")));
@property (readonly) MultipazMutableDictionary<MultipazDataItem *, MultipazDataItem *> *items __attribute__((swift_name("items")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CborMap.Companion")))
@interface MultipazCborMapCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazCborMapCompanion *shared __attribute__((swift_name("shared")));
- (MultipazMapBuilder<MultipazCborBuilder *> *)builder __attribute__((swift_name("builder()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DiagnosticOption")))
@interface MultipazDiagnosticOption : MultipazKotlinEnum<MultipazDiagnosticOption *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) MultipazDiagnosticOption *embeddedCbor __attribute__((swift_name("embeddedCbor")));
@property (class, readonly) MultipazDiagnosticOption *prettyPrint __attribute__((swift_name("prettyPrint")));
@property (class, readonly) MultipazDiagnosticOption *bstrPrintLength __attribute__((swift_name("bstrPrintLength")));
+ (MultipazKotlinArray<MultipazDiagnosticOption *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazDiagnosticOption *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IndefLengthBstr")))
@interface MultipazIndefLengthBstr : MultipazDataItem
- (instancetype)initWithChunks:(NSArray<MultipazKotlinByteArray *> *)chunks __attribute__((swift_name("init(chunks:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazIndefLengthBstrCompanion *companion __attribute__((swift_name("companion")));
- (MultipazIndefLengthBstr *)doCopyChunks:(NSArray<MultipazKotlinByteArray *> *)chunks __attribute__((swift_name("doCopy(chunks:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSArray<MultipazKotlinByteArray *> *chunks __attribute__((swift_name("chunks")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IndefLengthBstr.Companion")))
@interface MultipazIndefLengthBstrCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazIndefLengthBstrCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IndefLengthTstr")))
@interface MultipazIndefLengthTstr : MultipazDataItem
- (instancetype)initWithChunks:(NSArray<NSString *> *)chunks __attribute__((swift_name("init(chunks:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazIndefLengthTstrCompanion *companion __attribute__((swift_name("companion")));
- (MultipazIndefLengthTstr *)doCopyChunks:(NSArray<NSString *> *)chunks __attribute__((swift_name("doCopy(chunks:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSArray<NSString *> *chunks __attribute__((swift_name("chunks")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IndefLengthTstr.Companion")))
@interface MultipazIndefLengthTstrCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazIndefLengthTstrCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MajorType")))
@interface MultipazMajorType : MultipazKotlinEnum<MultipazMajorType *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazMajorTypeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) MultipazMajorType *unsignedInteger __attribute__((swift_name("unsignedInteger")));
@property (class, readonly) MultipazMajorType *negativeInteger __attribute__((swift_name("negativeInteger")));
@property (class, readonly) MultipazMajorType *byteString __attribute__((swift_name("byteString")));
@property (class, readonly) MultipazMajorType *unicodeString __attribute__((swift_name("unicodeString")));
@property (class, readonly) MultipazMajorType *array __attribute__((swift_name("array")));
@property (class, readonly) MultipazMajorType *map __attribute__((swift_name("map")));
@property (class, readonly) MultipazMajorType *tag __attribute__((swift_name("tag")));
@property (class, readonly) MultipazMajorType *special __attribute__((swift_name("special")));
+ (MultipazKotlinArray<MultipazMajorType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazMajorType *> *entries __attribute__((swift_name("entries")));
@property (readonly) int32_t type __attribute__((swift_name("type")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MajorType.Companion")))
@interface MultipazMajorTypeCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazMajorTypeCompanion *shared __attribute__((swift_name("shared")));
- (MultipazMajorType *)fromIntValue:(int32_t)value __attribute__((swift_name("fromInt(value:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MapBuilder")))
@interface MultipazMapBuilder<T> : MultipazBase
- (instancetype)initWithParent:(T _Nullable)parent map:(MultipazCborMap *)map __attribute__((swift_name("init(parent:map:)"))) __attribute__((objc_designated_initializer));
- (T _Nullable)end __attribute__((swift_name("end()")));
- (MultipazMapBuilder<T> *)putKey:(int64_t)key value:(BOOL)value __attribute__((swift_name("put(key:value:)")));
- (MultipazMapBuilder<T> *)putKey:(int64_t)key value_:(int8_t)value __attribute__((swift_name("put(key:value_:)")));
- (MultipazMapBuilder<T> *)putKey:(int64_t)key value__:(MultipazKotlinByteArray *)value __attribute__((swift_name("put(key:value__:)")));
- (MultipazMapBuilder<T> *)putKey:(int64_t)key value___:(double)value __attribute__((swift_name("put(key:value___:)")));
- (MultipazMapBuilder<T> *)putKey:(int64_t)key value____:(float)value __attribute__((swift_name("put(key:value____:)")));
- (MultipazMapBuilder<T> *)putKey:(int64_t)key value_____:(int32_t)value __attribute__((swift_name("put(key:value_____:)")));
- (MultipazMapBuilder<T> *)putKey:(int64_t)key value______:(int64_t)value __attribute__((swift_name("put(key:value______:)")));
- (MultipazMapBuilder<T> *)putKey:(int64_t)key value_______:(int16_t)value __attribute__((swift_name("put(key:value_______:)")));
- (MultipazMapBuilder<T> *)putKey:(int64_t)key value________:(NSString *)value __attribute__((swift_name("put(key:value________:)")));
- (MultipazMapBuilder<T> *)putKey:(int64_t)key value_________:(MultipazDataItem *)value __attribute__((swift_name("put(key:value_________:)")));
- (MultipazMapBuilder<T> *)putKey:(NSString *)key value__________:(BOOL)value __attribute__((swift_name("put(key:value__________:)")));
- (MultipazMapBuilder<T> *)putKey:(NSString *)key value___________:(int8_t)value __attribute__((swift_name("put(key:value___________:)")));
- (MultipazMapBuilder<T> *)putKey:(NSString *)key value____________:(MultipazKotlinByteArray *)value __attribute__((swift_name("put(key:value____________:)")));
- (MultipazMapBuilder<T> *)putKey:(NSString *)key value_____________:(double)value __attribute__((swift_name("put(key:value_____________:)")));
- (MultipazMapBuilder<T> *)putKey:(NSString *)key value______________:(float)value __attribute__((swift_name("put(key:value______________:)")));
- (MultipazMapBuilder<T> *)putKey:(NSString *)key value_______________:(int32_t)value __attribute__((swift_name("put(key:value_______________:)")));
- (MultipazMapBuilder<T> *)putKey:(NSString *)key value________________:(int64_t)value __attribute__((swift_name("put(key:value________________:)")));
- (MultipazMapBuilder<T> *)putKey:(NSString *)key value_________________:(int16_t)value __attribute__((swift_name("put(key:value_________________:)")));
- (MultipazMapBuilder<T> *)putKey:(NSString *)key value__________________:(NSString *)value __attribute__((swift_name("put(key:value__________________:)")));
- (MultipazMapBuilder<T> *)putKey:(NSString *)key value___________________:(MultipazDataItem *)value __attribute__((swift_name("put(key:value___________________:)")));
- (MultipazMapBuilder<T> *)putKey:(MultipazDataItem *)key value____________________:(MultipazDataItem *)value __attribute__((swift_name("put(key:value____________________:)")));
- (MultipazArrayBuilder<MultipazMapBuilder<T> *> *)putArrayKey:(int64_t)key __attribute__((swift_name("putArray(key:)")));
- (MultipazArrayBuilder<MultipazMapBuilder<T> *> *)putArrayKey_:(NSString *)key __attribute__((swift_name("putArray(key_:)")));
- (MultipazArrayBuilder<MultipazMapBuilder<T> *> *)putArrayKey__:(MultipazDataItem *)key __attribute__((swift_name("putArray(key__:)")));
- (MultipazMapBuilder<MultipazMapBuilder<T> *> *)putMapKey:(int64_t)key __attribute__((swift_name("putMap(key:)")));
- (MultipazMapBuilder<MultipazMapBuilder<T> *> *)putMapKey_:(NSString *)key __attribute__((swift_name("putMap(key_:)")));
- (MultipazMapBuilder<MultipazMapBuilder<T> *> *)putMapKey__:(MultipazDataItem *)key __attribute__((swift_name("putMap(key__:)")));
- (MultipazMapBuilder<T> *)putTaggedKey:(int64_t)key tagNumber:(int64_t)tagNumber value:(MultipazDataItem *)value __attribute__((swift_name("putTagged(key:tagNumber:value:)")));
- (MultipazMapBuilder<T> *)putTaggedKey:(NSString *)key tagNumber:(int64_t)tagNumber value_:(MultipazDataItem *)value __attribute__((swift_name("putTagged(key:tagNumber:value_:)")));
- (MultipazMapBuilder<T> *)putTaggedKey:(MultipazDataItem *)key tagNumber:(int64_t)tagNumber taggedItem:(MultipazDataItem *)taggedItem __attribute__((swift_name("putTagged(key:tagNumber:taggedItem:)")));
- (MultipazMapBuilder<T> *)putTaggedEncodedCborKey:(int64_t)key encodedCbor:(MultipazKotlinByteArray *)encodedCbor __attribute__((swift_name("putTaggedEncodedCbor(key:encodedCbor:)")));
- (MultipazMapBuilder<T> *)putTaggedEncodedCborKey:(NSString *)key encodedCbor_:(MultipazKotlinByteArray *)encodedCbor __attribute__((swift_name("putTaggedEncodedCbor(key:encodedCbor_:)")));
- (MultipazMapBuilder<T> *)putTaggedEncodedCborKey:(MultipazDataItem *)key encodedCbor__:(MultipazKotlinByteArray *)encodedCbor __attribute__((swift_name("putTaggedEncodedCbor(key:encodedCbor__:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Nint")))
@interface MultipazNint : MultipazCborInt
- (instancetype)initWithValue:(uint64_t)value __attribute__((swift_name("init(value:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMajorType:(MultipazMajorType *)majorType __attribute__((swift_name("init(majorType:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazNintCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) uint64_t value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Nint.Companion")))
@interface MultipazNintCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazNintCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RawCbor")))
@interface MultipazRawCbor : MultipazDataItem
- (instancetype)initWithEncodedCbor:(MultipazKotlinByteArray *)encodedCbor __attribute__((swift_name("init(encodedCbor:)"))) __attribute__((objc_designated_initializer));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinByteArray *encodedCbor __attribute__((swift_name("encodedCbor")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Simple")))
@interface MultipazSimple : MultipazDataItem
- (instancetype)initWithValue:(uint32_t)value __attribute__((swift_name("init(value:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazSimpleCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) uint32_t value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Simple.Companion")))
@interface MultipazSimpleCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazSimpleCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) MultipazSimple *False __attribute__((swift_name("False")));
@property (readonly) MultipazSimple *Null __attribute__((swift_name("Null")));
@property (readonly) MultipazSimple *True __attribute__((swift_name("True")));
@property (readonly) MultipazSimple *UNDEFINED __attribute__((swift_name("UNDEFINED")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Tagged")))
@interface MultipazTagged : MultipazDataItem
- (instancetype)initWithTagNumber:(int64_t)tagNumber taggedItem:(MultipazDataItem *)taggedItem __attribute__((swift_name("init(tagNumber:taggedItem:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazTaggedCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int64_t tagNumber __attribute__((swift_name("tagNumber")));
@property (readonly) MultipazDataItem *taggedItem __attribute__((swift_name("taggedItem")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Tagged.Companion")))
@interface MultipazTaggedCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazTaggedCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) int64_t DATE_TIME_NUMBER __attribute__((swift_name("DATE_TIME_NUMBER")));
@property (readonly) int64_t DATE_TIME_STRING __attribute__((swift_name("DATE_TIME_STRING")));
@property (readonly) int64_t ENCODED_CBOR __attribute__((swift_name("ENCODED_CBOR")));
@property (readonly) int64_t FULL_DATE_STRING __attribute__((swift_name("FULL_DATE_STRING")));
@property (readonly) int64_t NEGATIVE_BIGNUM __attribute__((swift_name("NEGATIVE_BIGNUM")));
@property (readonly) int64_t UNSIGNED_BIGNUM __attribute__((swift_name("UNSIGNED_BIGNUM")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Tstr")))
@interface MultipazTstr : MultipazDataItem
- (instancetype)initWithValue:(NSString *)value __attribute__((swift_name("init(value:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazTstrCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Tstr.Companion")))
@interface MultipazTstrCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazTstrCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Uint")))
@interface MultipazUint : MultipazCborInt
- (instancetype)initWithValue:(uint64_t)value __attribute__((swift_name("init(value:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMajorType:(MultipazMajorType *)majorType __attribute__((swift_name("init(majorType:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazUintCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) uint64_t value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Uint.Companion")))
@interface MultipazUintCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazUintCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((swift_name("Claim")))
@interface MultipazClaim : MultipazBase
- (NSString *)renderTimeZone:(MultipazKotlinx_datetimeTimeZone *)timeZone __attribute__((swift_name("render(timeZone:)")));
@property (readonly) MultipazDocumentAttribute * _Nullable attribute __attribute__((swift_name("attribute")));
@property (readonly) NSString *displayName __attribute__((swift_name("displayName")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocClaim")))
@interface MultipazMdocClaim : MultipazClaim
- (instancetype)initWithDisplayName:(NSString *)displayName attribute:(MultipazDocumentAttribute * _Nullable)attribute namespaceName:(NSString *)namespaceName dataElementName:(NSString *)dataElementName value:(MultipazDataItem *)value __attribute__((swift_name("init(displayName:attribute:namespaceName:dataElementName:value:)"))) __attribute__((objc_designated_initializer));
- (MultipazMdocClaim *)doCopyDisplayName:(NSString *)displayName attribute:(MultipazDocumentAttribute * _Nullable)attribute namespaceName:(NSString *)namespaceName dataElementName:(NSString *)dataElementName value:(MultipazDataItem *)value __attribute__((swift_name("doCopy(displayName:attribute:namespaceName:dataElementName:value:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)renderTimeZone:(MultipazKotlinx_datetimeTimeZone *)timeZone __attribute__((swift_name("render(timeZone:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazDocumentAttribute * _Nullable attribute __attribute__((swift_name("attribute")));
@property (readonly) NSString *dataElementName __attribute__((swift_name("dataElementName")));
@property (readonly) NSString *displayName __attribute__((swift_name("displayName")));
@property (readonly) NSString *namespaceName __attribute__((swift_name("namespaceName")));
@property (readonly) MultipazDataItem *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VcClaim")))
@interface MultipazVcClaim : MultipazClaim
- (instancetype)initWithDisplayName:(NSString *)displayName attribute:(MultipazDocumentAttribute * _Nullable)attribute claimName:(NSString *)claimName value:(MultipazKotlinx_serialization_jsonJsonElement *)value __attribute__((swift_name("init(displayName:attribute:claimName:value:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazVcClaimCompanion *companion __attribute__((swift_name("companion")));
- (MultipazVcClaim *)doCopyDisplayName:(NSString *)displayName attribute:(MultipazDocumentAttribute * _Nullable)attribute claimName:(NSString *)claimName value:(MultipazKotlinx_serialization_jsonJsonElement *)value __attribute__((swift_name("doCopy(displayName:attribute:claimName:value:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)renderTimeZone:(MultipazKotlinx_datetimeTimeZone *)timeZone __attribute__((swift_name("render(timeZone:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazDocumentAttribute * _Nullable attribute __attribute__((swift_name("attribute")));
@property (readonly) NSString *claimName __attribute__((swift_name("claimName")));
@property (readonly) NSString *displayName __attribute__((swift_name("displayName")));
@property (readonly) MultipazKotlinx_serialization_jsonJsonElement *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VcClaim.Companion")))
@interface MultipazVcClaimCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazVcClaimCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Cose")))
@interface MultipazCose : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)cose __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazCose *shared __attribute__((swift_name("shared")));
- (MultipazCoseMac0 *)coseMac0Algorithm:(MultipazAlgorithm *)algorithm key:(MultipazKotlinByteArray *)key message:(MultipazKotlinByteArray *)message includeMessageInPayload:(BOOL)includeMessageInPayload protectedHeaders:(NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *)protectedHeaders unprotectedHeaders:(NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *)unprotectedHeaders __attribute__((swift_name("coseMac0(algorithm:key:message:includeMessageInPayload:protectedHeaders:unprotectedHeaders:)")));
- (void)coseSign1CheckPublicKey:(MultipazEcPublicKey *)publicKey detachedData:(MultipazKotlinByteArray * _Nullable)detachedData signature:(MultipazCoseSign1 *)signature signatureAlgorithm:(MultipazAlgorithm *)signatureAlgorithm __attribute__((swift_name("coseSign1Check(publicKey:detachedData:signature:signatureAlgorithm:)")));
- (MultipazCoseSign1 *)coseSign1SignKey:(MultipazEcPrivateKey *)key dataToSign:(MultipazKotlinByteArray *)dataToSign includeDataInPayload:(BOOL)includeDataInPayload signatureAlgorithm:(MultipazAlgorithm *)signatureAlgorithm protectedHeaders:(NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *)protectedHeaders unprotectedHeaders:(NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *)unprotectedHeaders __attribute__((swift_name("coseSign1Sign(key:dataToSign:includeDataInPayload:signatureAlgorithm:protectedHeaders:unprotectedHeaders:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)coseSign1SignSecureArea:(id<MultipazSecureArea>)secureArea alias:(NSString *)alias message:(MultipazKotlinByteArray *)message includeMessageInPayload:(BOOL)includeMessageInPayload protectedHeaders:(NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *)protectedHeaders unprotectedHeaders:(NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *)unprotectedHeaders keyUnlockData:(id<MultipazKeyUnlockData> _Nullable)keyUnlockData completionHandler:(void (^)(MultipazCoseSign1 * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("coseSign1Sign(secureArea:alias:message:includeMessageInPayload:protectedHeaders:unprotectedHeaders:keyUnlockData:completionHandler:)")));
@property (readonly) int64_t COSE_KEY_KID __attribute__((swift_name("COSE_KEY_KID")));
@property (readonly) int64_t COSE_KEY_KTY __attribute__((swift_name("COSE_KEY_KTY")));
@property (readonly) int64_t COSE_KEY_PARAM_CRV __attribute__((swift_name("COSE_KEY_PARAM_CRV")));
@property (readonly) int64_t COSE_KEY_PARAM_D __attribute__((swift_name("COSE_KEY_PARAM_D")));
@property (readonly) int64_t COSE_KEY_PARAM_X __attribute__((swift_name("COSE_KEY_PARAM_X")));
@property (readonly) int64_t COSE_KEY_PARAM_Y __attribute__((swift_name("COSE_KEY_PARAM_Y")));
@property (readonly) int64_t COSE_KEY_TYPE_EC2 __attribute__((swift_name("COSE_KEY_TYPE_EC2")));
@property (readonly) int64_t COSE_KEY_TYPE_OKP __attribute__((swift_name("COSE_KEY_TYPE_OKP")));
@property (readonly) int64_t COSE_LABEL_ALG __attribute__((swift_name("COSE_LABEL_ALG")));
@property (readonly) int64_t COSE_LABEL_X5CHAIN __attribute__((swift_name("COSE_LABEL_X5CHAIN")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CoseKey")))
@interface MultipazCoseKey : MultipazBase
- (instancetype)initWithLabels:(NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *)labels __attribute__((swift_name("init(labels:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazCoseKeyCompanion *companion __attribute__((swift_name("companion")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@property (readonly) MultipazEcPrivateKey *ecPrivateKey __attribute__((swift_name("ecPrivateKey")));
@property (readonly) MultipazEcPublicKey *ecPublicKey __attribute__((swift_name("ecPublicKey")));
@property (readonly) MultipazDataItem *keyType __attribute__((swift_name("keyType")));
@property (readonly) NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *labels __attribute__((swift_name("labels")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CoseKey.Companion")))
@interface MultipazCoseKeyCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazCoseKeyCompanion *shared __attribute__((swift_name("shared")));
- (MultipazCoseKey *)fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("fromDataItem(dataItem:)")));
@end

__attribute__((swift_name("CoseLabel")))
@interface MultipazCoseLabel : MultipazBase
@property (class, readonly, getter=companion) MultipazCoseLabelCompanion *companion __attribute__((swift_name("companion")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CoseLabel.Companion")))
@interface MultipazCoseLabelCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazCoseLabelCompanion *shared __attribute__((swift_name("shared")));
- (MultipazCoseLabel *)fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("fromDataItem(dataItem:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CoseMac0")))
@interface MultipazCoseMac0 : MultipazBase
- (instancetype)initWithProtectedHeaders:(NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *)protectedHeaders unprotectedHeaders:(NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *)unprotectedHeaders tag:(MultipazKotlinByteArray *)tag payload:(MultipazKotlinByteArray * _Nullable)payload __attribute__((swift_name("init(protectedHeaders:unprotectedHeaders:tag:payload:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazCoseMac0Companion *companion __attribute__((swift_name("companion")));
- (MultipazCoseMac0 *)doCopyProtectedHeaders:(NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *)protectedHeaders unprotectedHeaders:(NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *)unprotectedHeaders tag:(MultipazKotlinByteArray *)tag payload:(MultipazKotlinByteArray * _Nullable)payload __attribute__((swift_name("doCopy(protectedHeaders:unprotectedHeaders:tag:payload:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinByteArray * _Nullable payload __attribute__((swift_name("payload")));
@property (readonly) NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *protectedHeaders __attribute__((swift_name("protectedHeaders")));
@property (readonly) MultipazKotlinByteArray *tag __attribute__((swift_name("tag")));
@property (readonly) NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *unprotectedHeaders __attribute__((swift_name("unprotectedHeaders")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CoseMac0.Companion")))
@interface MultipazCoseMac0Companion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazCoseMac0Companion *shared __attribute__((swift_name("shared")));
- (MultipazCoseMac0 *)fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("fromDataItem(dataItem:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CoseNumberLabel")))
@interface MultipazCoseNumberLabel : MultipazCoseLabel
- (instancetype)initWithNumber:(int64_t)number __attribute__((swift_name("init(number:)"))) __attribute__((objc_designated_initializer));
- (MultipazCoseNumberLabel *)doCopyNumber:(int64_t)number __attribute__((swift_name("doCopy(number:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int64_t number __attribute__((swift_name("number")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CoseSign1")))
@interface MultipazCoseSign1 : MultipazBase
- (instancetype)initWithProtectedHeaders:(NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *)protectedHeaders unprotectedHeaders:(NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *)unprotectedHeaders signature:(MultipazKotlinByteArray *)signature payload:(MultipazKotlinByteArray * _Nullable)payload __attribute__((swift_name("init(protectedHeaders:unprotectedHeaders:signature:payload:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazCoseSign1Companion *companion __attribute__((swift_name("companion")));
- (MultipazCoseSign1 *)doCopyProtectedHeaders:(NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *)protectedHeaders unprotectedHeaders:(NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *)unprotectedHeaders signature:(MultipazKotlinByteArray *)signature payload:(MultipazKotlinByteArray * _Nullable)payload __attribute__((swift_name("doCopy(protectedHeaders:unprotectedHeaders:signature:payload:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinByteArray * _Nullable payload __attribute__((swift_name("payload")));
@property (readonly) NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *protectedHeaders __attribute__((swift_name("protectedHeaders")));
@property (readonly) MultipazKotlinByteArray *signature __attribute__((swift_name("signature")));
@property (readonly) NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *unprotectedHeaders __attribute__((swift_name("unprotectedHeaders")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CoseSign1.Companion")))
@interface MultipazCoseSign1Companion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazCoseSign1Companion *shared __attribute__((swift_name("shared")));
- (MultipazCoseSign1 *)fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("fromDataItem(dataItem:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CoseTextLabel")))
@interface MultipazCoseTextLabel : MultipazCoseLabel
- (instancetype)initWithText:(NSString *)text __attribute__((swift_name("init(text:)"))) __attribute__((objc_designated_initializer));
- (MultipazCoseTextLabel *)doCopyText:(NSString *)text __attribute__((swift_name("doCopy(text:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *text __attribute__((swift_name("text")));
@end

__attribute__((swift_name("Credential")))
@interface MultipazCredential : MultipazBase

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (instancetype)initWithDocument:(MultipazDocument *)document __attribute__((swift_name("init(document:)"))) __attribute__((objc_designated_initializer));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (instancetype)initWithDocument:(MultipazDocument *)document asReplacementForIdentifier:(NSString * _Nullable)asReplacementForIdentifier domain:(NSString *)domain __attribute__((swift_name("init(document:asReplacementForIdentifier:domain:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazCredentialCompanion *companion __attribute__((swift_name("companion")));
- (void)addSerializedDataBuilder:(MultipazMapBuilder<MultipazCborBuilder *> *)builder __attribute__((swift_name("addSerializedData(builder:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)addToDocumentWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("addToDocument(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)certifyIssuerProvidedAuthenticationData:(MultipazKotlinByteArray *)issuerProvidedAuthenticationData validFrom:(MultipazKotlinx_datetimeInstant *)validFrom validUntil:(MultipazKotlinx_datetimeInstant *)validUntil completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("certify(issuerProvidedAuthenticationData:validFrom:validUntil:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)deleteWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("delete(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)deserializeDataItem:(MultipazDataItem *)dataItem completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("deserialize(dataItem:completionHandler:)")));
- (NSArray<MultipazClaim *> *)getClaimsDocumentTypeRepository:(MultipazDocumentTypeRepository * _Nullable)documentTypeRepository __attribute__((swift_name("getClaims(documentTypeRepository:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)increaseUsageCountWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("increaseUsageCount(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)isInvalidatedWithCompletionHandler:(void (^)(MultipazBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("isInvalidated(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)replacementForDeletedWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("replacementForDeleted(completionHandler:)")));
@property (readonly) NSString *credentialType __attribute__((swift_name("credentialType")));
@property (readonly) MultipazDocument *document __attribute__((swift_name("document")));
@property (readonly) NSString *domain __attribute__((swift_name("domain")));
@property (readonly) NSString *identifier __attribute__((swift_name("identifier")));
@property (readonly) BOOL isCertified __attribute__((swift_name("isCertified")));
@property (readonly) MultipazKotlinByteArray *issuerProvidedData __attribute__((swift_name("issuerProvidedData")));
@property (readonly) NSString * _Nullable replacementForIdentifier __attribute__((swift_name("replacementForIdentifier")));
@property int32_t usageCount __attribute__((swift_name("usageCount")));
@property (readonly) MultipazKotlinx_datetimeInstant *validFrom __attribute__((swift_name("validFrom")));
@property (readonly) MultipazKotlinx_datetimeInstant *validUntil __attribute__((swift_name("validUntil")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Credential.Companion")))
@interface MultipazCredentialCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazCredentialCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CredentialLoader")))
@interface MultipazCredentialLoader : MultipazBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (void)addCredentialImplementationCredentialType:(NSString *)credentialType createCredentialFunction:(id<MultipazKotlinSuspendFunction1>)createCredentialFunction __attribute__((swift_name("addCredentialImplementation(credentialType:createCredentialFunction:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)loadCredentialDocument:(MultipazDocument *)document identifier:(NSString *)identifier completionHandler:(void (^)(MultipazCredential * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("loadCredential(document:identifier:completionHandler:)")));
@end

__attribute__((swift_name("SecureAreaBoundCredential")))
@interface MultipazSecureAreaBoundCredential : MultipazCredential
- (instancetype)initWithDocument:(MultipazDocument *)document __attribute__((swift_name("init(document:)"))) __attribute__((objc_designated_initializer));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (instancetype)initWithDocument:(MultipazDocument *)document asReplacementForIdentifier:(NSString * _Nullable)asReplacementForIdentifier domain:(NSString *)domain secureArea:(id<MultipazSecureArea>)secureArea __attribute__((swift_name("init(document:asReplacementForIdentifier:domain:secureArea:)"))) __attribute__((objc_designated_initializer));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (instancetype)initWithDocument:(MultipazDocument *)document asReplacementForIdentifier:(NSString * _Nullable)asReplacementForIdentifier domain:(NSString *)domain __attribute__((swift_name("init(document:asReplacementForIdentifier:domain:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazSecureAreaBoundCredentialCompanion *companion __attribute__((swift_name("companion")));
- (void)addSerializedDataBuilder:(MultipazMapBuilder<MultipazCborBuilder *> *)builder __attribute__((swift_name("addSerializedData(builder:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)deleteWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("delete(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)deserializeDataItem:(MultipazDataItem *)dataItem completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("deserialize(dataItem:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)generateKeyCreateKeySettings:(MultipazCreateKeySettings *)createKeySettings completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("generateKey(createKeySettings:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getAttestationWithCompletionHandler:(void (^)(MultipazKeyAttestation * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getAttestation(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)isInvalidatedWithCompletionHandler:(void (^)(MultipazBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("isInvalidated(completionHandler:)")));
@property NSString *alias __attribute__((swift_name("alias")));
@property (readonly) id<MultipazSecureArea> secureArea __attribute__((swift_name("secureArea")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SecureAreaBoundCredential.Companion")))
@interface MultipazSecureAreaBoundCredentialCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazSecureAreaBoundCredentialCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Algorithm")))
@interface MultipazAlgorithm : MultipazKotlinEnum<MultipazAlgorithm *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazAlgorithmCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) MultipazAlgorithm *unset __attribute__((swift_name("unset")));
@property (class, readonly) MultipazAlgorithm *es256 __attribute__((swift_name("es256")));
@property (class, readonly) MultipazAlgorithm *es384 __attribute__((swift_name("es384")));
@property (class, readonly) MultipazAlgorithm *es512 __attribute__((swift_name("es512")));
@property (class, readonly) MultipazAlgorithm *eddsa __attribute__((swift_name("eddsa")));
@property (class, readonly) MultipazAlgorithm *insecureSha1 __attribute__((swift_name("insecureSha1")));
@property (class, readonly) MultipazAlgorithm *sha256 __attribute__((swift_name("sha256")));
@property (class, readonly) MultipazAlgorithm *sha384 __attribute__((swift_name("sha384")));
@property (class, readonly) MultipazAlgorithm *sha512 __attribute__((swift_name("sha512")));
@property (class, readonly) MultipazAlgorithm *hmacSha256 __attribute__((swift_name("hmacSha256")));
@property (class, readonly) MultipazAlgorithm *hmacSha384 __attribute__((swift_name("hmacSha384")));
@property (class, readonly) MultipazAlgorithm *hmacSha512 __attribute__((swift_name("hmacSha512")));
@property (class, readonly) MultipazAlgorithm *a128gcm __attribute__((swift_name("a128gcm")));
@property (class, readonly) MultipazAlgorithm *a192gcm __attribute__((swift_name("a192gcm")));
@property (class, readonly) MultipazAlgorithm *a256gcm __attribute__((swift_name("a256gcm")));
@property (class, readonly) MultipazAlgorithm *hpkeBaseP256Sha256Aes128gcm __attribute__((swift_name("hpkeBaseP256Sha256Aes128gcm")));
@property (class, readonly) MultipazAlgorithm *rs256 __attribute__((swift_name("rs256")));
@property (class, readonly) MultipazAlgorithm *rs384 __attribute__((swift_name("rs384")));
@property (class, readonly) MultipazAlgorithm *rs512 __attribute__((swift_name("rs512")));
@property (class, readonly) MultipazAlgorithm *esp256 __attribute__((swift_name("esp256")));
@property (class, readonly) MultipazAlgorithm *esp384 __attribute__((swift_name("esp384")));
@property (class, readonly) MultipazAlgorithm *esp512 __attribute__((swift_name("esp512")));
@property (class, readonly) MultipazAlgorithm *esb256 __attribute__((swift_name("esb256")));
@property (class, readonly) MultipazAlgorithm *esb320 __attribute__((swift_name("esb320")));
@property (class, readonly) MultipazAlgorithm *esb384 __attribute__((swift_name("esb384")));
@property (class, readonly) MultipazAlgorithm *esb512 __attribute__((swift_name("esb512")));
@property (class, readonly) MultipazAlgorithm *ed25519 __attribute__((swift_name("ed25519")));
@property (class, readonly) MultipazAlgorithm *ed448 __attribute__((swift_name("ed448")));
@property (class, readonly) MultipazAlgorithm *ecdhP256 __attribute__((swift_name("ecdhP256")));
@property (class, readonly) MultipazAlgorithm *ecdhP384 __attribute__((swift_name("ecdhP384")));
@property (class, readonly) MultipazAlgorithm *ecdhP521 __attribute__((swift_name("ecdhP521")));
@property (class, readonly) MultipazAlgorithm *ecdhBrainpoolp256r1 __attribute__((swift_name("ecdhBrainpoolp256r1")));
@property (class, readonly) MultipazAlgorithm *ecdhBrainpoolp320r1 __attribute__((swift_name("ecdhBrainpoolp320r1")));
@property (class, readonly) MultipazAlgorithm *ecdhBrainpoolp384r1 __attribute__((swift_name("ecdhBrainpoolp384r1")));
@property (class, readonly) MultipazAlgorithm *ecdhBrainpoolp512r1 __attribute__((swift_name("ecdhBrainpoolp512r1")));
@property (class, readonly) MultipazAlgorithm *ecdhX25519 __attribute__((swift_name("ecdhX25519")));
@property (class, readonly) MultipazAlgorithm *ecdhX448 __attribute__((swift_name("ecdhX448")));
+ (MultipazKotlinArray<MultipazAlgorithm *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazAlgorithm *> *entries __attribute__((swift_name("entries")));
@property (readonly) MultipazInt * _Nullable coseAlgorithmIdentifier __attribute__((swift_name("coseAlgorithmIdentifier")));
@property (readonly) MultipazEcCurve * _Nullable curve __attribute__((swift_name("curve")));
@property (readonly) NSString *description_ __attribute__((swift_name("description_")));
@property (readonly) BOOL fullySpecified __attribute__((swift_name("fullySpecified")));
@property (readonly) MultipazAlgorithm * _Nullable hashAlgorithm __attribute__((swift_name("hashAlgorithm")));
@property (readonly) NSString * _Nullable hashAlgorithmName __attribute__((swift_name("hashAlgorithmName")));
@property (readonly) BOOL isKeyAgreement __attribute__((swift_name("isKeyAgreement")));
@property (readonly) BOOL isSigning __attribute__((swift_name("isSigning")));
@property (readonly) NSString * _Nullable joseAlgorithmIdentifier __attribute__((swift_name("joseAlgorithmIdentifier")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Algorithm.Companion")))
@interface MultipazAlgorithmCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazAlgorithmCompanion *shared __attribute__((swift_name("shared")));
- (MultipazAlgorithm *)fromCoseAlgorithmIdentifierCoseAlgorithmIdentifier:(int32_t)coseAlgorithmIdentifier __attribute__((swift_name("fromCoseAlgorithmIdentifier(coseAlgorithmIdentifier:)")));
- (MultipazAlgorithm *)fromHashAlgorithmIdentifierHashAlgorithmIdentifier:(NSString *)hashAlgorithmIdentifier __attribute__((swift_name("fromHashAlgorithmIdentifier(hashAlgorithmIdentifier:)")));
- (MultipazAlgorithm *)fromJoseAlgorithmIdentifierJoseAlgorithmIdentifier:(NSString *)joseAlgorithmIdentifier __attribute__((swift_name("fromJoseAlgorithmIdentifier(joseAlgorithmIdentifier:)")));
- (MultipazAlgorithm *)fromNameName:(NSString *)name __attribute__((swift_name("fromName(name:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Crypto")))
@interface MultipazCrypto : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)crypto __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazCrypto *shared __attribute__((swift_name("shared")));
- (void)checkSignaturePublicKey:(MultipazEcPublicKey *)publicKey message:(MultipazKotlinByteArray *)message algorithm:(MultipazAlgorithm *)algorithm signature:(MultipazEcSignature *)signature __attribute__((swift_name("checkSignature(publicKey:message:algorithm:signature:)")));
- (MultipazEcPrivateKey *)createEcPrivateKeyCurve:(MultipazEcCurve *)curve __attribute__((swift_name("createEcPrivateKey(curve:)")));
- (MultipazKotlinByteArray *)decryptAlgorithm:(MultipazAlgorithm *)algorithm key:(MultipazKotlinByteArray *)key nonce:(MultipazKotlinByteArray *)nonce messageCiphertext:(MultipazKotlinByteArray *)messageCiphertext aad:(MultipazKotlinByteArray * _Nullable)aad __attribute__((swift_name("decrypt(algorithm:key:nonce:messageCiphertext:aad:)")));
- (MultipazKotlinByteArray *)digestAlgorithm:(MultipazAlgorithm *)algorithm message:(MultipazKotlinByteArray *)message __attribute__((swift_name("digest(algorithm:message:)")));
- (MultipazKotlinByteArray *)encryptAlgorithm:(MultipazAlgorithm *)algorithm key:(MultipazKotlinByteArray *)key nonce:(MultipazKotlinByteArray *)nonce messagePlaintext:(MultipazKotlinByteArray *)messagePlaintext aad:(MultipazKotlinByteArray * _Nullable)aad __attribute__((swift_name("encrypt(algorithm:key:nonce:messagePlaintext:aad:)")));
- (MultipazKotlinByteArray *)hkdfAlgorithm:(MultipazAlgorithm *)algorithm ikm:(MultipazKotlinByteArray *)ikm salt:(MultipazKotlinByteArray * _Nullable)salt info:(MultipazKotlinByteArray * _Nullable)info size:(int32_t)size __attribute__((swift_name("hkdf(algorithm:ikm:salt:info:size:)")));
- (MultipazKotlinByteArray *)hpkeDecryptCipherSuite:(MultipazAlgorithm *)cipherSuite receiverPrivateKey:(MultipazEcPrivateKey *)receiverPrivateKey cipherText:(MultipazKotlinByteArray *)cipherText aad:(MultipazKotlinByteArray *)aad encapsulatedPublicKey:(MultipazEcPublicKey *)encapsulatedPublicKey __attribute__((swift_name("hpkeDecrypt(cipherSuite:receiverPrivateKey:cipherText:aad:encapsulatedPublicKey:)")));
- (MultipazKotlinPair<MultipazKotlinByteArray *, MultipazEcPublicKey *> *)hpkeEncryptCipherSuite:(MultipazAlgorithm *)cipherSuite receiverPublicKey:(MultipazEcPublicKey *)receiverPublicKey plainText:(MultipazKotlinByteArray *)plainText aad:(MultipazKotlinByteArray *)aad __attribute__((swift_name("hpkeEncrypt(cipherSuite:receiverPublicKey:plainText:aad:)")));
- (MultipazKotlinByteArray *)keyAgreementKey:(MultipazEcPrivateKey *)key otherKey:(MultipazEcPublicKey *)otherKey __attribute__((swift_name("keyAgreement(key:otherKey:)")));
- (MultipazKotlinByteArray *)macAlgorithm:(MultipazAlgorithm *)algorithm key:(MultipazKotlinByteArray *)key message:(MultipazKotlinByteArray *)message __attribute__((swift_name("mac(algorithm:key:message:)")));
- (MultipazEcSignature *)signKey:(MultipazEcPrivateKey *)key signatureAlgorithm:(MultipazAlgorithm *)signatureAlgorithm message:(MultipazKotlinByteArray *)message __attribute__((swift_name("sign(key:signatureAlgorithm:message:)")));
@property (readonly) NSSet<MultipazEcCurve *> *supportedCurves __attribute__((swift_name("supportedCurves")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EcCurve")))
@interface MultipazEcCurve : MultipazKotlinEnum<MultipazEcCurve *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazEcCurveCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) MultipazEcCurve *p256 __attribute__((swift_name("p256")));
@property (class, readonly) MultipazEcCurve *p384 __attribute__((swift_name("p384")));
@property (class, readonly) MultipazEcCurve *p521 __attribute__((swift_name("p521")));
@property (class, readonly) MultipazEcCurve *brainpoolp256r1 __attribute__((swift_name("brainpoolp256r1")));
@property (class, readonly) MultipazEcCurve *brainpoolp320r1 __attribute__((swift_name("brainpoolp320r1")));
@property (class, readonly) MultipazEcCurve *brainpoolp384r1 __attribute__((swift_name("brainpoolp384r1")));
@property (class, readonly) MultipazEcCurve *brainpoolp512r1 __attribute__((swift_name("brainpoolp512r1")));
@property (class, readonly) MultipazEcCurve *ed25519 __attribute__((swift_name("ed25519")));
@property (class, readonly) MultipazEcCurve *x25519 __attribute__((swift_name("x25519")));
@property (class, readonly) MultipazEcCurve *ed448 __attribute__((swift_name("ed448")));
@property (class, readonly) MultipazEcCurve *x448 __attribute__((swift_name("x448")));
+ (MultipazKotlinArray<MultipazEcCurve *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazEcCurve *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString *SECGName __attribute__((swift_name("SECGName")));
@property (readonly) int32_t bitSize __attribute__((swift_name("bitSize")));
@property (readonly) int32_t coseCurveIdentifier __attribute__((swift_name("coseCurveIdentifier")));
@property (readonly) MultipazAlgorithm *defaultSigningAlgorithm __attribute__((swift_name("defaultSigningAlgorithm")));
@property (readonly) MultipazAlgorithm *defaultSigningAlgorithmFullySpecified __attribute__((swift_name("defaultSigningAlgorithmFullySpecified")));
@property (readonly) NSString *jwkName __attribute__((swift_name("jwkName")));
@property (readonly) BOOL supportsKeyAgreement __attribute__((swift_name("supportsKeyAgreement")));
@property (readonly) BOOL supportsSigning __attribute__((swift_name("supportsSigning")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EcCurve.Companion")))
@interface MultipazEcCurveCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazEcCurveCompanion *shared __attribute__((swift_name("shared")));
- (MultipazEcCurve *)fromIntCoseCurveIdentifier:(int32_t)coseCurveIdentifier __attribute__((swift_name("fromInt(coseCurveIdentifier:)")));
- (MultipazEcCurve *)fromJwkNameJwkName:(NSString *)jwkName __attribute__((swift_name("fromJwkName(jwkName:)")));
@end

__attribute__((swift_name("EcPrivateKey")))
@interface MultipazEcPrivateKey : MultipazBase
@property (class, readonly, getter=companion) MultipazEcPrivateKeyCompanion *companion __attribute__((swift_name("companion")));
- (MultipazCoseKey *)toCoseKeyAdditionalLabels:(NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *)additionalLabels __attribute__((swift_name("toCoseKey(additionalLabels:)")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
- (NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> *)toJwkAdditionalClaims:(NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> * _Nullable)additionalClaims __attribute__((swift_name("toJwk(additionalClaims:)")));
- (NSString *)toPem __attribute__((swift_name("toPem()")));
@property (readonly) MultipazEcCurve *curve __attribute__((swift_name("curve")));
@property (readonly) MultipazKotlinByteArray *d __attribute__((swift_name("d")));
@property (readonly) MultipazEcPublicKey *publicKey __attribute__((swift_name("publicKey")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EcPrivateKey.Companion")))
@interface MultipazEcPrivateKeyCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazEcPrivateKeyCompanion *shared __attribute__((swift_name("shared")));
- (MultipazEcPrivateKey *)fromCoseKeyCoseKey:(MultipazCoseKey *)coseKey __attribute__((swift_name("fromCoseKey(coseKey:)")));
- (MultipazEcPrivateKey *)fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("fromDataItem(dataItem:)")));
- (MultipazEcPrivateKey *)fromJwkJwk:(NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> *)jwk __attribute__((swift_name("fromJwk(jwk:)")));
- (MultipazEcPrivateKey *)fromPemPemEncoding:(NSString *)pemEncoding publicKey:(MultipazEcPublicKey *)publicKey __attribute__((swift_name("fromPem(pemEncoding:publicKey:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EcPrivateKeyDoubleCoordinate")))
@interface MultipazEcPrivateKeyDoubleCoordinate : MultipazEcPrivateKey
- (instancetype)initWithCurve:(MultipazEcCurve *)curve d:(MultipazKotlinByteArray *)d x:(MultipazKotlinByteArray *)x y:(MultipazKotlinByteArray *)y __attribute__((swift_name("init(curve:d:x:y:)"))) __attribute__((objc_designated_initializer));
- (MultipazEcPrivateKeyDoubleCoordinate *)doCopyCurve:(MultipazEcCurve *)curve d:(MultipazKotlinByteArray *)d x:(MultipazKotlinByteArray *)x y:(MultipazKotlinByteArray *)y __attribute__((swift_name("doCopy(curve:d:x:y:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (MultipazCoseKey *)toCoseKeyAdditionalLabels:(NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *)additionalLabels __attribute__((swift_name("toCoseKey(additionalLabels:)")));
- (NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> *)toJwkAdditionalClaims:(NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> * _Nullable)additionalClaims __attribute__((swift_name("toJwk(additionalClaims:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazEcCurve *curve __attribute__((swift_name("curve")));
@property (readonly) MultipazKotlinByteArray *d __attribute__((swift_name("d")));
@property (readonly) MultipazEcPublicKey *publicKey __attribute__((swift_name("publicKey")));
@property (readonly) MultipazKotlinByteArray *x __attribute__((swift_name("x")));
@property (readonly) MultipazKotlinByteArray *y __attribute__((swift_name("y")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EcPrivateKeyOkp")))
@interface MultipazEcPrivateKeyOkp : MultipazEcPrivateKey
- (instancetype)initWithCurve:(MultipazEcCurve *)curve d:(MultipazKotlinByteArray *)d x:(MultipazKotlinByteArray *)x __attribute__((swift_name("init(curve:d:x:)"))) __attribute__((objc_designated_initializer));
- (MultipazEcPrivateKeyOkp *)doCopyCurve:(MultipazEcCurve *)curve d:(MultipazKotlinByteArray *)d x:(MultipazKotlinByteArray *)x __attribute__((swift_name("doCopy(curve:d:x:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (MultipazCoseKey *)toCoseKeyAdditionalLabels:(NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *)additionalLabels __attribute__((swift_name("toCoseKey(additionalLabels:)")));
- (NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> *)toJwkAdditionalClaims:(NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> * _Nullable)additionalClaims __attribute__((swift_name("toJwk(additionalClaims:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazEcCurve *curve __attribute__((swift_name("curve")));
@property (readonly) MultipazKotlinByteArray *d __attribute__((swift_name("d")));
@property (readonly) MultipazEcPublicKey *publicKey __attribute__((swift_name("publicKey")));
@property (readonly) MultipazKotlinByteArray *x __attribute__((swift_name("x")));
@end

__attribute__((swift_name("EcPublicKey")))
@interface MultipazEcPublicKey : MultipazBase
@property (class, readonly, getter=companion) MultipazEcPublicKeyCompanion *companion __attribute__((swift_name("companion")));
- (MultipazCoseKey *)toCoseKeyAdditionalLabels:(NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *)additionalLabels __attribute__((swift_name("toCoseKey(additionalLabels:)")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
- (NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> *)toJwkAdditionalClaims:(NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> * _Nullable)additionalClaims __attribute__((swift_name("toJwk(additionalClaims:)")));
- (NSString *)toPem __attribute__((swift_name("toPem()")));
@property (readonly) MultipazEcCurve *curve __attribute__((swift_name("curve")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EcPublicKey.Companion")))
@interface MultipazEcPublicKeyCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazEcPublicKeyCompanion *shared __attribute__((swift_name("shared")));
- (MultipazEcPublicKey *)fromCoseKeyCoseKey:(MultipazCoseKey *)coseKey __attribute__((swift_name("fromCoseKey(coseKey:)")));
- (MultipazEcPublicKey *)fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("fromDataItem(dataItem:)")));
- (MultipazEcPublicKey *)fromJwkJwk:(NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> *)jwk __attribute__((swift_name("fromJwk(jwk:)")));
- (MultipazEcPublicKey *)fromPemPemEncoding:(NSString *)pemEncoding curve:(MultipazEcCurve *)curve __attribute__((swift_name("fromPem(pemEncoding:curve:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EcPublicKeyDoubleCoordinate")))
@interface MultipazEcPublicKeyDoubleCoordinate : MultipazEcPublicKey
- (instancetype)initWithCurve:(MultipazEcCurve *)curve x:(MultipazKotlinByteArray *)x y:(MultipazKotlinByteArray *)y __attribute__((swift_name("init(curve:x:y:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazEcPublicKeyDoubleCoordinateCompanion *companion __attribute__((swift_name("companion")));
- (MultipazEcPublicKeyDoubleCoordinate *)doCopyCurve:(MultipazEcCurve *)curve x:(MultipazKotlinByteArray *)x y:(MultipazKotlinByteArray *)y __attribute__((swift_name("doCopy(curve:x:y:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (MultipazCoseKey *)toCoseKeyAdditionalLabels:(NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *)additionalLabels __attribute__((swift_name("toCoseKey(additionalLabels:)")));
- (NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> *)toJwkAdditionalClaims:(NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> * _Nullable)additionalClaims __attribute__((swift_name("toJwk(additionalClaims:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinByteArray *asUncompressedPointEncoding __attribute__((swift_name("asUncompressedPointEncoding")));
@property (readonly) MultipazEcCurve *curve __attribute__((swift_name("curve")));
@property (readonly) MultipazKotlinByteArray *x __attribute__((swift_name("x")));
@property (readonly) MultipazKotlinByteArray *y __attribute__((swift_name("y")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EcPublicKeyDoubleCoordinate.Companion")))
@interface MultipazEcPublicKeyDoubleCoordinateCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazEcPublicKeyDoubleCoordinateCompanion *shared __attribute__((swift_name("shared")));
- (MultipazEcPublicKeyDoubleCoordinate *)fromUncompressedPointEncodingCurve:(MultipazEcCurve *)curve encoded:(MultipazKotlinByteArray *)encoded __attribute__((swift_name("fromUncompressedPointEncoding(curve:encoded:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EcPublicKeyOkp")))
@interface MultipazEcPublicKeyOkp : MultipazEcPublicKey
- (instancetype)initWithCurve:(MultipazEcCurve *)curve x:(MultipazKotlinByteArray *)x __attribute__((swift_name("init(curve:x:)"))) __attribute__((objc_designated_initializer));
- (MultipazEcPublicKeyOkp *)doCopyCurve:(MultipazEcCurve *)curve x:(MultipazKotlinByteArray *)x __attribute__((swift_name("doCopy(curve:x:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (MultipazCoseKey *)toCoseKeyAdditionalLabels:(NSDictionary<MultipazCoseLabel *, MultipazDataItem *> *)additionalLabels __attribute__((swift_name("toCoseKey(additionalLabels:)")));
- (NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> *)toJwkAdditionalClaims:(NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> * _Nullable)additionalClaims __attribute__((swift_name("toJwk(additionalClaims:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazEcCurve *curve __attribute__((swift_name("curve")));
@property (readonly) MultipazKotlinByteArray *x __attribute__((swift_name("x")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EcSignature")))
@interface MultipazEcSignature : MultipazBase
- (instancetype)initWithR:(MultipazKotlinByteArray *)r s:(MultipazKotlinByteArray *)s __attribute__((swift_name("init(r:s:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazEcSignatureCompanion *companion __attribute__((swift_name("companion")));
- (MultipazEcSignature *)doCopyR:(MultipazKotlinByteArray *)r s:(MultipazKotlinByteArray *)s __attribute__((swift_name("doCopy(r:s:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (MultipazKotlinByteArray *)toCoseEncoded __attribute__((swift_name("toCoseEncoded()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
- (MultipazKotlinByteArray *)toDerEncoded __attribute__((swift_name("toDerEncoded()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinByteArray *r __attribute__((swift_name("r")));
@property (readonly) MultipazKotlinByteArray *s __attribute__((swift_name("s")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EcSignature.Companion")))
@interface MultipazEcSignatureCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazEcSignatureCompanion *shared __attribute__((swift_name("shared")));
- (MultipazEcSignature *)fromCoseEncodedCoseSignature:(MultipazKotlinByteArray *)coseSignature __attribute__((swift_name("fromCoseEncoded(coseSignature:)")));
- (MultipazEcSignature *)fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("fromDataItem(dataItem:)")));
- (MultipazEcSignature *)fromDerEncodedKeySizeBits:(int32_t)keySizeBits derEncodedSignature:(MultipazKotlinByteArray *)derEncodedSignature __attribute__((swift_name("fromDerEncoded(keySizeBits:derEncodedSignature:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("JsonWebEncryption")))
@interface MultipazJsonWebEncryption : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)jsonWebEncryption __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazJsonWebEncryption *shared __attribute__((swift_name("shared")));
- (NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> *)decryptEncryptedJwt:(NSString *)encryptedJwt recipientKey:(MultipazEcPrivateKey *)recipientKey __attribute__((swift_name("decrypt(encryptedJwt:recipientKey:)")));
- (NSString *)encryptClaimsSet:(NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> *)claimsSet recipientPublicKey:(MultipazEcPublicKey *)recipientPublicKey encAlg:(MultipazAlgorithm *)encAlg apu:(MultipazKotlinx_io_bytestringByteString * _Nullable)apu apv:(MultipazKotlinx_io_bytestringByteString * _Nullable)apv random:(MultipazKotlinRandom *)random compressionLevel:(MultipazInt * _Nullable)compressionLevel __attribute__((swift_name("encrypt(claimsSet:recipientPublicKey:encAlg:apu:apv:random:compressionLevel:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("JsonWebSignature")))
@interface MultipazJsonWebSignature : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)jsonWebSignature __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazJsonWebSignature *shared __attribute__((swift_name("shared")));
- (MultipazJsonWebSignatureJwsInfo *)getInfoJws:(NSString *)jws __attribute__((swift_name("getInfo(jws:)")));
- (NSString *)signKey:(MultipazEcPrivateKey *)key signatureAlgorithm:(MultipazAlgorithm *)signatureAlgorithm claimsSet:(NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> *)claimsSet type:(NSString * _Nullable)type x5c:(MultipazX509CertChain * _Nullable)x5c __attribute__((swift_name("sign(key:signatureAlgorithm:claimsSet:type:x5c:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)signSecureArea:(id<MultipazSecureArea>)secureArea alias:(NSString *)alias keyUnlockData:(id<MultipazKeyUnlockData> _Nullable)keyUnlockData claimsSet:(NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> *)claimsSet type:(NSString * _Nullable)type x5c:(MultipazX509CertChain * _Nullable)x5c completionHandler:(void (^)(NSString * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("sign(secureArea:alias:keyUnlockData:claimsSet:type:x5c:completionHandler:)")));
- (void)verifyJws:(NSString *)jws publicKey:(MultipazEcPublicKey *)publicKey __attribute__((swift_name("verify(jws:publicKey:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("JsonWebSignature.JwsInfo")))
@interface MultipazJsonWebSignatureJwsInfo : MultipazBase
- (instancetype)initWithClaimsSet:(NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> *)claimsSet type:(NSString * _Nullable)type x5c:(MultipazX509CertChain * _Nullable)x5c __attribute__((swift_name("init(claimsSet:type:x5c:)"))) __attribute__((objc_designated_initializer));
- (MultipazJsonWebSignatureJwsInfo *)doCopyClaimsSet:(NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> *)claimsSet type:(NSString * _Nullable)type x5c:(MultipazX509CertChain * _Nullable)x5c __attribute__((swift_name("doCopy(claimsSet:type:x5c:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> *claimsSet __attribute__((swift_name("claimsSet")));
@property (readonly) NSString * _Nullable type __attribute__((swift_name("type")));
@property (readonly) MultipazX509CertChain * _Nullable x5c __attribute__((swift_name("x5c")));
@end

__attribute__((swift_name("KotlinThrowable")))
@interface MultipazKotlinThrowable : MultipazBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));

/**
 * @note annotations
 *   kotlin.experimental.ExperimentalNativeApi
*/
- (MultipazKotlinArray<NSString *> *)getStackTrace __attribute__((swift_name("getStackTrace()")));
- (void)printStackTrace __attribute__((swift_name("printStackTrace()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinThrowable * _Nullable cause __attribute__((swift_name("cause")));
@property (readonly) NSString * _Nullable message __attribute__((swift_name("message")));
- (NSError *)asError __attribute__((swift_name("asError()")));
@end

__attribute__((swift_name("KotlinException")))
@interface MultipazKotlinException : MultipazKotlinThrowable
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((swift_name("SecurityException")))
@interface MultipazSecurityException : MultipazKotlinException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SignatureVerificationException")))
@interface MultipazSignatureVerificationException : MultipazSecurityException
- (instancetype)initWithMessage:(NSString *)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("X500Name")))
@interface MultipazX500Name : MultipazBase
- (instancetype)initWithComponents:(NSDictionary<NSString *, MultipazASN1String *> *)components __attribute__((swift_name("init(components:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazX500NameCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
@property (readonly) NSDictionary<NSString *, MultipazASN1String *> *components __attribute__((swift_name("components")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("X500Name.Companion")))
@interface MultipazX500NameCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazX500NameCompanion *shared __attribute__((swift_name("shared")));
- (MultipazX500Name *)fromNameName:(NSString *)name __attribute__((swift_name("fromName(name:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("X509Cert")))
@interface MultipazX509Cert : MultipazBase
- (instancetype)initWithEncodedCertificate:(MultipazKotlinByteArray *)encodedCertificate __attribute__((swift_name("init(encodedCertificate:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazX509CertCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (MultipazKotlinByteArray * _Nullable)getExtensionValueOid:(NSString *)oid __attribute__((swift_name("getExtensionValue(oid:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
- (NSString *)toPem __attribute__((swift_name("toPem()")));
- (void)verifyPublicKey:(MultipazEcPublicKey *)publicKey __attribute__((swift_name("verify(publicKey:)")));
@property (readonly) MultipazKotlinByteArray * _Nullable authorityKeyIdentifier __attribute__((swift_name("authorityKeyIdentifier")));
@property (readonly) NSSet<NSString *> *criticalExtensionOIDs __attribute__((swift_name("criticalExtensionOIDs")));
@property (readonly) MultipazEcPublicKey *ecPublicKey __attribute__((swift_name("ecPublicKey")));
@property (readonly) MultipazKotlinByteArray *encodedCertificate __attribute__((swift_name("encodedCertificate")));
@property (readonly) NSArray<MultipazX509Extension *> *extensions __attribute__((swift_name("extensions")));
@property (readonly) MultipazX500Name *issuer __attribute__((swift_name("issuer")));
@property (readonly) NSSet<MultipazX509KeyUsage *> *keyUsage __attribute__((swift_name("keyUsage")));
@property (readonly) NSSet<NSString *> *nonCriticalExtensionOIDs __attribute__((swift_name("nonCriticalExtensionOIDs")));
@property (readonly) MultipazASN1Integer *serialNumber __attribute__((swift_name("serialNumber")));
@property (readonly) MultipazKotlinByteArray *signature __attribute__((swift_name("signature")));
@property (readonly) MultipazAlgorithm *signatureAlgorithm __attribute__((swift_name("signatureAlgorithm")));
@property (readonly) NSString *signatureAlgorithmOid __attribute__((swift_name("signatureAlgorithmOid")));
@property (readonly) MultipazX500Name *subject __attribute__((swift_name("subject")));
@property (readonly) MultipazKotlinByteArray * _Nullable subjectKeyIdentifier __attribute__((swift_name("subjectKeyIdentifier")));
@property (readonly) MultipazKotlinByteArray *tbsCertificate __attribute__((swift_name("tbsCertificate")));
@property (readonly) MultipazKotlinx_datetimeInstant *validityNotAfter __attribute__((swift_name("validityNotAfter")));
@property (readonly) MultipazKotlinx_datetimeInstant *validityNotBefore __attribute__((swift_name("validityNotBefore")));
@property (readonly) int32_t version __attribute__((swift_name("version")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("X509Cert.Builder")))
@interface MultipazX509CertBuilder : MultipazBase
- (instancetype)initWithPublicKey:(MultipazEcPublicKey *)publicKey signingKey:(MultipazEcPrivateKey *)signingKey signatureAlgorithm:(MultipazAlgorithm *)signatureAlgorithm serialNumber:(MultipazASN1Integer *)serialNumber subject:(MultipazX500Name *)subject issuer:(MultipazX500Name *)issuer validFrom:(MultipazKotlinx_datetimeInstant *)validFrom validUntil:(MultipazKotlinx_datetimeInstant *)validUntil __attribute__((swift_name("init(publicKey:signingKey:signatureAlgorithm:serialNumber:subject:issuer:validFrom:validUntil:)"))) __attribute__((objc_designated_initializer));
- (MultipazX509CertBuilder *)addExtensionOid:(NSString *)oid critical:(BOOL)critical value:(MultipazKotlinByteArray *)value __attribute__((swift_name("addExtension(oid:critical:value:)")));
- (MultipazX509Cert *)build __attribute__((swift_name("build()")));
- (MultipazX509CertBuilder *)includeAuthorityKeyIdentifierAsSubjectKeyIdentifierValue:(BOOL)value __attribute__((swift_name("includeAuthorityKeyIdentifierAsSubjectKeyIdentifier(value:)")));
- (MultipazX509CertBuilder *)includeSubjectKeyIdentifierValue:(BOOL)value __attribute__((swift_name("includeSubjectKeyIdentifier(value:)")));
- (MultipazX509CertBuilder *)setAuthorityKeyIdentifierToCertificateCertificate:(MultipazX509Cert *)certificate __attribute__((swift_name("setAuthorityKeyIdentifierToCertificate(certificate:)")));
- (MultipazX509CertBuilder *)setBasicConstraintsCa:(BOOL)ca pathLenConstraint:(MultipazInt * _Nullable)pathLenConstraint __attribute__((swift_name("setBasicConstraints(ca:pathLenConstraint:)")));
- (MultipazX509CertBuilder *)setKeyUsageKeyUsage:(NSSet<MultipazX509KeyUsage *> *)keyUsage __attribute__((swift_name("setKeyUsage(keyUsage:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("X509Cert.Companion")))
@interface MultipazX509CertCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazX509CertCompanion *shared __attribute__((swift_name("shared")));
- (MultipazX509Cert *)fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("fromDataItem(dataItem:)")));
- (MultipazX509Cert *)fromPemPemEncoding:(NSString *)pemEncoding __attribute__((swift_name("fromPem(pemEncoding:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("X509CertChain")))
@interface MultipazX509CertChain : MultipazBase
- (instancetype)initWithCertificates:(NSArray<MultipazX509Cert *> *)certificates __attribute__((swift_name("init(certificates:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazX509CertChainCompanion *companion __attribute__((swift_name("companion")));
- (MultipazX509CertChain *)doCopyCertificates:(NSArray<MultipazX509Cert *> *)certificates __attribute__((swift_name("doCopy(certificates:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
- (NSString *)description __attribute__((swift_name("description()")));
- (MultipazKotlinx_serialization_jsonJsonElement *)toX5c __attribute__((swift_name("toX5c()")));
- (BOOL)validate __attribute__((swift_name("validate()")));
@property (readonly) NSArray<MultipazX509Cert *> *certificates __attribute__((swift_name("certificates")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("X509CertChain.Companion")))
@interface MultipazX509CertChainCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazX509CertChainCompanion *shared __attribute__((swift_name("shared")));
- (MultipazX509CertChain *)fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("fromDataItem(dataItem:)")));
- (MultipazX509CertChain *)fromX5cX5c:(MultipazKotlinx_serialization_jsonJsonElement *)x5c __attribute__((swift_name("fromX5c(x5c:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("X509Extension")))
@interface MultipazX509Extension : MultipazBase
- (instancetype)initWithOid:(NSString *)oid isCritical:(BOOL)isCritical data:(MultipazKotlinx_io_bytestringByteString *)data __attribute__((swift_name("init(oid:isCritical:data:)"))) __attribute__((objc_designated_initializer));
- (MultipazX509Extension *)doCopyOid:(NSString *)oid isCritical:(BOOL)isCritical data:(MultipazKotlinx_io_bytestringByteString *)data __attribute__((swift_name("doCopy(oid:isCritical:data:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *data __attribute__((swift_name("data")));
@property (readonly) BOOL isCritical __attribute__((swift_name("isCritical")));
@property (readonly) NSString *oid __attribute__((swift_name("oid")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("X509KeyUsage")))
@interface MultipazX509KeyUsage : MultipazKotlinEnum<MultipazX509KeyUsage *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazX509KeyUsageCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) MultipazX509KeyUsage *digitalSignature __attribute__((swift_name("digitalSignature")));
@property (class, readonly) MultipazX509KeyUsage *nonRepudiation __attribute__((swift_name("nonRepudiation")));
@property (class, readonly) MultipazX509KeyUsage *keyEncipherment __attribute__((swift_name("keyEncipherment")));
@property (class, readonly) MultipazX509KeyUsage *dataEncipherment __attribute__((swift_name("dataEncipherment")));
@property (class, readonly) MultipazX509KeyUsage *keyAgreement __attribute__((swift_name("keyAgreement")));
@property (class, readonly) MultipazX509KeyUsage *keyCertSign __attribute__((swift_name("keyCertSign")));
@property (class, readonly) MultipazX509KeyUsage *crlSign __attribute__((swift_name("crlSign")));
@property (class, readonly) MultipazX509KeyUsage *encipherOnly __attribute__((swift_name("encipherOnly")));
@property (class, readonly) MultipazX509KeyUsage *decipherOnly __attribute__((swift_name("decipherOnly")));
+ (MultipazKotlinArray<MultipazX509KeyUsage *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazX509KeyUsage *> *entries __attribute__((swift_name("entries")));
@property (readonly) int32_t bitNumber __attribute__((swift_name("bitNumber")));
@property (readonly) NSString *description_ __attribute__((swift_name("description_")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("X509KeyUsage.Companion")))
@interface MultipazX509KeyUsageCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazX509KeyUsageCompanion *shared __attribute__((swift_name("shared")));
- (NSSet<MultipazX509KeyUsage *> *)decodeSetEncodedValue:(MultipazASN1BitString *)encodedValue __attribute__((swift_name("decodeSet(encodedValue:)")));
- (MultipazASN1BitString *)encodeSetUsages:(NSSet<MultipazX509KeyUsage *> *)usages __attribute__((swift_name("encodeSet(usages:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("FormatStyle")))
@interface MultipazFormatStyle : MultipazKotlinEnum<MultipazFormatStyle *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) MultipazFormatStyle *short_ __attribute__((swift_name("short_")));
@property (class, readonly) MultipazFormatStyle *medium __attribute__((swift_name("medium")));
@property (class, readonly) MultipazFormatStyle *long_ __attribute__((swift_name("long_")));
@property (class, readonly) MultipazFormatStyle *full __attribute__((swift_name("full")));
+ (MultipazKotlinArray<MultipazFormatStyle *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazFormatStyle *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((swift_name("Assertion")))
@interface MultipazAssertion : MultipazBase
@property (class, readonly, getter=companion) MultipazAssertionCompanion *companion __attribute__((swift_name("companion")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Assertion.Companion")))
@interface MultipazAssertionCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazAssertionCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AssertionBindingKeys")))
@interface MultipazAssertionBindingKeys : MultipazAssertion
- (instancetype)initWithPublicKeys:(NSArray<MultipazEcPublicKey *> *)publicKeys nonce:(MultipazKotlinx_io_bytestringByteString *)nonce clientId:(NSString *)clientId keyStorage:(NSArray<NSString *> *)keyStorage userAuthentication:(NSArray<NSString *> *)userAuthentication issuedAt:(MultipazKotlinx_datetimeInstant *)issuedAt expiration:(MultipazKotlinx_datetimeInstant * _Nullable)expiration __attribute__((swift_name("init(publicKeys:nonce:clientId:keyStorage:userAuthentication:issuedAt:expiration:)"))) __attribute__((objc_designated_initializer));
- (MultipazAssertionBindingKeys *)doCopyPublicKeys:(NSArray<MultipazEcPublicKey *> *)publicKeys nonce:(MultipazKotlinx_io_bytestringByteString *)nonce clientId:(NSString *)clientId keyStorage:(NSArray<NSString *> *)keyStorage userAuthentication:(NSArray<NSString *> *)userAuthentication issuedAt:(MultipazKotlinx_datetimeInstant *)issuedAt expiration:(MultipazKotlinx_datetimeInstant * _Nullable)expiration __attribute__((swift_name("doCopy(publicKeys:nonce:clientId:keyStorage:userAuthentication:issuedAt:expiration:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *clientId __attribute__((swift_name("clientId")));
@property (readonly) MultipazKotlinx_datetimeInstant * _Nullable expiration __attribute__((swift_name("expiration")));
@property (readonly) MultipazKotlinx_datetimeInstant *issuedAt __attribute__((swift_name("issuedAt")));
@property (readonly) NSArray<NSString *> *keyStorage __attribute__((swift_name("keyStorage")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *nonce __attribute__((swift_name("nonce")));
@property (readonly) NSArray<MultipazEcPublicKey *> *publicKeys __attribute__((swift_name("publicKeys")));
@property (readonly) NSArray<NSString *> *userAuthentication __attribute__((swift_name("userAuthentication")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AssertionGenericCbor")))
@interface MultipazAssertionGenericCbor : MultipazAssertion
- (instancetype)initWithData:(MultipazDataItem *)data __attribute__((swift_name("init(data:)"))) __attribute__((objc_designated_initializer));
@property (readonly) MultipazDataItem *data __attribute__((swift_name("data")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AssertionNonce")))
@interface MultipazAssertionNonce : MultipazAssertion
- (instancetype)initWithNonce:(MultipazKotlinx_io_bytestringByteString *)nonce __attribute__((swift_name("init(nonce:)"))) __attribute__((objc_designated_initializer));
@property (readonly) MultipazKotlinx_io_bytestringByteString *nonce __attribute__((swift_name("nonce")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AssertionPoPKey")))
@interface MultipazAssertionPoPKey : MultipazAssertion
- (instancetype)initWithPublicKey:(MultipazEcPublicKey *)publicKey targetUrl:(NSString *)targetUrl __attribute__((swift_name("init(publicKey:targetUrl:)"))) __attribute__((objc_designated_initializer));
- (MultipazAssertionPoPKey *)doCopyPublicKey:(MultipazEcPublicKey *)publicKey targetUrl:(NSString *)targetUrl __attribute__((swift_name("doCopy(publicKey:targetUrl:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazEcPublicKey *publicKey __attribute__((swift_name("publicKey")));
@property (readonly) NSString *targetUrl __attribute__((swift_name("targetUrl")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AssertionRpcAuth")))
@interface MultipazAssertionRpcAuth : MultipazAssertion
- (instancetype)initWithTarget:(NSString *)target method:(NSString *)method nonce:(MultipazKotlinx_io_bytestringByteString *)nonce timestamp:(MultipazKotlinx_datetimeInstant *)timestamp clientId:(NSString *)clientId payloadHash:(MultipazKotlinx_io_bytestringByteString *)payloadHash __attribute__((swift_name("init(target:method:nonce:timestamp:clientId:payloadHash:)"))) __attribute__((objc_designated_initializer));
@property (readonly) NSString *clientId __attribute__((swift_name("clientId")));
@property (readonly) NSString *method __attribute__((swift_name("method")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *nonce __attribute__((swift_name("nonce")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *payloadHash __attribute__((swift_name("payloadHash")));
@property (readonly) NSString *target __attribute__((swift_name("target")));
@property (readonly) MultipazKotlinx_datetimeInstant *timestamp __attribute__((swift_name("timestamp")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceAssertion")))
@interface MultipazDeviceAssertion : MultipazBase
- (instancetype)initWithAssertionData:(MultipazKotlinx_io_bytestringByteString *)assertionData platformAssertion:(MultipazKotlinx_io_bytestringByteString *)platformAssertion __attribute__((swift_name("init(assertionData:platformAssertion:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazDeviceAssertionCompanion *companion __attribute__((swift_name("companion")));
- (MultipazDeviceAssertion *)doCopyAssertionData:(MultipazKotlinx_io_bytestringByteString *)assertionData platformAssertion:(MultipazKotlinx_io_bytestringByteString *)platformAssertion __attribute__((swift_name("doCopy(assertionData:platformAssertion:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazAssertion *assertion __attribute__((swift_name("assertion")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *assertionData __attribute__((swift_name("assertionData")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *platformAssertion __attribute__((swift_name("platformAssertion")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceAssertion.Companion")))
@interface MultipazDeviceAssertionCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazDeviceAssertionCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceAssertionException")))
@interface MultipazDeviceAssertionException : MultipazKotlinException
- (instancetype)initWithMessage:(NSString *)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@end

__attribute__((swift_name("DeviceAssertionMaker")))
@protocol MultipazDeviceAssertionMaker
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)makeDeviceAssertionAssertionFactory:(MultipazAssertion *(^)(NSString *))assertionFactory completionHandler:(void (^)(MultipazDeviceAssertion * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("makeDeviceAssertion(assertionFactory:completionHandler:)")));
@end

__attribute__((swift_name("DeviceAttestation")))
@interface MultipazDeviceAttestation : MultipazBase
@property (class, readonly, getter=companion) MultipazDeviceAttestationCompanion *companion __attribute__((swift_name("companion")));
- (void)validateValidationData:(MultipazDeviceAttestationValidationData *)validationData __attribute__((swift_name("validate(validationData:)")));
- (void)validateAssertionAssertion:(MultipazDeviceAssertion *)assertion __attribute__((swift_name("validateAssertion(assertion:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceAttestation.Companion")))
@interface MultipazDeviceAttestationCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazDeviceAttestationCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceAttestationAndroid")))
@interface MultipazDeviceAttestationAndroid : MultipazDeviceAttestation
- (instancetype)initWithCertificateChain:(MultipazX509CertChain *)certificateChain __attribute__((swift_name("init(certificateChain:)"))) __attribute__((objc_designated_initializer));
- (MultipazDeviceAttestationAndroid *)doCopyCertificateChain:(MultipazX509CertChain *)certificateChain __attribute__((swift_name("doCopy(certificateChain:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
- (void)validateValidationData:(MultipazDeviceAttestationValidationData *)validationData __attribute__((swift_name("validate(validationData:)")));
- (void)validateAssertionAssertion:(MultipazDeviceAssertion *)assertion __attribute__((swift_name("validateAssertion(assertion:)")));
@property (readonly) MultipazX509CertChain *certificateChain __attribute__((swift_name("certificateChain")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceAttestationException")))
@interface MultipazDeviceAttestationException : MultipazKotlinException
- (instancetype)initWithMessage:(NSString *)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceAttestationIos")))
@interface MultipazDeviceAttestationIos : MultipazDeviceAttestation
- (instancetype)initWithBlob:(MultipazKotlinx_io_bytestringByteString *)blob __attribute__((swift_name("init(blob:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazDeviceAttestationIosCompanion *companion __attribute__((swift_name("companion")));
- (MultipazDeviceAttestationIos *)doCopyBlob:(MultipazKotlinx_io_bytestringByteString *)blob __attribute__((swift_name("doCopy(blob:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
- (void)validateValidationData:(MultipazDeviceAttestationValidationData *)validationData __attribute__((swift_name("validate(validationData:)")));
- (void)validateAssertionAssertion:(MultipazDeviceAssertion *)assertion __attribute__((swift_name("validateAssertion(assertion:)")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *blob __attribute__((swift_name("blob")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceAttestationIos.Companion")))
@interface MultipazDeviceAttestationIosCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazDeviceAttestationIosCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) MultipazX509Cert *APPLE_ROOT_CERTIFICATE __attribute__((swift_name("APPLE_ROOT_CERTIFICATE")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *debugAaguid __attribute__((swift_name("debugAaguid")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *releaseAaguid __attribute__((swift_name("releaseAaguid")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceAttestationIos.ParsedAuthData")))
@interface MultipazDeviceAttestationIosParsedAuthData : MultipazBase
- (instancetype)initWithAppIdHash:(MultipazKotlinx_io_bytestringByteString *)appIdHash signCount:(int32_t)signCount aaguid:(MultipazKotlinx_io_bytestringByteString *)aaguid keyIdentifier:(MultipazKotlinx_io_bytestringByteString *)keyIdentifier publicKey:(MultipazEcPublicKey *)publicKey __attribute__((swift_name("init(appIdHash:signCount:aaguid:keyIdentifier:publicKey:)"))) __attribute__((objc_designated_initializer));
@property (readonly) MultipazKotlinx_io_bytestringByteString *aaguid __attribute__((swift_name("aaguid")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *appIdHash __attribute__((swift_name("appIdHash")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *keyIdentifier __attribute__((swift_name("keyIdentifier")));
@property (readonly) MultipazEcPublicKey *publicKey __attribute__((swift_name("publicKey")));
@property (readonly) int32_t signCount __attribute__((swift_name("signCount")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceAttestationJvm")))
@interface MultipazDeviceAttestationJvm : MultipazDeviceAttestation
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (void)validateValidationData:(MultipazDeviceAttestationValidationData *)validationData __attribute__((swift_name("validate(validationData:)")));
- (void)validateAssertionAssertion:(MultipazDeviceAssertion *)assertion __attribute__((swift_name("validateAssertion(assertion:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceAttestationResult")))
@interface MultipazDeviceAttestationResult : MultipazBase
- (instancetype)initWithDeviceAttestationId:(NSString *)deviceAttestationId deviceAttestation:(MultipazDeviceAttestation *)deviceAttestation __attribute__((swift_name("init(deviceAttestationId:deviceAttestation:)"))) __attribute__((objc_designated_initializer));
- (MultipazDeviceAttestationResult *)doCopyDeviceAttestationId:(NSString *)deviceAttestationId deviceAttestation:(MultipazDeviceAttestation *)deviceAttestation __attribute__((swift_name("doCopy(deviceAttestationId:deviceAttestation:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazDeviceAttestation *deviceAttestation __attribute__((swift_name("deviceAttestation")));
@property (readonly) NSString *deviceAttestationId __attribute__((swift_name("deviceAttestationId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceAttestationValidationData")))
@interface MultipazDeviceAttestationValidationData : MultipazBase
- (instancetype)initWithAttestationChallenge:(MultipazKotlinx_io_bytestringByteString *)attestationChallenge iosReleaseBuild:(BOOL)iosReleaseBuild iosAppIdentifier:(NSString * _Nullable)iosAppIdentifier androidGmsAttestation:(BOOL)androidGmsAttestation androidVerifiedBootGreen:(BOOL)androidVerifiedBootGreen androidAppSignatureCertificateDigests:(NSArray<MultipazKotlinx_io_bytestringByteString *> *)androidAppSignatureCertificateDigests __attribute__((swift_name("init(attestationChallenge:iosReleaseBuild:iosAppIdentifier:androidGmsAttestation:androidVerifiedBootGreen:androidAppSignatureCertificateDigests:)"))) __attribute__((objc_designated_initializer));
- (MultipazDeviceAttestationValidationData *)doCopyAttestationChallenge:(MultipazKotlinx_io_bytestringByteString *)attestationChallenge iosReleaseBuild:(BOOL)iosReleaseBuild iosAppIdentifier:(NSString * _Nullable)iosAppIdentifier androidGmsAttestation:(BOOL)androidGmsAttestation androidVerifiedBootGreen:(BOOL)androidVerifiedBootGreen androidAppSignatureCertificateDigests:(NSArray<MultipazKotlinx_io_bytestringByteString *> *)androidAppSignatureCertificateDigests __attribute__((swift_name("doCopy(attestationChallenge:iosReleaseBuild:iosAppIdentifier:androidGmsAttestation:androidVerifiedBootGreen:androidAppSignatureCertificateDigests:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSArray<MultipazKotlinx_io_bytestringByteString *> *androidAppSignatureCertificateDigests __attribute__((swift_name("androidAppSignatureCertificateDigests")));
@property (readonly) BOOL androidGmsAttestation __attribute__((swift_name("androidGmsAttestation")));
@property (readonly) BOOL androidVerifiedBootGreen __attribute__((swift_name("androidVerifiedBootGreen")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *attestationChallenge __attribute__((swift_name("attestationChallenge")));
@property (readonly) NSString * _Nullable iosAppIdentifier __attribute__((swift_name("iosAppIdentifier")));
@property (readonly) BOOL iosReleaseBuild __attribute__((swift_name("iosReleaseBuild")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceCheck")))
@interface MultipazDeviceCheck : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)deviceCheck __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazDeviceCheck *shared __attribute__((swift_name("shared")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)generateAssertionSecureArea:(id<MultipazSecureArea>)secureArea deviceAttestationId:(NSString *)deviceAttestationId assertion:(MultipazAssertion *)assertion completionHandler:(void (^)(MultipazDeviceAssertion * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("generateAssertion(secureArea:deviceAttestationId:assertion:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)generateAttestationSecureArea:(id<MultipazSecureArea>)secureArea challenge:(MultipazKotlinx_io_bytestringByteString *)challenge completionHandler:(void (^)(MultipazDeviceAttestationResult * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("generateAttestation(secureArea:challenge:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Document")))
@interface MultipazDocument : MultipazBase
@property (class, readonly, getter=companion) MultipazDocumentCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)countUsableCredentialsAt:(MultipazKotlinx_datetimeInstant *)at completionHandler:(void (^)(MultipazDocumentUsableCredentialResult * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("countUsableCredentials(at:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)deleteCredentialCredentialIdentifier:(NSString *)credentialIdentifier completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("deleteCredential(credentialIdentifier:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)deleteInvalidatedCredentialsWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("deleteInvalidatedCredentials(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)findCredentialDomain:(NSString *)domain now:(MultipazKotlinx_datetimeInstant * _Nullable)now completionHandler:(void (^)(MultipazCredential * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("findCredential(domain:now:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getCertifiedCredentialsWithCompletionHandler:(void (^)(NSArray<MultipazCredential *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getCertifiedCredentials(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getCertifiedCredentialsForDomainDomain:(NSString *)domain completionHandler:(void (^)(NSArray<MultipazCredential *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getCertifiedCredentialsForDomain(domain:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getCredentialIdentifiersWithCompletionHandler:(void (^)(NSArray<NSString *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getCredentialIdentifiers(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getCredentialsWithCompletionHandler:(void (^)(NSArray<MultipazCredential *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getCredentials(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getPendingCredentialsWithCompletionHandler:(void (^)(NSArray<MultipazCredential *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getPendingCredentials(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getPendingCredentialsForDomainDomain:(NSString *)domain completionHandler:(void (^)(NSArray<MultipazCredential *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getPendingCredentialsForDomain(domain:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getReplacementCredentialForCredentialIdentifier:(NSString *)credentialIdentifier completionHandler:(void (^)(MultipazCredential * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("getReplacementCredentialFor(credentialIdentifier:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)hasUsableCredentialAt:(MultipazKotlinx_datetimeInstant *)at completionHandler:(void (^)(MultipazBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("hasUsableCredential(at:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)lookupCredentialCredentialIdentifier:(NSString *)credentialIdentifier completionHandler:(void (^)(MultipazCredential * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("lookupCredential(credentialIdentifier:completionHandler:)")));
@property (readonly) NSString *identifier __attribute__((swift_name("identifier")));
@property (readonly) id<MultipazDocumentMetadata> metadata __attribute__((swift_name("metadata")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Document.Companion")))
@interface MultipazDocumentCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazDocumentCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) MultipazStorageTableSpec *defaultTableSpec __attribute__((swift_name("defaultTableSpec")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Document.UsableCredentialResult")))
@interface MultipazDocumentUsableCredentialResult : MultipazBase
- (instancetype)initWithNumCredentials:(int32_t)numCredentials numCredentialsAvailable:(int32_t)numCredentialsAvailable __attribute__((swift_name("init(numCredentials:numCredentialsAvailable:)"))) __attribute__((objc_designated_initializer));
- (MultipazDocumentUsableCredentialResult *)doCopyNumCredentials:(int32_t)numCredentials numCredentialsAvailable:(int32_t)numCredentialsAvailable __attribute__((swift_name("doCopy(numCredentials:numCredentialsAvailable:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t numCredentials __attribute__((swift_name("numCredentials")));
@property (readonly) int32_t numCredentialsAvailable __attribute__((swift_name("numCredentialsAvailable")));
@end

__attribute__((swift_name("DocumentEvent")))
@interface MultipazDocumentEvent : MultipazBase
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *documentId __attribute__((swift_name("documentId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentAdded")))
@interface MultipazDocumentAdded : MultipazDocumentEvent
- (instancetype)initWithDocumentId:(NSString *)documentId __attribute__((swift_name("init(documentId:)"))) __attribute__((objc_designated_initializer));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentDeleted")))
@interface MultipazDocumentDeleted : MultipazDocumentEvent
- (instancetype)initWithDocumentId:(NSString *)documentId __attribute__((swift_name("init(documentId:)"))) __attribute__((objc_designated_initializer));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
@end

__attribute__((swift_name("DocumentMetadata")))
@protocol MultipazDocumentMetadata
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)documentDeletedWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("documentDeleted(completionHandler:)")));
@property (readonly) MultipazKotlinx_io_bytestringByteString * _Nullable cardArt __attribute__((swift_name("cardArt")));
@property (readonly) NSString * _Nullable displayName __attribute__((swift_name("displayName")));
@property (readonly) MultipazKotlinx_io_bytestringByteString * _Nullable issuerLogo __attribute__((swift_name("issuerLogo")));
@property (readonly) BOOL provisioned __attribute__((swift_name("provisioned")));
@property (readonly) NSString * _Nullable typeDisplayName __attribute__((swift_name("typeDisplayName")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentMetadataCompanion")))
@interface MultipazDocumentMetadataCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazDocumentMetadataCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentRequest")))
@interface MultipazDocumentRequest : MultipazBase
- (instancetype)initWithRequestedDataElements:(NSArray<MultipazDocumentRequestDataElement *> *)requestedDataElements __attribute__((swift_name("init(requestedDataElements:)"))) __attribute__((objc_designated_initializer));
@property (readonly) NSArray<MultipazDocumentRequestDataElement *> *requestedDataElements __attribute__((swift_name("requestedDataElements")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentRequest.DataElement")))
@interface MultipazDocumentRequestDataElement : MultipazBase
- (instancetype)initWithNameSpaceName:(NSString *)nameSpaceName dataElementName:(NSString *)dataElementName intentToRetain:(BOOL)intentToRetain doNotSend:(BOOL)doNotSend __attribute__((swift_name("init(nameSpaceName:dataElementName:intentToRetain:doNotSend:)"))) __attribute__((objc_designated_initializer));
- (MultipazDocumentRequestDataElement *)doCopyNameSpaceName:(NSString *)nameSpaceName dataElementName:(NSString *)dataElementName intentToRetain:(BOOL)intentToRetain doNotSend:(BOOL)doNotSend __attribute__((swift_name("doCopy(nameSpaceName:dataElementName:intentToRetain:doNotSend:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *dataElementName __attribute__((swift_name("dataElementName")));
@property BOOL doNotSend __attribute__((swift_name("doNotSend")));
@property (readonly) BOOL intentToRetain __attribute__((swift_name("intentToRetain")));
@property (readonly) NSString *nameSpaceName __attribute__((swift_name("nameSpaceName")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentStore")))
@interface MultipazDocumentStore : MultipazBase
- (instancetype)initWithStorage:(id<MultipazStorage>)storage secureAreaRepository:(MultipazSecureAreaRepository *)secureAreaRepository credentialLoader:(MultipazCredentialLoader *)credentialLoader documentMetadataFactory:(id<MultipazKotlinSuspendFunction3>)documentMetadataFactory documentTableSpec:(MultipazStorageTableSpec *)documentTableSpec __attribute__((swift_name("init(storage:secureAreaRepository:credentialLoader:documentMetadataFactory:documentTableSpec:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazDocumentStoreCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)createDocumentMetadataInitializer:(id<MultipazKotlinSuspendFunction1>)metadataInitializer completionHandler:(void (^)(MultipazDocument * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("createDocument(metadataInitializer:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)deleteDocumentIdentifier:(NSString *)identifier completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("deleteDocument(identifier:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)listDocumentsWithCompletionHandler:(void (^)(NSArray<NSString *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("listDocuments(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)lookupDocumentIdentifier:(NSString *)identifier completionHandler:(void (^)(MultipazDocument * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("lookupDocument(identifier:completionHandler:)")));
@property (readonly) id<MultipazKotlinx_coroutines_coreSharedFlow> eventFlow __attribute__((swift_name("eventFlow")));
@property (readonly) id<MultipazStorage> storage __attribute__((swift_name("storage")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentStore.Companion")))
@interface MultipazDocumentStoreCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazDocumentStoreCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) NSString *TAG __attribute__((swift_name("TAG")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentUpdated")))
@interface MultipazDocumentUpdated : MultipazDocumentEvent
- (instancetype)initWithDocumentId:(NSString *)documentId __attribute__((swift_name("init(documentId:)"))) __attribute__((objc_designated_initializer));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentUtil")))
@interface MultipazDocumentUtil : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)documentUtil __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazDocumentUtil *shared __attribute__((swift_name("shared")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)managedCredentialHelperDocument:(MultipazDocument *)document domain:(NSString *)domain createCredential:(id<MultipazKotlinSuspendFunction1> _Nullable)createCredential now:(MultipazKotlinx_datetimeInstant *)now numCredentials:(int32_t)numCredentials maxUsesPerCredential:(int32_t)maxUsesPerCredential minValidTimeMillis:(int64_t)minValidTimeMillis dryRun:(BOOL)dryRun completionHandler:(void (^)(MultipazInt * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("managedCredentialHelper(document:domain:createCredential:now:numCredentials:maxUsesPerCredential:minValidTimeMillis:dryRun:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NameSpacedData")))
@interface MultipazNameSpacedData : MultipazBase
@property (class, readonly, getter=companion) MultipazNameSpacedDataCompanion *companion __attribute__((swift_name("companion")));
- (MultipazKotlinByteArray *)encodeAsCbor __attribute__((swift_name("encodeAsCbor()")));
- (MultipazKotlinByteArray *)getDataElementNameSpaceName:(NSString *)nameSpaceName dataElementName:(NSString *)dataElementName __attribute__((swift_name("getDataElement(nameSpaceName:dataElementName:)")));
- (BOOL)getDataElementBooleanNameSpaceName:(NSString *)nameSpaceName dataElementName:(NSString *)dataElementName __attribute__((swift_name("getDataElementBoolean(nameSpaceName:dataElementName:)")));
- (MultipazKotlinByteArray *)getDataElementByteStringNameSpaceName:(NSString *)nameSpaceName dataElementName:(NSString *)dataElementName __attribute__((swift_name("getDataElementByteString(nameSpaceName:dataElementName:)")));
- (NSArray<NSString *> *)getDataElementNamesNameSpaceName:(NSString *)nameSpaceName __attribute__((swift_name("getDataElementNames(nameSpaceName:)")));
- (int64_t)getDataElementNumberNameSpaceName:(NSString *)nameSpaceName dataElementName:(NSString *)dataElementName __attribute__((swift_name("getDataElementNumber(nameSpaceName:dataElementName:)")));
- (NSString *)getDataElementStringNameSpaceName:(NSString *)nameSpaceName dataElementName:(NSString *)dataElementName __attribute__((swift_name("getDataElementString(nameSpaceName:dataElementName:)")));
- (BOOL)hasDataElementNameSpaceName:(NSString *)nameSpaceName dataElementName:(NSString *)dataElementName __attribute__((swift_name("hasDataElement(nameSpaceName:dataElementName:)")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@property (readonly) NSArray<NSString *> *nameSpaceNames __attribute__((swift_name("nameSpaceNames")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NameSpacedData.Builder")))
@interface MultipazNameSpacedDataBuilder : MultipazBase
- (instancetype)initWithNameSpacedDataToCopyFrom:(MultipazNameSpacedData * _Nullable)nameSpacedDataToCopyFrom __attribute__((swift_name("init(nameSpacedDataToCopyFrom:)"))) __attribute__((objc_designated_initializer));
- (MultipazNameSpacedData *)build __attribute__((swift_name("build()")));
- (MultipazNameSpacedDataBuilder *)putEntryNameSpaceName:(NSString *)nameSpaceName dataElementName:(NSString *)dataElementName value:(MultipazKotlinByteArray *)value __attribute__((swift_name("putEntry(nameSpaceName:dataElementName:value:)")));
- (MultipazNameSpacedDataBuilder *)putEntryBooleanNameSpaceName:(NSString *)nameSpaceName dataElementName:(NSString *)dataElementName value:(BOOL)value __attribute__((swift_name("putEntryBoolean(nameSpaceName:dataElementName:value:)")));
- (MultipazNameSpacedDataBuilder *)putEntryByteStringNameSpaceName:(NSString *)nameSpaceName dataElementName:(NSString *)dataElementName value:(MultipazKotlinByteArray *)value __attribute__((swift_name("putEntryByteString(nameSpaceName:dataElementName:value:)")));
- (MultipazNameSpacedDataBuilder *)putEntryNumberNameSpaceName:(NSString *)nameSpaceName dataElementName:(NSString *)dataElementName value:(int64_t)value __attribute__((swift_name("putEntryNumber(nameSpaceName:dataElementName:value:)")));
- (MultipazNameSpacedDataBuilder *)putEntryStringNameSpaceName:(NSString *)nameSpaceName dataElementName:(NSString *)dataElementName value:(NSString *)value __attribute__((swift_name("putEntryString(nameSpaceName:dataElementName:value:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NameSpacedData.Companion")))
@interface MultipazNameSpacedDataCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazNameSpacedDataCompanion *shared __attribute__((swift_name("shared")));
- (MultipazNameSpacedData *)fromDataItemMapDataItem:(MultipazDataItem *)mapDataItem __attribute__((swift_name("fromDataItem(mapDataItem:)")));
- (MultipazNameSpacedData *)fromEncodedCborEncodedCbor:(MultipazKotlinByteArray *)encodedCbor __attribute__((swift_name("fromEncodedCbor(encodedCbor:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SimpleDocumentMetadata")))
@interface MultipazSimpleDocumentMetadata : MultipazBase <MultipazDocumentMetadata>
@property (class, readonly, getter=companion) MultipazSimpleDocumentMetadataCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)documentDeletedWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("documentDeleted(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)markAsProvisionedWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("markAsProvisioned(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)setBasicPropertiesDisplayName:(NSString *)displayName typeDisplayName:(NSString *)typeDisplayName cardArt:(MultipazKotlinx_io_bytestringByteString * _Nullable)cardArt issuerLogo:(MultipazKotlinx_io_bytestringByteString * _Nullable)issuerLogo completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("setBasicProperties(displayName:typeDisplayName:cardArt:issuerLogo:completionHandler:)")));
@property (readonly) MultipazKotlinx_io_bytestringByteString * _Nullable cardArt __attribute__((swift_name("cardArt")));
@property (readonly) NSString * _Nullable displayName __attribute__((swift_name("displayName")));
@property (readonly) MultipazKotlinx_io_bytestringByteString * _Nullable issuerLogo __attribute__((swift_name("issuerLogo")));
@property (readonly) BOOL provisioned __attribute__((swift_name("provisioned")));
@property (readonly) NSString * _Nullable typeDisplayName __attribute__((swift_name("typeDisplayName")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SimpleDocumentMetadata.Companion")))
@interface MultipazSimpleDocumentMetadataCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazSimpleDocumentMetadataCompanion *shared __attribute__((swift_name("shared")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)createDocumentId:(NSString *)documentId serializedData:(MultipazKotlinx_io_bytestringByteString * _Nullable)serializedData saveFn:(id<MultipazKotlinSuspendFunction1>)saveFn completionHandler:(void (^)(MultipazSimpleDocumentMetadata * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("create(documentId:serializedData:saveFn:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SimpleDocumentMetadata.Data")))
@interface MultipazSimpleDocumentMetadataData : MultipazBase
- (instancetype)initWithProvisioned:(BOOL)provisioned displayName:(NSString * _Nullable)displayName typeDisplayName:(NSString * _Nullable)typeDisplayName cardArt:(MultipazKotlinx_io_bytestringByteString * _Nullable)cardArt issuerLogo:(MultipazKotlinx_io_bytestringByteString * _Nullable)issuerLogo __attribute__((swift_name("init(provisioned:displayName:typeDisplayName:cardArt:issuerLogo:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazSimpleDocumentMetadataDataCompanion *companion __attribute__((swift_name("companion")));
- (MultipazSimpleDocumentMetadataData *)doCopyProvisioned:(BOOL)provisioned displayName:(NSString * _Nullable)displayName typeDisplayName:(NSString * _Nullable)typeDisplayName cardArt:(MultipazKotlinx_io_bytestringByteString * _Nullable)cardArt issuerLogo:(MultipazKotlinx_io_bytestringByteString * _Nullable)issuerLogo __attribute__((swift_name("doCopy(provisioned:displayName:typeDisplayName:cardArt:issuerLogo:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinx_io_bytestringByteString * _Nullable cardArt __attribute__((swift_name("cardArt")));
@property (readonly) NSString * _Nullable displayName __attribute__((swift_name("displayName")));
@property (readonly) MultipazKotlinx_io_bytestringByteString * _Nullable issuerLogo __attribute__((swift_name("issuerLogo")));
@property (readonly) BOOL provisioned __attribute__((swift_name("provisioned")));
@property (readonly) NSString * _Nullable typeDisplayName __attribute__((swift_name("typeDisplayName")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SimpleDocumentMetadata.DataCompanion")))
@interface MultipazSimpleDocumentMetadataDataCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazSimpleDocumentMetadataDataCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentAttribute")))
@interface MultipazDocumentAttribute : MultipazBase
- (instancetype)initWithType:(MultipazDocumentAttributeType *)type identifier:(NSString *)identifier displayName:(NSString *)displayName description:(NSString *)description icon:(MultipazIcon * _Nullable)icon sampleValueMdoc:(MultipazDataItem * _Nullable)sampleValueMdoc sampleValueVc:(MultipazKotlinx_serialization_jsonJsonElement * _Nullable)sampleValueVc __attribute__((swift_name("init(type:identifier:displayName:description:icon:sampleValueMdoc:sampleValueVc:)"))) __attribute__((objc_designated_initializer));
- (MultipazDocumentAttribute *)doCopyType:(MultipazDocumentAttributeType *)type identifier:(NSString *)identifier displayName:(NSString *)displayName description:(NSString *)description icon:(MultipazIcon * _Nullable)icon sampleValueMdoc:(MultipazDataItem * _Nullable)sampleValueMdoc sampleValueVc:(MultipazKotlinx_serialization_jsonJsonElement * _Nullable)sampleValueVc __attribute__((swift_name("doCopy(type:identifier:displayName:description:icon:sampleValueMdoc:sampleValueVc:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *description_ __attribute__((swift_name("description_")));
@property (readonly) NSString *displayName __attribute__((swift_name("displayName")));
@property (readonly) MultipazIcon * _Nullable icon __attribute__((swift_name("icon")));
@property (readonly) NSString *identifier __attribute__((swift_name("identifier")));
@property (readonly) MultipazDataItem * _Nullable sampleValueMdoc __attribute__((swift_name("sampleValueMdoc")));
@property (readonly) MultipazKotlinx_serialization_jsonJsonElement * _Nullable sampleValueVc __attribute__((swift_name("sampleValueVc")));
@property (readonly) MultipazDocumentAttributeType *type __attribute__((swift_name("type")));
@end

__attribute__((swift_name("DocumentAttributeType")))
@interface MultipazDocumentAttributeType : MultipazBase
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentAttributeType.Blob")))
@interface MultipazDocumentAttributeTypeBlob : MultipazDocumentAttributeType
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)blob __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazDocumentAttributeTypeBlob *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentAttributeType.Boolean")))
@interface MultipazDocumentAttributeTypeBoolean : MultipazDocumentAttributeType
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)boolean __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazDocumentAttributeTypeBoolean *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentAttributeType.ComplexType")))
@interface MultipazDocumentAttributeTypeComplexType : MultipazDocumentAttributeType
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)complexType __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazDocumentAttributeTypeComplexType *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentAttributeType.Date")))
@interface MultipazDocumentAttributeTypeDate : MultipazDocumentAttributeType
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)date __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazDocumentAttributeTypeDate *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentAttributeType.DateTime")))
@interface MultipazDocumentAttributeTypeDateTime : MultipazDocumentAttributeType
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)dateTime __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazDocumentAttributeTypeDateTime *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentAttributeType.IntegerOptions")))
@interface MultipazDocumentAttributeTypeIntegerOptions : MultipazDocumentAttributeType
- (instancetype)initWithOptions:(NSArray<MultipazIntegerOption *> *)options __attribute__((swift_name("init(options:)"))) __attribute__((objc_designated_initializer));
@property (readonly) NSArray<MultipazIntegerOption *> *options __attribute__((swift_name("options")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentAttributeType.Number")))
@interface MultipazDocumentAttributeTypeNumber : MultipazDocumentAttributeType
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)number __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazDocumentAttributeTypeNumber *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentAttributeType.Picture")))
@interface MultipazDocumentAttributeTypePicture : MultipazDocumentAttributeType
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)picture __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazDocumentAttributeTypePicture *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentAttributeType.String")))
@interface MultipazDocumentAttributeTypeString : MultipazDocumentAttributeType
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)string __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazDocumentAttributeTypeString *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentAttributeType.StringOptions")))
@interface MultipazDocumentAttributeTypeStringOptions : MultipazDocumentAttributeType
- (instancetype)initWithOptions:(NSArray<MultipazStringOption *> *)options __attribute__((swift_name("init(options:)"))) __attribute__((objc_designated_initializer));
@property (readonly) NSArray<MultipazStringOption *> *options __attribute__((swift_name("options")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentCannedRequest")))
@interface MultipazDocumentCannedRequest : MultipazBase
- (instancetype)initWithId:(NSString *)id displayName:(NSString *)displayName mdocRequest:(MultipazMdocCannedRequest * _Nullable)mdocRequest vcRequest:(MultipazVcCannedRequest * _Nullable)vcRequest __attribute__((swift_name("init(id:displayName:mdocRequest:vcRequest:)"))) __attribute__((objc_designated_initializer));
- (MultipazDocumentCannedRequest *)doCopyId:(NSString *)id displayName:(NSString *)displayName mdocRequest:(MultipazMdocCannedRequest * _Nullable)mdocRequest vcRequest:(MultipazVcCannedRequest * _Nullable)vcRequest __attribute__((swift_name("doCopy(id:displayName:mdocRequest:vcRequest:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *displayName __attribute__((swift_name("displayName")));
@property (readonly) NSString *id __attribute__((swift_name("id")));
@property (readonly) MultipazMdocCannedRequest * _Nullable mdocRequest __attribute__((swift_name("mdocRequest")));
@property (readonly) MultipazVcCannedRequest * _Nullable vcRequest __attribute__((swift_name("vcRequest")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentType")))
@interface MultipazDocumentType : MultipazBase
@property (readonly) NSArray<MultipazDocumentCannedRequest *> *cannedRequests __attribute__((swift_name("cannedRequests")));
@property (readonly) NSString *displayName __attribute__((swift_name("displayName")));
@property (readonly) MultipazMdocDocumentType * _Nullable mdocDocumentType __attribute__((swift_name("mdocDocumentType")));
@property (readonly) MultipazVcDocumentType * _Nullable vcDocumentType __attribute__((swift_name("vcDocumentType")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentType.Builder")))
@interface MultipazDocumentTypeBuilder : MultipazBase
- (instancetype)initWithDisplayName:(NSString *)displayName mdocBuilder:(MultipazMdocDocumentTypeBuilder * _Nullable)mdocBuilder vcBuilder:(MultipazVcDocumentTypeBuilder * _Nullable)vcBuilder __attribute__((swift_name("init(displayName:mdocBuilder:vcBuilder:)"))) __attribute__((objc_designated_initializer));
- (MultipazDocumentTypeBuilder *)addAttributeType:(MultipazDocumentAttributeType *)type identifier:(NSString *)identifier displayName:(NSString *)displayName description:(NSString *)description mandatory:(BOOL)mandatory mdocNamespace:(NSString *)mdocNamespace icon:(MultipazIcon * _Nullable)icon sampleValueMdoc:(MultipazDataItem * _Nullable)sampleValueMdoc sampleValueVc:(MultipazKotlinx_serialization_jsonJsonElement * _Nullable)sampleValueVc __attribute__((swift_name("addAttribute(type:identifier:displayName:description:mandatory:mdocNamespace:icon:sampleValueMdoc:sampleValueVc:)")));
- (MultipazDocumentTypeBuilder *)addAttributeType:(MultipazDocumentAttributeType *)type mdocIdentifier:(NSString *)mdocIdentifier vcIdentifier:(NSString *)vcIdentifier displayName:(NSString *)displayName description:(NSString *)description mandatory:(BOOL)mandatory mdocNamespace:(NSString *)mdocNamespace icon:(MultipazIcon * _Nullable)icon sampleValueMdoc:(MultipazDataItem * _Nullable)sampleValueMdoc sampleValueVc:(MultipazKotlinx_serialization_jsonJsonElement * _Nullable)sampleValueVc __attribute__((swift_name("addAttribute(type:mdocIdentifier:vcIdentifier:displayName:description:mandatory:mdocNamespace:icon:sampleValueMdoc:sampleValueVc:)")));
- (MultipazDocumentTypeBuilder *)addMdocAttributeType:(MultipazDocumentAttributeType *)type identifier:(NSString *)identifier displayName:(NSString *)displayName description:(NSString *)description mandatory:(BOOL)mandatory mdocNamespace:(NSString *)mdocNamespace icon:(MultipazIcon * _Nullable)icon sampleValue:(MultipazDataItem * _Nullable)sampleValue __attribute__((swift_name("addMdocAttribute(type:identifier:displayName:description:mandatory:mdocNamespace:icon:sampleValue:)")));
- (MultipazDocumentTypeBuilder *)addMdocDocumentTypeMdocDocType:(NSString *)mdocDocType __attribute__((swift_name("addMdocDocumentType(mdocDocType:)")));
- (MultipazDocumentTypeBuilder *)addSampleRequestId:(NSString *)id displayName:(NSString *)displayName mdocDataElements:(NSDictionary<NSString *, NSDictionary<NSString *, MultipazBoolean *> *> * _Nullable)mdocDataElements vcClaims:(NSArray<NSString *> * _Nullable)vcClaims __attribute__((swift_name("addSampleRequest(id:displayName:mdocDataElements:vcClaims:)")));
- (MultipazDocumentTypeBuilder *)addVcAttributeType:(MultipazDocumentAttributeType *)type identifier:(NSString *)identifier displayName:(NSString *)displayName description:(NSString *)description icon:(MultipazIcon * _Nullable)icon sampleValue:(MultipazKotlinx_serialization_jsonJsonElement * _Nullable)sampleValue __attribute__((swift_name("addVcAttribute(type:identifier:displayName:description:icon:sampleValue:)")));
- (MultipazDocumentTypeBuilder *)addVcDocumentTypeVct:(NSString *)vct keyBound:(BOOL)keyBound __attribute__((swift_name("addVcDocumentType(vct:keyBound:)")));
- (MultipazDocumentType *)build __attribute__((swift_name("build()")));
- (MultipazDocumentTypeBuilder *)doCopyDisplayName:(NSString *)displayName mdocBuilder:(MultipazMdocDocumentTypeBuilder * _Nullable)mdocBuilder vcBuilder:(MultipazVcDocumentTypeBuilder * _Nullable)vcBuilder __attribute__((swift_name("doCopy(displayName:mdocBuilder:vcBuilder:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *displayName __attribute__((swift_name("displayName")));
@property MultipazMdocDocumentTypeBuilder * _Nullable mdocBuilder __attribute__((swift_name("mdocBuilder")));
@property MultipazVcDocumentTypeBuilder * _Nullable vcBuilder __attribute__((swift_name("vcBuilder")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentTypeRepository")))
@interface MultipazDocumentTypeRepository : MultipazBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (BOOL)addDocumentTypeDocumentType:(MultipazDocumentType *)documentType __attribute__((swift_name("addDocumentType(documentType:)")));
- (MultipazDocumentType * _Nullable)getDocumentTypeForMdocMdocDocType:(NSString *)mdocDocType __attribute__((swift_name("getDocumentTypeForMdoc(mdocDocType:)")));
- (MultipazDocumentType * _Nullable)getDocumentTypeForMdocNamespaceMdocNamespace:(NSString *)mdocNamespace __attribute__((swift_name("getDocumentTypeForMdocNamespace(mdocNamespace:)")));
- (MultipazDocumentType * _Nullable)getDocumentTypeForVcVct:(NSString *)vct __attribute__((swift_name("getDocumentTypeForVc(vct:)")));
@property (readonly) NSArray<MultipazDocumentType *> *documentTypes __attribute__((swift_name("documentTypes")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Icon")))
@interface MultipazIcon : MultipazKotlinEnum<MultipazIcon *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) MultipazIcon *person __attribute__((swift_name("person")));
@property (class, readonly) MultipazIcon *today __attribute__((swift_name("today")));
@property (class, readonly) MultipazIcon *dateRange __attribute__((swift_name("dateRange")));
@property (class, readonly) MultipazIcon *calendarClock __attribute__((swift_name("calendarClock")));
@property (class, readonly) MultipazIcon *accountBalance __attribute__((swift_name("accountBalance")));
@property (class, readonly) MultipazIcon *numbers __attribute__((swift_name("numbers")));
@property (class, readonly) MultipazIcon *accountBox __attribute__((swift_name("accountBox")));
@property (class, readonly) MultipazIcon *directionsCar __attribute__((swift_name("directionsCar")));
@property (class, readonly) MultipazIcon *language __attribute__((swift_name("language")));
@property (class, readonly) MultipazIcon *emergency __attribute__((swift_name("emergency")));
@property (class, readonly) MultipazIcon *place __attribute__((swift_name("place")));
@property (class, readonly) MultipazIcon *signature __attribute__((swift_name("signature")));
@property (class, readonly) MultipazIcon *militaryTech __attribute__((swift_name("militaryTech")));
@property (class, readonly) MultipazIcon *stars __attribute__((swift_name("stars")));
@property (class, readonly) MultipazIcon *face __attribute__((swift_name("face")));
@property (class, readonly) MultipazIcon *fingerprint __attribute__((swift_name("fingerprint")));
@property (class, readonly) MultipazIcon *eyeTracking __attribute__((swift_name("eyeTracking")));
@property (class, readonly) MultipazIcon *airportShuttle __attribute__((swift_name("airportShuttle")));
+ (MultipazKotlinArray<MultipazIcon *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazIcon *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString *iconName __attribute__((swift_name("iconName")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IntegerOption")))
@interface MultipazIntegerOption : MultipazBase
- (instancetype)initWithValue:(MultipazInt * _Nullable)value displayName:(NSString *)displayName __attribute__((swift_name("init(value:displayName:)"))) __attribute__((objc_designated_initializer));
- (MultipazIntegerOption *)doCopyValue:(MultipazInt * _Nullable)value displayName:(NSString *)displayName __attribute__((swift_name("doCopy(value:displayName:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *displayName __attribute__((swift_name("displayName")));
@property (readonly) MultipazInt * _Nullable value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocCannedRequest")))
@interface MultipazMdocCannedRequest : MultipazBase
- (instancetype)initWithDocType:(NSString *)docType namespacesToRequest:(NSArray<MultipazMdocNamespaceRequest *> *)namespacesToRequest __attribute__((swift_name("init(docType:namespacesToRequest:)"))) __attribute__((objc_designated_initializer));
- (MultipazMdocCannedRequest *)doCopyDocType:(NSString *)docType namespacesToRequest:(NSArray<MultipazMdocNamespaceRequest *> *)namespacesToRequest __attribute__((swift_name("doCopy(docType:namespacesToRequest:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *docType __attribute__((swift_name("docType")));
@property (readonly) NSArray<MultipazMdocNamespaceRequest *> *namespacesToRequest __attribute__((swift_name("namespacesToRequest")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocDataElement")))
@interface MultipazMdocDataElement : MultipazBase
- (instancetype)initWithAttribute:(MultipazDocumentAttribute *)attribute mandatory:(BOOL)mandatory __attribute__((swift_name("init(attribute:mandatory:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazMdocDataElementCompanion *companion __attribute__((swift_name("companion")));
- (MultipazMdocDataElement *)doCopyAttribute:(MultipazDocumentAttribute *)attribute mandatory:(BOOL)mandatory __attribute__((swift_name("doCopy(attribute:mandatory:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)renderValueValue:(MultipazDataItem *)value timeZone:(MultipazKotlinx_datetimeTimeZone *)timeZone trueFalseStrings:(MultipazKotlinPair<NSString *, NSString *> *)trueFalseStrings __attribute__((swift_name("renderValue(value:timeZone:trueFalseStrings:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazDocumentAttribute *attribute __attribute__((swift_name("attribute")));
@property (readonly) BOOL mandatory __attribute__((swift_name("mandatory")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocDataElement.Companion")))
@interface MultipazMdocDataElementCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazMdocDataElementCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocDocumentType")))
@interface MultipazMdocDocumentType : MultipazBase
@property (readonly) NSString *docType __attribute__((swift_name("docType")));
@property (readonly) NSDictionary<NSString *, MultipazMdocNamespace *> *namespaces __attribute__((swift_name("namespaces")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocDocumentType.Builder")))
@interface MultipazMdocDocumentTypeBuilder : MultipazBase
- (instancetype)initWithDocType:(NSString *)docType namespaces:(MultipazMutableDictionary<NSString *, MultipazMdocNamespaceBuilder *> *)namespaces __attribute__((swift_name("init(docType:namespaces:)"))) __attribute__((objc_designated_initializer));
- (MultipazMdocDocumentTypeBuilder *)addDataElementNamespace:(NSString *)namespace_ type:(MultipazDocumentAttributeType *)type identifier:(NSString *)identifier displayName:(NSString *)displayName description:(NSString *)description mandatory:(BOOL)mandatory icon:(MultipazIcon * _Nullable)icon sampleValue:(MultipazDataItem * _Nullable)sampleValue __attribute__((swift_name("addDataElement(namespace:type:identifier:displayName:description:mandatory:icon:sampleValue:)")));
- (MultipazMdocDocumentType *)build __attribute__((swift_name("build()")));
- (MultipazMdocDocumentTypeBuilder *)doCopyDocType:(NSString *)docType namespaces:(MultipazMutableDictionary<NSString *, MultipazMdocNamespaceBuilder *> *)namespaces __attribute__((swift_name("doCopy(docType:namespaces:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *docType __attribute__((swift_name("docType")));
@property (readonly) MultipazMutableDictionary<NSString *, MultipazMdocNamespaceBuilder *> *namespaces __attribute__((swift_name("namespaces")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocNamespace")))
@interface MultipazMdocNamespace : MultipazBase
@property (readonly) NSDictionary<NSString *, MultipazMdocDataElement *> *dataElements __attribute__((swift_name("dataElements")));
@property (readonly, getter=namespace) NSString *namespace_ __attribute__((swift_name("namespace_")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocNamespace.Builder")))
@interface MultipazMdocNamespaceBuilder : MultipazBase
- (instancetype)initWithNamespace:(NSString *)namespace_ dataElements:(MultipazMutableDictionary<NSString *, MultipazMdocDataElement *> *)dataElements __attribute__((swift_name("init(namespace:dataElements:)"))) __attribute__((objc_designated_initializer));
- (MultipazMdocNamespaceBuilder *)addDataElementType:(MultipazDocumentAttributeType *)type identifier:(NSString *)identifier displayName:(NSString *)displayName description:(NSString *)description mandatory:(BOOL)mandatory icon:(MultipazIcon * _Nullable)icon sampleValue:(MultipazDataItem * _Nullable)sampleValue __attribute__((swift_name("addDataElement(type:identifier:displayName:description:mandatory:icon:sampleValue:)")));
- (MultipazMdocNamespace *)build __attribute__((swift_name("build()")));
- (MultipazMdocNamespaceBuilder *)doCopyNamespace:(NSString *)namespace_ dataElements:(MultipazMutableDictionary<NSString *, MultipazMdocDataElement *> *)dataElements __attribute__((swift_name("doCopy(namespace:dataElements:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazMutableDictionary<NSString *, MultipazMdocDataElement *> *dataElements __attribute__((swift_name("dataElements")));
@property (readonly, getter=namespace) NSString *namespace_ __attribute__((swift_name("namespace_")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocNamespaceRequest")))
@interface MultipazMdocNamespaceRequest : MultipazBase
- (instancetype)initWithNamespace:(NSString *)namespace_ dataElementsToRequest:(NSDictionary<MultipazMdocDataElement *, MultipazBoolean *> *)dataElementsToRequest __attribute__((swift_name("init(namespace:dataElementsToRequest:)"))) __attribute__((objc_designated_initializer));
- (MultipazMdocNamespaceRequest *)doCopyNamespace:(NSString *)namespace_ dataElementsToRequest:(NSDictionary<MultipazMdocDataElement *, MultipazBoolean *> *)dataElementsToRequest __attribute__((swift_name("doCopy(namespace:dataElementsToRequest:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSDictionary<MultipazMdocDataElement *, MultipazBoolean *> *dataElementsToRequest __attribute__((swift_name("dataElementsToRequest")));
@property (readonly, getter=namespace) NSString *namespace_ __attribute__((swift_name("namespace_")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("StringOption")))
@interface MultipazStringOption : MultipazBase
- (instancetype)initWithValue:(NSString * _Nullable)value displayName:(NSString *)displayName __attribute__((swift_name("init(value:displayName:)"))) __attribute__((objc_designated_initializer));
- (MultipazStringOption *)doCopyValue:(NSString * _Nullable)value displayName:(NSString *)displayName __attribute__((swift_name("doCopy(value:displayName:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *displayName __attribute__((swift_name("displayName")));
@property (readonly) NSString * _Nullable value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VcCannedRequest")))
@interface MultipazVcCannedRequest : MultipazBase
- (instancetype)initWithVct:(NSString *)vct claimsToRequest:(NSArray<MultipazDocumentAttribute *> *)claimsToRequest __attribute__((swift_name("init(vct:claimsToRequest:)"))) __attribute__((objc_designated_initializer));
- (MultipazVcCannedRequest *)doCopyVct:(NSString *)vct claimsToRequest:(NSArray<MultipazDocumentAttribute *> *)claimsToRequest __attribute__((swift_name("doCopy(vct:claimsToRequest:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSArray<MultipazDocumentAttribute *> *claimsToRequest __attribute__((swift_name("claimsToRequest")));
@property (readonly) NSString *vct __attribute__((swift_name("vct")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VcDocumentType")))
@interface MultipazVcDocumentType : MultipazBase
@property (readonly) NSDictionary<NSString *, MultipazDocumentAttribute *> *claims __attribute__((swift_name("claims")));
@property (readonly) BOOL keyBound __attribute__((swift_name("keyBound")));
@property (readonly) NSString *type __attribute__((swift_name("type")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VcDocumentType.Builder")))
@interface MultipazVcDocumentTypeBuilder : MultipazBase
- (instancetype)initWithType:(NSString *)type claims:(MultipazMutableDictionary<NSString *, MultipazDocumentAttribute *> *)claims keyBound:(BOOL)keyBound __attribute__((swift_name("init(type:claims:keyBound:)"))) __attribute__((objc_designated_initializer));
- (MultipazVcDocumentTypeBuilder *)addClaimType:(MultipazDocumentAttributeType *)type identifier:(NSString *)identifier displayName:(NSString *)displayName description:(NSString *)description icon:(MultipazIcon * _Nullable)icon sampleValue:(MultipazKotlinx_serialization_jsonJsonElement * _Nullable)sampleValue __attribute__((swift_name("addClaim(type:identifier:displayName:description:icon:sampleValue:)")));
- (MultipazVcDocumentType *)build __attribute__((swift_name("build()")));
- (MultipazVcDocumentTypeBuilder *)doCopyType:(NSString *)type claims:(MultipazMutableDictionary<NSString *, MultipazDocumentAttribute *> *)claims keyBound:(BOOL)keyBound __attribute__((swift_name("doCopy(type:claims:keyBound:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazMutableDictionary<NSString *, MultipazDocumentAttribute *> *claims __attribute__((swift_name("claims")));
@property (readonly) BOOL keyBound __attribute__((swift_name("keyBound")));
@property (readonly) NSString *type __attribute__((swift_name("type")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DrivingLicense")))
@interface MultipazDrivingLicense : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)drivingLicense __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazDrivingLicense *shared __attribute__((swift_name("shared")));
- (MultipazDocumentType *)getDocumentType __attribute__((swift_name("getDocumentType()")));
@property (readonly) NSString *AAMVA_NAMESPACE __attribute__((swift_name("AAMVA_NAMESPACE")));
@property (readonly) NSString *MDL_DOCTYPE __attribute__((swift_name("MDL_DOCTYPE")));
@property (readonly) NSString *MDL_NAMESPACE __attribute__((swift_name("MDL_NAMESPACE")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EUCertificateOfResidence")))
@interface MultipazEUCertificateOfResidence : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)eUCertificateOfResidence __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazEUCertificateOfResidence *shared __attribute__((swift_name("shared")));
- (MultipazDocumentType *)getDocumentType __attribute__((swift_name("getDocumentType()")));
@property (readonly) NSString *DOCTYPE __attribute__((swift_name("DOCTYPE")));
@property (readonly) NSString *NAMESPACE __attribute__((swift_name("NAMESPACE")));
@property (readonly) NSString *VCT __attribute__((swift_name("VCT")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EUPersonalID")))
@interface MultipazEUPersonalID : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)eUPersonalID __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazEUPersonalID *shared __attribute__((swift_name("shared")));
- (MultipazDocumentType *)getDocumentType __attribute__((swift_name("getDocumentType()")));
@property (readonly) NSString *EUPID_DOCTYPE __attribute__((swift_name("EUPID_DOCTYPE")));
@property (readonly) NSString *EUPID_NAMESPACE __attribute__((swift_name("EUPID_NAMESPACE")));
@property (readonly) NSString *EUPID_VCT __attribute__((swift_name("EUPID_VCT")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("GermanPersonalID")))
@interface MultipazGermanPersonalID : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)germanPersonalID __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazGermanPersonalID *shared __attribute__((swift_name("shared")));
- (MultipazDocumentType *)getDocumentType __attribute__((swift_name("getDocumentType()")));
@property (readonly) NSString *EUPID_VCT __attribute__((swift_name("EUPID_VCT")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Options")))
@interface MultipazOptions : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)options __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazOptions *shared __attribute__((swift_name("shared")));
@property (readonly) NSArray<MultipazStringOption *> *AAMVA_NAME_SUFFIX __attribute__((swift_name("AAMVA_NAME_SUFFIX")));
@property (readonly) NSArray<MultipazStringOption *> *COUNTRY_ISO_3166_1_ALPHA_2 __attribute__((swift_name("COUNTRY_ISO_3166_1_ALPHA_2")));
@property (readonly) NSArray<MultipazStringOption *> *DISTINGUISHING_SIGN_ISO_IEC_18013_1_ANNEX_F __attribute__((swift_name("DISTINGUISHING_SIGN_ISO_IEC_18013_1_ANNEX_F")));
@property (readonly) NSArray<MultipazIntegerOption *> *SEX_ISO_IEC_5218 __attribute__((swift_name("SEX_ISO_IEC_5218")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PhotoID")))
@interface MultipazPhotoID : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)photoID __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazPhotoID *shared __attribute__((swift_name("shared")));
- (MultipazDocumentType *)getDocumentType __attribute__((swift_name("getDocumentType()")));
@property (readonly) NSString *DTC_NAMESPACE __attribute__((swift_name("DTC_NAMESPACE")));
@property (readonly) NSString *ISO_23220_2_NAMESPACE __attribute__((swift_name("ISO_23220_2_NAMESPACE")));
@property (readonly) NSString *PHOTO_ID_DOCTYPE __attribute__((swift_name("PHOTO_ID_DOCTYPE")));
@property (readonly) NSString *PHOTO_ID_NAMESPACE __attribute__((swift_name("PHOTO_ID_NAMESPACE")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("UtopiaMovieTicket")))
@interface MultipazUtopiaMovieTicket : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)utopiaMovieTicket __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazUtopiaMovieTicket *shared __attribute__((swift_name("shared")));
- (MultipazDocumentType *)getDocumentType __attribute__((swift_name("getDocumentType()")));
@property (readonly) NSString *MOVIE_TICKET_VCT __attribute__((swift_name("MOVIE_TICKET_VCT")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("UtopiaNaturalization")))
@interface MultipazUtopiaNaturalization : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)utopiaNaturalization __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazUtopiaNaturalization *shared __attribute__((swift_name("shared")));
- (MultipazDocumentType *)getDocumentType __attribute__((swift_name("getDocumentType()")));
@property (readonly) NSString *VCT __attribute__((swift_name("VCT")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VaccinationDocument")))
@interface MultipazVaccinationDocument : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)vaccinationDocument __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazVaccinationDocument *shared __attribute__((swift_name("shared")));
- (MultipazDocumentType *)getDocumentType __attribute__((swift_name("getDocumentType()")));
@property (readonly) NSString *MICOV_ATT_NAMESPACE __attribute__((swift_name("MICOV_ATT_NAMESPACE")));
@property (readonly) NSString *MICOV_VTR_NAMESPACE __attribute__((swift_name("MICOV_VTR_NAMESPACE")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VehicleRegistration")))
@interface MultipazVehicleRegistration : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)vehicleRegistration __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazVehicleRegistration *shared __attribute__((swift_name("shared")));
- (MultipazDocumentType *)getDocumentType __attribute__((swift_name("getDocumentType()")));
@property (readonly) NSString *MVR_NAMESPACE __attribute__((swift_name("MVR_NAMESPACE")));
@end

__attribute__((swift_name("MdocConnectionMethod")))
@interface MultipazMdocConnectionMethod : MultipazBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (class, readonly, getter=companion) MultipazMdocConnectionMethodCompanion *companion __attribute__((swift_name("companion")));
- (MultipazKotlinByteArray *)toDeviceEngagement __attribute__((swift_name("toDeviceEngagement()")));
- (MultipazKotlinPair<MultipazNdefRecord *, MultipazNdefRecord *> * _Nullable)toNdefRecordAuxiliaryReferences:(NSArray<NSString *> *)auxiliaryReferences role:(MultipazMdocRole *)role skipUuids:(BOOL)skipUuids __attribute__((swift_name("toNdefRecord(auxiliaryReferences:role:skipUuids:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocConnectionMethod.Companion")))
@interface MultipazMdocConnectionMethodCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazMdocConnectionMethodCompanion *shared __attribute__((swift_name("shared")));
- (NSArray<MultipazMdocConnectionMethod *> *)combineConnectionMethods:(NSArray<MultipazMdocConnectionMethod *> *)connectionMethods __attribute__((swift_name("combine(connectionMethods:)")));
- (NSArray<MultipazMdocConnectionMethod *> *)disambiguateConnectionMethods:(NSArray<MultipazMdocConnectionMethod *> *)connectionMethods role:(MultipazMdocRole *)role __attribute__((swift_name("disambiguate(connectionMethods:role:)")));
- (MultipazMdocConnectionMethod * _Nullable)fromDeviceEngagementEncodedDeviceRetrievalMethod:(MultipazKotlinByteArray *)encodedDeviceRetrievalMethod __attribute__((swift_name("fromDeviceEngagement(encodedDeviceRetrievalMethod:)")));
- (MultipazMdocConnectionMethod * _Nullable)fromNdefRecordRecord:(MultipazNdefRecord *)record role:(MultipazMdocRole *)role uuid:(MultipazUUID * _Nullable)uuid __attribute__((swift_name("fromNdefRecord(record:role:uuid:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocConnectionMethodBle")))
@interface MultipazMdocConnectionMethodBle : MultipazMdocConnectionMethod
- (instancetype)initWithSupportsPeripheralServerMode:(BOOL)supportsPeripheralServerMode supportsCentralClientMode:(BOOL)supportsCentralClientMode peripheralServerModeUuid:(MultipazUUID * _Nullable)peripheralServerModeUuid centralClientModeUuid:(MultipazUUID * _Nullable)centralClientModeUuid peripheralServerModePsm:(MultipazInt * _Nullable)peripheralServerModePsm peripheralServerModeMacAddress:(MultipazKotlinx_io_bytestringByteString * _Nullable)peripheralServerModeMacAddress __attribute__((swift_name("init(supportsPeripheralServerMode:supportsCentralClientMode:peripheralServerModeUuid:centralClientModeUuid:peripheralServerModePsm:peripheralServerModeMacAddress:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazMdocConnectionMethodBleCompanion *companion __attribute__((swift_name("companion")));
- (MultipazMdocConnectionMethodBle *)doCopySupportsPeripheralServerMode:(BOOL)supportsPeripheralServerMode supportsCentralClientMode:(BOOL)supportsCentralClientMode peripheralServerModeUuid:(MultipazUUID * _Nullable)peripheralServerModeUuid centralClientModeUuid:(MultipazUUID * _Nullable)centralClientModeUuid peripheralServerModePsm:(MultipazInt * _Nullable)peripheralServerModePsm peripheralServerModeMacAddress:(MultipazKotlinx_io_bytestringByteString * _Nullable)peripheralServerModeMacAddress __attribute__((swift_name("doCopy(supportsPeripheralServerMode:supportsCentralClientMode:peripheralServerModeUuid:centralClientModeUuid:peripheralServerModePsm:peripheralServerModeMacAddress:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (MultipazKotlinByteArray *)toDeviceEngagement __attribute__((swift_name("toDeviceEngagement()")));
- (MultipazKotlinPair<MultipazNdefRecord *, MultipazNdefRecord *> *)toNdefRecordAuxiliaryReferences:(NSArray<NSString *> *)auxiliaryReferences role:(MultipazMdocRole *)role skipUuids:(BOOL)skipUuids __attribute__((swift_name("toNdefRecord(auxiliaryReferences:role:skipUuids:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazUUID * _Nullable centralClientModeUuid __attribute__((swift_name("centralClientModeUuid")));
@property (readonly) MultipazKotlinx_io_bytestringByteString * _Nullable peripheralServerModeMacAddress __attribute__((swift_name("peripheralServerModeMacAddress")));
@property (readonly) MultipazInt * _Nullable peripheralServerModePsm __attribute__((swift_name("peripheralServerModePsm")));
@property (readonly) MultipazUUID * _Nullable peripheralServerModeUuid __attribute__((swift_name("peripheralServerModeUuid")));
@property (readonly) BOOL supportsCentralClientMode __attribute__((swift_name("supportsCentralClientMode")));
@property (readonly) BOOL supportsPeripheralServerMode __attribute__((swift_name("supportsPeripheralServerMode")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocConnectionMethodBle.Companion")))
@interface MultipazMdocConnectionMethodBleCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazMdocConnectionMethodBleCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) int64_t METHOD_MAX_VERSION __attribute__((swift_name("METHOD_MAX_VERSION")));
@property (readonly) int64_t METHOD_TYPE __attribute__((swift_name("METHOD_TYPE")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocConnectionMethodNfc")))
@interface MultipazMdocConnectionMethodNfc : MultipazMdocConnectionMethod
- (instancetype)initWithCommandDataFieldMaxLength:(int64_t)commandDataFieldMaxLength responseDataFieldMaxLength:(int64_t)responseDataFieldMaxLength __attribute__((swift_name("init(commandDataFieldMaxLength:responseDataFieldMaxLength:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazMdocConnectionMethodNfcCompanion *companion __attribute__((swift_name("companion")));
- (MultipazMdocConnectionMethodNfc *)doCopyCommandDataFieldMaxLength:(int64_t)commandDataFieldMaxLength responseDataFieldMaxLength:(int64_t)responseDataFieldMaxLength __attribute__((swift_name("doCopy(commandDataFieldMaxLength:responseDataFieldMaxLength:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (MultipazKotlinByteArray *)toDeviceEngagement __attribute__((swift_name("toDeviceEngagement()")));
- (MultipazKotlinPair<MultipazNdefRecord *, MultipazNdefRecord *> * _Nullable)toNdefRecordAuxiliaryReferences:(NSArray<NSString *> *)auxiliaryReferences role:(MultipazMdocRole *)role skipUuids:(BOOL)skipUuids __attribute__((swift_name("toNdefRecord(auxiliaryReferences:role:skipUuids:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int64_t commandDataFieldMaxLength __attribute__((swift_name("commandDataFieldMaxLength")));
@property (readonly) int64_t responseDataFieldMaxLength __attribute__((swift_name("responseDataFieldMaxLength")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocConnectionMethodNfc.Companion")))
@interface MultipazMdocConnectionMethodNfcCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazMdocConnectionMethodNfcCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) int64_t METHOD_MAX_VERSION __attribute__((swift_name("METHOD_MAX_VERSION")));
@property (readonly) int64_t METHOD_TYPE __attribute__((swift_name("METHOD_TYPE")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocConnectionMethodWifiAware")))
@interface MultipazMdocConnectionMethodWifiAware : MultipazMdocConnectionMethod
- (instancetype)initWithPassphraseInfoPassphrase:(NSString * _Nullable)passphraseInfoPassphrase channelInfoChannelNumber:(MultipazLong * _Nullable)channelInfoChannelNumber channelInfoOperatingClass:(MultipazLong * _Nullable)channelInfoOperatingClass bandInfoSupportedBands:(MultipazKotlinx_io_bytestringByteString * _Nullable)bandInfoSupportedBands __attribute__((swift_name("init(passphraseInfoPassphrase:channelInfoChannelNumber:channelInfoOperatingClass:bandInfoSupportedBands:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazMdocConnectionMethodWifiAwareCompanion *companion __attribute__((swift_name("companion")));
- (MultipazMdocConnectionMethodWifiAware *)doCopyPassphraseInfoPassphrase:(NSString * _Nullable)passphraseInfoPassphrase channelInfoChannelNumber:(MultipazLong * _Nullable)channelInfoChannelNumber channelInfoOperatingClass:(MultipazLong * _Nullable)channelInfoOperatingClass bandInfoSupportedBands:(MultipazKotlinx_io_bytestringByteString * _Nullable)bandInfoSupportedBands __attribute__((swift_name("doCopy(passphraseInfoPassphrase:channelInfoChannelNumber:channelInfoOperatingClass:bandInfoSupportedBands:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (MultipazKotlinByteArray *)toDeviceEngagement __attribute__((swift_name("toDeviceEngagement()")));
- (MultipazKotlinPair<MultipazNdefRecord *, MultipazNdefRecord *> * _Nullable)toNdefRecordAuxiliaryReferences:(NSArray<NSString *> *)auxiliaryReferences role:(MultipazMdocRole *)role skipUuids:(BOOL)skipUuids __attribute__((swift_name("toNdefRecord(auxiliaryReferences:role:skipUuids:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinx_io_bytestringByteString * _Nullable bandInfoSupportedBands __attribute__((swift_name("bandInfoSupportedBands")));
@property (readonly) MultipazLong * _Nullable channelInfoChannelNumber __attribute__((swift_name("channelInfoChannelNumber")));
@property (readonly) MultipazLong * _Nullable channelInfoOperatingClass __attribute__((swift_name("channelInfoOperatingClass")));
@property (readonly) NSString * _Nullable passphraseInfoPassphrase __attribute__((swift_name("passphraseInfoPassphrase")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocConnectionMethodWifiAware.Companion")))
@interface MultipazMdocConnectionMethodWifiAwareCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazMdocConnectionMethodWifiAwareCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) int64_t METHOD_MAX_VERSION __attribute__((swift_name("METHOD_MAX_VERSION")));
@property (readonly) int64_t METHOD_TYPE __attribute__((swift_name("METHOD_TYPE")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocCredential")))
@interface MultipazMdocCredential : MultipazSecureAreaBoundCredential
- (instancetype)initWithDocument:(MultipazDocument *)document __attribute__((swift_name("init(document:)"))) __attribute__((objc_designated_initializer));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (instancetype)initWithDocument:(MultipazDocument *)document asReplacementForIdentifier:(NSString * _Nullable)asReplacementForIdentifier domain:(NSString *)domain secureArea:(id<MultipazSecureArea>)secureArea __attribute__((swift_name("init(document:asReplacementForIdentifier:domain:secureArea:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazMdocCredentialCompanion *companion __attribute__((swift_name("companion")));
- (void)addSerializedDataBuilder:(MultipazMapBuilder<MultipazCborBuilder *> *)builder __attribute__((swift_name("addSerializedData(builder:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)certifyIssuerProvidedAuthenticationData:(MultipazKotlinByteArray *)issuerProvidedAuthenticationData validFrom:(MultipazKotlinx_datetimeInstant *)validFrom validUntil:(MultipazKotlinx_datetimeInstant *)validUntil completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("certify(issuerProvidedAuthenticationData:validFrom:validUntil:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)deserializeDataItem:(MultipazDataItem *)dataItem completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("deserialize(dataItem:completionHandler:)")));
- (NSArray<MultipazMdocClaim *> *)getClaimsDocumentTypeRepository:(MultipazDocumentTypeRepository * _Nullable)documentTypeRepository __attribute__((swift_name("getClaims(documentTypeRepository:)")));
@property (readonly) NSString *credentialType __attribute__((swift_name("credentialType")));
@property (readonly) NSString *docType __attribute__((swift_name("docType")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocCredential.Companion")))
@interface MultipazMdocCredentialCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazMdocCredentialCompanion *shared __attribute__((swift_name("shared")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)createDocument:(MultipazDocument *)document asReplacementForIdentifier:(NSString * _Nullable)asReplacementForIdentifier domain:(NSString *)domain secureArea:(id<MultipazSecureArea>)secureArea docType:(NSString *)docType createKeySettings:(MultipazCreateKeySettings *)createKeySettings completionHandler:(void (^)(MultipazMdocCredential * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("create(document:asReplacementForIdentifier:domain:secureArea:docType:createKeySettings:completionHandler:)")));
@property (readonly) NSString *CREDENTIAL_TYPE __attribute__((swift_name("CREDENTIAL_TYPE")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EngagementGenerator")))
@interface MultipazEngagementGenerator : MultipazBase
- (instancetype)initWithESenderKey:(MultipazEcPublicKey *)eSenderKey version:(NSString *)version __attribute__((swift_name("init(eSenderKey:version:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazEngagementGeneratorCompanion *companion __attribute__((swift_name("companion")));
- (MultipazEngagementGenerator *)addConnectionMethodsConnectionMethods:(NSArray<MultipazMdocConnectionMethod *> *)connectionMethods __attribute__((swift_name("addConnectionMethods(connectionMethods:)")));
- (MultipazEngagementGenerator *)addOriginInfosOriginInfos:(NSArray<MultipazOriginInfo *> *)originInfos __attribute__((swift_name("addOriginInfos(originInfos:)")));
- (MultipazKotlinByteArray *)generate __attribute__((swift_name("generate()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EngagementGenerator.Companion")))
@interface MultipazEngagementGeneratorCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazEngagementGeneratorCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) NSString *ENGAGEMENT_VERSION_1_0 __attribute__((swift_name("ENGAGEMENT_VERSION_1_0")));
@property (readonly) NSString *ENGAGEMENT_VERSION_1_1 __attribute__((swift_name("ENGAGEMENT_VERSION_1_1")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EngagementParser")))
@interface MultipazEngagementParser : MultipazBase
- (instancetype)initWithEncodedEngagement:(MultipazKotlinByteArray *)encodedEngagement __attribute__((swift_name("init(encodedEngagement:)"))) __attribute__((objc_designated_initializer));
- (MultipazEngagementParserEngagement *)parse __attribute__((swift_name("parse()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EngagementParser.Engagement")))
@interface MultipazEngagementParserEngagement : MultipazBase
@property (class, readonly, getter=companion) MultipazEngagementParserEngagementCompanion *companion __attribute__((swift_name("companion")));
- (void)parseEncodedEngagement:(MultipazKotlinByteArray *)encodedEngagement __attribute__((swift_name("parse(encodedEngagement:)")));
@property NSArray<MultipazMdocConnectionMethod *> *connectionMethods __attribute__((swift_name("connectionMethods")));
@property MultipazEcPublicKey *eSenderKey __attribute__((swift_name("eSenderKey")));
@property MultipazKotlinByteArray *eSenderKeyBytes __attribute__((swift_name("eSenderKeyBytes")));
@property NSArray<MultipazOriginInfo *> *originInfos __attribute__((swift_name("originInfos")));
@property NSString *version __attribute__((swift_name("version")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EngagementParser.EngagementCompanion")))
@interface MultipazEngagementParserEngagementCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazEngagementParserEngagementCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IssuerNamespaces")))
@interface MultipazIssuerNamespaces : MultipazBase
- (instancetype)initWithData:(NSDictionary<NSString *, NSDictionary<NSString *, MultipazIssuerSignedItem *> *> *)data __attribute__((swift_name("init(data:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazIssuerNamespacesCompanion *companion __attribute__((swift_name("companion")));
- (MultipazIssuerNamespaces *)doCopyData:(NSDictionary<NSString *, NSDictionary<NSString *, MultipazIssuerSignedItem *> *> *)data __attribute__((swift_name("doCopy(data:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (MultipazIssuerNamespaces *)filterRequestedClaims:(NSArray<MultipazMdocRequestedClaim *> *)requestedClaims __attribute__((swift_name("filter(requestedClaims:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSDictionary<NSString *, NSDictionary<NSString *, MultipazIssuerSignedItem *> *> *data __attribute__((swift_name("data")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IssuerNamespaces.Companion")))
@interface MultipazIssuerNamespacesCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazIssuerNamespacesCompanion *shared __attribute__((swift_name("shared")));
- (MultipazIssuerNamespaces *)fromDataItemNameSpaces:(MultipazDataItem *)nameSpaces __attribute__((swift_name("fromDataItem(nameSpaces:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IssuerNamespacesBuilder")))
@interface MultipazIssuerNamespacesBuilder : MultipazBase
- (instancetype)initWithDataElementRandomSize:(int32_t)dataElementRandomSize randomProvider:(MultipazKotlinRandom *)randomProvider __attribute__((swift_name("init(dataElementRandomSize:randomProvider:)"))) __attribute__((objc_designated_initializer));
- (void)addNamespaceNamespaceName:(NSString *)namespaceName builderAction:(void (^)(MultipazIssuerNamespacesDataElementBuilder *))builderAction __attribute__((swift_name("addNamespace(namespaceName:builderAction:)")));
- (MultipazIssuerNamespaces *)build __attribute__((swift_name("build()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IssuerNamespacesDataElementBuilder")))
@interface MultipazIssuerNamespacesDataElementBuilder : MultipazBase
- (instancetype)initWithNamespaceName:(NSString *)namespaceName __attribute__((swift_name("init(namespaceName:)"))) __attribute__((objc_designated_initializer));
- (void)addDataElementDataElementName:(NSString *)dataElementName value:(MultipazDataItem *)value __attribute__((swift_name("addDataElement(dataElementName:value:)")));
- (MultipazIssuerNamespacesDataElements *)build __attribute__((swift_name("build()")));
@property (readonly) NSMutableArray<MultipazKotlinPair<NSString *, MultipazDataItem *> *> *dataElements __attribute__((swift_name("dataElements")));
@property (readonly) NSString *namespaceName __attribute__((swift_name("namespaceName")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IssuerNamespacesDataElements")))
@interface MultipazIssuerNamespacesDataElements : MultipazBase
- (instancetype)initWithNamespaceName:(NSString *)namespaceName dataElements:(NSArray<MultipazKotlinPair<NSString *, MultipazDataItem *> *> *)dataElements __attribute__((swift_name("init(namespaceName:dataElements:)"))) __attribute__((objc_designated_initializer));
- (MultipazIssuerNamespacesDataElements *)doCopyNamespaceName:(NSString *)namespaceName dataElements:(NSArray<MultipazKotlinPair<NSString *, MultipazDataItem *> *> *)dataElements __attribute__((swift_name("doCopy(namespaceName:dataElements:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSArray<MultipazKotlinPair<NSString *, MultipazDataItem *> *> *dataElements __attribute__((swift_name("dataElements")));
@property (readonly) NSString *namespaceName __attribute__((swift_name("namespaceName")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IssuerSignedItem")))
@interface MultipazIssuerSignedItem : MultipazBase
- (instancetype)initWithDigestId:(int64_t)digestId random:(MultipazKotlinx_io_bytestringByteString *)random dataElementIdentifier:(NSString *)dataElementIdentifier dataElementValue:(MultipazDataItem *)dataElementValue __attribute__((swift_name("init(digestId:random:dataElementIdentifier:dataElementValue:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazIssuerSignedItemCompanion *companion __attribute__((swift_name("companion")));
- (MultipazKotlinx_io_bytestringByteString *)calculateDigestAlgorithm:(MultipazAlgorithm *)algorithm __attribute__((swift_name("calculateDigest(algorithm:)")));
- (MultipazIssuerSignedItem *)doCopyDigestId:(int64_t)digestId random:(MultipazKotlinx_io_bytestringByteString *)random dataElementIdentifier:(NSString *)dataElementIdentifier dataElementValue:(MultipazDataItem *)dataElementValue __attribute__((swift_name("doCopy(digestId:random:dataElementIdentifier:dataElementValue:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *dataElementIdentifier __attribute__((swift_name("dataElementIdentifier")));
@property (readonly) MultipazDataItem *dataElementValue __attribute__((swift_name("dataElementValue")));
@property (readonly) int64_t digestId __attribute__((swift_name("digestId")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *random __attribute__((swift_name("random")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IssuerSignedItem.Companion")))
@interface MultipazIssuerSignedItemCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazIssuerSignedItemCompanion *shared __attribute__((swift_name("shared")));
- (MultipazIssuerSignedItem *)fromDataItemIssuerSignedItem:(MultipazDataItem *)issuerSignedItem __attribute__((swift_name("fromDataItem(issuerSignedItem:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MobileSecurityObjectGenerator")))
@interface MultipazMobileSecurityObjectGenerator : MultipazBase
- (instancetype)initWithDigestAlgorithm:(MultipazAlgorithm *)digestAlgorithm docType:(NSString *)docType deviceKey:(MultipazEcPublicKey *)deviceKey __attribute__((swift_name("init(digestAlgorithm:docType:deviceKey:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazMobileSecurityObjectGeneratorCompanion *companion __attribute__((swift_name("companion")));
- (MultipazMobileSecurityObjectGenerator *)addDigestIdsForNamespaceNameSpace:(NSString *)nameSpace digestIDs:(NSDictionary<MultipazLong *, MultipazKotlinByteArray *> *)digestIDs __attribute__((swift_name("addDigestIdsForNamespace(nameSpace:digestIDs:)")));
- (void)addValueDigestsIssuerNamespaces:(MultipazIssuerNamespaces *)issuerNamespaces __attribute__((swift_name("addValueDigests(issuerNamespaces:)")));
- (MultipazKotlinByteArray *)generate __attribute__((swift_name("generate()")));
- (MultipazMobileSecurityObjectGenerator *)setDeviceKeyAuthorizedDataElementsAuthorizedDataElements:(NSDictionary<NSString *, NSArray<NSString *> *> *)authorizedDataElements __attribute__((swift_name("setDeviceKeyAuthorizedDataElements(authorizedDataElements:)")));
- (MultipazMobileSecurityObjectGenerator *)setDeviceKeyAuthorizedNameSpacesAuthorizedNameSpaces:(NSArray<NSString *> *)authorizedNameSpaces __attribute__((swift_name("setDeviceKeyAuthorizedNameSpaces(authorizedNameSpaces:)")));
- (MultipazMobileSecurityObjectGenerator *)setDeviceKeyInfoKeyInfo:(NSDictionary<MultipazLong *, MultipazKotlinByteArray *> *)keyInfo __attribute__((swift_name("setDeviceKeyInfo(keyInfo:)")));
- (MultipazMobileSecurityObjectGenerator *)setValidityInfoSigned:(MultipazKotlinx_datetimeInstant *)signed_ validFrom:(MultipazKotlinx_datetimeInstant *)validFrom validUntil:(MultipazKotlinx_datetimeInstant *)validUntil expectedUpdate:(MultipazKotlinx_datetimeInstant * _Nullable)expectedUpdate __attribute__((swift_name("setValidityInfo(signed:validFrom:validUntil:expectedUpdate:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MobileSecurityObjectGenerator.Companion")))
@interface MultipazMobileSecurityObjectGeneratorCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazMobileSecurityObjectGeneratorCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MobileSecurityObjectParser")))
@interface MultipazMobileSecurityObjectParser : MultipazBase
- (instancetype)initWithEncodedMobileSecurityObject:(MultipazKotlinByteArray *)encodedMobileSecurityObject __attribute__((swift_name("init(encodedMobileSecurityObject:)"))) __attribute__((objc_designated_initializer));
- (MultipazMobileSecurityObjectParserMobileSecurityObject *)parse __attribute__((swift_name("parse()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MobileSecurityObjectParser.MobileSecurityObject")))
@interface MultipazMobileSecurityObjectParserMobileSecurityObject : MultipazBase
- (NSDictionary<MultipazLong *, MultipazKotlinByteArray *> * _Nullable)getDigestIDsNamespace:(NSString *)namespace_ __attribute__((swift_name("getDigestIDs(namespace:)")));
- (void)parseEncodedMobileSecurityObject:(MultipazKotlinByteArray *)encodedMobileSecurityObject __attribute__((swift_name("parse(encodedMobileSecurityObject:)")));
@property MultipazEcPublicKey *deviceKey __attribute__((swift_name("deviceKey")));
@property (readonly) NSDictionary<NSString *, NSArray<NSString *> *> * _Nullable deviceKeyAuthorizedDataElements __attribute__((swift_name("deviceKeyAuthorizedDataElements")));
@property (readonly) NSArray<NSString *> * _Nullable deviceKeyAuthorizedNameSpaces __attribute__((swift_name("deviceKeyAuthorizedNameSpaces")));
@property (readonly) NSDictionary<MultipazLong *, MultipazKotlinByteArray *> * _Nullable deviceKeyInfo __attribute__((swift_name("deviceKeyInfo")));
@property MultipazAlgorithm *digestAlgorithm __attribute__((swift_name("digestAlgorithm")));
@property NSString *docType __attribute__((swift_name("docType")));
@property MultipazKotlinx_datetimeInstant * _Nullable expectedUpdate __attribute__((swift_name("expectedUpdate")));
@property (getter=signed, setter=setSigned:) MultipazKotlinx_datetimeInstant *signed_ __attribute__((swift_name("signed_")));
@property MultipazKotlinx_datetimeInstant *validFrom __attribute__((swift_name("validFrom")));
@property MultipazKotlinx_datetimeInstant *validUntil __attribute__((swift_name("validUntil")));
@property (readonly) NSSet<NSString *> *valueDigestNamespaces __attribute__((swift_name("valueDigestNamespaces")));
@property NSString *version __attribute__((swift_name("version")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("StaticAuthDataGenerator")))
@interface MultipazStaticAuthDataGenerator : MultipazBase
- (instancetype)initWithDigestIdMapping:(NSDictionary<NSString *, NSArray<MultipazKotlinByteArray *> *> *)digestIdMapping encodedIssuerAuth:(MultipazKotlinByteArray *)encodedIssuerAuth __attribute__((swift_name("init(digestIdMapping:encodedIssuerAuth:)"))) __attribute__((objc_designated_initializer));
- (MultipazKotlinByteArray *)generate __attribute__((swift_name("generate()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("StaticAuthDataParser")))
@interface MultipazStaticAuthDataParser : MultipazBase
- (instancetype)initWithEncodedStaticAuthData:(MultipazKotlinByteArray *)encodedStaticAuthData __attribute__((swift_name("init(encodedStaticAuthData:)"))) __attribute__((objc_designated_initializer));
- (MultipazStaticAuthDataParserStaticAuthData *)parse __attribute__((swift_name("parse()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("StaticAuthDataParser.StaticAuthData")))
@interface MultipazStaticAuthDataParserStaticAuthData : MultipazBase
@property (readonly) NSDictionary<NSString *, NSArray<MultipazKotlinByteArray *> *> *digestIdMapping __attribute__((swift_name("digestIdMapping")));
@property MultipazKotlinByteArray *issuerAuth __attribute__((swift_name("issuerAuth")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocNfcEngagementHelper")))
@interface MultipazMdocNfcEngagementHelper : MultipazBase
- (instancetype)initWithEDeviceKey:(MultipazEcPublicKey *)eDeviceKey onHandoverComplete:(void (^)(NSArray<MultipazMdocConnectionMethod *> *, MultipazKotlinx_io_bytestringByteString *, MultipazDataItem *))onHandoverComplete onError:(void (^)(MultipazKotlinThrowable *))onError staticHandoverMethods:(NSArray<MultipazMdocConnectionMethod *> * _Nullable)staticHandoverMethods negotiatedHandoverPicker:(MultipazMdocConnectionMethod *(^ _Nullable)(NSArray<MultipazMdocConnectionMethod *> *))negotiatedHandoverPicker __attribute__((swift_name("init(eDeviceKey:onHandoverComplete:onError:staticHandoverMethods:negotiatedHandoverPicker:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazMdocNfcEngagementHelperCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)processApduCommand:(MultipazCommandApdu *)command completionHandler:(void (^)(MultipazResponseApdu * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("processApdu(command:completionHandler:)")));
@property (readonly) MultipazEcPublicKey *eDeviceKey __attribute__((swift_name("eDeviceKey")));
@property (readonly) MultipazMdocConnectionMethod *(^ _Nullable negotiatedHandoverPicker)(NSArray<MultipazMdocConnectionMethod *> *) __attribute__((swift_name("negotiatedHandoverPicker")));
@property (readonly) void (^onError)(MultipazKotlinThrowable *) __attribute__((swift_name("onError")));
@property (readonly) void (^onHandoverComplete)(NSArray<MultipazMdocConnectionMethod *> *, MultipazKotlinx_io_bytestringByteString *, MultipazDataItem *) __attribute__((swift_name("onHandoverComplete")));
@property (readonly) NSArray<MultipazMdocConnectionMethod *> * _Nullable staticHandoverMethods __attribute__((swift_name("staticHandoverMethods")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocNfcEngagementHelper.Companion")))
@interface MultipazMdocNfcEngagementHelperCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazMdocNfcEngagementHelperCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocReaderNfcHandoverResult")))
@interface MultipazMdocReaderNfcHandoverResult : MultipazBase
- (instancetype)initWithConnectionMethods:(NSArray<MultipazMdocConnectionMethod *> *)connectionMethods encodedDeviceEngagement:(MultipazKotlinx_io_bytestringByteString *)encodedDeviceEngagement handover:(MultipazDataItem *)handover __attribute__((swift_name("init(connectionMethods:encodedDeviceEngagement:handover:)"))) __attribute__((objc_designated_initializer));
- (MultipazMdocReaderNfcHandoverResult *)doCopyConnectionMethods:(NSArray<MultipazMdocConnectionMethod *> *)connectionMethods encodedDeviceEngagement:(MultipazKotlinx_io_bytestringByteString *)encodedDeviceEngagement handover:(MultipazDataItem *)handover __attribute__((swift_name("doCopy(connectionMethods:encodedDeviceEngagement:handover:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSArray<MultipazMdocConnectionMethod *> *connectionMethods __attribute__((swift_name("connectionMethods")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *encodedDeviceEngagement __attribute__((swift_name("encodedDeviceEngagement")));
@property (readonly) MultipazDataItem *handover __attribute__((swift_name("handover")));
@end

__attribute__((swift_name("OriginInfo")))
@interface MultipazOriginInfo : MultipazBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (class, readonly, getter=companion) MultipazOriginInfoCompanion *companion __attribute__((swift_name("companion")));
- (MultipazDataItem *)encode __attribute__((swift_name("encode()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("OriginInfo.Companion")))
@interface MultipazOriginInfoCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazOriginInfoCompanion *shared __attribute__((swift_name("shared")));
- (MultipazOriginInfo * _Nullable)decodeOiDataItem:(MultipazDataItem *)oiDataItem __attribute__((swift_name("decode(oiDataItem:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("OriginInfoDomain")))
@interface MultipazOriginInfoDomain : MultipazOriginInfo
- (instancetype)initWithUrl:(NSString *)url __attribute__((swift_name("init(url:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazOriginInfoDomainCompanion *companion __attribute__((swift_name("companion")));
- (MultipazDataItem *)encode __attribute__((swift_name("encode()")));
@property (readonly) NSString *url __attribute__((swift_name("url")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("OriginInfoDomain.Companion")))
@interface MultipazOriginInfoDomainCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazOriginInfoDomainCompanion *shared __attribute__((swift_name("shared")));
- (MultipazOriginInfoDomain * _Nullable)decodeOiDataItem:(MultipazDataItem *)oiDataItem __attribute__((swift_name("decode(oiDataItem:)")));
@property (readonly) int64_t CAT __attribute__((swift_name("CAT")));
@property (readonly) int32_t TYPE __attribute__((swift_name("TYPE")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceRequestGenerator")))
@interface MultipazDeviceRequestGenerator : MultipazBase
- (instancetype)initWithEncodedSessionTranscript:(MultipazKotlinByteArray *)encodedSessionTranscript __attribute__((swift_name("init(encodedSessionTranscript:)"))) __attribute__((objc_designated_initializer));
- (MultipazDeviceRequestGenerator *)addDocumentRequestDocType:(NSString *)docType itemsToRequest:(NSDictionary<NSString *, NSDictionary<NSString *, MultipazBoolean *> *> *)itemsToRequest requestInfo:(NSDictionary<NSString *, MultipazKotlinByteArray *> * _Nullable)requestInfo readerKey:(MultipazEcPrivateKey * _Nullable)readerKey signatureAlgorithm:(MultipazAlgorithm *)signatureAlgorithm readerKeyCertificateChain:(MultipazX509CertChain * _Nullable)readerKeyCertificateChain __attribute__((swift_name("addDocumentRequest(docType:itemsToRequest:requestInfo:readerKey:signatureAlgorithm:readerKeyCertificateChain:)")));
- (MultipazKotlinByteArray *)generate __attribute__((swift_name("generate()")));
@property (readonly) MultipazKotlinByteArray *encodedSessionTranscript __attribute__((swift_name("encodedSessionTranscript")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceRequestParser")))
@interface MultipazDeviceRequestParser : MultipazBase
- (instancetype)initWithEncodedDeviceRequest:(MultipazKotlinByteArray *)encodedDeviceRequest encodedSessionTranscript:(MultipazKotlinByteArray *)encodedSessionTranscript __attribute__((swift_name("init(encodedDeviceRequest:encodedSessionTranscript:)"))) __attribute__((objc_designated_initializer));
- (MultipazDeviceRequestParserDeviceRequest *)parse __attribute__((swift_name("parse()")));
- (MultipazDeviceRequestParser *)setSkipReaderAuthParseAndCheckSkipReaderAuthParseAndCheck:(BOOL)skipReaderAuthParseAndCheck __attribute__((swift_name("setSkipReaderAuthParseAndCheck(skipReaderAuthParseAndCheck:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceRequestParser.DeviceRequest")))
@interface MultipazDeviceRequestParserDeviceRequest : MultipazBase
@property (class, readonly, getter=companion) MultipazDeviceRequestParserDeviceRequestCompanion *companion __attribute__((swift_name("companion")));
@property (readonly) NSArray<MultipazDeviceRequestParserDocRequest *> *docRequests __attribute__((swift_name("docRequests")));
@property NSString *version __attribute__((swift_name("version")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceRequestParser.DeviceRequestCompanion")))
@interface MultipazDeviceRequestParserDeviceRequestCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazDeviceRequestParserDeviceRequestCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) NSString *TAG __attribute__((swift_name("TAG")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceRequestParser.DocRequest")))
@interface MultipazDeviceRequestParserDocRequest : MultipazBase
- (NSArray<NSString *> *)getEntryNamesNamespaceName:(NSString *)namespaceName __attribute__((swift_name("getEntryNames(namespaceName:)")));
- (BOOL)getIntentToRetainNamespaceName:(NSString *)namespaceName entryName:(NSString *)entryName __attribute__((swift_name("getIntentToRetain(namespaceName:entryName:)")));
@property (readonly) NSString *docType __attribute__((swift_name("docType")));
@property (readonly) MultipazKotlinByteArray *itemsRequest __attribute__((swift_name("itemsRequest")));
@property (readonly) NSArray<NSString *> *namespaces __attribute__((swift_name("namespaces")));
@property (readonly) MultipazKotlinByteArray * _Nullable readerAuth __attribute__((swift_name("readerAuth")));
@property (readonly) BOOL readerAuthenticated __attribute__((swift_name("readerAuthenticated")));
@property (readonly) MultipazX509CertChain * _Nullable readerCertificateChain __attribute__((swift_name("readerCertificateChain")));
@property (readonly) NSDictionary<NSString *, MultipazKotlinByteArray *> *requestInfo __attribute__((swift_name("requestInfo")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceResponseGenerator")))
@interface MultipazDeviceResponseGenerator : MultipazBase
- (instancetype)initWithMStatusCode:(int64_t)mStatusCode __attribute__((swift_name("init(mStatusCode:)"))) __attribute__((objc_designated_initializer));
- (MultipazDeviceResponseGenerator *)addDocumentEncodedDocument:(MultipazKotlinByteArray *)encodedDocument __attribute__((swift_name("addDocument(encodedDocument:)")));
- (MultipazDeviceResponseGenerator *)addDocumentDocType:(NSString *)docType encodedDeviceNamespaces:(MultipazKotlinByteArray *)encodedDeviceNamespaces encodedDeviceSignature:(MultipazKotlinByteArray * _Nullable)encodedDeviceSignature encodedDeviceMac:(MultipazKotlinByteArray * _Nullable)encodedDeviceMac issuerNameSpaces:(NSDictionary<id, NSArray<id> *> *)issuerNameSpaces errors:(NSDictionary<id, NSDictionary<id, id> *> * _Nullable)errors encodedIssuerAuth:(MultipazKotlinByteArray *)encodedIssuerAuth __attribute__((swift_name("addDocument(docType:encodedDeviceNamespaces:encodedDeviceSignature:encodedDeviceMac:issuerNameSpaces:errors:encodedIssuerAuth:)")));
- (MultipazKotlinByteArray *)generate __attribute__((swift_name("generate()")));
- (BOOL)isEmpty __attribute__((swift_name("isEmpty()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceResponseParser")))
@interface MultipazDeviceResponseParser : MultipazBase
- (instancetype)initWithEncodedDeviceResponse:(MultipazKotlinByteArray *)encodedDeviceResponse encodedSessionTranscript:(MultipazKotlinByteArray *)encodedSessionTranscript __attribute__((swift_name("init(encodedDeviceResponse:encodedSessionTranscript:)"))) __attribute__((objc_designated_initializer));
- (MultipazDeviceResponseParserDeviceResponse *)parse __attribute__((swift_name("parse()")));
- (MultipazDeviceResponseParser *)setEphemeralReaderKeyEReaderKey:(MultipazEcPrivateKey *)eReaderKey __attribute__((swift_name("setEphemeralReaderKey(eReaderKey:)")));
@property (readonly) MultipazKotlinByteArray *encodedDeviceResponse __attribute__((swift_name("encodedDeviceResponse")));
@property (readonly) MultipazKotlinByteArray *encodedSessionTranscript __attribute__((swift_name("encodedSessionTranscript")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceResponseParser.DeviceResponse")))
@interface MultipazDeviceResponseParserDeviceResponse : MultipazBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (class, readonly, getter=companion) MultipazDeviceResponseParserDeviceResponseCompanion *companion __attribute__((swift_name("companion")));
@property (readonly) NSArray<MultipazDeviceResponseParserDocument *> *documents __attribute__((swift_name("documents")));
@property (readonly) int64_t status __attribute__((swift_name("status")));
@property NSString *version __attribute__((swift_name("version")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceResponseParser.DeviceResponseCompanion")))
@interface MultipazDeviceResponseParserDeviceResponseCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazDeviceResponseParserDeviceResponseCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) NSString *TAG __attribute__((swift_name("TAG")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceResponseParser.Document")))
@interface MultipazDeviceResponseParserDocument : MultipazBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (class, readonly, getter=companion) MultipazDeviceResponseParserDocumentCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)getDeviceEntryBooleanNamespaceName:(NSString *)namespaceName name:(NSString *)name __attribute__((swift_name("getDeviceEntryBoolean(namespaceName:name:)")));
- (MultipazKotlinByteArray *)getDeviceEntryByteStringNamespaceName:(NSString *)namespaceName name:(NSString *)name __attribute__((swift_name("getDeviceEntryByteString(namespaceName:name:)")));
- (MultipazKotlinByteArray *)getDeviceEntryDataNamespaceName:(NSString *)namespaceName name:(NSString *)name __attribute__((swift_name("getDeviceEntryData(namespaceName:name:)")));
- (MultipazKotlinx_datetimeInstant *)getDeviceEntryDateTimeNamespaceName:(NSString *)namespaceName name:(NSString *)name __attribute__((swift_name("getDeviceEntryDateTime(namespaceName:name:)")));
- (NSArray<NSString *> *)getDeviceEntryNamesNamespaceName:(NSString *)namespaceName __attribute__((swift_name("getDeviceEntryNames(namespaceName:)")));
- (int64_t)getDeviceEntryNumberNamespaceName:(NSString *)namespaceName name:(NSString *)name __attribute__((swift_name("getDeviceEntryNumber(namespaceName:name:)")));
- (NSString *)getDeviceEntryStringNamespaceName:(NSString *)namespaceName name:(NSString *)name __attribute__((swift_name("getDeviceEntryString(namespaceName:name:)")));
- (BOOL)getIssuerEntryBooleanNamespaceName:(NSString *)namespaceName name:(NSString *)name __attribute__((swift_name("getIssuerEntryBoolean(namespaceName:name:)")));
- (MultipazKotlinByteArray *)getIssuerEntryByteStringNamespaceName:(NSString *)namespaceName name:(NSString *)name __attribute__((swift_name("getIssuerEntryByteString(namespaceName:name:)")));
- (MultipazKotlinByteArray *)getIssuerEntryDataNamespaceName:(NSString *)namespaceName name:(NSString *)name __attribute__((swift_name("getIssuerEntryData(namespaceName:name:)")));
- (MultipazKotlinx_datetimeInstant *)getIssuerEntryDateTimeNamespaceName:(NSString *)namespaceName name:(NSString *)name __attribute__((swift_name("getIssuerEntryDateTime(namespaceName:name:)")));
- (BOOL)getIssuerEntryDigestMatchNamespaceName:(NSString *)namespaceName name:(NSString *)name __attribute__((swift_name("getIssuerEntryDigestMatch(namespaceName:name:)")));
- (NSArray<NSString *> *)getIssuerEntryNamesNamespaceName:(NSString *)namespaceName __attribute__((swift_name("getIssuerEntryNames(namespaceName:)")));
- (int64_t)getIssuerEntryNumberNamespaceName:(NSString *)namespaceName name:(NSString *)name __attribute__((swift_name("getIssuerEntryNumber(namespaceName:name:)")));
- (NSString *)getIssuerEntryStringNamespaceName:(NSString *)namespaceName name:(NSString *)name __attribute__((swift_name("getIssuerEntryString(namespaceName:name:)")));
@property MultipazEcPublicKey *deviceKey __attribute__((swift_name("deviceKey")));
@property (readonly) NSArray<NSString *> *deviceNamespaces __attribute__((swift_name("deviceNamespaces")));
@property BOOL deviceSignedAuthenticated __attribute__((swift_name("deviceSignedAuthenticated")));
@property BOOL deviceSignedAuthenticatedViaSignature __attribute__((swift_name("deviceSignedAuthenticatedViaSignature")));
@property NSString *docType __attribute__((swift_name("docType")));
@property MultipazX509CertChain *issuerCertificateChain __attribute__((swift_name("issuerCertificateChain")));
@property (readonly) NSArray<NSString *> *issuerNamespaces __attribute__((swift_name("issuerNamespaces")));
@property BOOL issuerSignedAuthenticated __attribute__((swift_name("issuerSignedAuthenticated")));
@property int32_t numIssuerEntryDigestMatchFailures __attribute__((swift_name("numIssuerEntryDigestMatchFailures")));
@property MultipazKotlinx_datetimeInstant * _Nullable validityInfoExpectedUpdate __attribute__((swift_name("validityInfoExpectedUpdate")));
@property MultipazKotlinx_datetimeInstant *validityInfoSigned __attribute__((swift_name("validityInfoSigned")));
@property MultipazKotlinx_datetimeInstant *validityInfoValidFrom __attribute__((swift_name("validityInfoValidFrom")));
@property MultipazKotlinx_datetimeInstant *validityInfoValidUntil __attribute__((swift_name("validityInfoValidUntil")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceResponseParser.DocumentCompanion")))
@interface MultipazDeviceResponseParserDocumentCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazDeviceResponseParserDocumentCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) NSString *TAG __attribute__((swift_name("TAG")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DocumentGenerator")))
@interface MultipazDocumentGenerator : MultipazBase
- (instancetype)initWithDocType:(NSString *)docType encodedIssuerAuth:(MultipazKotlinByteArray *)encodedIssuerAuth encodedSessionTranscript:(MultipazKotlinByteArray *)encodedSessionTranscript __attribute__((swift_name("init(docType:encodedIssuerAuth:encodedSessionTranscript:)"))) __attribute__((objc_designated_initializer));
- (MultipazKotlinByteArray *)generate __attribute__((swift_name("generate()")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)setDeviceNamespacesMacDataElements:(MultipazNameSpacedData *)dataElements secureArea:(id<MultipazSecureArea>)secureArea keyAlias:(NSString *)keyAlias keyUnlockData:(id<MultipazKeyUnlockData> _Nullable)keyUnlockData eReaderKey:(MultipazEcPublicKey *)eReaderKey completionHandler:(void (^)(MultipazDocumentGenerator * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("setDeviceNamespacesMac(dataElements:secureArea:keyAlias:keyUnlockData:eReaderKey:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)setDeviceNamespacesSignatureDataElements:(MultipazNameSpacedData *)dataElements secureArea:(id<MultipazSecureArea>)secureArea keyAlias:(NSString *)keyAlias keyUnlockData:(id<MultipazKeyUnlockData> _Nullable)keyUnlockData completionHandler:(void (^)(MultipazDocumentGenerator * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("setDeviceNamespacesSignature(dataElements:secureArea:keyAlias:keyUnlockData:completionHandler:)")));
- (MultipazDocumentGenerator *)setErrorsErrors:(NSDictionary<NSString *, NSDictionary<NSString *, MultipazLong *> *> *)errors __attribute__((swift_name("setErrors(errors:)")));
- (MultipazDocumentGenerator *)setIssuerNamespacesIssuerNameSpaces:(NSDictionary<NSString *, NSArray<MultipazKotlinByteArray *> *> * _Nullable)issuerNameSpaces __attribute__((swift_name("setIssuerNamespaces(issuerNameSpaces:)")));
- (void)setIssuerNamespacesIssuerNamespaces:(MultipazIssuerNamespaces *)issuerNamespaces __attribute__((swift_name("setIssuerNamespaces(issuerNamespaces:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocRole")))
@interface MultipazMdocRole : MultipazKotlinEnum<MultipazMdocRole *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) MultipazMdocRole *mdoc __attribute__((swift_name("mdoc")));
@property (class, readonly) MultipazMdocRole *mdocReader __attribute__((swift_name("mdocReader")));
+ (MultipazKotlinArray<MultipazMdocRole *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazMdocRole *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SessionEncryption")))
@interface MultipazSessionEncryption : MultipazBase
- (instancetype)initWithRole:(MultipazMdocRole *)role eSelfKey:(MultipazEcPrivateKey *)eSelfKey remotePublicKey:(MultipazEcPublicKey *)remotePublicKey encodedSessionTranscript:(MultipazKotlinByteArray *)encodedSessionTranscript __attribute__((swift_name("init(role:eSelfKey:remotePublicKey:encodedSessionTranscript:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazSessionEncryptionCompanion *companion __attribute__((swift_name("companion")));
- (MultipazKotlinPair<MultipazKotlinByteArray *, MultipazLong *> *)decryptMessageMessageData:(MultipazKotlinByteArray *)messageData __attribute__((swift_name("decryptMessage(messageData:)")));
- (MultipazKotlinByteArray *)encryptMessageMessagePlaintext:(MultipazKotlinByteArray * _Nullable)messagePlaintext statusCode:(MultipazLong * _Nullable)statusCode __attribute__((swift_name("encryptMessage(messagePlaintext:statusCode:)")));
- (void)setSendSessionEstablishmentSendSessionEstablishment:(BOOL)sendSessionEstablishment __attribute__((swift_name("setSendSessionEstablishment(sendSessionEstablishment:)")));
@property (readonly) int32_t numMessagesDecrypted __attribute__((swift_name("numMessagesDecrypted")));
@property (readonly) int32_t numMessagesEncrypted __attribute__((swift_name("numMessagesEncrypted")));
@property (readonly) MultipazMdocRole *role __attribute__((swift_name("role")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SessionEncryption.Companion")))
@interface MultipazSessionEncryptionCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazSessionEncryptionCompanion *shared __attribute__((swift_name("shared")));
- (MultipazKotlinByteArray *)encodeStatusStatusCode:(int64_t)statusCode __attribute__((swift_name("encodeStatus(statusCode:)")));
- (MultipazEcPublicKey *)getEReaderKeySessionEstablishmentMessage:(MultipazKotlinByteArray *)sessionEstablishmentMessage __attribute__((swift_name("getEReaderKey(sessionEstablishmentMessage:)")));
@end

__attribute__((swift_name("MdocTransport")))
@interface MultipazMdocTransport : MultipazBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)advertiseWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("advertise(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)closeWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("close(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)openESenderKey:(MultipazEcPublicKey *)eSenderKey completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("open(eSenderKey:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)sendMessageMessage:(MultipazKotlinByteArray *)message completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("sendMessage(message:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)waitForMessageWithCompletionHandler:(void (^)(MultipazKotlinByteArray * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("waitForMessage(completionHandler:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (MultipazKotlinThrowable *)wrapUnlessCancellationException:(MultipazKotlinThrowable *)receiver message:(NSString *)message __attribute__((swift_name("wrapUnlessCancellationException(_:message:)")));
@property (readonly) MultipazMdocConnectionMethod *connectionMethod __attribute__((swift_name("connectionMethod")));
@property (readonly) MultipazMdocRole *role __attribute__((swift_name("role")));
@property (readonly) id _Nullable scanningTime __attribute__((swift_name("scanningTime")));
@property (readonly) id<MultipazKotlinx_coroutines_coreStateFlow> state __attribute__((swift_name("state")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocTransport.State")))
@interface MultipazMdocTransportState : MultipazKotlinEnum<MultipazMdocTransportState *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) MultipazMdocTransportState *idle __attribute__((swift_name("idle")));
@property (class, readonly) MultipazMdocTransportState *advertising __attribute__((swift_name("advertising")));
@property (class, readonly) MultipazMdocTransportState *scanning __attribute__((swift_name("scanning")));
@property (class, readonly) MultipazMdocTransportState *connecting __attribute__((swift_name("connecting")));
@property (class, readonly) MultipazMdocTransportState *connected __attribute__((swift_name("connected")));
@property (class, readonly) MultipazMdocTransportState *closed __attribute__((swift_name("closed")));
@property (class, readonly) MultipazMdocTransportState *failed __attribute__((swift_name("failed")));
+ (MultipazKotlinArray<MultipazMdocTransportState *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazMdocTransportState *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocTransportClosedException")))
@interface MultipazMdocTransportClosedException : MultipazKotlinException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(MultipazKotlinThrowable *)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString *)message cause:(MultipazKotlinThrowable *)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocTransportException")))
@interface MultipazMdocTransportException : MultipazKotlinException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(MultipazKotlinThrowable *)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString *)message cause:(MultipazKotlinThrowable *)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((swift_name("MdocTransportFactory")))
@protocol MultipazMdocTransportFactory
@required
- (MultipazMdocTransport *)createTransportConnectionMethod:(MultipazMdocConnectionMethod *)connectionMethod role:(MultipazMdocRole *)role options:(MultipazMdocTransportOptions *)options __attribute__((swift_name("createTransport(connectionMethod:role:options:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocTransportFactoryDefault")))
@interface MultipazMdocTransportFactoryDefault : MultipazBase <MultipazMdocTransportFactory>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)default_ __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazMdocTransportFactoryDefault *shared __attribute__((swift_name("shared")));
- (MultipazMdocTransport *)createTransportConnectionMethod:(MultipazMdocConnectionMethod *)connectionMethod role:(MultipazMdocRole *)role options:(MultipazMdocTransportOptions *)options __attribute__((swift_name("createTransport(connectionMethod:role:options:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocTransportOptions")))
@interface MultipazMdocTransportOptions : MultipazBase
- (instancetype)initWithBleUseL2CAP:(BOOL)bleUseL2CAP __attribute__((swift_name("init(bleUseL2CAP:)"))) __attribute__((objc_designated_initializer));
- (MultipazMdocTransportOptions *)doCopyBleUseL2CAP:(BOOL)bleUseL2CAP __attribute__((swift_name("doCopy(bleUseL2CAP:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) BOOL bleUseL2CAP __attribute__((swift_name("bleUseL2CAP")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocTransportTerminationException")))
@interface MultipazMdocTransportTerminationException : MultipazKotlinException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(MultipazKotlinThrowable *)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString *)message cause:(MultipazKotlinThrowable *)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NfcTransportMdoc")))
@interface MultipazNfcTransportMdoc : MultipazMdocTransport
- (instancetype)initWithRole:(MultipazMdocRole *)role options:(MultipazMdocTransportOptions *)options connectionMethod:(MultipazMdocConnectionMethod *)connectionMethod __attribute__((swift_name("init(role:options:connectionMethod:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazNfcTransportMdocCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)advertiseWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("advertise(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)closeWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("close(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)openESenderKey:(MultipazEcPublicKey *)eSenderKey completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("open(eSenderKey:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)sendMessageMessage:(MultipazKotlinByteArray *)message completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("sendMessage(message:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)waitForMessageWithCompletionHandler:(void (^)(MultipazKotlinByteArray * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("waitForMessage(completionHandler:)")));
@property (readonly) MultipazMdocConnectionMethod *connectionMethod __attribute__((swift_name("connectionMethod")));
@property (readonly) MultipazMdocRole *role __attribute__((swift_name("role")));
@property (readonly) id _Nullable scanningTime __attribute__((swift_name("scanningTime")));
@property (readonly) id<MultipazKotlinx_coroutines_coreStateFlow> state __attribute__((swift_name("state")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NfcTransportMdoc.Companion")))
@interface MultipazNfcTransportMdocCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazNfcTransportMdocCompanion *shared __attribute__((swift_name("shared")));
- (void)onDeactivated __attribute__((swift_name("onDeactivated()")));
- (void)processCommandApduCommandApdu:(MultipazKotlinByteArray *)commandApdu sendResponse:(void (^)(MultipazKotlinByteArray *))sendResponse __attribute__((swift_name("processCommandApdu(commandApdu:sendResponse:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NfcTransportMdoc.NfcError")))
@interface MultipazNfcTransportMdocNfcError : MultipazKotlinException
- (instancetype)initWithStatus:(int32_t)status message:(NSString *)message __attribute__((swift_name("init(status:message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (readonly) int32_t status __attribute__((swift_name("status")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NfcTransportMdocReader")))
@interface MultipazNfcTransportMdocReader : MultipazMdocTransport
- (instancetype)initWithRole:(MultipazMdocRole *)role options:(MultipazMdocTransportOptions *)options connectionMethod:(MultipazMdocConnectionMethodNfc *)connectionMethod __attribute__((swift_name("init(role:options:connectionMethod:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazNfcTransportMdocReaderCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)advertiseWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("advertise(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)closeWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("close(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)openESenderKey:(MultipazEcPublicKey *)eSenderKey completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("open(eSenderKey:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)sendMessageMessage:(MultipazKotlinByteArray *)message completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("sendMessage(message:completionHandler:)")));
- (void)setTagTag:(MultipazNfcIsoTag *)tag __attribute__((swift_name("setTag(tag:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)waitForMessageWithCompletionHandler:(void (^)(MultipazKotlinByteArray * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("waitForMessage(completionHandler:)")));
@property (readonly) MultipazMdocConnectionMethodNfc *connectionMethod __attribute__((swift_name("connectionMethod")));
@property (readonly) MultipazMdocRole *role __attribute__((swift_name("role")));
@property (readonly) id _Nullable scanningTime __attribute__((swift_name("scanningTime")));
@property (readonly) id<MultipazKotlinx_coroutines_coreStateFlow> state __attribute__((swift_name("state")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NfcTransportMdocReader.Companion")))
@interface MultipazNfcTransportMdocReaderCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazNfcTransportMdocReaderCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocUtil")))
@interface MultipazMdocUtil : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)mdocUtil __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazMdocUtil *shared __attribute__((swift_name("shared")));
- (NSDictionary<MultipazLong *, MultipazKotlinByteArray *> *)calculateDigestsForNameSpaceNameSpaceName:(NSString *)nameSpaceName issuerNameSpaces:(NSDictionary<NSString *, NSArray<MultipazKotlinByteArray *> *> *)issuerNameSpaces digestAlgorithm:(MultipazAlgorithm *)digestAlgorithm __attribute__((swift_name("calculateDigestsForNameSpace(nameSpaceName:issuerNameSpaces:digestAlgorithm:)")));
- (MultipazDocumentRequest *)generateDocumentRequestDocumentRequest:(MultipazDeviceRequestParserDocRequest *)documentRequest __attribute__((swift_name("generateDocumentRequest(documentRequest:)")));
- (MultipazX509Cert *)generateDsCertificateIacaCert:(MultipazX509Cert *)iacaCert iacaKey:(MultipazEcPrivateKey *)iacaKey dsKey:(MultipazEcPublicKey *)dsKey subject:(MultipazX500Name *)subject serial:(MultipazASN1Integer *)serial validFrom:(MultipazKotlinx_datetimeInstant *)validFrom validUntil:(MultipazKotlinx_datetimeInstant *)validUntil __attribute__((swift_name("generateDsCertificate(iacaCert:iacaKey:dsKey:subject:serial:validFrom:validUntil:)")));
- (MultipazX509Cert *)generateIacaCertificateIacaKey:(MultipazEcPrivateKey *)iacaKey subject:(MultipazX500Name *)subject serial:(MultipazASN1Integer *)serial validFrom:(MultipazKotlinx_datetimeInstant *)validFrom validUntil:(MultipazKotlinx_datetimeInstant *)validUntil issuerAltNameUrl:(NSString *)issuerAltNameUrl crlUrl:(NSString *)crlUrl __attribute__((swift_name("generateIacaCertificate(iacaKey:subject:serial:validFrom:validUntil:issuerAltNameUrl:crlUrl:)")));
- (NSDictionary<NSString *, NSArray<MultipazKotlinByteArray *> *> *)generateIssuerNameSpacesData:(MultipazNameSpacedData *)data randomProvider:(MultipazKotlinRandom *)randomProvider dataElementRandomSize:(int32_t)dataElementRandomSize overrides:(NSDictionary<NSString *, NSDictionary<NSString *, MultipazKotlinByteArray *> *> * _Nullable)overrides __attribute__((swift_name("generateIssuerNameSpaces(data:randomProvider:dataElementRandomSize:overrides:)")));
- (MultipazX509Cert *)generateReaderCertificateReaderRootCert:(MultipazX509Cert *)readerRootCert readerRootKey:(MultipazEcPrivateKey *)readerRootKey readerKey:(MultipazEcPublicKey *)readerKey subject:(MultipazX500Name *)subject serial:(MultipazASN1Integer *)serial validFrom:(MultipazKotlinx_datetimeInstant *)validFrom validUntil:(MultipazKotlinx_datetimeInstant *)validUntil __attribute__((swift_name("generateReaderCertificate(readerRootCert:readerRootKey:readerKey:subject:serial:validFrom:validUntil:)")));
- (MultipazX509Cert *)generateReaderRootCertificateReaderRootKey:(MultipazEcPrivateKey *)readerRootKey subject:(MultipazX500Name *)subject serial:(MultipazASN1Integer *)serial validFrom:(MultipazKotlinx_datetimeInstant *)validFrom validUntil:(MultipazKotlinx_datetimeInstant *)validUntil crlUrl:(NSString *)crlUrl __attribute__((swift_name("generateReaderRootCertificate(readerRootKey:subject:serial:validFrom:validUntil:crlUrl:)")));
- (NSArray<MultipazMdocRequestedClaim *> *)generateRequestedClaimsDocType:(NSString *)docType requestedData:(NSDictionary<NSString *, NSArray<MultipazKotlinPair<NSString *, MultipazBoolean *> *> *> *)requestedData documentTypeRepository:(MultipazDocumentTypeRepository *)documentTypeRepository mdocCredential:(MultipazMdocCredential * _Nullable)mdocCredential __attribute__((swift_name("generateRequestedClaims(docType:requestedData:documentTypeRepository:mdocCredential:)")));
- (NSDictionary<NSString *, NSMutableArray<MultipazKotlinByteArray *> *> *)mergeIssuerNamesSpacesDataElements:(NSDictionary<NSString *, NSArray<NSString *> *> *)dataElements documentData:(MultipazNameSpacedData *)documentData staticAuthData:(MultipazStaticAuthDataParserStaticAuthData *)staticAuthData __attribute__((swift_name("mergeIssuerNamesSpaces(dataElements:documentData:staticAuthData:)")));
- (NSDictionary<NSString *, NSMutableArray<MultipazKotlinByteArray *> *> *)mergeIssuerNamesSpacesRequest:(MultipazDocumentRequest *)request documentData:(MultipazNameSpacedData *)documentData staticAuthData:(MultipazStaticAuthDataParserStaticAuthData *)staticAuthData __attribute__((swift_name("mergeIssuerNamesSpaces(request:documentData:staticAuthData:)")));
- (NSDictionary<NSString *, NSArray<MultipazKotlinByteArray *> *> *)stripIssuerNameSpacesIssuerNameSpaces:(NSDictionary<NSString *, NSArray<MultipazKotlinByteArray *> *> *)issuerNameSpaces exceptions:(NSDictionary<NSString *, NSArray<NSString *> *> * _Nullable)exceptions __attribute__((swift_name("stripIssuerNameSpaces(issuerNameSpaces:exceptions:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SignedVical")))
@interface MultipazSignedVical : MultipazBase
- (instancetype)initWithVical:(MultipazVical *)vical vicalProviderCertificateChain:(MultipazX509CertChain *)vicalProviderCertificateChain __attribute__((swift_name("init(vical:vicalProviderCertificateChain:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazSignedVicalCompanion *companion __attribute__((swift_name("companion")));
- (MultipazSignedVical *)doCopyVical:(MultipazVical *)vical vicalProviderCertificateChain:(MultipazX509CertChain *)vicalProviderCertificateChain __attribute__((swift_name("doCopy(vical:vicalProviderCertificateChain:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (MultipazKotlinByteArray *)generateSigningKey:(MultipazEcPrivateKey *)signingKey signingAlgorithm:(MultipazAlgorithm *)signingAlgorithm __attribute__((swift_name("generate(signingKey:signingAlgorithm:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazVical *vical __attribute__((swift_name("vical")));
@property (readonly) MultipazX509CertChain *vicalProviderCertificateChain __attribute__((swift_name("vicalProviderCertificateChain")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SignedVical.Companion")))
@interface MultipazSignedVicalCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazSignedVicalCompanion *shared __attribute__((swift_name("shared")));
- (MultipazSignedVical *)parseEncodedSignedVical:(MultipazKotlinByteArray *)encodedSignedVical __attribute__((swift_name("parse(encodedSignedVical:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Vical")))
@interface MultipazVical : MultipazBase
- (instancetype)initWithVersion:(NSString *)version vicalProvider:(NSString *)vicalProvider date:(MultipazKotlinx_datetimeInstant *)date nextUpdate:(MultipazKotlinx_datetimeInstant * _Nullable)nextUpdate vicalIssueID:(MultipazLong * _Nullable)vicalIssueID certificateInfos:(NSArray<MultipazVicalCertificateInfo *> *)certificateInfos __attribute__((swift_name("init(version:vicalProvider:date:nextUpdate:vicalIssueID:certificateInfos:)"))) __attribute__((objc_designated_initializer));
- (MultipazVical *)doCopyVersion:(NSString *)version vicalProvider:(NSString *)vicalProvider date:(MultipazKotlinx_datetimeInstant *)date nextUpdate:(MultipazKotlinx_datetimeInstant * _Nullable)nextUpdate vicalIssueID:(MultipazLong * _Nullable)vicalIssueID certificateInfos:(NSArray<MultipazVicalCertificateInfo *> *)certificateInfos __attribute__((swift_name("doCopy(version:vicalProvider:date:nextUpdate:vicalIssueID:certificateInfos:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSArray<MultipazVicalCertificateInfo *> *certificateInfos __attribute__((swift_name("certificateInfos")));
@property (readonly) MultipazKotlinx_datetimeInstant *date __attribute__((swift_name("date")));
@property (readonly) MultipazKotlinx_datetimeInstant * _Nullable nextUpdate __attribute__((swift_name("nextUpdate")));
@property (readonly) NSString *version __attribute__((swift_name("version")));
@property (readonly) MultipazLong * _Nullable vicalIssueID __attribute__((swift_name("vicalIssueID")));
@property (readonly) NSString *vicalProvider __attribute__((swift_name("vicalProvider")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VicalCertificateInfo")))
@interface MultipazVicalCertificateInfo : MultipazBase
- (instancetype)initWithCertificate:(MultipazX509Cert *)certificate docType:(NSArray<NSString *> *)docType certificateProfiles:(NSArray<NSString *> * _Nullable)certificateProfiles __attribute__((swift_name("init(certificate:docType:certificateProfiles:)"))) __attribute__((objc_designated_initializer));
- (MultipazVicalCertificateInfo *)doCopyCertificate:(MultipazX509Cert *)certificate docType:(NSArray<NSString *> *)docType certificateProfiles:(NSArray<NSString *> * _Nullable)certificateProfiles __attribute__((swift_name("doCopy(certificate:docType:certificateProfiles:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazX509Cert *certificate __attribute__((swift_name("certificate")));
@property (readonly) NSArray<NSString *> * _Nullable certificateProfiles __attribute__((swift_name("certificateProfiles")));
@property (readonly) NSArray<NSString *> *docType __attribute__((swift_name("docType")));
@end

__attribute__((swift_name("DigitalCredentials")))
@protocol MultipazDigitalCredentials
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)startExportingCredentialsDocumentStore:(MultipazDocumentStore *)documentStore documentTypeRepository:(MultipazDocumentTypeRepository *)documentTypeRepository completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("startExportingCredentials(documentStore:documentTypeRepository:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)stopExportingCredentialsDocumentStore:(MultipazDocumentStore *)documentStore completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("stopExportingCredentials(documentStore:completionHandler:)")));
@property (readonly) BOOL available __attribute__((swift_name("available")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DigitalCredentialsDefault")))
@interface MultipazDigitalCredentialsDefault : MultipazBase <MultipazDigitalCredentials>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)default_ __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazDigitalCredentialsDefault *shared __attribute__((swift_name("shared")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)startExportingCredentialsDocumentStore:(MultipazDocumentStore *)documentStore documentTypeRepository:(MultipazDocumentTypeRepository *)documentTypeRepository completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("startExportingCredentials(documentStore:documentTypeRepository:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)stopExportingCredentialsDocumentStore:(MultipazDocumentStore *)documentStore completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("stopExportingCredentials(documentStore:completionHandler:)")));
@property (readonly) BOOL available __attribute__((swift_name("available")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CredentialForPresentment")))
@interface MultipazCredentialForPresentment : MultipazBase
- (instancetype)initWithCredential:(MultipazCredential * _Nullable)credential credentialKeyAgreement:(MultipazCredential * _Nullable)credentialKeyAgreement __attribute__((swift_name("init(credential:credentialKeyAgreement:)"))) __attribute__((objc_designated_initializer));
- (MultipazCredentialForPresentment *)doCopyCredential:(MultipazCredential * _Nullable)credential credentialKeyAgreement:(MultipazCredential * _Nullable)credentialKeyAgreement __attribute__((swift_name("doCopy(credential:credentialKeyAgreement:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazCredential * _Nullable credential __attribute__((swift_name("credential")));
@property (readonly) MultipazCredential * _Nullable credentialKeyAgreement __attribute__((swift_name("credentialKeyAgreement")));
@end

__attribute__((swift_name("PresentmentMechanism")))
@protocol MultipazPresentmentMechanism
@required
- (void)close __attribute__((swift_name("close()")));
@end

__attribute__((swift_name("DigitalCredentialsPresentmentMechanism")))
@interface MultipazDigitalCredentialsPresentmentMechanism : MultipazBase <MultipazPresentmentMechanism>
- (instancetype)initWithAppId:(NSString *)appId webOrigin:(NSString * _Nullable)webOrigin protocol:(NSString *)protocol request:(NSString *)request document:(MultipazDocument *)document __attribute__((swift_name("init(appId:webOrigin:protocol:request:document:)"))) __attribute__((objc_designated_initializer));
- (void)sendResponseResponse:(NSString *)response __attribute__((swift_name("sendResponse(response:)")));
@property (readonly) NSString *appId __attribute__((swift_name("appId")));
@property (readonly) MultipazDocument *document __attribute__((swift_name("document")));
@property (readonly) NSString *protocol __attribute__((swift_name("protocol")));
@property (readonly) NSString *request __attribute__((swift_name("request")));
@property (readonly) NSString * _Nullable webOrigin __attribute__((swift_name("webOrigin")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocPresentmentMechanism")))
@interface MultipazMdocPresentmentMechanism : MultipazBase <MultipazPresentmentMechanism>
- (instancetype)initWithTransport:(MultipazMdocTransport *)transport eDeviceKey:(MultipazEcPrivateKey *)eDeviceKey encodedDeviceEngagement:(MultipazKotlinx_io_bytestringByteString *)encodedDeviceEngagement handover:(MultipazDataItem *)handover engagementDuration:(id _Nullable)engagementDuration allowMultipleRequests:(BOOL)allowMultipleRequests __attribute__((swift_name("init(transport:eDeviceKey:encodedDeviceEngagement:handover:engagementDuration:allowMultipleRequests:)"))) __attribute__((objc_designated_initializer));
- (void)close __attribute__((swift_name("close()")));
@property (readonly) BOOL allowMultipleRequests __attribute__((swift_name("allowMultipleRequests")));
@property (readonly) MultipazEcPrivateKey *eDeviceKey __attribute__((swift_name("eDeviceKey")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *encodedDeviceEngagement __attribute__((swift_name("encodedDeviceEngagement")));
@property (readonly) id _Nullable engagementDuration __attribute__((swift_name("engagementDuration")));
@property (readonly) MultipazDataItem *handover __attribute__((swift_name("handover")));
@property (readonly) MultipazMdocTransport *transport __attribute__((swift_name("transport")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PresentmentCanceled")))
@interface MultipazPresentmentCanceled : MultipazKotlinException
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PresentmentModel")))
@interface MultipazPresentmentModel : MultipazBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (class, readonly, getter=companion) MultipazPresentmentModelCompanion *companion __attribute__((swift_name("companion")));
- (void)consentReviewedConsentObtained:(BOOL)consentObtained __attribute__((swift_name("consentReviewed(consentObtained:)")));
- (void)dismissDismissType:(MultipazPresentmentModelDismissType *)dismissType __attribute__((swift_name("dismiss(dismissType:)")));
- (void)documentSelectedDocument:(MultipazDocument * _Nullable)document __attribute__((swift_name("documentSelected(document:)")));
- (void)reset __attribute__((swift_name("reset()")));
- (void)setCompletedError:(MultipazKotlinThrowable * _Nullable)error __attribute__((swift_name("setCompleted(error:)")));
- (void)setConnecting __attribute__((swift_name("setConnecting()")));
- (void)setMechanismMechanism:(id<MultipazPresentmentMechanism>)mechanism __attribute__((swift_name("setMechanism(mechanism:)")));
- (void)setPromptModelPromptModel:(id<MultipazPromptModel>)promptModel __attribute__((swift_name("setPromptModel(promptModel:)")));
- (void)setSourceSource:(id<MultipazPresentmentSource>)source __attribute__((swift_name("setSource(source:)")));
@property (readonly) NSArray<MultipazDocument *> *availableDocuments __attribute__((swift_name("availableDocuments")));
@property (readonly) MultipazPresentmentModelConsentData *consentData __attribute__((swift_name("consentData")));
@property (readonly) id<MultipazKotlinx_coroutines_coreStateFlow> dismissable __attribute__((swift_name("dismissable")));
@property (readonly) MultipazKotlinThrowable * _Nullable error __attribute__((swift_name("error")));
@property (readonly) id<MultipazPresentmentMechanism> _Nullable mechanism __attribute__((swift_name("mechanism")));
@property (readonly) id<MultipazKotlinx_coroutines_coreStateFlow> numRequestsServed __attribute__((swift_name("numRequestsServed")));
@property (readonly) id<MultipazKotlinx_coroutines_coreCoroutineScope> presentmentScope __attribute__((swift_name("presentmentScope")));
@property (readonly) id<MultipazPresentmentSource> _Nullable source __attribute__((swift_name("source")));
@property (readonly) id<MultipazKotlinx_coroutines_coreStateFlow> state __attribute__((swift_name("state")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PresentmentModel.Companion")))
@interface MultipazPresentmentModelCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazPresentmentModelCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PresentmentModel.ConsentData")))
@interface MultipazPresentmentModelConsentData : MultipazBase
- (instancetype)initWithDocument:(MultipazDocument *)document request:(MultipazRequest *)request trustPoint:(MultipazTrustPoint * _Nullable)trustPoint __attribute__((swift_name("init(document:request:trustPoint:)"))) __attribute__((objc_designated_initializer));
- (MultipazPresentmentModelConsentData *)doCopyDocument:(MultipazDocument *)document request:(MultipazRequest *)request trustPoint:(MultipazTrustPoint * _Nullable)trustPoint __attribute__((swift_name("doCopy(document:request:trustPoint:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazDocument *document __attribute__((swift_name("document")));
@property (readonly) MultipazRequest *request __attribute__((swift_name("request")));
@property (readonly) MultipazTrustPoint * _Nullable trustPoint __attribute__((swift_name("trustPoint")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PresentmentModel.DismissType")))
@interface MultipazPresentmentModelDismissType : MultipazKotlinEnum<MultipazPresentmentModelDismissType *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) MultipazPresentmentModelDismissType *click __attribute__((swift_name("click")));
@property (class, readonly) MultipazPresentmentModelDismissType *longClick __attribute__((swift_name("longClick")));
@property (class, readonly) MultipazPresentmentModelDismissType *doubleClick __attribute__((swift_name("doubleClick")));
+ (MultipazKotlinArray<MultipazPresentmentModelDismissType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazPresentmentModelDismissType *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PresentmentModel.State")))
@interface MultipazPresentmentModelState : MultipazKotlinEnum<MultipazPresentmentModelState *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) MultipazPresentmentModelState *idle __attribute__((swift_name("idle")));
@property (class, readonly) MultipazPresentmentModelState *connecting __attribute__((swift_name("connecting")));
@property (class, readonly) MultipazPresentmentModelState *waitingForSource __attribute__((swift_name("waitingForSource")));
@property (class, readonly) MultipazPresentmentModelState *processing __attribute__((swift_name("processing")));
@property (class, readonly) MultipazPresentmentModelState *waitingForDocumentSelection __attribute__((swift_name("waitingForDocumentSelection")));
@property (class, readonly) MultipazPresentmentModelState *waitingForConsent __attribute__((swift_name("waitingForConsent")));
@property (class, readonly) MultipazPresentmentModelState *completed __attribute__((swift_name("completed")));
+ (MultipazKotlinArray<MultipazPresentmentModelState *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazPresentmentModelState *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((swift_name("PresentmentSource")))
@protocol MultipazPresentmentSource
@required
- (MultipazTrustPoint * _Nullable)findTrustPointRequest:(MultipazRequest *)request __attribute__((swift_name("findTrustPoint(request:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getCredentialForPresentmentRequest:(MultipazRequest *)request document:(MultipazDocument *)document completionHandler:(void (^)(MultipazCredentialForPresentment * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getCredentialForPresentment(request:document:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getDocumentsMatchingRequestRequest:(MultipazRequest *)request completionHandler:(void (^)(NSArray<MultipazDocument *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getDocumentsMatchingRequest(request:completionHandler:)")));
- (BOOL)shouldPreferSignatureToKeyAgreementDocument:(MultipazDocument *)document request:(MultipazRequest *)request __attribute__((swift_name("shouldPreferSignatureToKeyAgreement(document:request:)")));
- (BOOL)shouldShowConsentPromptCredential:(MultipazCredential *)credential request:(MultipazRequest *)request __attribute__((swift_name("shouldShowConsentPrompt(credential:request:)")));
@property (readonly) MultipazDocumentTypeRepository *documentTypeRepository __attribute__((swift_name("documentTypeRepository")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PresentmentTimeout")))
@interface MultipazPresentmentTimeout : MultipazKotlinException
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CommandApdu")))
@interface MultipazCommandApdu : MultipazBase
- (instancetype)initWithCla:(int32_t)cla ins:(int32_t)ins p1:(int32_t)p1 p2:(int32_t)p2 payload:(MultipazKotlinx_io_bytestringByteString *)payload le:(int32_t)le __attribute__((swift_name("init(cla:ins:p1:p2:payload:le:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazCommandApduCompanion *companion __attribute__((swift_name("companion")));
- (MultipazCommandApdu *)doCopyCla:(int32_t)cla ins:(int32_t)ins p1:(int32_t)p1 p2:(int32_t)p2 payload:(MultipazKotlinx_io_bytestringByteString *)payload le:(int32_t)le __attribute__((swift_name("doCopy(cla:ins:p1:p2:payload:le:)")));
- (MultipazKotlinByteArray *)encode __attribute__((swift_name("encode()")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t cla __attribute__((swift_name("cla")));
@property (readonly) int32_t ins __attribute__((swift_name("ins")));
@property (readonly) int32_t le __attribute__((swift_name("le")));
@property (readonly) int32_t p1 __attribute__((swift_name("p1")));
@property (readonly) int32_t p2 __attribute__((swift_name("p2")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *payload __attribute__((swift_name("payload")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CommandApdu.Companion")))
@interface MultipazCommandApduCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazCommandApduCompanion *shared __attribute__((swift_name("shared")));
- (MultipazCommandApdu *)decodeEncoded:(MultipazKotlinByteArray *)encoded __attribute__((swift_name("decode(encoded:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("HandoverRequestRecord")))
@interface MultipazHandoverRequestRecord : MultipazBase
- (instancetype)initWithVersion:(int32_t)version embeddedMessage:(MultipazNdefMessage *)embeddedMessage __attribute__((swift_name("init(version:embeddedMessage:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazHandoverRequestRecordCompanion *companion __attribute__((swift_name("companion")));
- (MultipazHandoverRequestRecord *)doCopyVersion:(int32_t)version embeddedMessage:(MultipazNdefMessage *)embeddedMessage __attribute__((swift_name("doCopy(version:embeddedMessage:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (MultipazNdefRecord *)generateNdefRecord __attribute__((swift_name("generateNdefRecord()")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazNdefMessage *embeddedMessage __attribute__((swift_name("embeddedMessage")));
@property (readonly) int32_t version __attribute__((swift_name("version")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("HandoverRequestRecord.Companion")))
@interface MultipazHandoverRequestRecordCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazHandoverRequestRecordCompanion *shared __attribute__((swift_name("shared")));
- (MultipazHandoverRequestRecord * _Nullable)fromNdefRecordRecord:(MultipazNdefRecord *)record __attribute__((swift_name("fromNdefRecord(record:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("HandoverSelectRecord")))
@interface MultipazHandoverSelectRecord : MultipazBase
- (instancetype)initWithVersion:(int32_t)version embeddedMessage:(MultipazNdefMessage *)embeddedMessage __attribute__((swift_name("init(version:embeddedMessage:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazHandoverSelectRecordCompanion *companion __attribute__((swift_name("companion")));
- (MultipazHandoverSelectRecord *)doCopyVersion:(int32_t)version embeddedMessage:(MultipazNdefMessage *)embeddedMessage __attribute__((swift_name("doCopy(version:embeddedMessage:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (MultipazNdefRecord *)generateNdefRecord __attribute__((swift_name("generateNdefRecord()")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazNdefMessage *embeddedMessage __attribute__((swift_name("embeddedMessage")));
@property (readonly) int32_t version __attribute__((swift_name("version")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("HandoverSelectRecord.Companion")))
@interface MultipazHandoverSelectRecordCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazHandoverSelectRecordCompanion *shared __attribute__((swift_name("shared")));
- (MultipazHandoverSelectRecord * _Nullable)fromNdefRecordRecord:(MultipazNdefRecord *)record __attribute__((swift_name("fromNdefRecord(record:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NdefMessage")))
@interface MultipazNdefMessage : MultipazBase
- (instancetype)initWithRecords:(NSArray<MultipazNdefRecord *> *)records __attribute__((swift_name("init(records:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazNdefMessageCompanion *companion __attribute__((swift_name("companion")));
- (MultipazNdefMessage *)doCopyRecords:(NSArray<MultipazNdefRecord *> *)records __attribute__((swift_name("doCopy(records:)")));
- (MultipazKotlinByteArray *)encode __attribute__((swift_name("encode()")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSArray<MultipazNdefRecord *> *records __attribute__((swift_name("records")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NdefMessage.Companion")))
@interface MultipazNdefMessageCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazNdefMessageCompanion *shared __attribute__((swift_name("shared")));
- (MultipazNdefMessage *)fromEncodedEncoded:(MultipazKotlinByteArray *)encoded __attribute__((swift_name("fromEncoded(encoded:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NdefRecord")))
@interface MultipazNdefRecord : MultipazBase
- (instancetype)initWithTnf:(MultipazNdefRecordTnf *)tnf type:(MultipazKotlinx_io_bytestringByteString *)type id:(MultipazKotlinx_io_bytestringByteString *)id payload:(MultipazKotlinx_io_bytestringByteString *)payload __attribute__((swift_name("init(tnf:type:id:payload:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazNdefRecordCompanion *companion __attribute__((swift_name("companion")));
- (MultipazNdefRecord *)doCopyTnf:(MultipazNdefRecordTnf *)tnf type:(MultipazKotlinx_io_bytestringByteString *)type id:(MultipazKotlinx_io_bytestringByteString *)id payload:(MultipazKotlinx_io_bytestringByteString *)payload __attribute__((swift_name("doCopy(tnf:type:id:payload:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *id __attribute__((swift_name("id")));
@property (readonly) NSString * _Nullable mimeType __attribute__((swift_name("mimeType")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *payload __attribute__((swift_name("payload")));
@property (readonly) MultipazNdefRecordTnf *tnf __attribute__((swift_name("tnf")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *type __attribute__((swift_name("type")));
@property (readonly) NSString * _Nullable uri __attribute__((swift_name("uri")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NdefRecord.Companion")))
@interface MultipazNdefRecordCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazNdefRecordCompanion *shared __attribute__((swift_name("shared")));
- (MultipazNdefRecord *)createMimeMimeType:(NSString *)mimeType mimeData:(MultipazKotlinByteArray *)mimeData __attribute__((swift_name("createMime(mimeType:mimeData:)")));
- (MultipazNdefRecord *)createUriUri:(NSString *)uri __attribute__((swift_name("createUri(uri:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NdefRecord.Tnf")))
@interface MultipazNdefRecordTnf : MultipazKotlinEnum<MultipazNdefRecordTnf *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) MultipazNdefRecordTnf *empty __attribute__((swift_name("empty")));
@property (class, readonly) MultipazNdefRecordTnf *wellKnown __attribute__((swift_name("wellKnown")));
@property (class, readonly) MultipazNdefRecordTnf *mimeMedia __attribute__((swift_name("mimeMedia")));
@property (class, readonly) MultipazNdefRecordTnf *absoluteUri __attribute__((swift_name("absoluteUri")));
@property (class, readonly) MultipazNdefRecordTnf *externalType __attribute__((swift_name("externalType")));
@property (class, readonly) MultipazNdefRecordTnf *unknown __attribute__((swift_name("unknown")));
@property (class, readonly) MultipazNdefRecordTnf *unchanged __attribute__((swift_name("unchanged")));
@property (class, readonly) MultipazNdefRecordTnf *reserved __attribute__((swift_name("reserved")));
+ (MultipazKotlinArray<MultipazNdefRecordTnf *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazNdefRecordTnf *> *entries __attribute__((swift_name("entries")));
@property (readonly) int32_t value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Nfc")))
@interface MultipazNfc : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)nfc __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazNfc *shared __attribute__((swift_name("shared")));
@property (readonly) int32_t CLA_CHAIN_LAST __attribute__((swift_name("CLA_CHAIN_LAST")));
@property (readonly) int32_t CLA_CHAIN_NOT_LAST __attribute__((swift_name("CLA_CHAIN_NOT_LAST")));
@property (readonly) NSString *EXTERNAL_TYPE_ISO_18013_5_NFC __attribute__((swift_name("EXTERNAL_TYPE_ISO_18013_5_NFC")));
@property (readonly) int32_t INS_ENVELOPE __attribute__((swift_name("INS_ENVELOPE")));
@property (readonly) int32_t INS_GET_RESPONSE __attribute__((swift_name("INS_GET_RESPONSE")));
@property (readonly) int32_t INS_READ_BINARY __attribute__((swift_name("INS_READ_BINARY")));
@property (readonly) int32_t INS_SELECT __attribute__((swift_name("INS_SELECT")));
@property (readonly) int32_t INS_SELECT_P1_APPLICATION __attribute__((swift_name("INS_SELECT_P1_APPLICATION")));
@property (readonly) int32_t INS_SELECT_P1_FILE __attribute__((swift_name("INS_SELECT_P1_FILE")));
@property (readonly) int32_t INS_SELECT_P2_APPLICATION __attribute__((swift_name("INS_SELECT_P2_APPLICATION")));
@property (readonly) int32_t INS_SELECT_P2_FILE __attribute__((swift_name("INS_SELECT_P2_FILE")));
@property (readonly) int32_t INS_UPDATE_BINARY __attribute__((swift_name("INS_UPDATE_BINARY")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *ISO_MDOC_NFC_DATA_TRANSFER_APPLICATION_ID __attribute__((swift_name("ISO_MDOC_NFC_DATA_TRANSFER_APPLICATION_ID")));
@property (readonly) NSString *MIME_TYPE_CONNECTION_HANDOVER_BLE __attribute__((swift_name("MIME_TYPE_CONNECTION_HANDOVER_BLE")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *NDEF_APPLICATION_ID __attribute__((swift_name("NDEF_APPLICATION_ID")));
@property (readonly) int32_t NDEF_CAPABILITY_CONTAINER_FILE_ID __attribute__((swift_name("NDEF_CAPABILITY_CONTAINER_FILE_ID")));
@property (readonly) int32_t RESPONSE_STATUS_CHAINING_RESPONSE_BYTES_STILL_AVAILABLE __attribute__((swift_name("RESPONSE_STATUS_CHAINING_RESPONSE_BYTES_STILL_AVAILABLE")));
@property (readonly) int32_t RESPONSE_STATUS_ERROR_FILE_OR_APPLICATION_NOT_FOUND __attribute__((swift_name("RESPONSE_STATUS_ERROR_FILE_OR_APPLICATION_NOT_FOUND")));
@property (readonly) int32_t RESPONSE_STATUS_ERROR_INSTRUCTION_NOT_SUPPORTED_OR_INVALID __attribute__((swift_name("RESPONSE_STATUS_ERROR_INSTRUCTION_NOT_SUPPORTED_OR_INVALID")));
@property (readonly) int32_t RESPONSE_STATUS_ERROR_NO_PRECISE_DIAGNOSIS __attribute__((swift_name("RESPONSE_STATUS_ERROR_NO_PRECISE_DIAGNOSIS")));
@property (readonly) int32_t RESPONSE_STATUS_SUCCESS __attribute__((swift_name("RESPONSE_STATUS_SUCCESS")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *RTD_ALTERNATIVE_CARRIER __attribute__((swift_name("RTD_ALTERNATIVE_CARRIER")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *RTD_HANDOVER_CARRIER __attribute__((swift_name("RTD_HANDOVER_CARRIER")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *RTD_HANDOVER_REQUEST __attribute__((swift_name("RTD_HANDOVER_REQUEST")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *RTD_HANDOVER_SELECT __attribute__((swift_name("RTD_HANDOVER_SELECT")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *RTD_SERVICE_PARAMETER __attribute__((swift_name("RTD_SERVICE_PARAMETER")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *RTD_SERVICE_SELECT __attribute__((swift_name("RTD_SERVICE_SELECT")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *RTD_SMART_POSTER __attribute__((swift_name("RTD_SMART_POSTER")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *RTD_TEXT __attribute__((swift_name("RTD_TEXT")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *RTD_TNEP_STATUS __attribute__((swift_name("RTD_TNEP_STATUS")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *RTD_URI __attribute__((swift_name("RTD_URI")));
@property (readonly) NSString *SERVICE_NAME_CONNECTION_HANDOVER __attribute__((swift_name("SERVICE_NAME_CONNECTION_HANDOVER")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NfcCommandFailedException")))
@interface MultipazNfcCommandFailedException : MultipazKotlinException
- (instancetype)initWithMessage:(NSString *)message status:(int32_t)status __attribute__((swift_name("init(message:status:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (readonly) int32_t status __attribute__((swift_name("status")));
@end

__attribute__((swift_name("NfcIsoTag")))
@interface MultipazNfcIsoTag : MultipazBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (class, readonly, getter=companion) MultipazNfcIsoTagCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)ndefReadMessageWtInt:(int32_t)wtInt nWait:(int32_t)nWait completionHandler:(void (^)(MultipazNdefMessage * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("ndefReadMessage(wtInt:nWait:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)ndefTransactNdefMessage:(MultipazNdefMessage *)ndefMessage wtInt:(int32_t)wtInt nWait:(int32_t)nWait completionHandler:(void (^)(MultipazNdefMessage * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("ndefTransact(ndefMessage:wtInt:nWait:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)readBinaryOffset:(int32_t)offset length:(int32_t)length completionHandler:(void (^)(MultipazKotlinByteArray * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("readBinary(offset:length:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)selectApplicationApplicationId:(MultipazKotlinx_io_bytestringByteString *)applicationId completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("selectApplication(applicationId:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)selectFileFileId:(int32_t)fileId completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("selectFile(fileId:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)transceiveCommand:(MultipazCommandApdu *)command completionHandler:(void (^)(MultipazResponseApdu * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("transceive(command:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)updateBinaryOffset:(int32_t)offset data:(MultipazKotlinByteArray *)data completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("updateBinary(offset:data:completionHandler:)")));
@property (readonly) int32_t maxTransceiveLength __attribute__((swift_name("maxTransceiveLength")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NfcIsoTag.Companion")))
@interface MultipazNfcIsoTagCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazNfcIsoTagCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NfcTagLostException")))
@interface MultipazNfcTagLostException : MultipazKotlinException
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(MultipazKotlinThrowable *)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString *)message cause:(MultipazKotlinThrowable *)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResponseApdu")))
@interface MultipazResponseApdu : MultipazBase
- (instancetype)initWithStatus:(int32_t)status payload:(MultipazKotlinx_io_bytestringByteString *)payload __attribute__((swift_name("init(status:payload:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazResponseApduCompanion *companion __attribute__((swift_name("companion")));
- (MultipazResponseApdu *)doCopyStatus:(int32_t)status payload:(MultipazKotlinx_io_bytestringByteString *)payload __attribute__((swift_name("doCopy(status:payload:)")));
- (MultipazKotlinByteArray *)encode __attribute__((swift_name("encode()")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *payload __attribute__((swift_name("payload")));
@property (readonly) int32_t status __attribute__((swift_name("status")));
@property (readonly) NSString *statusHexString __attribute__((swift_name("statusHexString")));
@property (readonly) int32_t sw1 __attribute__((swift_name("sw1")));
@property (readonly) int32_t sw2 __attribute__((swift_name("sw2")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResponseApdu.Companion")))
@interface MultipazResponseApduCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazResponseApduCompanion *shared __attribute__((swift_name("shared")));
- (MultipazResponseApdu *)decodeEncoded:(MultipazKotlinByteArray *)encoded __attribute__((swift_name("decode(encoded:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ServiceParameterRecord")))
@interface MultipazServiceParameterRecord : MultipazBase
- (instancetype)initWithTnepVersion:(int32_t)tnepVersion serviceNameUri:(NSString *)serviceNameUri tnepCommunicationMode:(int32_t)tnepCommunicationMode wtInt:(int32_t)wtInt nWait:(int32_t)nWait maxNdefSize:(int32_t)maxNdefSize __attribute__((swift_name("init(tnepVersion:serviceNameUri:tnepCommunicationMode:wtInt:nWait:maxNdefSize:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazServiceParameterRecordCompanion *companion __attribute__((swift_name("companion")));
- (MultipazServiceParameterRecord *)doCopyTnepVersion:(int32_t)tnepVersion serviceNameUri:(NSString *)serviceNameUri tnepCommunicationMode:(int32_t)tnepCommunicationMode wtInt:(int32_t)wtInt nWait:(int32_t)nWait maxNdefSize:(int32_t)maxNdefSize __attribute__((swift_name("doCopy(tnepVersion:serviceNameUri:tnepCommunicationMode:wtInt:nWait:maxNdefSize:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (MultipazNdefRecord *)generateNdefRecord __attribute__((swift_name("generateNdefRecord()")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t maxNdefSize __attribute__((swift_name("maxNdefSize")));
@property (readonly) int32_t nWait __attribute__((swift_name("nWait")));
@property (readonly) NSString *serviceNameUri __attribute__((swift_name("serviceNameUri")));
@property (readonly) int32_t tnepCommunicationMode __attribute__((swift_name("tnepCommunicationMode")));
@property (readonly) int32_t tnepVersion __attribute__((swift_name("tnepVersion")));
@property (readonly) int32_t wtInt __attribute__((swift_name("wtInt")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ServiceParameterRecord.Companion")))
@interface MultipazServiceParameterRecordCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazServiceParameterRecordCompanion *shared __attribute__((swift_name("shared")));
- (MultipazServiceParameterRecord * _Nullable)fromNdefRecordRecord:(MultipazNdefRecord *)record __attribute__((swift_name("fromNdefRecord(record:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ServiceSelectRecord")))
@interface MultipazServiceSelectRecord : MultipazBase
- (instancetype)initWithServiceName:(NSString *)serviceName __attribute__((swift_name("init(serviceName:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazServiceSelectRecordCompanion *companion __attribute__((swift_name("companion")));
- (MultipazServiceSelectRecord *)doCopyServiceName:(NSString *)serviceName __attribute__((swift_name("doCopy(serviceName:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (MultipazNdefRecord *)toNdefRecord __attribute__((swift_name("toNdefRecord()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *serviceName __attribute__((swift_name("serviceName")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ServiceSelectRecord.Companion")))
@interface MultipazServiceSelectRecordCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazServiceSelectRecordCompanion *shared __attribute__((swift_name("shared")));
- (MultipazServiceSelectRecord * _Nullable)fromNdefRecordRecord:(MultipazNdefRecord *)record __attribute__((swift_name("fromNdefRecord(record:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TnepStatusRecord")))
@interface MultipazTnepStatusRecord : MultipazBase
- (instancetype)initWithStatus:(int32_t)status __attribute__((swift_name("init(status:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazTnepStatusRecordCompanion *companion __attribute__((swift_name("companion")));
- (MultipazTnepStatusRecord *)doCopyStatus:(int32_t)status __attribute__((swift_name("doCopy(status:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (MultipazNdefRecord *)toNdefRecord __attribute__((swift_name("toNdefRecord()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t status __attribute__((swift_name("status")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TnepStatusRecord.Companion")))
@interface MultipazTnepStatusRecordCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazTnepStatusRecordCompanion *shared __attribute__((swift_name("shared")));
- (MultipazTnepStatusRecord * _Nullable)fromNdefRecordRecord:(MultipazNdefRecord *)record __attribute__((swift_name("fromNdefRecord(record:)")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.3")
*/
__attribute__((swift_name("KotlinCoroutineContext")))
@protocol MultipazKotlinCoroutineContext
@required
- (id _Nullable)foldInitial:(id _Nullable)initial operation:(id _Nullable (^)(id _Nullable, id<MultipazKotlinCoroutineContextElement>))operation __attribute__((swift_name("fold(initial:operation:)")));
- (id<MultipazKotlinCoroutineContextElement> _Nullable)getKey___:(id<MultipazKotlinCoroutineContextKey>)key __attribute__((swift_name("get(key___:)")));
- (id<MultipazKotlinCoroutineContext>)minusKeyKey:(id<MultipazKotlinCoroutineContextKey>)key __attribute__((swift_name("minusKey(key:)")));
- (id<MultipazKotlinCoroutineContext>)plusContext:(id<MultipazKotlinCoroutineContext>)context __attribute__((swift_name("plus(context:)")));
@end

__attribute__((swift_name("KotlinCoroutineContextElement")))
@protocol MultipazKotlinCoroutineContextElement <MultipazKotlinCoroutineContext>
@required
@property (readonly) id<MultipazKotlinCoroutineContextKey> key __attribute__((swift_name("key")));
@end

__attribute__((swift_name("PromptModel")))
@protocol MultipazPromptModel <MultipazKotlinCoroutineContextElement>
@required
@property (readonly) MultipazSinglePromptModel<MultipazPassphraseRequest *, NSString *> *passphrasePromptModel __attribute__((swift_name("passphrasePromptModel")));
@property (readonly) id<MultipazKotlinx_coroutines_coreCoroutineScope> promptModelScope __attribute__((swift_name("promptModelScope")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IosPromptModel")))
@interface MultipazIosPromptModel : MultipazBase <MultipazPromptModel>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (readonly) MultipazSinglePromptModel<MultipazPassphraseRequest *, NSString *> *passphrasePromptModel __attribute__((swift_name("passphrasePromptModel")));
@property (readonly) id<MultipazKotlinx_coroutines_coreCoroutineScope> promptModelScope __attribute__((swift_name("promptModelScope")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PassphraseRequest")))
@interface MultipazPassphraseRequest : MultipazBase
- (instancetype)initWithTitle:(NSString *)title subtitle:(NSString *)subtitle passphraseConstraints:(MultipazPassphraseConstraints *)passphraseConstraints passphraseEvaluator:(id<MultipazKotlinSuspendFunction1> _Nullable)passphraseEvaluator __attribute__((swift_name("init(title:subtitle:passphraseConstraints:passphraseEvaluator:)"))) __attribute__((objc_designated_initializer));
@property (readonly) MultipazPassphraseConstraints *passphraseConstraints __attribute__((swift_name("passphraseConstraints")));
@property (readonly) id<MultipazKotlinSuspendFunction1> _Nullable passphraseEvaluator __attribute__((swift_name("passphraseEvaluator")));
@property (readonly) NSString *subtitle __attribute__((swift_name("subtitle")));
@property (readonly) NSString *title __attribute__((swift_name("title")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PromptDismissedException")))
@interface MultipazPromptDismissedException : MultipazKotlinException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PromptModelCompanion")))
@interface MultipazPromptModelCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazPromptModelCompanion *shared __attribute__((swift_name("shared")));
- (id<MultipazPromptModel>)getCoroutineContext:(id<MultipazKotlinCoroutineContext>)coroutineContext __attribute__((swift_name("get(coroutineContext:)")));
@end

__attribute__((swift_name("KotlinCoroutineContextKey")))
@protocol MultipazKotlinCoroutineContextKey
@required
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PromptModelKey")))
@interface MultipazPromptModelKey : MultipazBase <MultipazKotlinCoroutineContextKey>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)key __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazPromptModelKey *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PromptModelNotAvailableException")))
@interface MultipazPromptModelNotAvailableException : MultipazKotlinException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PromptUiNotAvailableException")))
@interface MultipazPromptUiNotAvailableException : MultipazKotlinException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SinglePromptModel")))
@interface MultipazSinglePromptModel<ParametersT, ResultT> : MultipazBase
- (instancetype)initWithLingerDuration:(int64_t)lingerDuration __attribute__((swift_name("init(lingerDuration:)"))) __attribute__((objc_designated_initializer));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)displayPromptParameters:(ParametersT _Nullable)parameters completionHandler:(void (^)(ResultT _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("displayPrompt(parameters:completionHandler:)")));
@property (readonly) id<MultipazKotlinx_coroutines_coreSharedFlow> dialogState __attribute__((swift_name("dialogState")));
@end

__attribute__((swift_name("SinglePromptModelDialogState")))
@interface MultipazSinglePromptModelDialogState<ParametersT, ResultT> : MultipazBase
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SinglePromptModelDialogShownState")))
@interface MultipazSinglePromptModelDialogShownState<ParametersT, ResultT> : MultipazSinglePromptModelDialogState<ParametersT, ResultT>
- (instancetype)initWithParameters:(ParametersT _Nullable)parameters resultChannel:(id<MultipazKotlinx_coroutines_coreSendChannel>)resultChannel __attribute__((swift_name("init(parameters:resultChannel:)"))) __attribute__((objc_designated_initializer));
@property (readonly) ParametersT _Nullable parameters __attribute__((swift_name("parameters")));
@property (readonly) id<MultipazKotlinx_coroutines_coreSendChannel> resultChannel __attribute__((swift_name("resultChannel")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SinglePromptModelNoDialogState")))
@interface MultipazSinglePromptModelNoDialogState<ParametersT, ResultT> : MultipazSinglePromptModelDialogState<ParametersT, ResultT>
- (instancetype)initWithInitial:(BOOL)initial __attribute__((swift_name("init(initial:)"))) __attribute__((objc_designated_initializer));
@property (readonly) BOOL initial __attribute__((swift_name("initial")));
@end

__attribute__((swift_name("Request")))
@interface MultipazRequest : MultipazBase
@property (readonly) NSArray<MultipazRequestedClaim *> *requestedClaims __attribute__((swift_name("requestedClaims")));
@property (readonly) MultipazRequester *requester __attribute__((swift_name("requester")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocRequest")))
@interface MultipazMdocRequest : MultipazRequest
- (instancetype)initWithRequester:(MultipazRequester *)requester requestedClaims:(NSArray<MultipazMdocRequestedClaim *> *)requestedClaims docType:(NSString *)docType __attribute__((swift_name("init(requester:requestedClaims:docType:)"))) __attribute__((objc_designated_initializer));
- (MultipazMdocRequest *)doCopyRequester:(MultipazRequester *)requester requestedClaims:(NSArray<MultipazMdocRequestedClaim *> *)requestedClaims docType:(NSString *)docType __attribute__((swift_name("doCopy(requester:requestedClaims:docType:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *docType __attribute__((swift_name("docType")));
@property (readonly) NSArray<MultipazMdocRequestedClaim *> *requestedClaims __attribute__((swift_name("requestedClaims")));
@property (readonly) MultipazRequester *requester __attribute__((swift_name("requester")));
@end

__attribute__((swift_name("RequestedClaim")))
@interface MultipazRequestedClaim : MultipazBase
@property (readonly) MultipazDocumentAttribute * _Nullable attribute __attribute__((swift_name("attribute")));
@property (readonly) NSString *displayName __attribute__((swift_name("displayName")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocRequestedClaim")))
@interface MultipazMdocRequestedClaim : MultipazRequestedClaim
- (instancetype)initWithDisplayName:(NSString *)displayName attribute:(MultipazDocumentAttribute * _Nullable)attribute namespaceName:(NSString *)namespaceName dataElementName:(NSString *)dataElementName intentToRetain:(BOOL)intentToRetain __attribute__((swift_name("init(displayName:attribute:namespaceName:dataElementName:intentToRetain:)"))) __attribute__((objc_designated_initializer));
- (MultipazMdocRequestedClaim *)doCopyDisplayName:(NSString *)displayName attribute:(MultipazDocumentAttribute * _Nullable)attribute namespaceName:(NSString *)namespaceName dataElementName:(NSString *)dataElementName intentToRetain:(BOOL)intentToRetain __attribute__((swift_name("doCopy(displayName:attribute:namespaceName:dataElementName:intentToRetain:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazDocumentAttribute * _Nullable attribute __attribute__((swift_name("attribute")));
@property (readonly) NSString *dataElementName __attribute__((swift_name("dataElementName")));
@property (readonly) NSString *displayName __attribute__((swift_name("displayName")));
@property (readonly) BOOL intentToRetain __attribute__((swift_name("intentToRetain")));
@property (readonly) NSString *namespaceName __attribute__((swift_name("namespaceName")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Requester")))
@interface MultipazRequester : MultipazBase
- (instancetype)initWithCertChain:(MultipazX509CertChain * _Nullable)certChain appId:(NSString * _Nullable)appId websiteOrigin:(NSString * _Nullable)websiteOrigin __attribute__((swift_name("init(certChain:appId:websiteOrigin:)"))) __attribute__((objc_designated_initializer));
- (MultipazRequester *)doCopyCertChain:(MultipazX509CertChain * _Nullable)certChain appId:(NSString * _Nullable)appId websiteOrigin:(NSString * _Nullable)websiteOrigin __attribute__((swift_name("doCopy(certChain:appId:websiteOrigin:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString * _Nullable appId __attribute__((swift_name("appId")));
@property (readonly) MultipazX509CertChain * _Nullable certChain __attribute__((swift_name("certChain")));
@property (readonly) NSString * _Nullable websiteOrigin __attribute__((swift_name("websiteOrigin")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VcRequest")))
@interface MultipazVcRequest : MultipazRequest
- (instancetype)initWithRequester:(MultipazRequester *)requester requestedClaims:(NSArray<MultipazVcRequestedClaim *> *)requestedClaims vct:(NSString *)vct __attribute__((swift_name("init(requester:requestedClaims:vct:)"))) __attribute__((objc_designated_initializer));
- (MultipazVcRequest *)doCopyRequester:(MultipazRequester *)requester requestedClaims:(NSArray<MultipazVcRequestedClaim *> *)requestedClaims vct:(NSString *)vct __attribute__((swift_name("doCopy(requester:requestedClaims:vct:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSArray<MultipazVcRequestedClaim *> *requestedClaims __attribute__((swift_name("requestedClaims")));
@property (readonly) MultipazRequester *requester __attribute__((swift_name("requester")));
@property (readonly) NSString *vct __attribute__((swift_name("vct")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VcRequestedClaim")))
@interface MultipazVcRequestedClaim : MultipazRequestedClaim
- (instancetype)initWithDisplayName:(NSString *)displayName attribute:(MultipazDocumentAttribute * _Nullable)attribute claimName:(NSString *)claimName __attribute__((swift_name("init(displayName:attribute:claimName:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazVcRequestedClaimCompanion *companion __attribute__((swift_name("companion")));
- (MultipazVcRequestedClaim *)doCopyDisplayName:(NSString *)displayName attribute:(MultipazDocumentAttribute * _Nullable)attribute claimName:(NSString *)claimName __attribute__((swift_name("doCopy(displayName:attribute:claimName:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazDocumentAttribute * _Nullable attribute __attribute__((swift_name("attribute")));
@property (readonly) NSString *claimName __attribute__((swift_name("claimName")));
@property (readonly) NSString *displayName __attribute__((swift_name("displayName")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VcRequestedClaim.Companion")))
@interface MultipazVcRequestedClaimCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazVcRequestedClaimCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((swift_name("BackendEnvironment")))
@protocol MultipazBackendEnvironment <MultipazKotlinCoroutineContextElement>
@required
- (id _Nullable)getInterfaceClazz:(id<MultipazKotlinKClass>)clazz __attribute__((swift_name("getInterface(clazz:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BackendEnvironmentCompanion")))
@interface MultipazBackendEnvironmentCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazBackendEnvironmentCompanion *shared __attribute__((swift_name("shared")));
- (id<MultipazBackendEnvironment>)getCoroutineContext:(id<MultipazKotlinCoroutineContext>)coroutineContext __attribute__((swift_name("get(coroutineContext:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getInterfaceClazz:(id<MultipazKotlinKClass>)clazz completionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("getInterface(clazz:completionHandler:)")));
@property (readonly) id<MultipazBackendEnvironment> EMPTY __attribute__((swift_name("EMPTY")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BackendEnvironmentKey")))
@interface MultipazBackendEnvironmentKey : MultipazBase <MultipazKotlinCoroutineContextKey>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)key __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazBackendEnvironmentKey *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BackendNotAvailable")))
@interface MultipazBackendNotAvailable : MultipazKotlinException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@end

__attribute__((swift_name("Configuration")))
@protocol MultipazConfiguration
@required
- (NSString * _Nullable)getValueKey:(NSString *)key __attribute__((swift_name("getValue(key:)")));
@end

__attribute__((swift_name("Resources")))
@protocol MultipazResources
@required
- (MultipazKotlinx_io_bytestringByteString * _Nullable)getRawResourceName:(NSString *)name __attribute__((swift_name("getRawResource(name:)")));
- (NSString * _Nullable)getStringResourceName:(NSString *)name __attribute__((swift_name("getStringResource(name:)")));
@end

__attribute__((swift_name("RpcAuthInspector")))
@protocol MultipazRpcAuthInspector
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)authCheckTarget:(NSString *)target method:(NSString *)method payload:(MultipazBstr *)payload authMessage:(MultipazDataItem *)authMessage completionHandler:(void (^)(id<MultipazKotlinCoroutineContext> _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("authCheck(target:method:payload:authMessage:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcAuthBackendDelegate")))
@interface MultipazRpcAuthBackendDelegate : MultipazBase <MultipazRpcAuthInspector>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)rpcAuthBackendDelegate __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazRpcAuthBackendDelegate *shared __attribute__((swift_name("shared")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)authCheckTarget:(NSString *)target method:(NSString *)method payload:(MultipazBstr *)payload authMessage:(MultipazDataItem *)authMessage completionHandler:(void (^)(id<MultipazKotlinCoroutineContext> _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("authCheck(target:method:payload:authMessage:completionHandler:)")));
@end

__attribute__((swift_name("RpcNotifiable")))
@protocol MultipazRpcNotifiable
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)collectCollector:(id<MultipazKotlinx_coroutines_coreFlowCollector>)collector completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("collect(collector:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)disposeWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("dispose(completionHandler:)")));
@end

__attribute__((swift_name("RpcStub")))
@interface MultipazRpcStub : MultipazBase
- (instancetype)initWithRpcEndpoint:(NSString *)rpcEndpoint rpcDispatcher:(id<MultipazRpcDispatcher>)rpcDispatcher rpcNotifier:(id<MultipazRpcNotifier>)rpcNotifier rpcState:(MultipazDataItem *)rpcState __attribute__((swift_name("init(rpcEndpoint:rpcDispatcher:rpcNotifier:rpcState:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazRpcStubCompanion *companion __attribute__((swift_name("companion")));
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@property (readonly) id<MultipazRpcDispatcher> rpcDispatcher __attribute__((swift_name("rpcDispatcher")));
@property (readonly) NSString *rpcEndpoint __attribute__((swift_name("rpcEndpoint")));
@property (readonly) id<MultipazRpcNotifier> rpcNotifier __attribute__((swift_name("rpcNotifier")));
@property MultipazDataItem *rpcState __attribute__((swift_name("rpcState")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcStub.Companion")))
@interface MultipazRpcStubCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazRpcStubCompanion *shared __attribute__((swift_name("shared")));
- (MultipazDataItem *)rpcParameterObj:(id)obj __attribute__((swift_name("rpcParameter(obj:)")));
@end

__attribute__((swift_name("SimpleCipher")))
@protocol MultipazSimpleCipher
@required
- (MultipazKotlinByteArray *)decryptCiphertext:(MultipazKotlinByteArray *)ciphertext __attribute__((swift_name("decrypt(ciphertext:)")));
- (MultipazKotlinByteArray *)encryptPlaintext:(MultipazKotlinByteArray *)plaintext __attribute__((swift_name("encrypt(plaintext:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AesGcmCipher")))
@interface MultipazAesGcmCipher : MultipazBase <MultipazSimpleCipher>
- (instancetype)initWithKey:(MultipazKotlinByteArray *)key __attribute__((swift_name("init(key:)"))) __attribute__((objc_designated_initializer));
- (MultipazKotlinByteArray *)decryptCiphertext:(MultipazKotlinByteArray *)ciphertext __attribute__((swift_name("decrypt(ciphertext:)")));
- (MultipazKotlinByteArray *)encryptPlaintext:(MultipazKotlinByteArray *)plaintext __attribute__((swift_name("encrypt(plaintext:)")));
@property (readonly) MultipazKotlinByteArray *key __attribute__((swift_name("key")));
@end

__attribute__((swift_name("HttpTransport")))
@protocol MultipazHttpTransport
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)postUrl:(NSString *)url data:(MultipazKotlinx_io_bytestringByteString *)data completionHandler:(void (^)(MultipazKotlinx_io_bytestringByteString * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("post(url:data:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("HttpHandler")))
@interface MultipazHttpHandler : MultipazBase <MultipazHttpTransport>
- (instancetype)initWithDispatcher:(id<MultipazRpcDispatcher>)dispatcher rpcPoll:(id<MultipazRpcPoll>)rpcPoll __attribute__((swift_name("init(dispatcher:rpcPoll:)"))) __attribute__((objc_designated_initializer));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)postUrl:(NSString *)url data:(MultipazKotlinx_io_bytestringByteString *)data completionHandler:(void (^)(MultipazKotlinx_io_bytestringByteString * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("post(url:data:completionHandler:)")));
@end

__attribute__((swift_name("KotlinRuntimeException")))
@interface MultipazKotlinRuntimeException : MultipazKotlinException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("InvalidRequestException")))
@interface MultipazInvalidRequestException : MultipazKotlinRuntimeException
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazInvalidRequestExceptionCompanion *companion __attribute__((swift_name("companion")));
@property (readonly) NSString * _Nullable message __attribute__((swift_name("message")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("InvalidRequestException.Companion")))
@interface MultipazInvalidRequestExceptionCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazInvalidRequestExceptionCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NoopCipher")))
@interface MultipazNoopCipher : MultipazBase <MultipazSimpleCipher>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)noopCipher __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazNoopCipher *shared __attribute__((swift_name("shared")));
- (MultipazKotlinByteArray *)decryptCiphertext:(MultipazKotlinByteArray *)ciphertext __attribute__((swift_name("decrypt(ciphertext:)")));
- (MultipazKotlinByteArray *)encryptPlaintext:(MultipazKotlinByteArray *)plaintext __attribute__((swift_name("encrypt(plaintext:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcAuthClientSession")))
@interface MultipazRpcAuthClientSession : MultipazBase <MultipazKotlinCoroutineContextElement>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (class, readonly, getter=companion) MultipazRpcAuthClientSessionCompanion *companion __attribute__((swift_name("companion")));
@property (readonly) id<MultipazKotlinCoroutineContextKey> key __attribute__((swift_name("key")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *nonce __attribute__((swift_name("nonce")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcAuthClientSession.Companion")))
@interface MultipazRpcAuthClientSessionCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazRpcAuthClientSessionCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *EMPTY_NONCE __attribute__((swift_name("EMPTY_NONCE")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcAuthClientSession.Key")))
@interface MultipazRpcAuthClientSessionKey : MultipazBase <MultipazKotlinCoroutineContextKey>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)key __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazRpcAuthClientSessionKey *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcAuthContext")))
@interface MultipazRpcAuthContext : MultipazBase <MultipazKotlinCoroutineContextElement>
- (instancetype)initWithClientId:(NSString *)clientId sessionId:(NSString *)sessionId nextNonce:(MultipazKotlinx_io_bytestringByteString * _Nullable)nextNonce __attribute__((swift_name("init(clientId:sessionId:nextNonce:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazRpcAuthContextCompanion *companion __attribute__((swift_name("companion")));
@property (readonly) id<MultipazKotlinCoroutineContextKey> key __attribute__((swift_name("key")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcAuthContext.Companion")))
@interface MultipazRpcAuthContextCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazRpcAuthContextCompanion *shared __attribute__((swift_name("shared")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getClientIdWithCompletionHandler:(void (^)(NSString * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getClientId(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getSessionIdWithCompletionHandler:(void (^)(NSString * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getSessionId(completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcAuthContext.Key")))
@interface MultipazRpcAuthContextKey : MultipazBase <MultipazKotlinCoroutineContextKey>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)key __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazRpcAuthContextKey *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcAuthError")))
@interface MultipazRpcAuthError : MultipazKotlinEnum<MultipazRpcAuthError *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) MultipazRpcAuthError *required __attribute__((swift_name("required")));
@property (class, readonly) MultipazRpcAuthError *notSupported __attribute__((swift_name("notSupported")));
@property (class, readonly) MultipazRpcAuthError *unknownClientId __attribute__((swift_name("unknownClientId")));
@property (class, readonly) MultipazRpcAuthError *requestUrlMismatch __attribute__((swift_name("requestUrlMismatch")));
@property (class, readonly) MultipazRpcAuthError *stale __attribute__((swift_name("stale")));
@property (class, readonly) MultipazRpcAuthError *replay __attribute__((swift_name("replay")));
@property (class, readonly) MultipazRpcAuthError *failed __attribute__((swift_name("failed")));
@property (class, readonly) MultipazRpcAuthError *config __attribute__((swift_name("config")));
+ (MultipazKotlinArray<MultipazRpcAuthError *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazRpcAuthError *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcAuthException")))
@interface MultipazRpcAuthException : MultipazKotlinRuntimeException
- (instancetype)initWithMessage:(NSString * _Nullable)message rpcAuthError:(MultipazRpcAuthError *)rpcAuthError __attribute__((swift_name("init(message:rpcAuthError:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazRpcAuthExceptionCompanion *companion __attribute__((swift_name("companion")));
@property (readonly) NSString * _Nullable message __attribute__((swift_name("message")));
@property (readonly) MultipazRpcAuthError *rpcAuthError __attribute__((swift_name("rpcAuthError")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcAuthException.Companion")))
@interface MultipazRpcAuthExceptionCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazRpcAuthExceptionCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcAuthInspectorAssertion")))
@interface MultipazRpcAuthInspectorAssertion : MultipazBase <MultipazRpcAuthInspector>
- (instancetype)initWithTimeout:(int64_t)timeout nonceChecker:(id<MultipazKotlinSuspendFunction3>)nonceChecker clientLookup:(id<MultipazKotlinSuspendFunction1>)clientLookup __attribute__((swift_name("init(timeout:nonceChecker:clientLookup:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazRpcAuthInspectorAssertionCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)authCheckTarget:(NSString *)target method:(NSString *)method payload:(MultipazBstr *)payload authMessage:(MultipazDataItem *)authMessage completionHandler:(void (^)(MultipazRpcAuthContext * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("authCheck(target:method:payload:authMessage:completionHandler:)")));
@property (readonly) id<MultipazKotlinSuspendFunction1> clientLookup __attribute__((swift_name("clientLookup")));
@property (readonly) id<MultipazKotlinSuspendFunction3> nonceChecker __attribute__((swift_name("nonceChecker")));
@property (readonly) int64_t timeout __attribute__((swift_name("timeout")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcAuthInspectorAssertion.Companion")))
@interface MultipazRpcAuthInspectorAssertionCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazRpcAuthInspectorAssertionCompanion *shared __attribute__((swift_name("shared")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getClientDeviceAttestationClientId:(NSString *)clientId completionHandler:(void (^)(MultipazDeviceAttestation * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("getClientDeviceAttestation(clientId:completionHandler:)")));
@property (readonly) MultipazRpcAuthInspectorAssertion *Default __attribute__((swift_name("Default")));
@property (readonly) NSString *TAG __attribute__((swift_name("TAG")));
@property (readonly) MultipazStorageTableSpec *rpcClientTableSpec __attribute__((swift_name("rpcClientTableSpec")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcAuthInspectorAssertion.NonceAndSession")))
@interface MultipazRpcAuthInspectorAssertionNonceAndSession : MultipazBase
- (instancetype)initWithNextNonce:(MultipazKotlinx_io_bytestringByteString *)nextNonce sessionId:(NSString *)sessionId __attribute__((swift_name("init(nextNonce:sessionId:)"))) __attribute__((objc_designated_initializer));
- (MultipazRpcAuthInspectorAssertionNonceAndSession *)doCopyNextNonce:(MultipazKotlinx_io_bytestringByteString *)nextNonce sessionId:(NSString *)sessionId __attribute__((swift_name("doCopy(nextNonce:sessionId:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *nextNonce __attribute__((swift_name("nextNonce")));
@property (readonly) NSString *sessionId __attribute__((swift_name("sessionId")));
@end

__attribute__((swift_name("RpcAuthIssuer")))
@protocol MultipazRpcAuthIssuer
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)authTarget:(NSString *)target method:(NSString *)method payload:(MultipazBstr *)payload completionHandler:(void (^)(MultipazDataItem * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("auth(target:method:payload:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcAuthIssuerAssertion")))
@interface MultipazRpcAuthIssuerAssertion : MultipazBase <MultipazRpcAuthIssuer>
- (instancetype)initWithClientId:(NSString *)clientId secureArea:(id<MultipazSecureArea>)secureArea deviceAttestationId:(NSString *)deviceAttestationId __attribute__((swift_name("init(clientId:secureArea:deviceAttestationId:)"))) __attribute__((objc_designated_initializer));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)authTarget:(NSString *)target method:(NSString *)method payload:(MultipazBstr *)payload completionHandler:(void (^)(MultipazDataItem * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("auth(target:method:payload:completionHandler:)")));
@property (readonly) id<MultipazKotlinx_coroutines_coreMutex> lock __attribute__((swift_name("lock")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcAuthNonceException")))
@interface MultipazRpcAuthNonceException : MultipazKotlinRuntimeException
- (instancetype)initWithNonce:(MultipazKotlinx_io_bytestringByteString *)nonce __attribute__((swift_name("init(nonce:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (readonly) MultipazKotlinx_io_bytestringByteString *nonce __attribute__((swift_name("nonce")));
@end

__attribute__((swift_name("RpcDispatcher")))
@protocol MultipazRpcDispatcher
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)dispatchTarget:(NSString *)target method:(NSString *)method args:(MultipazDataItem *)args completionHandler:(void (^)(NSArray<MultipazDataItem *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("dispatch(target:method:args:completionHandler:)")));
@property (readonly) MultipazRpcExceptionMap *exceptionMap __attribute__((swift_name("exceptionMap")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcDispatcherAuth")))
@interface MultipazRpcDispatcherAuth : MultipazBase <MultipazRpcDispatcher>
- (instancetype)initWithBase:(id<MultipazRpcDispatcher>)base rpcAuthIssuer:(id<MultipazRpcAuthIssuer>)rpcAuthIssuer __attribute__((swift_name("init(base:rpcAuthIssuer:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazRpcDispatcherAuthCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)dispatchTarget:(NSString *)target method:(NSString *)method args:(MultipazDataItem *)args completionHandler:(void (^)(NSArray<MultipazDataItem *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("dispatch(target:method:args:completionHandler:)")));
@property (readonly) id<MultipazRpcDispatcher> base __attribute__((swift_name("base")));
@property (readonly) MultipazRpcExceptionMap *exceptionMap __attribute__((swift_name("exceptionMap")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcDispatcherAuth.Companion")))
@interface MultipazRpcDispatcherAuthCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazRpcDispatcherAuthCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) NSString *TAG __attribute__((swift_name("TAG")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcDispatcherHttp")))
@interface MultipazRpcDispatcherHttp : MultipazBase <MultipazRpcDispatcher>
- (instancetype)initWithTransport:(id<MultipazHttpTransport>)transport exceptionMap:(MultipazRpcExceptionMap *)exceptionMap __attribute__((swift_name("init(transport:exceptionMap:)"))) __attribute__((objc_designated_initializer));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)dispatchTarget:(NSString *)target method:(NSString *)method args:(MultipazDataItem *)args completionHandler:(void (^)(NSArray<MultipazDataItem *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("dispatch(target:method:args:completionHandler:)")));
@property (readonly) MultipazRpcExceptionMap *exceptionMap __attribute__((swift_name("exceptionMap")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcDispatcherLocal")))
@interface MultipazRpcDispatcherLocal : MultipazBase <MultipazRpcDispatcher>
- (id)decodeStateParameterStateParameter:(MultipazDataItem *)stateParameter __attribute__((swift_name("decodeStateParameter(stateParameter:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)dispatchTarget:(NSString *)target method:(NSString *)method args:(MultipazDataItem *)args completionHandler:(void (^)(NSArray<MultipazDataItem *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("dispatch(target:method:args:completionHandler:)")));
- (MultipazDataItem *)encodeStateResultResult:(id)result __attribute__((swift_name("encodeStateResult(result:)")));
@property (readonly) id<MultipazBackendEnvironment> environment __attribute__((swift_name("environment")));
@property (readonly) MultipazRpcExceptionMap *exceptionMap __attribute__((swift_name("exceptionMap")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcDispatcherLocal.Builder")))
@interface MultipazRpcDispatcherLocalBuilder : MultipazBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (void)addEndpointTarget:(NSString *)target stateClass:(id<MultipazKotlinKClass>)stateClass stateSerializer:(MultipazDataItem *(^)(id))stateSerializer stateDeserializer:(id (^)(MultipazDataItem *))stateDeserializer block:(void (^)(MultipazRpcDispatcherLocalTargetBuilder<id> *))block __attribute__((swift_name("addEndpoint(target:stateClass:stateSerializer:stateDeserializer:block:)")));
- (MultipazRpcDispatcherLocal *)buildEnvironment:(id<MultipazBackendEnvironment>)environment cipher:(id<MultipazSimpleCipher>)cipher exceptionMap:(MultipazRpcExceptionMap *)exceptionMap __attribute__((swift_name("build(environment:cipher:exceptionMap:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcDispatcherLocalTargetBuilder")))
@interface MultipazRpcDispatcherLocalTargetBuilder<StateT> : MultipazBase
- (instancetype)initWithStateClass:(id<MultipazKotlinKClass>)stateClass stateSerializer:(MultipazDataItem *(^)(StateT))stateSerializer stateDeserializer:(StateT (^)(MultipazDataItem *))stateDeserializer __attribute__((swift_name("init(stateClass:stateSerializer:stateDeserializer:)"))) __attribute__((objc_designated_initializer));
- (void)creatable __attribute__((swift_name("creatable()")));
- (void)dispatchMethod:(NSString *)method impl:(id<MultipazKotlinSuspendFunction3>)impl __attribute__((swift_name("dispatch(method:impl:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcExceptionMap")))
@interface MultipazRpcExceptionMap : MultipazBase
- (NSArray<MultipazDataItem *> *)exceptionReturnState:(MultipazDataItem *)state exception:(MultipazKotlinThrowable *)exception nonce:(MultipazKotlinx_io_bytestringByteString * _Nullable)nonce __attribute__((swift_name("exceptionReturn(state:exception:nonce:)")));
- (void)handleExceptionReturnReturnList:(NSArray<MultipazDataItem *> *)returnList __attribute__((swift_name("handleExceptionReturn(returnList:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcExceptionMap.Builder")))
@interface MultipazRpcExceptionMapBuilder : MultipazBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (void)addExceptionExceptionId:(NSString *)exceptionId serializer:(MultipazDataItem *(^)(MultipazKotlinThrowable *))serializer deserializer:(MultipazKotlinThrowable *(^)(MultipazDataItem *))deserializer exceptionClasses:(NSArray<id<MultipazKotlinKClass>> *)exceptionClasses __attribute__((swift_name("addException(exceptionId:serializer:deserializer:exceptionClasses:)")));
- (MultipazRpcExceptionMap *)build __attribute__((swift_name("build()")));
@end

__attribute__((swift_name("RpcNotifications")))
@protocol MultipazRpcNotifications
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)emitTarget:(NSString *)target state:(MultipazDataItem *)state notification:(MultipazDataItem *)notification completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("emit(target:state:notification:completionHandler:)")));
@end

__attribute__((swift_name("RpcNotifier")))
@protocol MultipazRpcNotifier
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)registerTarget:(NSString *)target opaqueState:(MultipazDataItem *)opaqueState notifications:(id<MultipazKotlinx_coroutines_coreMutableSharedFlow>)notifications deserializer:(id (^)(MultipazDataItem *))deserializer completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("register(target:opaqueState:notifications:deserializer:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)unregisterTarget:(NSString *)target opaqueState:(MultipazDataItem *)opaqueState completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("unregister(target:opaqueState:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcNotificationsLocal")))
@interface MultipazRpcNotificationsLocal : MultipazBase <MultipazRpcNotifications, MultipazRpcNotifier>
- (instancetype)initWithCipher:(id<MultipazSimpleCipher>)cipher __attribute__((swift_name("init(cipher:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazRpcNotificationsLocalCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)emitTarget:(NSString *)target state:(MultipazDataItem *)state notification:(MultipazDataItem *)notification completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("emit(target:state:notification:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)registerTarget:(NSString *)target opaqueState:(MultipazDataItem *)opaqueState notifications:(id<MultipazKotlinx_coroutines_coreMutableSharedFlow>)notifications deserializer:(id (^)(MultipazDataItem *))deserializer completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("register(target:opaqueState:notifications:deserializer:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)unregisterTarget:(NSString *)target opaqueState:(MultipazDataItem *)opaqueState completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("unregister(target:opaqueState:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcNotificationsLocal.Companion")))
@interface MultipazRpcNotificationsLocalCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazRpcNotificationsLocalCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) NSString *TAG __attribute__((swift_name("TAG")));
@end

__attribute__((swift_name("RpcPoll")))
@protocol MultipazRpcPoll
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)pollConsumeToken:(NSString *)consumeToken pollKeys:(NSArray<MultipazRpcPollPollKey *> *)pollKeys completionHandler:(void (^)(MultipazRpcPollPollResult * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("poll(consumeToken:pollKeys:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcNotificationsLocalPoll")))
@interface MultipazRpcNotificationsLocalPoll : MultipazBase <MultipazRpcNotifications, MultipazRpcPoll>
- (instancetype)initWithCipher:(id<MultipazSimpleCipher>)cipher __attribute__((swift_name("init(cipher:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazRpcNotificationsLocalPollCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)emitTarget:(NSString *)target state:(MultipazDataItem *)state notification:(MultipazDataItem *)notification completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("emit(target:state:notification:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)pollConsumeToken:(NSString *)consumeToken pollKeys:(NSArray<MultipazRpcPollPollKey *> *)pollKeys completionHandler:(void (^)(MultipazRpcPollPollResult * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("poll(consumeToken:pollKeys:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcNotificationsLocalPoll.Companion")))
@interface MultipazRpcNotificationsLocalPollCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazRpcNotificationsLocalPollCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcNotifierCompanion")))
@interface MultipazRpcNotifierCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazRpcNotifierCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) id<MultipazRpcNotifier> SILENT __attribute__((swift_name("SILENT")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcNotifierPoll")))
@interface MultipazRpcNotifierPoll : MultipazBase <MultipazRpcNotifier>
- (instancetype)initWithPoll:(id<MultipazRpcPoll>)poll __attribute__((swift_name("init(poll:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazRpcNotifierPollCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)loopWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("loop(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)registerTarget:(NSString *)target opaqueState:(MultipazDataItem *)opaqueState notifications:(id<MultipazKotlinx_coroutines_coreMutableSharedFlow>)notifications deserializer:(id (^)(MultipazDataItem *))deserializer completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("register(target:opaqueState:notifications:deserializer:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)unregisterTarget:(NSString *)target opaqueState:(MultipazDataItem *)opaqueState completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("unregister(target:opaqueState:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcNotifierPoll.Companion")))
@interface MultipazRpcNotifierPollCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazRpcNotifierPollCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) NSString *TAG __attribute__((swift_name("TAG")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcPollCompanion")))
@interface MultipazRpcPollCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazRpcPollCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) id<MultipazRpcPoll> SILENT __attribute__((swift_name("SILENT")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcPollPollKey")))
@interface MultipazRpcPollPollKey : MultipazBase
- (instancetype)initWithTarget:(NSString *)target opaqueState:(MultipazDataItem *)opaqueState __attribute__((swift_name("init(target:opaqueState:)"))) __attribute__((objc_designated_initializer));
- (MultipazRpcPollPollKey *)doCopyTarget:(NSString *)target opaqueState:(MultipazDataItem *)opaqueState __attribute__((swift_name("doCopy(target:opaqueState:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazDataItem *opaqueState __attribute__((swift_name("opaqueState")));
@property (readonly) NSString *target __attribute__((swift_name("target")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcPollPollResult")))
@interface MultipazRpcPollPollResult : MultipazBase
- (instancetype)initWithConsumeToken:(NSString *)consumeToken index:(int32_t)index notification:(MultipazDataItem *)notification __attribute__((swift_name("init(consumeToken:index:notification:)"))) __attribute__((objc_designated_initializer));
- (MultipazRpcPollPollResult *)doCopyConsumeToken:(NSString *)consumeToken index:(int32_t)index notification:(MultipazDataItem *)notification __attribute__((swift_name("doCopy(consumeToken:index:notification:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *consumeToken __attribute__((swift_name("consumeToken")));
@property (readonly) int32_t index __attribute__((swift_name("index")));
@property (readonly) MultipazDataItem *notification __attribute__((swift_name("notification")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcPollTimeoutException")))
@interface MultipazRpcPollTimeoutException : MultipazKotlinException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcPollHttp")))
@interface MultipazRpcPollHttp : MultipazBase <MultipazRpcPoll>
- (instancetype)initWithTransport:(id<MultipazHttpTransport>)transport __attribute__((swift_name("init(transport:)"))) __attribute__((objc_designated_initializer));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)pollConsumeToken:(NSString *)consumeToken pollKeys:(NSArray<MultipazRpcPollPollKey *> *)pollKeys completionHandler:(void (^)(MultipazRpcPollPollResult * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("poll(consumeToken:pollKeys:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcReturnCode")))
@interface MultipazRpcReturnCode : MultipazKotlinEnum<MultipazRpcReturnCode *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) MultipazRpcReturnCode *result __attribute__((swift_name("result")));
@property (class, readonly) MultipazRpcReturnCode *exception __attribute__((swift_name("exception")));
@property (class, readonly) MultipazRpcReturnCode *nonceRetry __attribute__((swift_name("nonceRetry")));
+ (MultipazKotlinArray<MultipazRpcReturnCode *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazRpcReturnCode *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((swift_name("KotlinIllegalArgumentException")))
@interface MultipazKotlinIllegalArgumentException : MultipazKotlinRuntimeException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SimpleCipherDataTamperedException")))
@interface MultipazSimpleCipherDataTamperedException : MultipazKotlinIllegalArgumentException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@end

__attribute__((swift_name("TestInterface")))
@protocol MultipazTestInterface
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)testParam:(NSString *)param completionHandler:(void (^)(NSString * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("test(param:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TestInterfaceStub")))
@interface MultipazTestInterfaceStub : MultipazRpcStub <MultipazTestInterface>
- (instancetype)initWithEndpoint:(NSString *)endpoint dispatcher:(id<MultipazRpcDispatcher>)dispatcher notifier:(id<MultipazRpcNotifier>)notifier state:(MultipazDataItem *)state __attribute__((swift_name("init(endpoint:dispatcher:notifier:state:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithRpcEndpoint:(NSString *)rpcEndpoint rpcDispatcher:(id<MultipazRpcDispatcher>)rpcDispatcher rpcNotifier:(id<MultipazRpcNotifier>)rpcNotifier rpcState:(MultipazDataItem *)rpcState __attribute__((swift_name("init(rpcEndpoint:rpcDispatcher:rpcNotifier:rpcState:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazTestInterfaceStubCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)testParam:(NSString *)param completionHandler:(void (^)(NSString * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("test(param:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TestInterfaceStub.Companion")))
@interface MultipazTestInterfaceStubCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazTestInterfaceStubCompanion *shared __attribute__((swift_name("shared")));
- (MultipazTestInterfaceStub *)fromCborData:(MultipazKotlinByteArray *)data dispatcher:(id<MultipazRpcDispatcher>)dispatcher notifier:(id<MultipazRpcNotifier>)notifier __attribute__((swift_name("fromCbor(data:dispatcher:notifier:)")));
- (MultipazTestInterfaceStub *)fromDataItemData:(MultipazDataItem *)data dispatcher:(id<MultipazRpcDispatcher>)dispatcher notifier:(id<MultipazRpcNotifier>)notifier __attribute__((swift_name("fromDataItem(data:dispatcher:notifier:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TestState")))
@interface MultipazTestState : MultipazBase <MultipazTestInterface, MultipazRpcAuthInspector>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (class, readonly, getter=companion) MultipazTestStateCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)authCheckTarget:(NSString *)target method:(NSString *)method payload:(MultipazBstr *)payload authMessage:(MultipazDataItem *)authMessage completionHandler:(void (^)(id<MultipazKotlinCoroutineContext> _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("authCheck(target:method:payload:authMessage:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)testParam:(NSString *)param completionHandler:(void (^)(NSString * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("test(param:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TestState.Companion")))
@interface MultipazTestStateCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazTestStateCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("HttpTransportCompanion")))
@interface MultipazHttpTransportCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazHttpTransportCompanion *shared __attribute__((swift_name("shared")));
- (void)processStatusUrl:(NSString *)url status:(int32_t)status statusText:(NSString *)statusText __attribute__((swift_name("processStatus(url:status:statusText:)")));
@end

__attribute__((swift_name("HttpTransportHttpClientException")))
@interface MultipazHttpTransportHttpClientException : MultipazKotlinException
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString *)message cause:(MultipazKotlinThrowable *)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@end

__attribute__((swift_name("HttpTransportConnectionException")))
@interface MultipazHttpTransportConnectionException : MultipazHttpTransportHttpClientException
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString *)message cause:(MultipazKotlinThrowable *)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("HttpTransportConnectionRefusedException")))
@interface MultipazHttpTransportConnectionRefusedException : MultipazHttpTransportConnectionException
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString *)message cause:(MultipazKotlinThrowable *)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("HttpTransportRemoteException")))
@interface MultipazHttpTransportRemoteException : MultipazHttpTransportHttpClientException
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString *)message cause:(MultipazKotlinThrowable *)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("HttpTransportTimeoutException")))
@interface MultipazHttpTransportTimeoutException : MultipazHttpTransportConnectionException
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString *)message cause:(MultipazKotlinThrowable *)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SdJwt")))
@interface MultipazSdJwt : MultipazBase
- (instancetype)initWithCompactSerialization:(NSString *)compactSerialization __attribute__((swift_name("init(compactSerialization:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazSdJwtCompanion *companion __attribute__((swift_name("companion")));
- (MultipazSdJwt *)filterIncludeDisclosure:(MultipazBoolean *(^)(NSArray<MultipazKotlinx_serialization_jsonJsonElement *> *, MultipazKotlinx_serialization_jsonJsonElement *))includeDisclosure __attribute__((swift_name("filter(includeDisclosure:)")));
- (MultipazSdJwt *)filterPathsToInclude:(NSArray<NSArray<MultipazKotlinx_serialization_jsonJsonElement *> *> *)pathsToInclude __attribute__((swift_name("filter(pathsToInclude:)")));
- (MultipazSdJwtKb *)presentKbKey:(MultipazEcPrivateKey *)kbKey kbAlgorithm:(MultipazAlgorithm *)kbAlgorithm nonce:(NSString *)nonce audience:(NSString *)audience creationTime:(MultipazKotlinx_datetimeInstant *)creationTime __attribute__((swift_name("present(kbKey:kbAlgorithm:nonce:audience:creationTime:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)presentKbSecureArea:(id<MultipazSecureArea>)kbSecureArea kbAlias:(NSString *)kbAlias kbKeyUnlockData:(id<MultipazKeyUnlockData> _Nullable)kbKeyUnlockData nonce:(NSString *)nonce audience:(NSString *)audience creationTime:(MultipazKotlinx_datetimeInstant *)creationTime completionHandler:(void (^)(MultipazSdJwtKb * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("present(kbSecureArea:kbAlias:kbKeyUnlockData:nonce:audience:creationTime:completionHandler:)")));
- (NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> *)verifyIssuerKey:(MultipazEcPublicKey *)issuerKey __attribute__((swift_name("verify(issuerKey:)")));
@property (readonly) NSString *compactSerialization __attribute__((swift_name("compactSerialization")));
@property (readonly) NSString * _Nullable credentialType __attribute__((swift_name("credentialType")));
@property MultipazAlgorithm *digestAlg __attribute__((swift_name("digestAlg")));
@property (readonly) NSArray<NSString *> *disclosures __attribute__((swift_name("disclosures")));
@property (readonly) MultipazKotlinx_datetimeInstant * _Nullable issuedAt __attribute__((swift_name("issuedAt")));
@property (readonly) NSString *issuer __attribute__((swift_name("issuer")));
@property NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> *jwtBody __attribute__((swift_name("jwtBody")));
@property (readonly) NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> *jwtHeader __attribute__((swift_name("jwtHeader")));
@property (readonly) MultipazEcPublicKey * _Nullable kbKey __attribute__((swift_name("kbKey")));
@property (readonly) NSString * _Nullable subject __attribute__((swift_name("subject")));
@property (readonly) MultipazKotlinx_datetimeInstant * _Nullable validFrom __attribute__((swift_name("validFrom")));
@property (readonly) MultipazKotlinx_datetimeInstant * _Nullable validUntil __attribute__((swift_name("validUntil")));
@property (readonly) MultipazX509CertChain * _Nullable x5c __attribute__((swift_name("x5c")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SdJwt.Companion")))
@interface MultipazSdJwtCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazSdJwtCompanion *shared __attribute__((swift_name("shared")));
- (MultipazSdJwt *)createIssuerKey:(MultipazEcPrivateKey *)issuerKey issuerAlgorithm:(MultipazAlgorithm *)issuerAlgorithm issuerCertChain:(MultipazX509CertChain * _Nullable)issuerCertChain kbKey:(MultipazEcPublicKey * _Nullable)kbKey claims:(NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> *)claims nonSdClaims:(NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> *)nonSdClaims digestAlgorithm:(MultipazAlgorithm *)digestAlgorithm random:(MultipazKotlinRandom *)random saltSizeNumBits:(int32_t)saltSizeNumBits __attribute__((swift_name("create(issuerKey:issuerAlgorithm:issuerCertChain:kbKey:claims:nonSdClaims:digestAlgorithm:random:saltSizeNumBits:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SdJwtKb")))
@interface MultipazSdJwtKb : MultipazBase
- (instancetype)initWithCompactSerialization:(NSString *)compactSerialization __attribute__((swift_name("init(compactSerialization:)"))) __attribute__((objc_designated_initializer));
- (NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> *)verifyIssuerKey:(MultipazEcPublicKey *)issuerKey checkNonce:(MultipazBoolean *(^)(NSString *))checkNonce checkAudience:(MultipazBoolean *(^)(NSString *))checkAudience checkCreationTime:(MultipazBoolean *(^)(MultipazKotlinx_datetimeInstant *))checkCreationTime __attribute__((swift_name("verify(issuerKey:checkNonce:checkAudience:checkCreationTime:)")));
@property (readonly) NSString *compactSerialization __attribute__((swift_name("compactSerialization")));
@property MultipazSdJwt *sdJwt __attribute__((swift_name("sdJwt")));
@end

__attribute__((swift_name("SdJwtVcCredential")))
@protocol MultipazSdJwtVcCredential
@required
- (NSArray<MultipazVcClaim *> *)getClaimsImplDocumentTypeRepository:(MultipazDocumentTypeRepository * _Nullable)documentTypeRepository __attribute__((swift_name("getClaimsImpl(documentTypeRepository:)")));
@property (readonly) MultipazKotlinByteArray *issuerProvidedData __attribute__((swift_name("issuerProvidedData")));
@property (readonly) NSString *vct __attribute__((swift_name("vct")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KeyBoundSdJwtVcCredential")))
@interface MultipazKeyBoundSdJwtVcCredential : MultipazSecureAreaBoundCredential <MultipazSdJwtVcCredential>
- (instancetype)initWithDocument:(MultipazDocument *)document __attribute__((swift_name("init(document:)"))) __attribute__((objc_designated_initializer));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (instancetype)initWithDocument:(MultipazDocument *)document asReplacementForIdentifier:(NSString * _Nullable)asReplacementForIdentifier domain:(NSString *)domain secureArea:(id<MultipazSecureArea>)secureArea __attribute__((swift_name("init(document:asReplacementForIdentifier:domain:secureArea:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazKeyBoundSdJwtVcCredentialCompanion *companion __attribute__((swift_name("companion")));
- (void)addSerializedDataBuilder:(MultipazMapBuilder<MultipazCborBuilder *> *)builder __attribute__((swift_name("addSerializedData(builder:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)deserializeDataItem:(MultipazDataItem *)dataItem completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("deserialize(dataItem:completionHandler:)")));
- (NSArray<MultipazVcClaim *> *)getClaimsDocumentTypeRepository:(MultipazDocumentTypeRepository * _Nullable)documentTypeRepository __attribute__((swift_name("getClaims(documentTypeRepository:)")));
@property (readonly) NSString *credentialType __attribute__((swift_name("credentialType")));
@property (readonly) NSString *vct __attribute__((swift_name("vct")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KeyBoundSdJwtVcCredential.Companion")))
@interface MultipazKeyBoundSdJwtVcCredentialCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKeyBoundSdJwtVcCredentialCompanion *shared __attribute__((swift_name("shared")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)createDocument:(MultipazDocument *)document asReplacementForIdentifier:(NSString * _Nullable)asReplacementForIdentifier domain:(NSString *)domain secureArea:(id<MultipazSecureArea>)secureArea vct:(NSString *)vct createKeySettings:(MultipazCreateKeySettings *)createKeySettings completionHandler:(void (^)(MultipazKeyBoundSdJwtVcCredential * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("create(document:asReplacementForIdentifier:domain:secureArea:vct:createKeySettings:completionHandler:)")));
@property (readonly) NSString *CREDENTIAL_TYPE __attribute__((swift_name("CREDENTIAL_TYPE")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KeylessSdJwtVcCredential")))
@interface MultipazKeylessSdJwtVcCredential : MultipazCredential <MultipazSdJwtVcCredential>
- (instancetype)initWithDocument:(MultipazDocument *)document __attribute__((swift_name("init(document:)"))) __attribute__((objc_designated_initializer));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (instancetype)initWithDocument:(MultipazDocument *)document asReplacementForIdentifier:(NSString * _Nullable)asReplacementForIdentifier domain:(NSString *)domain __attribute__((swift_name("init(document:asReplacementForIdentifier:domain:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazKeylessSdJwtVcCredentialCompanion *companion __attribute__((swift_name("companion")));
- (void)addSerializedDataBuilder:(MultipazMapBuilder<MultipazCborBuilder *> *)builder __attribute__((swift_name("addSerializedData(builder:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)deserializeDataItem:(MultipazDataItem *)dataItem completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("deserialize(dataItem:completionHandler:)")));
- (NSArray<MultipazVcClaim *> *)getClaimsDocumentTypeRepository:(MultipazDocumentTypeRepository * _Nullable)documentTypeRepository __attribute__((swift_name("getClaims(documentTypeRepository:)")));
@property (readonly) NSString *credentialType __attribute__((swift_name("credentialType")));
@property (readonly) NSString *vct __attribute__((swift_name("vct")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KeylessSdJwtVcCredential.Companion")))
@interface MultipazKeylessSdJwtVcCredentialCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKeylessSdJwtVcCredentialCompanion *shared __attribute__((swift_name("shared")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)createDocument:(MultipazDocument *)document asReplacementForIdentifier:(NSString * _Nullable)asReplacementForIdentifier domain:(NSString *)domain vct:(NSString *)vct completionHandler:(void (^)(MultipazKeylessSdJwtVcCredential * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("create(document:asReplacementForIdentifier:domain:vct:completionHandler:)")));
@property (readonly) NSString *CREDENTIAL_TYPE __attribute__((swift_name("CREDENTIAL_TYPE")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BatchCreateKeyResult")))
@interface MultipazBatchCreateKeyResult : MultipazBase
- (instancetype)initWithKeyInfos:(NSArray<MultipazKeyInfo *> *)keyInfos openid4vciKeyAttestation:(NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> * _Nullable)openid4vciKeyAttestation __attribute__((swift_name("init(keyInfos:openid4vciKeyAttestation:)"))) __attribute__((objc_designated_initializer));
- (MultipazBatchCreateKeyResult *)doCopyKeyInfos:(NSArray<MultipazKeyInfo *> *)keyInfos openid4vciKeyAttestation:(NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> * _Nullable)openid4vciKeyAttestation __attribute__((swift_name("doCopy(keyInfos:openid4vciKeyAttestation:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSArray<MultipazKeyInfo *> *keyInfos __attribute__((swift_name("keyInfos")));
@property (readonly) NSDictionary<NSString *, MultipazKotlinx_serialization_jsonJsonElement *> * _Nullable openid4vciKeyAttestation __attribute__((swift_name("openid4vciKeyAttestation")));
@end

__attribute__((swift_name("CreateKeySettings")))
@interface MultipazCreateKeySettings : MultipazBase
- (instancetype)initWithAlgorithm:(MultipazAlgorithm *)algorithm nonce:(MultipazKotlinx_io_bytestringByteString *)nonce __attribute__((swift_name("init(algorithm:nonce:)"))) __attribute__((objc_designated_initializer));
@property (readonly) MultipazAlgorithm *algorithm __attribute__((swift_name("algorithm")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *nonce __attribute__((swift_name("nonce")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KeyAttestation")))
@interface MultipazKeyAttestation : MultipazBase
- (instancetype)initWithPublicKey:(MultipazEcPublicKey *)publicKey certChain:(MultipazX509CertChain * _Nullable)certChain __attribute__((swift_name("init(publicKey:certChain:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazKeyAttestationCompanion *companion __attribute__((swift_name("companion")));
- (MultipazKeyAttestation *)doCopyPublicKey:(MultipazEcPublicKey *)publicKey certChain:(MultipazX509CertChain * _Nullable)certChain __attribute__((swift_name("doCopy(publicKey:certChain:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazX509CertChain * _Nullable certChain __attribute__((swift_name("certChain")));
@property (readonly) MultipazEcPublicKey *publicKey __attribute__((swift_name("publicKey")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KeyAttestation.Companion")))
@interface MultipazKeyAttestationCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKeyAttestationCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((swift_name("KeyInfo")))
@interface MultipazKeyInfo : MultipazBase

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (instancetype)initWithAlias:(NSString *)alias algorithm:(MultipazAlgorithm *)algorithm publicKey:(MultipazEcPublicKey *)publicKey attestation:(MultipazKeyAttestation *)attestation __attribute__((swift_name("init(alias:algorithm:publicKey:attestation:)"))) __attribute__((objc_designated_initializer));
@property (readonly) MultipazAlgorithm *algorithm __attribute__((swift_name("algorithm")));
@property (readonly) NSString *alias __attribute__((swift_name("alias")));
@property (readonly) MultipazKeyAttestation *attestation __attribute__((swift_name("attestation")));
@property (readonly) MultipazEcPublicKey *publicKey __attribute__((swift_name("publicKey")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KeyInvalidatedException")))
@interface MultipazKeyInvalidatedException : MultipazKotlinException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithCause:(MultipazKotlinException *)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString *)message cause:(MultipazKotlinException *)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((swift_name("KeyLockedException")))
@interface MultipazKeyLockedException : MultipazKotlinException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithCause:(MultipazKotlinException *)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString *)message cause:(MultipazKotlinException *)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((swift_name("KeyUnlockData")))
@protocol MultipazKeyUnlockData
@required
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KeyUnlockInteractive")))
@interface MultipazKeyUnlockInteractive : MultipazBase <MultipazKeyUnlockData>
- (instancetype)initWithTitle:(NSString * _Nullable)title subtitle:(NSString * _Nullable)subtitle requireConfirmation:(BOOL)requireConfirmation __attribute__((swift_name("init(title:subtitle:requireConfirmation:)"))) __attribute__((objc_designated_initializer));
@property (readonly) BOOL requireConfirmation __attribute__((swift_name("requireConfirmation")));
@property (readonly) NSString * _Nullable subtitle __attribute__((swift_name("subtitle")));
@property (readonly) NSString * _Nullable title __attribute__((swift_name("title")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PassphraseConstraints")))
@interface MultipazPassphraseConstraints : MultipazBase
- (instancetype)initWithMinLength:(int32_t)minLength maxLength:(int32_t)maxLength requireNumerical:(BOOL)requireNumerical __attribute__((swift_name("init(minLength:maxLength:requireNumerical:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazPassphraseConstraintsCompanion *companion __attribute__((swift_name("companion")));
- (MultipazPassphraseConstraints *)doCopyMinLength:(int32_t)minLength maxLength:(int32_t)maxLength requireNumerical:(BOOL)requireNumerical __attribute__((swift_name("doCopy(minLength:maxLength:requireNumerical:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (BOOL)isFixedLength __attribute__((swift_name("isFixedLength()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t maxLength __attribute__((swift_name("maxLength")));
@property (readonly) int32_t minLength __attribute__((swift_name("minLength")));
@property (readonly) BOOL requireNumerical __attribute__((swift_name("requireNumerical")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PassphraseConstraints.Companion")))
@interface MultipazPassphraseConstraintsCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazPassphraseConstraintsCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) MultipazPassphraseConstraints *NONE __attribute__((swift_name("NONE")));
@property (readonly) MultipazPassphraseConstraints *PASSPHRASE_FOUR_CHARS __attribute__((swift_name("PASSPHRASE_FOUR_CHARS")));
@property (readonly) MultipazPassphraseConstraints *PASSPHRASE_FOUR_CHARS_OR_LONGER __attribute__((swift_name("PASSPHRASE_FOUR_CHARS_OR_LONGER")));
@property (readonly) MultipazPassphraseConstraints *PASSPHRASE_SIX_CHARS __attribute__((swift_name("PASSPHRASE_SIX_CHARS")));
@property (readonly) MultipazPassphraseConstraints *PASSPHRASE_SIX_CHARS_OR_LONGER __attribute__((swift_name("PASSPHRASE_SIX_CHARS_OR_LONGER")));
@property (readonly) MultipazPassphraseConstraints *PIN_FOUR_DIGITS __attribute__((swift_name("PIN_FOUR_DIGITS")));
@property (readonly) MultipazPassphraseConstraints *PIN_FOUR_DIGITS_OR_LONGER __attribute__((swift_name("PIN_FOUR_DIGITS_OR_LONGER")));
@property (readonly) MultipazPassphraseConstraints *PIN_SIX_DIGITS __attribute__((swift_name("PIN_SIX_DIGITS")));
@property (readonly) MultipazPassphraseConstraints *PIN_SIX_DIGITS_OR_LONGER __attribute__((swift_name("PIN_SIX_DIGITS_OR_LONGER")));
@end

__attribute__((swift_name("SecureArea")))
@protocol MultipazSecureArea
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)batchCreateKeyNumKeys:(int32_t)numKeys createKeySettings:(MultipazCreateKeySettings *)createKeySettings completionHandler:(void (^)(MultipazBatchCreateKeyResult * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("batchCreateKey(numKeys:createKeySettings:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)createKeyAlias:(NSString * _Nullable)alias createKeySettings:(MultipazCreateKeySettings *)createKeySettings completionHandler:(void (^)(MultipazKeyInfo * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("createKey(alias:createKeySettings:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)deleteKeyAlias:(NSString *)alias completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("deleteKey(alias:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getKeyInfoAlias:(NSString *)alias completionHandler:(void (^)(MultipazKeyInfo * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getKeyInfo(alias:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getKeyInvalidatedAlias:(NSString *)alias completionHandler:(void (^)(MultipazBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getKeyInvalidated(alias:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)keyAgreementAlias:(NSString *)alias otherKey:(MultipazEcPublicKey *)otherKey keyUnlockData:(id<MultipazKeyUnlockData> _Nullable)keyUnlockData completionHandler:(void (^)(MultipazKotlinByteArray * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("keyAgreement(alias:otherKey:keyUnlockData:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)signAlias:(NSString *)alias dataToSign:(MultipazKotlinByteArray *)dataToSign keyUnlockData:(id<MultipazKeyUnlockData> _Nullable)keyUnlockData completionHandler:(void (^)(MultipazEcSignature * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("sign(alias:dataToSign:keyUnlockData:completionHandler:)")));
@property (readonly) NSString *displayName __attribute__((swift_name("displayName")));
@property (readonly) NSString *identifier __attribute__((swift_name("identifier")));
@property (readonly) NSArray<MultipazAlgorithm *> *supportedAlgorithms __attribute__((swift_name("supportedAlgorithms")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SecureAreaProvider")))
@interface MultipazSecureAreaProvider<__covariant T> : MultipazBase
- (instancetype)initWithContext:(id<MultipazKotlinCoroutineContext>)context provider:(id<MultipazKotlinSuspendFunction1>)provider __attribute__((swift_name("init(context:provider:)"))) __attribute__((objc_designated_initializer));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getWithCompletionHandler:(void (^)(T _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("get(completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SecureAreaRepository")))
@interface MultipazSecureAreaRepository : MultipazBase
@property (class, readonly, getter=companion) MultipazSecureAreaRepositoryCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getImplementationIdentifier:(NSString *)identifier completionHandler:(void (^)(id<MultipazSecureArea> _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("getImplementation(identifier:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SecureAreaRepository.Builder")))
@interface MultipazSecureAreaRepositoryBuilder : MultipazBase
- (instancetype)initWithContext:(id<MultipazKotlinCoroutineContext>)context __attribute__((swift_name("init(context:)"))) __attribute__((objc_designated_initializer));
- (void)addSecureArea:(id<MultipazSecureArea>)secureArea __attribute__((swift_name("add(secureArea:)")));
- (void)addFactoryIdentifierPrefix:(NSString *)identifierPrefix factory:(id<MultipazKotlinSuspendFunction1>)factory __attribute__((swift_name("addFactory(identifierPrefix:factory:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SecureAreaRepository.Companion")))
@interface MultipazSecureAreaRepositoryCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazSecureAreaRepositoryCompanion *shared __attribute__((swift_name("shared")));
- (MultipazSecureAreaRepository *)buildContext:(id<MultipazKotlinCoroutineContext>)context block:(id<MultipazKotlinSuspendFunction1>)block __attribute__((swift_name("build(context:block:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SecureEnclaveCreateKeySettings")))
@interface MultipazSecureEnclaveCreateKeySettings : MultipazCreateKeySettings
- (instancetype)initWithAlgorithm:(MultipazAlgorithm *)algorithm nonce:(MultipazKotlinx_io_bytestringByteString *)nonce __attribute__((swift_name("init(algorithm:nonce:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (readonly) BOOL userAuthenticationRequired __attribute__((swift_name("userAuthenticationRequired")));
@property (readonly) NSSet<MultipazSecureEnclaveUserAuthType *> *userAuthenticationTypes __attribute__((swift_name("userAuthenticationTypes")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SecureEnclaveCreateKeySettings.Builder")))
@interface MultipazSecureEnclaveCreateKeySettingsBuilder : MultipazBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (MultipazSecureEnclaveCreateKeySettingsBuilder *)applyConfigurationConfiguration:(MultipazDataItem *)configuration __attribute__((swift_name("applyConfiguration(configuration:)")));
- (MultipazSecureEnclaveCreateKeySettings *)build __attribute__((swift_name("build()")));
- (MultipazSecureEnclaveCreateKeySettingsBuilder *)setAlgorithmAlgorithm:(MultipazAlgorithm *)algorithm __attribute__((swift_name("setAlgorithm(algorithm:)")));
- (MultipazSecureEnclaveCreateKeySettingsBuilder *)setUserAuthenticationRequiredRequired:(BOOL)required userAuthenticationTypes:(NSSet<MultipazSecureEnclaveUserAuthType *> *)userAuthenticationTypes __attribute__((swift_name("setUserAuthenticationRequired(required:userAuthenticationTypes:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SecureEnclaveKeyInfo")))
@interface MultipazSecureEnclaveKeyInfo : MultipazKeyInfo

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (instancetype)initWithAlias:(NSString *)alias algorithm:(MultipazAlgorithm *)algorithm publicKey:(MultipazEcPublicKey *)publicKey attestation:(MultipazKeyAttestation *)attestation __attribute__((swift_name("init(alias:algorithm:publicKey:attestation:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (readonly) BOOL isUserAuthenticationRequired __attribute__((swift_name("isUserAuthenticationRequired")));
@property (readonly) NSSet<MultipazSecureEnclaveUserAuthType *> *userAuthenticationTypes __attribute__((swift_name("userAuthenticationTypes")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SecureEnclaveKeyUnlockData")))
@interface MultipazSecureEnclaveKeyUnlockData : MultipazBase <MultipazKeyUnlockData>
- (instancetype)initWithAuthenticationContext:(LAContext *)authenticationContext __attribute__((swift_name("init(authenticationContext:)"))) __attribute__((objc_designated_initializer));
@property (readonly) LAContext *authenticationContext __attribute__((swift_name("authenticationContext")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SecureEnclaveSecureArea")))
@interface MultipazSecureEnclaveSecureArea : MultipazBase <MultipazSecureArea>
@property (class, readonly, getter=companion) MultipazSecureEnclaveSecureAreaCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)createKeyAlias:(NSString * _Nullable)alias createKeySettings:(MultipazCreateKeySettings *)createKeySettings completionHandler:(void (^)(MultipazKeyInfo * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("createKey(alias:createKeySettings:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)deleteKeyAlias:(NSString *)alias completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("deleteKey(alias:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getKeyInfoAlias:(NSString *)alias completionHandler:(void (^)(MultipazKeyInfo * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getKeyInfo(alias:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getKeyInvalidatedAlias:(NSString *)alias completionHandler:(void (^)(MultipazBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getKeyInvalidated(alias:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)keyAgreementAlias:(NSString *)alias otherKey:(MultipazEcPublicKey *)otherKey keyUnlockData:(id<MultipazKeyUnlockData> _Nullable)keyUnlockData completionHandler:(void (^)(MultipazKotlinByteArray * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("keyAgreement(alias:otherKey:keyUnlockData:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)signAlias:(NSString *)alias dataToSign:(MultipazKotlinByteArray *)dataToSign keyUnlockData:(id<MultipazKeyUnlockData> _Nullable)keyUnlockData completionHandler:(void (^)(MultipazEcSignature * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("sign(alias:dataToSign:keyUnlockData:completionHandler:)")));
@property (readonly) NSString *displayName __attribute__((swift_name("displayName")));
@property (readonly) NSString *identifier __attribute__((swift_name("identifier")));
@property (readonly) NSArray<MultipazAlgorithm *> *supportedAlgorithms __attribute__((swift_name("supportedAlgorithms")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SecureEnclaveSecureArea.Companion")))
@interface MultipazSecureEnclaveSecureAreaCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazSecureEnclaveSecureAreaCompanion *shared __attribute__((swift_name("shared")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)createStorage:(id<MultipazStorage>)storage partitionId:(NSString *)partitionId completionHandler:(void (^)(MultipazSecureEnclaveSecureArea * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("create(storage:partitionId:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SecureEnclaveUserAuthType")))
@interface MultipazSecureEnclaveUserAuthType : MultipazKotlinEnum<MultipazSecureEnclaveUserAuthType *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazSecureEnclaveUserAuthTypeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) MultipazSecureEnclaveUserAuthType *devicePasscode __attribute__((swift_name("devicePasscode")));
@property (class, readonly) MultipazSecureEnclaveUserAuthType *biometryCurrentSet __attribute__((swift_name("biometryCurrentSet")));
@property (class, readonly) MultipazSecureEnclaveUserAuthType *biometryAny __attribute__((swift_name("biometryAny")));
@property (class, readonly) MultipazSecureEnclaveUserAuthType *userPresence __attribute__((swift_name("userPresence")));
+ (MultipazKotlinArray<MultipazSecureEnclaveUserAuthType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazSecureEnclaveUserAuthType *> *entries __attribute__((swift_name("entries")));
@property (readonly) int64_t flagValue __attribute__((swift_name("flagValue")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SecureEnclaveUserAuthType.Companion")))
@interface MultipazSecureEnclaveUserAuthTypeCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazSecureEnclaveUserAuthTypeCompanion *shared __attribute__((swift_name("shared")));
- (NSSet<MultipazSecureEnclaveUserAuthType *> *)decodeSetTypes:(int64_t)types __attribute__((swift_name("decodeSet(types:)")));
- (int64_t)encodeSetTypes:(NSSet<MultipazSecureEnclaveUserAuthType *> *)types __attribute__((swift_name("encodeSet(types:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudAttestationExtension")))
@interface MultipazCloudAttestationExtension : MultipazBase
- (instancetype)initWithChallenge:(MultipazKotlinx_io_bytestringByteString *)challenge passphrase:(BOOL)passphrase userAuthentication:(NSSet<MultipazCloudUserAuthType *> *)userAuthentication __attribute__((swift_name("init(challenge:passphrase:userAuthentication:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazCloudAttestationExtensionCompanion *companion __attribute__((swift_name("companion")));
- (MultipazCloudAttestationExtension *)doCopyChallenge:(MultipazKotlinx_io_bytestringByteString *)challenge passphrase:(BOOL)passphrase userAuthentication:(NSSet<MultipazCloudUserAuthType *> *)userAuthentication __attribute__((swift_name("doCopy(challenge:passphrase:userAuthentication:)")));
- (MultipazKotlinx_io_bytestringByteString *)encode __attribute__((swift_name("encode()")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)prettyPrint __attribute__((swift_name("prettyPrint()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *challenge __attribute__((swift_name("challenge")));
@property (readonly) BOOL passphrase __attribute__((swift_name("passphrase")));
@property (readonly) NSSet<MultipazCloudUserAuthType *> *userAuthentication __attribute__((swift_name("userAuthentication")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudAttestationExtension.Companion")))
@interface MultipazCloudAttestationExtensionCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazCloudAttestationExtensionCompanion *shared __attribute__((swift_name("shared")));
- (MultipazCloudAttestationExtension *)decodeAttestationExtensionPayload:(MultipazKotlinx_io_bytestringByteString *)attestationExtensionPayload __attribute__((swift_name("decode(attestationExtensionPayload:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudCreateKeySettings")))
@interface MultipazCloudCreateKeySettings : MultipazCreateKeySettings
- (instancetype)initWithAlgorithm:(MultipazAlgorithm *)algorithm nonce:(MultipazKotlinx_io_bytestringByteString *)nonce __attribute__((swift_name("init(algorithm:nonce:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (readonly) MultipazKotlinx_io_bytestringByteString *attestationChallenge __attribute__((swift_name("attestationChallenge")));
@property (readonly) BOOL passphraseRequired __attribute__((swift_name("passphraseRequired")));
@property (readonly) BOOL userAuthenticationRequired __attribute__((swift_name("userAuthenticationRequired")));
@property (readonly) NSSet<MultipazCloudUserAuthType *> *userAuthenticationTypes __attribute__((swift_name("userAuthenticationTypes")));
@property (readonly) MultipazKotlinx_datetimeInstant * _Nullable validFrom __attribute__((swift_name("validFrom")));
@property (readonly) MultipazKotlinx_datetimeInstant * _Nullable validUntil __attribute__((swift_name("validUntil")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudCreateKeySettings.Builder")))
@interface MultipazCloudCreateKeySettingsBuilder : MultipazBase
- (instancetype)initWithAttestationChallenge:(MultipazKotlinx_io_bytestringByteString *)attestationChallenge __attribute__((swift_name("init(attestationChallenge:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudCreateKeySettingsBuilder *)applyConfigurationConfiguration:(MultipazSecureAreaConfigurationCloud *)configuration __attribute__((swift_name("applyConfiguration(configuration:)")));
- (MultipazCloudCreateKeySettings *)build __attribute__((swift_name("build()")));
- (MultipazCloudCreateKeySettingsBuilder *)setAlgorithmAlgorithm:(MultipazAlgorithm *)algorithm __attribute__((swift_name("setAlgorithm(algorithm:)")));
- (MultipazCloudCreateKeySettingsBuilder *)setPassphraseRequiredRequired:(BOOL)required __attribute__((swift_name("setPassphraseRequired(required:)")));
- (MultipazCloudCreateKeySettingsBuilder *)setUserAuthenticationRequiredRequired:(BOOL)required types:(NSSet<MultipazCloudUserAuthType *> *)types __attribute__((swift_name("setUserAuthenticationRequired(required:types:)")));
- (MultipazCloudCreateKeySettingsBuilder *)setValidityPeriodValidFrom:(MultipazKotlinx_datetimeInstant *)validFrom validUntil:(MultipazKotlinx_datetimeInstant *)validUntil __attribute__((swift_name("setValidityPeriod(validFrom:validUntil:)")));
@end

__attribute__((swift_name("CloudException")))
@interface MultipazCloudException : MultipazKotlinException
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(MultipazKotlinThrowable *)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString *)message cause:(MultipazKotlinException *)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudKeyInfo")))
@interface MultipazCloudKeyInfo : MultipazKeyInfo

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (instancetype)initWithAlias:(NSString *)alias algorithm:(MultipazAlgorithm *)algorithm publicKey:(MultipazEcPublicKey *)publicKey attestation:(MultipazKeyAttestation *)attestation __attribute__((swift_name("init(alias:algorithm:publicKey:attestation:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (readonly) BOOL isPassphraseRequired __attribute__((swift_name("isPassphraseRequired")));
@property (readonly) BOOL isUserAuthenticationRequired __attribute__((swift_name("isUserAuthenticationRequired")));
@property (readonly) NSSet<MultipazCloudUserAuthType *> *userAuthenticationTypes __attribute__((swift_name("userAuthenticationTypes")));
@property (readonly) MultipazKotlinx_datetimeInstant * _Nullable validFrom __attribute__((swift_name("validFrom")));
@property (readonly) MultipazKotlinx_datetimeInstant * _Nullable validUntil __attribute__((swift_name("validUntil")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudKeyLockedException")))
@interface MultipazCloudKeyLockedException : MultipazKeyLockedException
- (instancetype)initWithReason:(MultipazCloudKeyLockedExceptionReason *)reason message:(NSString *)message __attribute__((swift_name("init(reason:message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithReason:(MultipazCloudKeyLockedExceptionReason *)reason message:(NSString *)message cause:(MultipazKotlinException *)cause __attribute__((swift_name("init(reason:message:cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithCause:(MultipazKotlinException *)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString *)message cause:(MultipazKotlinException *)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (readonly) MultipazCloudKeyLockedExceptionReason *reason __attribute__((swift_name("reason")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudKeyLockedException.Reason")))
@interface MultipazCloudKeyLockedExceptionReason : MultipazKotlinEnum<MultipazCloudKeyLockedExceptionReason *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) MultipazCloudKeyLockedExceptionReason *wrongPassphrase __attribute__((swift_name("wrongPassphrase")));
@property (class, readonly) MultipazCloudKeyLockedExceptionReason *userNotAuthenticated __attribute__((swift_name("userNotAuthenticated")));
+ (MultipazKotlinArray<MultipazCloudKeyLockedExceptionReason *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazCloudKeyLockedExceptionReason *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudKeyUnlockData")))
@interface MultipazCloudKeyUnlockData : MultipazBase <MultipazKeyUnlockData>
- (instancetype)initWithCloudSecureArea:(MultipazCloudSecureArea *)cloudSecureArea alias:(NSString *)alias __attribute__((swift_name("init(cloudSecureArea:alias:)"))) __attribute__((objc_designated_initializer));
@property NSString * _Nullable passphrase __attribute__((swift_name("passphrase")));
@end

__attribute__((swift_name("CloudSecureArea")))
@interface MultipazCloudSecureArea : MultipazBase <MultipazSecureArea>

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (instancetype)initWithStorageTable:(id<MultipazStorageTable>)storageTable identifier:(NSString *)identifier serverUrl:(NSString *)serverUrl httpClientEngineFactory:(id<MultipazKtor_client_coreHttpClientEngineFactory>)httpClientEngineFactory __attribute__((swift_name("init(storageTable:identifier:serverUrl:httpClientEngineFactory:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazCloudSecureAreaCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)communicateLowlevelEndpointUri:(NSString *)endpointUri requestData:(MultipazKotlinByteArray *)requestData completionHandler:(void (^)(MultipazKotlinPair<MultipazInt *, MultipazKotlinByteArray *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("communicateLowlevel(endpointUri:requestData:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)createKeyAlias:(NSString * _Nullable)alias createKeySettings:(MultipazCreateKeySettings *)createKeySettings completionHandler:(void (^)(MultipazCloudKeyInfo * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("createKey(alias:createKeySettings:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)deleteKeyAlias:(NSString *)alias completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("deleteKey(alias:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getKeyInfoAlias:(NSString *)alias completionHandler:(void (^)(MultipazCloudKeyInfo * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getKeyInfo(alias:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getKeyInvalidatedAlias:(NSString *)alias completionHandler:(void (^)(MultipazBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getKeyInvalidated(alias:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getPassphraseConstraintsWithCompletionHandler:(void (^)(MultipazPassphraseConstraints * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getPassphraseConstraints(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)initializeWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("initialize(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)keyAgreementAlias:(NSString *)alias otherKey:(MultipazEcPublicKey *)otherKey keyUnlockData:(id<MultipazKeyUnlockData> _Nullable)keyUnlockData completionHandler:(void (^)(MultipazKotlinByteArray * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("keyAgreement(alias:otherKey:keyUnlockData:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)registerPassphrase:(NSString *)passphrase passphraseConstraints:(MultipazPassphraseConstraints *)passphraseConstraints onAuthorizeRootOfTrust:(MultipazBoolean *(^)(MultipazX509Cert *))onAuthorizeRootOfTrust completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("register(passphrase:passphraseConstraints:onAuthorizeRootOfTrust:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)signAlias:(NSString *)alias dataToSign:(MultipazKotlinByteArray *)dataToSign keyUnlockData:(id<MultipazKeyUnlockData> _Nullable)keyUnlockData completionHandler:(void (^)(MultipazEcSignature * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("sign(alias:dataToSign:keyUnlockData:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)unregisterWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("unregister(completionHandler:)")));
@property (readonly) NSString *displayName __attribute__((swift_name("displayName")));
@property (readonly) NSString *identifier __attribute__((swift_name("identifier")));
@property (readonly) BOOL isRegistered __attribute__((swift_name("isRegistered")));
@property id<MultipazSecureArea> platformSecureArea __attribute__((swift_name("platformSecureArea")));
@property (readonly) NSString *serverUrl __attribute__((swift_name("serverUrl")));
@property (readonly) NSArray<MultipazAlgorithm *> *supportedAlgorithms __attribute__((swift_name("supportedAlgorithms")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureArea.Companion")))
@interface MultipazCloudSecureAreaCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazCloudSecureAreaCompanion *shared __attribute__((swift_name("shared")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)createStorage:(id<MultipazStorage>)storage identifier:(NSString *)identifier serverUrl:(NSString *)serverUrl httpClientEngineFactory:(id<MultipazKtor_client_coreHttpClientEngineFactory>)httpClientEngineFactory completionHandler:(void (^)(MultipazCloudSecureArea * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("create(storage:identifier:serverUrl:httpClientEngineFactory:completionHandler:)")));
@property (readonly) NSString *IDENTIFIER_PREFIX __attribute__((swift_name("IDENTIFIER_PREFIX")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol")))
@interface MultipazCloudSecureAreaProtocol : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)cloudSecureAreaProtocol __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazCloudSecureAreaProtocol *shared __attribute__((swift_name("shared")));
@property (readonly) int32_t RESULT_OK __attribute__((swift_name("RESULT_OK")));
@property (readonly) int32_t RESULT_TOO_MANY_PASSPHRASE_ATTEMPTS __attribute__((swift_name("RESULT_TOO_MANY_PASSPHRASE_ATTEMPTS")));
@property (readonly) int32_t RESULT_WRONG_PASSPHRASE __attribute__((swift_name("RESULT_WRONG_PASSPHRASE")));
@end

__attribute__((swift_name("CloudSecureAreaProtocol.Command")))
@interface MultipazCloudSecureAreaProtocolCommand : MultipazBase
@property (class, readonly, getter=companion) MultipazCloudSecureAreaProtocolCommandCompanion *companion __attribute__((swift_name("companion")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.CheckPassphraseRequest")))
@interface MultipazCloudSecureAreaProtocolCheckPassphraseRequest : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithPassphrase:(NSString *)passphrase __attribute__((swift_name("init(passphrase:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolCheckPassphraseRequest *)doCopyPassphrase:(NSString *)passphrase __attribute__((swift_name("doCopy(passphrase:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *passphrase __attribute__((swift_name("passphrase")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.CheckPassphraseResponse")))
@interface MultipazCloudSecureAreaProtocolCheckPassphraseResponse : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithResult:(int32_t)result __attribute__((swift_name("init(result:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolCheckPassphraseResponse *)doCopyResult:(int32_t)result __attribute__((swift_name("doCopy(result:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t result __attribute__((swift_name("result")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.CommandCompanion")))
@interface MultipazCloudSecureAreaProtocolCommandCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazCloudSecureAreaProtocolCommandCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.CreateKeyRequest0")))
@interface MultipazCloudSecureAreaProtocolCreateKeyRequest0 : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithAlgorithm:(NSString *)algorithm validFromMillis:(int64_t)validFromMillis validUntilMillis:(int64_t)validUntilMillis passphraseRequired:(BOOL)passphraseRequired userAuthenticationRequired:(BOOL)userAuthenticationRequired userAuthenticationTypes:(int64_t)userAuthenticationTypes challenge:(MultipazKotlinByteArray *)challenge __attribute__((swift_name("init(algorithm:validFromMillis:validUntilMillis:passphraseRequired:userAuthenticationRequired:userAuthenticationTypes:challenge:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolCreateKeyRequest0 *)doCopyAlgorithm:(NSString *)algorithm validFromMillis:(int64_t)validFromMillis validUntilMillis:(int64_t)validUntilMillis passphraseRequired:(BOOL)passphraseRequired userAuthenticationRequired:(BOOL)userAuthenticationRequired userAuthenticationTypes:(int64_t)userAuthenticationTypes challenge:(MultipazKotlinByteArray *)challenge __attribute__((swift_name("doCopy(algorithm:validFromMillis:validUntilMillis:passphraseRequired:userAuthenticationRequired:userAuthenticationTypes:challenge:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *algorithm __attribute__((swift_name("algorithm")));
@property (readonly) MultipazKotlinByteArray *challenge __attribute__((swift_name("challenge")));
@property (readonly) BOOL passphraseRequired __attribute__((swift_name("passphraseRequired")));
@property (readonly) BOOL userAuthenticationRequired __attribute__((swift_name("userAuthenticationRequired")));
@property (readonly) int64_t userAuthenticationTypes __attribute__((swift_name("userAuthenticationTypes")));
@property (readonly) int64_t validFromMillis __attribute__((swift_name("validFromMillis")));
@property (readonly) int64_t validUntilMillis __attribute__((swift_name("validUntilMillis")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.CreateKeyRequest1")))
@interface MultipazCloudSecureAreaProtocolCreateKeyRequest1 : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithLocalKey:(MultipazCoseKey *)localKey localKeyAttestation:(MultipazX509CertChain * _Nullable)localKeyAttestation serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("init(localKey:localKeyAttestation:serverState:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolCreateKeyRequest1 *)doCopyLocalKey:(MultipazCoseKey *)localKey localKeyAttestation:(MultipazX509CertChain * _Nullable)localKeyAttestation serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("doCopy(localKey:localKeyAttestation:serverState:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazCoseKey *localKey __attribute__((swift_name("localKey")));
@property (readonly) MultipazX509CertChain * _Nullable localKeyAttestation __attribute__((swift_name("localKeyAttestation")));
@property (readonly) MultipazKotlinByteArray *serverState __attribute__((swift_name("serverState")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.CreateKeyResponse0")))
@interface MultipazCloudSecureAreaProtocolCreateKeyResponse0 : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithCloudChallenge:(MultipazKotlinByteArray *)cloudChallenge serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("init(cloudChallenge:serverState:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolCreateKeyResponse0 *)doCopyCloudChallenge:(MultipazKotlinByteArray *)cloudChallenge serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("doCopy(cloudChallenge:serverState:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinByteArray *cloudChallenge __attribute__((swift_name("cloudChallenge")));
@property (readonly) MultipazKotlinByteArray *serverState __attribute__((swift_name("serverState")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.CreateKeyResponse1")))
@interface MultipazCloudSecureAreaProtocolCreateKeyResponse1 : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithRemoteKeyAttestation:(MultipazX509CertChain *)remoteKeyAttestation serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("init(remoteKeyAttestation:serverState:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolCreateKeyResponse1 *)doCopyRemoteKeyAttestation:(MultipazX509CertChain *)remoteKeyAttestation serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("doCopy(remoteKeyAttestation:serverState:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazX509CertChain *remoteKeyAttestation __attribute__((swift_name("remoteKeyAttestation")));
@property (readonly) MultipazKotlinByteArray *serverState __attribute__((swift_name("serverState")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.E2EERequest")))
@interface MultipazCloudSecureAreaProtocolE2EERequest : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithEncryptedRequest:(MultipazKotlinByteArray *)encryptedRequest e2eeContext:(MultipazKotlinByteArray *)e2eeContext __attribute__((swift_name("init(encryptedRequest:e2eeContext:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolE2EERequest *)doCopyEncryptedRequest:(MultipazKotlinByteArray *)encryptedRequest e2eeContext:(MultipazKotlinByteArray *)e2eeContext __attribute__((swift_name("doCopy(encryptedRequest:e2eeContext:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinByteArray *e2eeContext __attribute__((swift_name("e2eeContext")));
@property (readonly) MultipazKotlinByteArray *encryptedRequest __attribute__((swift_name("encryptedRequest")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.E2EEResponse")))
@interface MultipazCloudSecureAreaProtocolE2EEResponse : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithEncryptedResponse:(MultipazKotlinByteArray *)encryptedResponse e2eeContext:(MultipazKotlinByteArray *)e2eeContext __attribute__((swift_name("init(encryptedResponse:e2eeContext:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolE2EEResponse *)doCopyEncryptedResponse:(MultipazKotlinByteArray *)encryptedResponse e2eeContext:(MultipazKotlinByteArray *)e2eeContext __attribute__((swift_name("doCopy(encryptedResponse:e2eeContext:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinByteArray *e2eeContext __attribute__((swift_name("e2eeContext")));
@property (readonly) MultipazKotlinByteArray *encryptedResponse __attribute__((swift_name("encryptedResponse")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.E2EESetupRequest0")))
@interface MultipazCloudSecureAreaProtocolE2EESetupRequest0 : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithRegistrationContext:(MultipazKotlinByteArray *)registrationContext __attribute__((swift_name("init(registrationContext:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolE2EESetupRequest0 *)doCopyRegistrationContext:(MultipazKotlinByteArray *)registrationContext __attribute__((swift_name("doCopy(registrationContext:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinByteArray *registrationContext __attribute__((swift_name("registrationContext")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.E2EESetupRequest1")))
@interface MultipazCloudSecureAreaProtocolE2EESetupRequest1 : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithEDeviceKey:(MultipazCoseKey *)eDeviceKey deviceNonce:(MultipazKotlinByteArray *)deviceNonce signature:(MultipazEcSignature *)signature deviceAssertion:(MultipazDeviceAssertion *)deviceAssertion serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("init(eDeviceKey:deviceNonce:signature:deviceAssertion:serverState:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolE2EESetupRequest1 *)doCopyEDeviceKey:(MultipazCoseKey *)eDeviceKey deviceNonce:(MultipazKotlinByteArray *)deviceNonce signature:(MultipazEcSignature *)signature deviceAssertion:(MultipazDeviceAssertion *)deviceAssertion serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("doCopy(eDeviceKey:deviceNonce:signature:deviceAssertion:serverState:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazDeviceAssertion *deviceAssertion __attribute__((swift_name("deviceAssertion")));
@property (readonly) MultipazKotlinByteArray *deviceNonce __attribute__((swift_name("deviceNonce")));
@property (readonly) MultipazCoseKey *eDeviceKey __attribute__((swift_name("eDeviceKey")));
@property (readonly) MultipazKotlinByteArray *serverState __attribute__((swift_name("serverState")));
@property (readonly) MultipazEcSignature *signature __attribute__((swift_name("signature")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.E2EESetupResponse0")))
@interface MultipazCloudSecureAreaProtocolE2EESetupResponse0 : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithCloudNonce:(MultipazKotlinByteArray *)cloudNonce serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("init(cloudNonce:serverState:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolE2EESetupResponse0 *)doCopyCloudNonce:(MultipazKotlinByteArray *)cloudNonce serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("doCopy(cloudNonce:serverState:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinByteArray *cloudNonce __attribute__((swift_name("cloudNonce")));
@property (readonly) MultipazKotlinByteArray *serverState __attribute__((swift_name("serverState")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.E2EESetupResponse1")))
@interface MultipazCloudSecureAreaProtocolE2EESetupResponse1 : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithECloudKey:(MultipazCoseKey *)eCloudKey signature:(MultipazEcSignature *)signature serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("init(eCloudKey:signature:serverState:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolE2EESetupResponse1 *)doCopyECloudKey:(MultipazCoseKey *)eCloudKey signature:(MultipazEcSignature *)signature serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("doCopy(eCloudKey:signature:serverState:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazCoseKey *eCloudKey __attribute__((swift_name("eCloudKey")));
@property (readonly) MultipazKotlinByteArray *serverState __attribute__((swift_name("serverState")));
@property (readonly) MultipazEcSignature *signature __attribute__((swift_name("signature")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.KeyAgreementRequest0")))
@interface MultipazCloudSecureAreaProtocolKeyAgreementRequest0 : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithOtherPublicKey:(MultipazCoseKey *)otherPublicKey keyContext:(MultipazKotlinByteArray *)keyContext __attribute__((swift_name("init(otherPublicKey:keyContext:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolKeyAgreementRequest0 *)doCopyOtherPublicKey:(MultipazCoseKey *)otherPublicKey keyContext:(MultipazKotlinByteArray *)keyContext __attribute__((swift_name("doCopy(otherPublicKey:keyContext:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinByteArray *keyContext __attribute__((swift_name("keyContext")));
@property (readonly) MultipazCoseKey *otherPublicKey __attribute__((swift_name("otherPublicKey")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.KeyAgreementRequest1")))
@interface MultipazCloudSecureAreaProtocolKeyAgreementRequest1 : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithSignature:(MultipazEcSignature *)signature passphrase:(NSString * _Nullable)passphrase serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("init(signature:passphrase:serverState:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolKeyAgreementRequest1 *)doCopySignature:(MultipazEcSignature *)signature passphrase:(NSString * _Nullable)passphrase serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("doCopy(signature:passphrase:serverState:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString * _Nullable passphrase __attribute__((swift_name("passphrase")));
@property (readonly) MultipazKotlinByteArray *serverState __attribute__((swift_name("serverState")));
@property (readonly) MultipazEcSignature *signature __attribute__((swift_name("signature")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.KeyAgreementResponse0")))
@interface MultipazCloudSecureAreaProtocolKeyAgreementResponse0 : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithCloudNonce:(MultipazKotlinByteArray *)cloudNonce serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("init(cloudNonce:serverState:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolKeyAgreementResponse0 *)doCopyCloudNonce:(MultipazKotlinByteArray *)cloudNonce serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("doCopy(cloudNonce:serverState:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinByteArray *cloudNonce __attribute__((swift_name("cloudNonce")));
@property (readonly) MultipazKotlinByteArray *serverState __attribute__((swift_name("serverState")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.KeyAgreementResponse1")))
@interface MultipazCloudSecureAreaProtocolKeyAgreementResponse1 : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithResult:(int32_t)result zab:(MultipazKotlinByteArray * _Nullable)zab waitDurationMillis:(int64_t)waitDurationMillis __attribute__((swift_name("init(result:zab:waitDurationMillis:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolKeyAgreementResponse1 *)doCopyResult:(int32_t)result zab:(MultipazKotlinByteArray * _Nullable)zab waitDurationMillis:(int64_t)waitDurationMillis __attribute__((swift_name("doCopy(result:zab:waitDurationMillis:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t result __attribute__((swift_name("result")));
@property (readonly) int64_t waitDurationMillis __attribute__((swift_name("waitDurationMillis")));
@property (readonly) MultipazKotlinByteArray * _Nullable zab __attribute__((swift_name("zab")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.RegisterRequest0")))
@interface MultipazCloudSecureAreaProtocolRegisterRequest0 : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithClientVersion:(NSString *)clientVersion __attribute__((swift_name("init(clientVersion:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolRegisterRequest0 *)doCopyClientVersion:(NSString *)clientVersion __attribute__((swift_name("doCopy(clientVersion:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *clientVersion __attribute__((swift_name("clientVersion")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.RegisterRequest1")))
@interface MultipazCloudSecureAreaProtocolRegisterRequest1 : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithDeviceChallenge:(MultipazKotlinByteArray *)deviceChallenge deviceAttestation:(MultipazDeviceAttestation *)deviceAttestation deviceBindingKey:(MultipazCoseKey *)deviceBindingKey deviceBindingKeyAttestation:(MultipazX509CertChain * _Nullable)deviceBindingKeyAttestation serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("init(deviceChallenge:deviceAttestation:deviceBindingKey:deviceBindingKeyAttestation:serverState:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolRegisterRequest1 *)doCopyDeviceChallenge:(MultipazKotlinByteArray *)deviceChallenge deviceAttestation:(MultipazDeviceAttestation *)deviceAttestation deviceBindingKey:(MultipazCoseKey *)deviceBindingKey deviceBindingKeyAttestation:(MultipazX509CertChain * _Nullable)deviceBindingKeyAttestation serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("doCopy(deviceChallenge:deviceAttestation:deviceBindingKey:deviceBindingKeyAttestation:serverState:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazDeviceAttestation *deviceAttestation __attribute__((swift_name("deviceAttestation")));
@property (readonly) MultipazCoseKey *deviceBindingKey __attribute__((swift_name("deviceBindingKey")));
@property (readonly) MultipazX509CertChain * _Nullable deviceBindingKeyAttestation __attribute__((swift_name("deviceBindingKeyAttestation")));
@property (readonly) MultipazKotlinByteArray *deviceChallenge __attribute__((swift_name("deviceChallenge")));
@property (readonly) MultipazKotlinByteArray *serverState __attribute__((swift_name("serverState")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.RegisterResponse0")))
@interface MultipazCloudSecureAreaProtocolRegisterResponse0 : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithAttestationChallenge:(MultipazKotlinx_io_bytestringByteString *)attestationChallenge cloudChallenge:(MultipazKotlinByteArray *)cloudChallenge serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("init(attestationChallenge:cloudChallenge:serverState:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolRegisterResponse0 *)doCopyAttestationChallenge:(MultipazKotlinx_io_bytestringByteString *)attestationChallenge cloudChallenge:(MultipazKotlinByteArray *)cloudChallenge serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("doCopy(attestationChallenge:cloudChallenge:serverState:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *attestationChallenge __attribute__((swift_name("attestationChallenge")));
@property (readonly) MultipazKotlinByteArray *cloudChallenge __attribute__((swift_name("cloudChallenge")));
@property (readonly) MultipazKotlinByteArray *serverState __attribute__((swift_name("serverState")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.RegisterResponse1")))
@interface MultipazCloudSecureAreaProtocolRegisterResponse1 : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithCloudBindingKeyAttestation:(MultipazX509CertChain *)cloudBindingKeyAttestation serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("init(cloudBindingKeyAttestation:serverState:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolRegisterResponse1 *)doCopyCloudBindingKeyAttestation:(MultipazX509CertChain *)cloudBindingKeyAttestation serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("doCopy(cloudBindingKeyAttestation:serverState:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazX509CertChain *cloudBindingKeyAttestation __attribute__((swift_name("cloudBindingKeyAttestation")));
@property (readonly) MultipazKotlinByteArray *serverState __attribute__((swift_name("serverState")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.RegisterStage2Request0")))
@interface MultipazCloudSecureAreaProtocolRegisterStage2Request0 : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithPassphrase:(NSString *)passphrase __attribute__((swift_name("init(passphrase:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolRegisterStage2Request0 *)doCopyPassphrase:(NSString *)passphrase __attribute__((swift_name("doCopy(passphrase:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *passphrase __attribute__((swift_name("passphrase")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.RegisterStage2Response0")))
@interface MultipazCloudSecureAreaProtocolRegisterStage2Response0 : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithServerState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("init(serverState:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolRegisterStage2Response0 *)doCopyServerState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("doCopy(serverState:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinByteArray *serverState __attribute__((swift_name("serverState")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.SignRequest0")))
@interface MultipazCloudSecureAreaProtocolSignRequest0 : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithDataToSign:(MultipazKotlinByteArray *)dataToSign keyContext:(MultipazKotlinByteArray *)keyContext __attribute__((swift_name("init(dataToSign:keyContext:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolSignRequest0 *)doCopyDataToSign:(MultipazKotlinByteArray *)dataToSign keyContext:(MultipazKotlinByteArray *)keyContext __attribute__((swift_name("doCopy(dataToSign:keyContext:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinByteArray *dataToSign __attribute__((swift_name("dataToSign")));
@property (readonly) MultipazKotlinByteArray *keyContext __attribute__((swift_name("keyContext")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.SignRequest1")))
@interface MultipazCloudSecureAreaProtocolSignRequest1 : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithSignature:(MultipazEcSignature *)signature passphrase:(NSString * _Nullable)passphrase serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("init(signature:passphrase:serverState:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolSignRequest1 *)doCopySignature:(MultipazEcSignature *)signature passphrase:(NSString * _Nullable)passphrase serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("doCopy(signature:passphrase:serverState:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString * _Nullable passphrase __attribute__((swift_name("passphrase")));
@property (readonly) MultipazKotlinByteArray *serverState __attribute__((swift_name("serverState")));
@property (readonly) MultipazEcSignature *signature __attribute__((swift_name("signature")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.SignResponse0")))
@interface MultipazCloudSecureAreaProtocolSignResponse0 : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithCloudNonce:(MultipazKotlinByteArray *)cloudNonce serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("init(cloudNonce:serverState:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolSignResponse0 *)doCopyCloudNonce:(MultipazKotlinByteArray *)cloudNonce serverState:(MultipazKotlinByteArray *)serverState __attribute__((swift_name("doCopy(cloudNonce:serverState:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinByteArray *cloudNonce __attribute__((swift_name("cloudNonce")));
@property (readonly) MultipazKotlinByteArray *serverState __attribute__((swift_name("serverState")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudSecureAreaProtocol.SignResponse1")))
@interface MultipazCloudSecureAreaProtocolSignResponse1 : MultipazCloudSecureAreaProtocolCommand
- (instancetype)initWithResult:(int32_t)result signature:(MultipazEcSignature * _Nullable)signature waitDurationMillis:(int64_t)waitDurationMillis __attribute__((swift_name("init(result:signature:waitDurationMillis:)"))) __attribute__((objc_designated_initializer));
- (MultipazCloudSecureAreaProtocolSignResponse1 *)doCopyResult:(int32_t)result signature:(MultipazEcSignature * _Nullable)signature waitDurationMillis:(int64_t)waitDurationMillis __attribute__((swift_name("doCopy(result:signature:waitDurationMillis:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t result __attribute__((swift_name("result")));
@property (readonly) MultipazEcSignature * _Nullable signature __attribute__((swift_name("signature")));
@property (readonly) int64_t waitDurationMillis __attribute__((swift_name("waitDurationMillis")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudUserAuthType")))
@interface MultipazCloudUserAuthType : MultipazKotlinEnum<MultipazCloudUserAuthType *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazCloudUserAuthTypeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) MultipazCloudUserAuthType *passcode __attribute__((swift_name("passcode")));
@property (class, readonly) MultipazCloudUserAuthType *biometric __attribute__((swift_name("biometric")));
+ (MultipazKotlinArray<MultipazCloudUserAuthType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazCloudUserAuthType *> *entries __attribute__((swift_name("entries")));
@property (readonly) int64_t flagValue __attribute__((swift_name("flagValue")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CloudUserAuthType.Companion")))
@interface MultipazCloudUserAuthTypeCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazCloudUserAuthTypeCompanion *shared __attribute__((swift_name("shared")));
- (NSSet<MultipazCloudUserAuthType *> *)decodeSetTypes:(int64_t)types __attribute__((swift_name("decodeSet(types:)")));
- (int64_t)encodeSetTypes:(NSSet<MultipazCloudUserAuthType *> *)types __attribute__((swift_name("encodeSet(types:)")));
@end

__attribute__((swift_name("SecureAreaConfiguration")))
@interface MultipazSecureAreaConfiguration : MultipazBase
@property (class, readonly, getter=companion) MultipazSecureAreaConfigurationCompanion *companion __attribute__((swift_name("companion")));
@property (readonly) NSString *algorithm __attribute__((swift_name("algorithm")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SecureAreaConfiguration.Companion")))
@interface MultipazSecureAreaConfigurationCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazSecureAreaConfigurationCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SecureAreaConfigurationAndroidKeystore")))
@interface MultipazSecureAreaConfigurationAndroidKeystore : MultipazSecureAreaConfiguration
- (instancetype)initWithAlgorithm:(NSString *)algorithm useStrongBox:(BOOL)useStrongBox userAuthenticationRequired:(BOOL)userAuthenticationRequired userAuthenticationTimeoutMillis:(int64_t)userAuthenticationTimeoutMillis userAuthenticationTypes:(int64_t)userAuthenticationTypes __attribute__((swift_name("init(algorithm:useStrongBox:userAuthenticationRequired:userAuthenticationTimeoutMillis:userAuthenticationTypes:)"))) __attribute__((objc_designated_initializer));
@property (readonly) BOOL useStrongBox __attribute__((swift_name("useStrongBox")));
@property (readonly) BOOL userAuthenticationRequired __attribute__((swift_name("userAuthenticationRequired")));
@property (readonly) int64_t userAuthenticationTimeoutMillis __attribute__((swift_name("userAuthenticationTimeoutMillis")));
@property (readonly) int64_t userAuthenticationTypes __attribute__((swift_name("userAuthenticationTypes")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SecureAreaConfigurationCloud")))
@interface MultipazSecureAreaConfigurationCloud : MultipazSecureAreaConfiguration
- (instancetype)initWithAlgorithm:(NSString *)algorithm cloudSecureAreaId:(NSString *)cloudSecureAreaId userAuthenticationRequired:(BOOL)userAuthenticationRequired useStrongBox:(BOOL)useStrongBox userAuthenticationTimeoutMillis:(int64_t)userAuthenticationTimeoutMillis userAuthenticationTypes:(int64_t)userAuthenticationTypes passphraseRequired:(BOOL)passphraseRequired __attribute__((swift_name("init(algorithm:cloudSecureAreaId:userAuthenticationRequired:useStrongBox:userAuthenticationTimeoutMillis:userAuthenticationTypes:passphraseRequired:)"))) __attribute__((objc_designated_initializer));
@property (readonly) NSString *cloudSecureAreaId __attribute__((swift_name("cloudSecureAreaId")));
@property (readonly) BOOL passphraseRequired __attribute__((swift_name("passphraseRequired")));
@property (readonly) BOOL useStrongBox __attribute__((swift_name("useStrongBox")));
@property (readonly) BOOL userAuthenticationRequired __attribute__((swift_name("userAuthenticationRequired")));
@property (readonly) int64_t userAuthenticationTimeoutMillis __attribute__((swift_name("userAuthenticationTimeoutMillis")));
@property (readonly) int64_t userAuthenticationTypes __attribute__((swift_name("userAuthenticationTypes")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SecureAreaConfigurationSoftware")))
@interface MultipazSecureAreaConfigurationSoftware : MultipazSecureAreaConfiguration
- (instancetype)initWithAlgorithm:(NSString *)algorithm passphrase:(NSString * _Nullable)passphrase passphraseConstraints:(MultipazPassphraseConstraints *)passphraseConstraints __attribute__((swift_name("init(algorithm:passphrase:passphraseConstraints:)"))) __attribute__((objc_designated_initializer));
@property (readonly) NSString * _Nullable passphrase __attribute__((swift_name("passphrase")));
@property (readonly) MultipazPassphraseConstraints *passphraseConstraints __attribute__((swift_name("passphraseConstraints")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SoftwareCreateKeySettings")))
@interface MultipazSoftwareCreateKeySettings : MultipazCreateKeySettings
- (instancetype)initWithAlgorithm:(MultipazAlgorithm *)algorithm nonce:(MultipazKotlinx_io_bytestringByteString *)nonce __attribute__((swift_name("init(algorithm:nonce:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (readonly) NSString * _Nullable passphrase __attribute__((swift_name("passphrase")));
@property (readonly) MultipazPassphraseConstraints * _Nullable passphraseConstraints __attribute__((swift_name("passphraseConstraints")));
@property (readonly) BOOL passphraseRequired __attribute__((swift_name("passphraseRequired")));
@property (readonly) NSString * _Nullable subject __attribute__((swift_name("subject")));
@property (readonly) MultipazKotlinx_datetimeInstant * _Nullable validFrom __attribute__((swift_name("validFrom")));
@property (readonly) MultipazKotlinx_datetimeInstant * _Nullable validUntil __attribute__((swift_name("validUntil")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SoftwareCreateKeySettings.Builder")))
@interface MultipazSoftwareCreateKeySettingsBuilder : MultipazBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (MultipazSoftwareCreateKeySettingsBuilder *)applyConfigurationConfiguration:(MultipazSecureAreaConfigurationSoftware *)configuration __attribute__((swift_name("applyConfiguration(configuration:)")));
- (MultipazSoftwareCreateKeySettings *)build __attribute__((swift_name("build()")));
- (MultipazSoftwareCreateKeySettingsBuilder *)setAlgorithmAlgorithm:(MultipazAlgorithm *)algorithm __attribute__((swift_name("setAlgorithm(algorithm:)")));
- (MultipazSoftwareCreateKeySettingsBuilder *)setPassphraseRequiredRequired:(BOOL)required passphrase:(NSString * _Nullable)passphrase constraints:(MultipazPassphraseConstraints * _Nullable)constraints __attribute__((swift_name("setPassphraseRequired(required:passphrase:constraints:)")));
- (MultipazSoftwareCreateKeySettingsBuilder *)setSubjectSubject:(NSString * _Nullable)subject __attribute__((swift_name("setSubject(subject:)")));
- (MultipazSoftwareCreateKeySettingsBuilder *)setValidityPeriodValidFrom:(MultipazKotlinx_datetimeInstant *)validFrom validUntil:(MultipazKotlinx_datetimeInstant *)validUntil __attribute__((swift_name("setValidityPeriod(validFrom:validUntil:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SoftwareKeyInfo")))
@interface MultipazSoftwareKeyInfo : MultipazKeyInfo

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (instancetype)initWithAlias:(NSString *)alias algorithm:(MultipazAlgorithm *)algorithm publicKey:(MultipazEcPublicKey *)publicKey attestation:(MultipazKeyAttestation *)attestation __attribute__((swift_name("init(alias:algorithm:publicKey:attestation:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (readonly) BOOL isPassphraseProtected __attribute__((swift_name("isPassphraseProtected")));
@property (readonly) MultipazPassphraseConstraints * _Nullable passphraseConstraints __attribute__((swift_name("passphraseConstraints")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SoftwareKeyUnlockData")))
@interface MultipazSoftwareKeyUnlockData : MultipazBase <MultipazKeyUnlockData>
- (instancetype)initWithPassphrase:(NSString *)passphrase __attribute__((swift_name("init(passphrase:)"))) __attribute__((objc_designated_initializer));
@property (readonly) NSString *passphrase __attribute__((swift_name("passphrase")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SoftwareSecureArea")))
@interface MultipazSoftwareSecureArea : MultipazBase <MultipazSecureArea>
@property (class, readonly, getter=companion) MultipazSoftwareSecureAreaCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)createKeyAlias:(NSString * _Nullable)alias createKeySettings:(MultipazCreateKeySettings *)createKeySettings completionHandler:(void (^)(MultipazSoftwareKeyInfo * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("createKey(alias:createKeySettings:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)deleteKeyAlias:(NSString *)alias completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("deleteKey(alias:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getKeyInfoAlias:(NSString *)alias completionHandler:(void (^)(MultipazSoftwareKeyInfo * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getKeyInfo(alias:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getKeyInvalidatedAlias:(NSString *)alias completionHandler:(void (^)(MultipazBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getKeyInvalidated(alias:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getPrivateKeyAlias:(NSString *)alias keyUnlockData:(id<MultipazKeyUnlockData> _Nullable)keyUnlockData completionHandler:(void (^)(MultipazEcPrivateKey * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getPrivateKey(alias:keyUnlockData:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)keyAgreementAlias:(NSString *)alias otherKey:(MultipazEcPublicKey *)otherKey keyUnlockData:(id<MultipazKeyUnlockData> _Nullable)keyUnlockData completionHandler:(void (^)(MultipazKotlinByteArray * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("keyAgreement(alias:otherKey:keyUnlockData:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)signAlias:(NSString *)alias dataToSign:(MultipazKotlinByteArray *)dataToSign keyUnlockData:(id<MultipazKeyUnlockData> _Nullable)keyUnlockData completionHandler:(void (^)(MultipazEcSignature * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("sign(alias:dataToSign:keyUnlockData:completionHandler:)")));
@property (readonly) NSString *displayName __attribute__((swift_name("displayName")));
@property (readonly) NSString *identifier __attribute__((swift_name("identifier")));
@property (readonly) NSArray<MultipazAlgorithm *> *supportedAlgorithms __attribute__((swift_name("supportedAlgorithms")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SoftwareSecureArea.Companion")))
@interface MultipazSoftwareSecureAreaCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazSoftwareSecureAreaCompanion *shared __attribute__((swift_name("shared")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)createStorage:(id<MultipazStorage>)storage completionHandler:(void (^)(MultipazSoftwareSecureArea * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("create(storage:completionHandler:)")));
@property (readonly) NSString *IDENTIFIER __attribute__((swift_name("IDENTIFIER")));
@end

__attribute__((swift_name("StorageEngine")))
@protocol MultipazStorageEngine
@required
- (void)deleteKey:(NSString *)key __attribute__((swift_name("delete(key:)")));
- (void)deleteAll __attribute__((swift_name("deleteAll()")));
- (id)enumerate __attribute__((swift_name("enumerate()")));
- (MultipazKotlinByteArray * _Nullable)getKey_:(NSString *)key __attribute__((swift_name("get(key_:)")));
- (void)putKey:(NSString *)key data:(MultipazKotlinByteArray *)data __attribute__((swift_name("put(key:data:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EphemeralStorageEngine")))
@interface MultipazEphemeralStorageEngine : MultipazBase <MultipazStorageEngine>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (class, readonly, getter=companion) MultipazEphemeralStorageEngineCompanion *companion __attribute__((swift_name("companion")));
- (void)deleteKey:(NSString *)key __attribute__((swift_name("delete(key:)")));
- (void)deleteAll __attribute__((swift_name("deleteAll()")));
- (id)enumerate __attribute__((swift_name("enumerate()")));
- (MultipazKotlinByteArray * _Nullable)getKey_:(NSString *)key __attribute__((swift_name("get(key_:)")));
- (void)putKey:(NSString *)key data:(MultipazKotlinByteArray *)data __attribute__((swift_name("put(key:data:)")));
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EphemeralStorageEngine.Companion")))
@interface MultipazEphemeralStorageEngineCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazEphemeralStorageEngineCompanion *shared __attribute__((swift_name("shared")));
- (MultipazEphemeralStorageEngine *)fromCborEncodedData:(MultipazKotlinByteArray *)encodedData __attribute__((swift_name("fromCbor(encodedData:)")));
@end

__attribute__((swift_name("GenericStorageEngine")))
@interface MultipazGenericStorageEngine : MultipazBase <MultipazStorageEngine>
- (instancetype)initWithStorageFile:(MultipazKotlinx_io_corePath *)storageFile __attribute__((swift_name("init(storageFile:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazGenericStorageEngineCompanion *companion __attribute__((swift_name("companion")));
- (void)deleteKey:(NSString *)key __attribute__((swift_name("delete(key:)")));
- (void)deleteAll __attribute__((swift_name("deleteAll()")));
- (id)enumerate __attribute__((swift_name("enumerate()")));
- (MultipazKotlinByteArray * _Nullable)getKey_:(NSString *)key __attribute__((swift_name("get(key_:)")));
- (void)putKey:(NSString *)key data:(MultipazKotlinByteArray *)data __attribute__((swift_name("put(key:data:)")));
- (MultipazKotlinByteArray *)transformData:(MultipazKotlinByteArray *)data isLoading:(BOOL)isLoading __attribute__((swift_name("transform(data:isLoading:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("GenericStorageEngine.Companion")))
@interface MultipazGenericStorageEngineCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazGenericStorageEngineCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((swift_name("StorageException")))
@interface MultipazStorageException : MultipazKotlinException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KeyExistsStorageException")))
@interface MultipazKeyExistsStorageException : MultipazStorageException
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NoRecordStorageException")))
@interface MultipazNoRecordStorageException : MultipazStorageException
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((swift_name("Storage")))
@protocol MultipazStorage
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getTableSpec:(MultipazStorageTableSpec *)spec completionHandler:(void (^)(id<MultipazStorageTable> _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getTable(spec:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)purgeExpiredWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("purgeExpired(completionHandler:)")));
@end

__attribute__((swift_name("StorageTable")))
@protocol MultipazStorageTable
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)deleteKey:(NSString *)key partitionId:(NSString * _Nullable)partitionId completionHandler:(void (^)(MultipazBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("delete(key:partitionId:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)deleteAllWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("deleteAll(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)deletePartitionPartitionId:(NSString *)partitionId completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("deletePartition(partitionId:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)enumeratePartitionId:(NSString * _Nullable)partitionId afterKey:(NSString * _Nullable)afterKey limit:(int32_t)limit completionHandler:(void (^)(NSArray<NSString *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("enumerate(partitionId:afterKey:limit:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getKey:(NSString *)key partitionId:(NSString * _Nullable)partitionId completionHandler:(void (^)(MultipazKotlinx_io_bytestringByteString * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("get(key:partitionId:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)insertKey:(NSString * _Nullable)key data:(MultipazKotlinx_io_bytestringByteString *)data partitionId:(NSString * _Nullable)partitionId expiration:(MultipazKotlinx_datetimeInstant *)expiration completionHandler:(void (^)(NSString * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("insert(key:data:partitionId:expiration:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)updateKey:(NSString *)key data:(MultipazKotlinx_io_bytestringByteString *)data partitionId:(NSString * _Nullable)partitionId expiration:(MultipazKotlinx_datetimeInstant * _Nullable)expiration completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("update(key:data:partitionId:expiration:completionHandler:)")));
@property (readonly) id<MultipazStorage> storage __attribute__((swift_name("storage")));
@end

__attribute__((swift_name("StorageTableSpec")))
@interface MultipazStorageTableSpec : MultipazBase
- (instancetype)initWithName:(NSString *)name supportPartitions:(BOOL)supportPartitions supportExpiration:(BOOL)supportExpiration schemaVersion:(int64_t)schemaVersion __attribute__((swift_name("init(name:supportPartitions:supportExpiration:schemaVersion:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazStorageTableSpecCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)schemaUpgradeOldTable:(MultipazBaseStorageTable *)oldTable completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("schemaUpgrade(oldTable:completionHandler:)")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@property (readonly) int64_t schemaVersion __attribute__((swift_name("schemaVersion")));
@property (readonly) BOOL supportExpiration __attribute__((swift_name("supportExpiration")));
@property (readonly) BOOL supportPartitions __attribute__((swift_name("supportPartitions")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("StorageTableSpec.Companion")))
@interface MultipazStorageTableSpecCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazStorageTableSpecCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((swift_name("BaseStorage")))
@interface MultipazBaseStorage : MultipazBase <MultipazStorage>
- (instancetype)initWithClock:(id<MultipazKotlinx_datetimeClock>)clock __attribute__((swift_name("init(clock:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazBaseStorageCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)createTableTableSpec:(MultipazStorageTableSpec *)tableSpec completionHandler:(void (^)(MultipazBaseStorageTable * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("createTable(tableSpec:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)enumerateTablesWithCompletionHandler:(void (^)(NSArray<MultipazBaseStorageTable *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("enumerateTables(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getTableSpec:(MultipazStorageTableSpec *)spec completionHandler:(void (^)(id<MultipazStorageTable> _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getTable(spec:completionHandler:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)doInitTablesTables:(NSArray<MultipazBaseStorageTable *> *)tables __attribute__((swift_name("doInitTables(tables:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)purgeExpiredWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("purgeExpired(completionHandler:)")));
@property (readonly) id<MultipazKotlinx_datetimeClock> clock __attribute__((swift_name("clock")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BaseStorage.Companion")))
@interface MultipazBaseStorageCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazBaseStorageCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) int32_t MAX_KEY_SIZE __attribute__((swift_name("MAX_KEY_SIZE")));
@property (readonly) int32_t MAX_TABLE_NAME_LENGTH __attribute__((swift_name("MAX_TABLE_NAME_LENGTH")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BaseStorage.SchemaTableSpec")))
@interface MultipazBaseStorageSchemaTableSpec : MultipazStorageTableSpec
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name supportPartitions:(BOOL)supportPartitions supportExpiration:(BOOL)supportExpiration schemaVersion:(int64_t)schemaVersion __attribute__((swift_name("init(name:supportPartitions:supportExpiration:schemaVersion:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)schemaTableSpec __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazBaseStorageSchemaTableSpec *shared __attribute__((swift_name("shared")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)schemaUpgradeOldTable:(MultipazBaseStorageTable *)oldTable completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("schemaUpgrade(oldTable:completionHandler:)")));
@end

__attribute__((swift_name("Kotlinx_datetimeClock")))
@protocol MultipazKotlinx_datetimeClock
@required
- (MultipazKotlinx_datetimeInstant *)now __attribute__((swift_name("now()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BaseStorage.StoppedClock")))
@interface MultipazBaseStorageStoppedClock : MultipazBase <MultipazKotlinx_datetimeClock>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)stoppedClock __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazBaseStorageStoppedClock *shared __attribute__((swift_name("shared")));
- (MultipazKotlinx_datetimeInstant *)now __attribute__((swift_name("now()")));
@end

__attribute__((swift_name("BaseStorageTable")))
@interface MultipazBaseStorageTable : MultipazBase <MultipazStorageTable>
- (instancetype)initWithSpec:(MultipazStorageTableSpec *)spec __attribute__((swift_name("init(spec:)"))) __attribute__((objc_designated_initializer));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)checkExpirationExpiration:(MultipazKotlinx_datetimeInstant *)expiration __attribute__((swift_name("checkExpiration(expiration:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)checkKeyKey:(NSString *)key __attribute__((swift_name("checkKey(key:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)checkLimitLimit:(int32_t)limit __attribute__((swift_name("checkLimit(limit:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)checkPartitionPartitionId:(NSString * _Nullable)partitionId __attribute__((swift_name("checkPartition(partitionId:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)purgeExpiredWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("purgeExpired(completionHandler:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (NSString *)recordDescriptionKey:(NSString *)key partitionId:(NSString * _Nullable)partitionId __attribute__((swift_name("recordDescription(key:partitionId:)")));
@property (readonly) MultipazStorageTableSpec *spec __attribute__((swift_name("spec")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SqlStatementMaker")))
@interface MultipazSqlStatementMaker : MultipazBase
- (instancetype)initWithSpec:(MultipazStorageTableSpec *)spec textType:(NSString *)textType blobType:(NSString *)blobType longType:(NSString *)longType useReturningClause:(BOOL)useReturningClause collationCharset:(NSString * _Nullable)collationCharset __attribute__((swift_name("init(spec:textType:blobType:longType:useReturningClause:collationCharset:)"))) __attribute__((objc_designated_initializer));
- (NSString *)conditionWithExpirationNowSeconds:(int64_t)nowSeconds __attribute__((swift_name("conditionWithExpiration(nowSeconds:)")));
- (NSString *)enumerateConditionWithExpirationNowSeconds:(int64_t)nowSeconds __attribute__((swift_name("enumerateConditionWithExpiration(nowSeconds:)")));
- (NSString *)purgeExpiredWithIdConditionTimeSeconds:(int64_t)timeSeconds __attribute__((swift_name("purgeExpiredWithIdCondition(timeSeconds:)")));
@property (readonly) NSString *blobType __attribute__((swift_name("blobType")));
@property (readonly) NSString *createTableStatement __attribute__((swift_name("createTableStatement")));
@property (readonly) NSString *deleteAllInPartitionStatement __attribute__((swift_name("deleteAllInPartitionStatement")));
@property (readonly) NSString *deleteAllStatement __attribute__((swift_name("deleteAllStatement")));
@property (readonly) NSString *deleteOrUpdateCheckStatement __attribute__((swift_name("deleteOrUpdateCheckStatement")));
@property (readonly) NSString *deleteStatement __attribute__((swift_name("deleteStatement")));
@property (readonly) NSString *enumerateStatement __attribute__((swift_name("enumerateStatement")));
@property (readonly) NSString *enumerateWithLimitStatement __attribute__((swift_name("enumerateWithLimitStatement")));
@property (readonly) NSString *getStatement __attribute__((swift_name("getStatement")));
@property (readonly) NSString *insertStatement __attribute__((swift_name("insertStatement")));
@property (readonly) NSString *longType __attribute__((swift_name("longType")));
@property (readonly) NSString *purgeExpiredStatement __attribute__((swift_name("purgeExpiredStatement")));
@property (readonly) NSString *purgeExpiredWithIdStatement __attribute__((swift_name("purgeExpiredWithIdStatement")));
@property (readonly) MultipazStorageTableSpec *spec __attribute__((swift_name("spec")));
@property (readonly) NSString *tableName __attribute__((swift_name("tableName")));
@property (readonly) NSString *textType __attribute__((swift_name("textType")));
@property (readonly) NSString *updateStatement __attribute__((swift_name("updateStatement")));
@property (readonly) NSString *updateWithExpirationStatement __attribute__((swift_name("updateWithExpirationStatement")));
@property (readonly) BOOL useReturningClause __attribute__((swift_name("useReturningClause")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EphemeralStorage")))
@interface MultipazEphemeralStorage : MultipazBaseStorage
- (instancetype)initWithClock:(id<MultipazKotlinx_datetimeClock>)clock __attribute__((swift_name("init(clock:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazEphemeralStorageCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)createTableTableSpec:(MultipazStorageTableSpec *)tableSpec completionHandler:(void (^)(MultipazBaseStorageTable * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("createTable(tableSpec:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)serializeWithCompletionHandler:(void (^)(MultipazKotlinx_io_bytestringByteString * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("serialize(completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EphemeralStorage.Companion")))
@interface MultipazEphemeralStorageCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazEphemeralStorageCompanion *shared __attribute__((swift_name("shared")));
- (MultipazEphemeralStorage *)deserializeData:(MultipazKotlinx_io_bytestringByteString *)data clock:(id<MultipazKotlinx_datetimeClock>)clock __attribute__((swift_name("deserialize(data:clock:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EphemeralStorageItem")))
@interface MultipazEphemeralStorageItem : MultipazBase <MultipazKotlinComparable>
- (instancetype)initWithPartitionId:(NSString * _Nullable)partitionId key:(NSString *)key value:(MultipazKotlinx_io_bytestringByteString *)value expiration:(MultipazKotlinx_datetimeInstant *)expiration __attribute__((swift_name("init(partitionId:key:value:expiration:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazEphemeralStorageItemCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(MultipazEphemeralStorageItem *)other __attribute__((swift_name("compareTo(other:)")));
- (BOOL)expiredNow:(MultipazKotlinx_datetimeInstant *)now __attribute__((swift_name("expired(now:)")));
@property MultipazKotlinx_datetimeInstant *expiration __attribute__((swift_name("expiration")));
@property (readonly) NSString *key __attribute__((swift_name("key")));
@property (readonly) NSString * _Nullable partitionId __attribute__((swift_name("partitionId")));
@property MultipazKotlinx_io_bytestringByteString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EphemeralStorageItem.Companion")))
@interface MultipazEphemeralStorageItemCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazEphemeralStorageItemCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SqliteStorage")))
@interface MultipazSqliteStorage : MultipazBaseStorage
- (instancetype)initWithConnection:(id<MultipazSqliteSQLiteConnection>)connection clock:(id<MultipazKotlinx_datetimeClock>)clock coroutineContext:(id<MultipazKotlinCoroutineContext>)coroutineContext keySize:(int32_t)keySize __attribute__((swift_name("init(connection:clock:coroutineContext:keySize:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithClock:(id<MultipazKotlinx_datetimeClock>)clock __attribute__((swift_name("init(clock:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)createTableTableSpec:(MultipazStorageTableSpec *)tableSpec completionHandler:(void (^)(MultipazBaseStorageTable * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("createTable(tableSpec:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SqliteStorageTable")))
@interface MultipazSqliteStorageTable : MultipazBaseStorageTable
- (instancetype)initWithStorage:(MultipazSqliteStorage *)storage spec:(MultipazStorageTableSpec *)spec __attribute__((swift_name("init(storage:spec:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithSpec:(MultipazStorageTableSpec *)spec __attribute__((swift_name("init(spec:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)deleteKey:(NSString *)key partitionId:(NSString * _Nullable)partitionId completionHandler:(void (^)(MultipazBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("delete(key:partitionId:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)deleteAllWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("deleteAll(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)deletePartitionPartitionId:(NSString *)partitionId completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("deletePartition(partitionId:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)enumeratePartitionId:(NSString * _Nullable)partitionId afterKey:(NSString * _Nullable)afterKey limit:(int32_t)limit completionHandler:(void (^)(NSArray<NSString *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("enumerate(partitionId:afterKey:limit:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getKey:(NSString *)key partitionId:(NSString * _Nullable)partitionId completionHandler:(void (^)(MultipazKotlinx_io_bytestringByteString * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("get(key:partitionId:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)insertKey:(NSString * _Nullable)key data:(MultipazKotlinx_io_bytestringByteString *)data partitionId:(NSString * _Nullable)partitionId expiration:(MultipazKotlinx_datetimeInstant *)expiration completionHandler:(void (^)(NSString * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("insert(key:data:partitionId:expiration:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)purgeExpiredWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("purgeExpired(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)updateKey:(NSString *)key data:(MultipazKotlinx_io_bytestringByteString *)data partitionId:(NSString * _Nullable)partitionId expiration:(MultipazKotlinx_datetimeInstant * _Nullable)expiration completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("update(key:data:partitionId:expiration:completionHandler:)")));
@property (readonly) MultipazSqliteStorage *storage __attribute__((swift_name("storage")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TrustManager")))
@interface MultipazTrustManager : MultipazBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (void)addTrustPointTrustPoint:(MultipazTrustPoint *)trustPoint __attribute__((swift_name("addTrustPoint(trustPoint:)")));
- (NSArray<MultipazTrustPoint *> *)getAllTrustPoints __attribute__((swift_name("getAllTrustPoints()")));
- (void)removeTrustPointTrustPoint:(MultipazTrustPoint *)trustPoint __attribute__((swift_name("removeTrustPoint(trustPoint:)")));
- (MultipazTrustManagerTrustResult *)verifyChain:(NSArray<MultipazX509Cert *> *)chain atTime:(MultipazKotlinx_datetimeInstant *)atTime __attribute__((swift_name("verify(chain:atTime:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TrustManager.TrustResult")))
@interface MultipazTrustManagerTrustResult : MultipazBase
- (instancetype)initWithIsTrusted:(BOOL)isTrusted trustChain:(MultipazX509CertChain * _Nullable)trustChain trustPoints:(NSArray<MultipazTrustPoint *> *)trustPoints error:(MultipazKotlinThrowable * _Nullable)error __attribute__((swift_name("init(isTrusted:trustChain:trustPoints:error:)"))) __attribute__((objc_designated_initializer));
- (MultipazTrustManagerTrustResult *)doCopyIsTrusted:(BOOL)isTrusted trustChain:(MultipazX509CertChain * _Nullable)trustChain trustPoints:(NSArray<MultipazTrustPoint *> *)trustPoints error:(MultipazKotlinThrowable * _Nullable)error __attribute__((swift_name("doCopy(isTrusted:trustChain:trustPoints:error:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinThrowable * _Nullable error __attribute__((swift_name("error")));
@property (readonly) BOOL isTrusted __attribute__((swift_name("isTrusted")));
@property (readonly) MultipazX509CertChain * _Nullable trustChain __attribute__((swift_name("trustChain")));
@property (readonly) NSArray<MultipazTrustPoint *> *trustPoints __attribute__((swift_name("trustPoints")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TrustPoint")))
@interface MultipazTrustPoint : MultipazBase
- (instancetype)initWithCertificate:(MultipazX509Cert *)certificate displayName:(NSString * _Nullable)displayName displayIcon:(MultipazKotlinByteArray * _Nullable)displayIcon __attribute__((swift_name("init(certificate:displayName:displayIcon:)"))) __attribute__((objc_designated_initializer));
- (MultipazTrustPoint *)doCopyCertificate:(MultipazX509Cert *)certificate displayName:(NSString * _Nullable)displayName displayIcon:(MultipazKotlinByteArray * _Nullable)displayIcon __attribute__((swift_name("doCopy(certificate:displayName:displayIcon:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazX509Cert *certificate __attribute__((swift_name("certificate")));
@property (readonly) MultipazKotlinByteArray * _Nullable displayIcon __attribute__((swift_name("displayIcon")));
@property (readonly) NSString * _Nullable displayName __attribute__((swift_name("displayName")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AndroidAttestationExtensionParser")))
@interface MultipazAndroidAttestationExtensionParser : MultipazBase
- (instancetype)initWithCert:(MultipazX509Cert *)cert __attribute__((swift_name("init(cert:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazAndroidAttestationExtensionParserCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)getSoftwareAuthorizationBooleanTag:(int32_t)tag __attribute__((swift_name("getSoftwareAuthorizationBoolean(tag:)")));
- (MultipazKotlinByteArray * _Nullable)getSoftwareAuthorizationByteStringTag:(int32_t)tag __attribute__((swift_name("getSoftwareAuthorizationByteString(tag:)")));
- (MultipazInt * _Nullable)getSoftwareAuthorizationIntegerTag:(int32_t)tag __attribute__((swift_name("getSoftwareAuthorizationInteger(tag:)")));
- (MultipazLong * _Nullable)getSoftwareAuthorizationLongTag:(int32_t)tag __attribute__((swift_name("getSoftwareAuthorizationLong(tag:)")));
- (MultipazASN1Object *)getSoftwareAuthorizationValueTag:(int32_t)tag __attribute__((swift_name("getSoftwareAuthorizationValue(tag:)")));
- (BOOL)getTeeAuthorizationBooleanTag:(int32_t)tag __attribute__((swift_name("getTeeAuthorizationBoolean(tag:)")));
- (MultipazKotlinByteArray * _Nullable)getTeeAuthorizationByteStringTag:(int32_t)tag __attribute__((swift_name("getTeeAuthorizationByteString(tag:)")));
- (MultipazInt * _Nullable)getTeeAuthorizationIntegerTag:(int32_t)tag __attribute__((swift_name("getTeeAuthorizationInteger(tag:)")));
- (MultipazLong * _Nullable)getTeeAuthorizationLongTag:(int32_t)tag __attribute__((swift_name("getTeeAuthorizationLong(tag:)")));
- (MultipazASN1Object *)getTeeAuthorizationValueTag:(int32_t)tag __attribute__((swift_name("getTeeAuthorizationValue(tag:)")));
- (int64_t)getUserAuthenticationType __attribute__((swift_name("getUserAuthenticationType()")));
- (NSString *)prettyPrint __attribute__((swift_name("prettyPrint()")));
@property (readonly) NSArray<MultipazKotlinx_io_bytestringByteString *> *applicationSignatureDigests __attribute__((swift_name("applicationSignatureDigests")));
@property (readonly) MultipazKotlinByteArray *attestationChallenge __attribute__((swift_name("attestationChallenge")));
@property (readonly) MultipazAndroidAttestationExtensionParserSecurityLevel *attestationSecurityLevel __attribute__((swift_name("attestationSecurityLevel")));
@property (readonly) int32_t attestationVersion __attribute__((swift_name("attestationVersion")));
@property (readonly) MultipazAndroidAttestationExtensionParserSecurityLevel *keymasterSecurityLevel __attribute__((swift_name("keymasterSecurityLevel")));
@property (readonly) int32_t keymasterVersion __attribute__((swift_name("keymasterVersion")));
@property (readonly) NSSet<MultipazInt *> *softwareEnforcedAuthorizationTags __attribute__((swift_name("softwareEnforcedAuthorizationTags")));
@property (readonly) NSSet<MultipazInt *> *teeEnforcedAuthorizationTags __attribute__((swift_name("teeEnforcedAuthorizationTags")));
@property (readonly) MultipazKotlinByteArray *uniqueId __attribute__((swift_name("uniqueId")));
@property (readonly) MultipazAndroidAttestationExtensionParserVerifiedBootState *verifiedBootState __attribute__((swift_name("verifiedBootState")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AndroidAttestationExtensionParser.Companion")))
@interface MultipazAndroidAttestationExtensionParserCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazAndroidAttestationExtensionParserCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AndroidAttestationExtensionParser.SecurityLevel")))
@interface MultipazAndroidAttestationExtensionParserSecurityLevel : MultipazKotlinEnum<MultipazAndroidAttestationExtensionParserSecurityLevel *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) MultipazAndroidAttestationExtensionParserSecurityLevel *software __attribute__((swift_name("software")));
@property (class, readonly) MultipazAndroidAttestationExtensionParserSecurityLevel *trustedEnvironment __attribute__((swift_name("trustedEnvironment")));
@property (class, readonly) MultipazAndroidAttestationExtensionParserSecurityLevel *strongBox __attribute__((swift_name("strongBox")));
+ (MultipazKotlinArray<MultipazAndroidAttestationExtensionParserSecurityLevel *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazAndroidAttestationExtensionParserSecurityLevel *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AndroidAttestationExtensionParser.VerifiedBootState")))
@interface MultipazAndroidAttestationExtensionParserVerifiedBootState : MultipazKotlinEnum<MultipazAndroidAttestationExtensionParserVerifiedBootState *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) MultipazAndroidAttestationExtensionParserVerifiedBootState *unknown __attribute__((swift_name("unknown")));
@property (class, readonly) MultipazAndroidAttestationExtensionParserVerifiedBootState *green __attribute__((swift_name("green")));
@property (class, readonly) MultipazAndroidAttestationExtensionParserVerifiedBootState *yellow __attribute__((swift_name("yellow")));
@property (class, readonly) MultipazAndroidAttestationExtensionParserVerifiedBootState *orange __attribute__((swift_name("orange")));
@property (class, readonly) MultipazAndroidAttestationExtensionParserVerifiedBootState *red __attribute__((swift_name("red")));
+ (MultipazKotlinArray<MultipazAndroidAttestationExtensionParserVerifiedBootState *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazAndroidAttestationExtensionParserVerifiedBootState *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ByteDataReader")))
@interface MultipazByteDataReader : MultipazBase
- (instancetype)initWithByteArray:(MultipazKotlinByteArray *)byteArray __attribute__((swift_name("init(byteArray:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithByteString:(MultipazKotlinx_io_bytestringByteString *)byteString __attribute__((swift_name("init(byteString:)"))) __attribute__((objc_designated_initializer));
- (BOOL)exhausted __attribute__((swift_name("exhausted()")));
- (MultipazKotlinx_io_bytestringByteString *)getByteStringNumBytes:(int32_t)numBytes __attribute__((swift_name("getByteString(numBytes:)")));
- (int16_t)getInt16 __attribute__((swift_name("getInt16()")));
- (int16_t)getInt16Le __attribute__((swift_name("getInt16Le()")));
- (int32_t)getInt32 __attribute__((swift_name("getInt32()")));
- (int32_t)getInt32Le __attribute__((swift_name("getInt32Le()")));
- (int64_t)getInt64 __attribute__((swift_name("getInt64()")));
- (int64_t)getInt64Le __attribute__((swift_name("getInt64Le()")));
- (int8_t)getInt8 __attribute__((swift_name("getInt8()")));
- (NSString *)getStringNumBytes:(int32_t)numBytes __attribute__((swift_name("getString(numBytes:)")));
- (uint16_t)getUInt16 __attribute__((swift_name("getUInt16()")));
- (uint16_t)getUInt16Le __attribute__((swift_name("getUInt16Le()")));
- (uint32_t)getUInt32 __attribute__((swift_name("getUInt32()")));
- (uint32_t)getUInt32Le __attribute__((swift_name("getUInt32Le()")));
- (uint64_t)getUInt64 __attribute__((swift_name("getUInt64()")));
- (uint64_t)getUInt64Le __attribute__((swift_name("getUInt64Le()")));
- (uint8_t)getUInt8 __attribute__((swift_name("getUInt8()")));
- (int32_t)numBytesRemaining __attribute__((swift_name("numBytesRemaining()")));
- (MultipazKotlinx_io_bytestringByteString *)peekByteStringNumBytes:(int32_t)numBytes __attribute__((swift_name("peekByteString(numBytes:)")));
- (int16_t)peekInt16 __attribute__((swift_name("peekInt16()")));
- (int16_t)peekInt16Le __attribute__((swift_name("peekInt16Le()")));
- (int32_t)peekInt32 __attribute__((swift_name("peekInt32()")));
- (int32_t)peekInt32Le __attribute__((swift_name("peekInt32Le()")));
- (int64_t)peekInt64 __attribute__((swift_name("peekInt64()")));
- (int64_t)peekInt64Le __attribute__((swift_name("peekInt64Le()")));
- (int8_t)peekInt8 __attribute__((swift_name("peekInt8()")));
- (NSString *)peekStringNumBytes:(int32_t)numBytes __attribute__((swift_name("peekString(numBytes:)")));
- (uint16_t)peekUInt16 __attribute__((swift_name("peekUInt16()")));
- (uint16_t)peekUInt16Le __attribute__((swift_name("peekUInt16Le()")));
- (uint32_t)peekUInt32 __attribute__((swift_name("peekUInt32()")));
- (uint32_t)peekUInt32Le __attribute__((swift_name("peekUInt32Le()")));
- (uint64_t)peekUInt64 __attribute__((swift_name("peekUInt64()")));
- (uint64_t)peekUInt64Le __attribute__((swift_name("peekUInt64Le()")));
- (uint8_t)peekUInt8 __attribute__((swift_name("peekUInt8()")));
- (MultipazByteDataReader *)skipNumBytes:(int32_t)numBytes __attribute__((swift_name("skip(numBytes:)")));
@property (readonly) MultipazKotlinByteArray *byteArray __attribute__((swift_name("byteArray")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Constants")))
@interface MultipazConstants : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)constants __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazConstants *shared __attribute__((swift_name("shared")));
@property (readonly) int32_t BLE_DATA_RETRIEVAL_CLEAR_CACHE __attribute__((swift_name("BLE_DATA_RETRIEVAL_CLEAR_CACHE")));
@property (readonly) int32_t BLE_DATA_RETRIEVAL_OPTION_L2CAP __attribute__((swift_name("BLE_DATA_RETRIEVAL_OPTION_L2CAP")));
@property (readonly) int32_t BLE_DATA_RETRIEVAL_OPTION_MDOC_CENTRAL_CLIENT_MODE __attribute__((swift_name("BLE_DATA_RETRIEVAL_OPTION_MDOC_CENTRAL_CLIENT_MODE")));
@property (readonly) int32_t BLE_DATA_RETRIEVAL_OPTION_MDOC_PERIPHERAL_SERVER_MODE __attribute__((swift_name("BLE_DATA_RETRIEVAL_OPTION_MDOC_PERIPHERAL_SERVER_MODE")));
@property (readonly) int64_t DEVICE_RESPONSE_STATUS_CBOR_DECODING_ERROR __attribute__((swift_name("DEVICE_RESPONSE_STATUS_CBOR_DECODING_ERROR")));
@property (readonly) int64_t DEVICE_RESPONSE_STATUS_CBOR_VALIDATION_ERROR __attribute__((swift_name("DEVICE_RESPONSE_STATUS_CBOR_VALIDATION_ERROR")));
@property (readonly) int64_t DEVICE_RESPONSE_STATUS_GENERAL_ERROR __attribute__((swift_name("DEVICE_RESPONSE_STATUS_GENERAL_ERROR")));
@property (readonly) int64_t DEVICE_RESPONSE_STATUS_OK __attribute__((swift_name("DEVICE_RESPONSE_STATUS_OK")));
@property (readonly) int64_t SESSION_DATA_STATUS_ERROR_CBOR_DECODING __attribute__((swift_name("SESSION_DATA_STATUS_ERROR_CBOR_DECODING")));
@property (readonly) int64_t SESSION_DATA_STATUS_ERROR_SESSION_ENCRYPTION __attribute__((swift_name("SESSION_DATA_STATUS_ERROR_SESSION_ENCRYPTION")));
@property (readonly) int64_t SESSION_DATA_STATUS_SESSION_TERMINATION __attribute__((swift_name("SESSION_DATA_STATUS_SESSION_TERMINATION")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("HexUtil")))
@interface MultipazHexUtil : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)hexUtil __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazHexUtil *shared __attribute__((swift_name("shared")));
- (MultipazKotlinByteArray *)fromHexStringWithHex:(NSString *)stringWithHex __attribute__((swift_name("fromHex(stringWithHex:)")));
- (NSString *)toHexBytes:(MultipazKotlinByteArray *)bytes upperCase:(BOOL)upperCase byteDivider:(NSString *)byteDivider decodeAsString:(BOOL)decodeAsString __attribute__((swift_name("toHex(bytes:upperCase:byteDivider:decodeAsString:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Logger")))
@interface MultipazLogger : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)logger __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazLogger *shared __attribute__((swift_name("shared")));
- (void)dTag:(NSString *)tag msg:(NSString *)msg __attribute__((swift_name("d(tag:msg:)")));
- (void)dTag:(NSString *)tag msg:(NSString *)msg throwable:(MultipazKotlinThrowable *)throwable __attribute__((swift_name("d(tag:msg:throwable:)")));
- (void)dCborTag:(NSString *)tag message:(NSString *)message encodedCbor:(MultipazKotlinByteArray *)encodedCbor __attribute__((swift_name("dCbor(tag:message:encodedCbor:)")));
- (void)dHexTag:(NSString *)tag message:(NSString *)message data:(MultipazKotlinByteArray *)data __attribute__((swift_name("dHex(tag:message:data:)")));
- (void)dJsonTag:(NSString *)tag message:(NSString *)message json:(MultipazKotlinx_serialization_jsonJsonElement *)json __attribute__((swift_name("dJson(tag:message:json:)")));
- (void)eTag:(NSString *)tag msg:(NSString *)msg __attribute__((swift_name("e(tag:msg:)")));
- (void)eTag:(NSString *)tag msg:(NSString *)msg throwable:(MultipazKotlinThrowable *)throwable __attribute__((swift_name("e(tag:msg:throwable:)")));
- (void)eCborTag:(NSString *)tag message:(NSString *)message encodedCbor:(MultipazKotlinByteArray *)encodedCbor __attribute__((swift_name("eCbor(tag:message:encodedCbor:)")));
- (void)eHexTag:(NSString *)tag message:(NSString *)message data:(MultipazKotlinByteArray *)data __attribute__((swift_name("eHex(tag:message:data:)")));
- (void)eJsonTag:(NSString *)tag message:(NSString *)message json:(MultipazKotlinx_serialization_jsonJsonElement *)json __attribute__((swift_name("eJson(tag:message:json:)")));
- (void)iTag:(NSString *)tag msg:(NSString *)msg __attribute__((swift_name("i(tag:msg:)")));
- (void)iTag:(NSString *)tag msg:(NSString *)msg throwable:(MultipazKotlinThrowable *)throwable __attribute__((swift_name("i(tag:msg:throwable:)")));
- (void)iCborTag:(NSString *)tag message:(NSString *)message encodedCbor:(MultipazKotlinByteArray *)encodedCbor __attribute__((swift_name("iCbor(tag:message:encodedCbor:)")));
- (void)iHexTag:(NSString *)tag message:(NSString *)message data:(MultipazKotlinByteArray *)data __attribute__((swift_name("iHex(tag:message:data:)")));
- (void)iJsonTag:(NSString *)tag message:(NSString *)message json:(MultipazKotlinx_serialization_jsonJsonElement *)json __attribute__((swift_name("iJson(tag:message:json:)")));
- (void)startLoggingToFileLogPath:(MultipazKotlinx_io_corePath *)logPath __attribute__((swift_name("startLoggingToFile(logPath:)")));
- (void)stopLoggingToFile __attribute__((swift_name("stopLoggingToFile()")));
- (void)wTag:(NSString *)tag msg:(NSString *)msg __attribute__((swift_name("w(tag:msg:)")));
- (void)wTag:(NSString *)tag msg:(NSString *)msg throwable:(MultipazKotlinThrowable *)throwable __attribute__((swift_name("w(tag:msg:throwable:)")));
- (void)wCborTag:(NSString *)tag message:(NSString *)message encodedCbor:(MultipazKotlinByteArray *)encodedCbor __attribute__((swift_name("wCbor(tag:message:encodedCbor:)")));
- (void)wHexTag:(NSString *)tag message:(NSString *)message data:(MultipazKotlinByteArray *)data __attribute__((swift_name("wHex(tag:message:data:)")));
- (void)wJsonTag:(NSString *)tag message:(NSString *)message json:(MultipazKotlinx_serialization_jsonJsonElement *)json __attribute__((swift_name("wJson(tag:message:json:)")));
@property BOOL isDebugEnabled __attribute__((swift_name("isDebugEnabled")));
@property id<MultipazLoggerLogPrinter> _Nullable logPrinter __attribute__((swift_name("logPrinter")));
@end

__attribute__((swift_name("LoggerLogPrinter")))
@protocol MultipazLoggerLogPrinter
@required
- (void)printLevel:(MultipazLoggerLogPrinterLevel *)level tag:(NSString *)tag msg:(NSString *)msg throwable:(MultipazKotlinThrowable * _Nullable)throwable __attribute__((swift_name("print(level:tag:msg:throwable:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("LoggerLogPrinterLevel")))
@interface MultipazLoggerLogPrinterLevel : MultipazKotlinEnum<MultipazLoggerLogPrinterLevel *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) MultipazLoggerLogPrinterLevel *debug __attribute__((swift_name("debug")));
@property (class, readonly) MultipazLoggerLogPrinterLevel *info __attribute__((swift_name("info")));
@property (class, readonly) MultipazLoggerLogPrinterLevel *warning __attribute__((swift_name("warning")));
@property (class, readonly) MultipazLoggerLogPrinterLevel *error __attribute__((swift_name("error")));
+ (MultipazKotlinArray<MultipazLoggerLogPrinterLevel *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazLoggerLogPrinterLevel *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("UUID")))
@interface MultipazUUID : MultipazBase
- (instancetype)initWithMostSignificantBits:(uint64_t)mostSignificantBits leastSignificantBits:(uint64_t)leastSignificantBits __attribute__((swift_name("init(mostSignificantBits:leastSignificantBits:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazUUIDCompanion *companion __attribute__((swift_name("companion")));
- (MultipazUUID *)doCopyMostSignificantBits:(uint64_t)mostSignificantBits leastSignificantBits:(uint64_t)leastSignificantBits __attribute__((swift_name("doCopy(mostSignificantBits:leastSignificantBits:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (MultipazKotlinByteArray *)toByteArray __attribute__((swift_name("toByteArray()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) uint64_t leastSignificantBits __attribute__((swift_name("leastSignificantBits")));
@property (readonly) uint64_t mostSignificantBits __attribute__((swift_name("mostSignificantBits")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("UUID.Companion")))
@interface MultipazUUIDCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazUUIDCompanion *shared __attribute__((swift_name("shared")));
- (MultipazUUID *)fromByteArrayEncodedUuid:(MultipazKotlinByteArray *)encodedUuid __attribute__((swift_name("fromByteArray(encodedUuid:)")));
- (MultipazUUID *)fromStringStr:(NSString *)str __attribute__((swift_name("fromString(str:)")));
- (MultipazUUID *)randomUUID __attribute__((swift_name("randomUUID()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinByteArray")))
@interface MultipazKotlinByteArray : MultipazBase
+ (instancetype)arrayWithSize:(int32_t)size __attribute__((swift_name("init(size:)")));
+ (instancetype)arrayWithSize:(int32_t)size init:(MultipazByte *(^)(MultipazInt *))init __attribute__((swift_name("init(size:init:)")));
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (int8_t)getIndex:(int32_t)index __attribute__((swift_name("get(index:)")));
- (MultipazKotlinByteIterator *)iterator __attribute__((swift_name("iterator()")));
- (void)setIndex:(int32_t)index value:(int8_t)value __attribute__((swift_name("set(index:value:)")));
@property (readonly) int32_t size __attribute__((swift_name("size")));
@end

@interface MultipazKotlinByteArray (Extensions)
- (MultipazKotlinx_io_bytestringByteString *)getByteStringOffset:(int32_t)offset numBytes:(int32_t)numBytes __attribute__((swift_name("getByteString(offset:numBytes:)")));
- (int16_t)getInt16Offset:(int32_t)offset __attribute__((swift_name("getInt16(offset:)")));
- (int16_t)getInt16LeOffset:(int32_t)offset __attribute__((swift_name("getInt16Le(offset:)")));
- (int32_t)getInt32Offset:(int32_t)offset __attribute__((swift_name("getInt32(offset:)")));
- (int32_t)getInt32LeOffset:(int32_t)offset __attribute__((swift_name("getInt32Le(offset:)")));
- (int64_t)getInt64Offset:(int32_t)offset __attribute__((swift_name("getInt64(offset:)")));
- (int64_t)getInt64LeOffset:(int32_t)offset __attribute__((swift_name("getInt64Le(offset:)")));
- (int8_t)getInt8Offset:(int32_t)offset __attribute__((swift_name("getInt8(offset:)")));
- (NSString *)getStringOffset:(int32_t)offset numBytes:(int32_t)numBytes __attribute__((swift_name("getString(offset:numBytes:)")));
- (uint16_t)getUInt16Offset:(int32_t)offset __attribute__((swift_name("getUInt16(offset:)")));
- (uint16_t)getUInt16LeOffset:(int32_t)offset __attribute__((swift_name("getUInt16Le(offset:)")));
- (uint32_t)getUInt32Offset:(int32_t)offset __attribute__((swift_name("getUInt32(offset:)")));
- (uint32_t)getUInt32LeOffset:(int32_t)offset __attribute__((swift_name("getUInt32Le(offset:)")));
- (uint64_t)getUInt64Offset:(int32_t)offset __attribute__((swift_name("getUInt64(offset:)")));
- (uint64_t)getUInt64LeOffset:(int32_t)offset __attribute__((swift_name("getUInt64Le(offset:)")));
- (uint8_t)getUInt8Offset:(int32_t)offset __attribute__((swift_name("getUInt8(offset:)")));
- (void)putInt16Offset:(int32_t)offset value:(int32_t)value validRange:(MultipazKotlinIntRange *)validRange __attribute__((swift_name("putInt16(offset:value:validRange:)")));
- (void)putInt16LeOffset:(int32_t)offset value:(int32_t)value validRange:(MultipazKotlinIntRange *)validRange __attribute__((swift_name("putInt16Le(offset:value:validRange:)")));
- (void)putInt32Offset:(int32_t)offset value:(int32_t)value validRange:(MultipazKotlinIntRange *)validRange __attribute__((swift_name("putInt32(offset:value:validRange:)")));
- (void)putInt32LeOffset:(int32_t)offset value:(int32_t)value validRange:(MultipazKotlinIntRange *)validRange __attribute__((swift_name("putInt32Le(offset:value:validRange:)")));
- (void)putInt64Offset:(int32_t)offset value:(int64_t)value validRange:(MultipazKotlinLongRange *)validRange __attribute__((swift_name("putInt64(offset:value:validRange:)")));
- (void)putInt64LeOffset:(int32_t)offset value:(int64_t)value validRange:(MultipazKotlinLongRange *)validRange __attribute__((swift_name("putInt64Le(offset:value:validRange:)")));
- (void)putInt8Offset:(int32_t)offset value:(int32_t)value validRange:(MultipazKotlinIntRange *)validRange __attribute__((swift_name("putInt8(offset:value:validRange:)")));
- (void)putUInt16Offset:(int32_t)offset value:(uint32_t)value validRange:(MultipazKotlinUIntRange *)validRange __attribute__((swift_name("putUInt16(offset:value:validRange:)")));
- (void)putUInt16LeOffset:(int32_t)offset value:(uint32_t)value validRange:(MultipazKotlinUIntRange *)validRange __attribute__((swift_name("putUInt16Le(offset:value:validRange:)")));
- (void)putUInt32Offset:(int32_t)offset value:(uint32_t)value validRange:(MultipazKotlinUIntRange *)validRange __attribute__((swift_name("putUInt32(offset:value:validRange:)")));
- (void)putUInt32LeOffset:(int32_t)offset value:(uint32_t)value validRange:(MultipazKotlinUIntRange *)validRange __attribute__((swift_name("putUInt32Le(offset:value:validRange:)")));
- (void)putUInt64Offset:(int32_t)offset value:(uint64_t)value validRange:(MultipazKotlinULongRange *)validRange __attribute__((swift_name("putUInt64(offset:value:validRange:)")));
- (void)putUInt64LeOffset:(int32_t)offset value:(uint64_t)value validRange:(MultipazKotlinULongRange *)validRange __attribute__((swift_name("putUInt64Le(offset:value:validRange:)")));
- (void)putUInt8Offset:(int32_t)offset value:(uint32_t)value validRange:(MultipazKotlinUIntRange *)validRange __attribute__((swift_name("putUInt8(offset:value:validRange:)")));
- (NSString *)toBase64 __attribute__((swift_name("toBase64()")));
- (NSString *)toBase64Url __attribute__((swift_name("toBase64Url()")));
- (MultipazBstr *)toDataItem __attribute__((swift_name("toDataItem()")));
- (NSString *)toHexUpperCase:(BOOL)upperCase byteDivider:(NSString *)byteDivider decodeAsString:(BOOL)decodeAsString __attribute__((swift_name("toHex(upperCase:byteDivider:decodeAsString:)")));
- (NSData *)toNSData __attribute__((swift_name("toNSData()")));
- (NSString *)unsignedBigIntToStringBase:(int32_t)base __attribute__((swift_name("unsignedBigIntToString(base:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinDuration.Companion")))
@interface MultipazKotlinDurationCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinDurationCompanion *shared __attribute__((swift_name("shared")));
- (int64_t)days:(double)receiver __attribute__((swift_name("days(_:)")));
- (int64_t)days_:(int32_t)receiver __attribute__((swift_name("days(__:)")));
- (int64_t)days__:(int64_t)receiver __attribute__((swift_name("days(___:)")));
- (int64_t)hours:(double)receiver __attribute__((swift_name("hours(_:)")));
- (int64_t)hours_:(int32_t)receiver __attribute__((swift_name("hours(__:)")));
- (int64_t)hours__:(int64_t)receiver __attribute__((swift_name("hours(___:)")));
- (int64_t)microseconds:(double)receiver __attribute__((swift_name("microseconds(_:)")));
- (int64_t)microseconds_:(int32_t)receiver __attribute__((swift_name("microseconds(__:)")));
- (int64_t)microseconds__:(int64_t)receiver __attribute__((swift_name("microseconds(___:)")));
- (int64_t)milliseconds:(double)receiver __attribute__((swift_name("milliseconds(_:)")));
- (int64_t)milliseconds_:(int32_t)receiver __attribute__((swift_name("milliseconds(__:)")));
- (int64_t)milliseconds__:(int64_t)receiver __attribute__((swift_name("milliseconds(___:)")));
- (int64_t)minutes:(double)receiver __attribute__((swift_name("minutes(_:)")));
- (int64_t)minutes_:(int32_t)receiver __attribute__((swift_name("minutes(__:)")));
- (int64_t)minutes__:(int64_t)receiver __attribute__((swift_name("minutes(___:)")));
- (int64_t)nanoseconds:(double)receiver __attribute__((swift_name("nanoseconds(_:)")));
- (int64_t)nanoseconds_:(int32_t)receiver __attribute__((swift_name("nanoseconds(__:)")));
- (int64_t)nanoseconds__:(int64_t)receiver __attribute__((swift_name("nanoseconds(___:)")));
- (int64_t)seconds:(double)receiver __attribute__((swift_name("seconds(_:)")));
- (int64_t)seconds_:(int32_t)receiver __attribute__((swift_name("seconds(__:)")));
- (int64_t)seconds__:(int64_t)receiver __attribute__((swift_name("seconds(___:)")));

/**
 * @note annotations
 *   kotlin.time.ExperimentalTime
*/
- (double)convertValue:(double)value sourceUnit:(MultipazKotlinDurationUnit *)sourceUnit targetUnit:(MultipazKotlinDurationUnit *)targetUnit __attribute__((swift_name("convert(value:sourceUnit:targetUnit:)")));
- (int64_t)parseValue:(NSString *)value __attribute__((swift_name("parse(value:)")));
- (int64_t)parseIsoStringValue:(NSString *)value __attribute__((swift_name("parseIsoString(value:)")));
- (id _Nullable)parseIsoStringOrNullValue:(NSString *)value __attribute__((swift_name("parseIsoStringOrNull(value:)")));
- (id _Nullable)parseOrNullValue:(NSString *)value __attribute__((swift_name("parseOrNull(value:)")));
@property (readonly) int64_t INFINITE __attribute__((swift_name("INFINITE")));
@property (readonly) int64_t ZERO __attribute__((swift_name("ZERO")));
@end

@interface MultipazKotlinDurationCompanion (Extensions)
- (int64_t)fromWtIntWtInt:(int32_t)wtInt __attribute__((swift_name("fromWtInt(wtInt:)")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/InstantIso8601Serializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeInstant")))
@interface MultipazKotlinx_datetimeInstant : MultipazBase <MultipazKotlinComparable>
@property (class, readonly, getter=companion) MultipazKotlinx_datetimeInstantCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(MultipazKotlinx_datetimeInstant *)other __attribute__((swift_name("compareTo(other:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (MultipazKotlinx_datetimeInstant *)minusDuration:(int64_t)duration __attribute__((swift_name("minus(duration:)")));
- (int64_t)minusOther:(MultipazKotlinx_datetimeInstant *)other __attribute__((swift_name("minus(other:)")));
- (MultipazKotlinx_datetimeInstant *)plusDuration:(int64_t)duration __attribute__((swift_name("plus(duration:)")));
- (int64_t)toEpochMilliseconds __attribute__((swift_name("toEpochMilliseconds()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int64_t epochSeconds __attribute__((swift_name("epochSeconds")));
@property (readonly) int32_t nanosecondsOfSecond __attribute__((swift_name("nanosecondsOfSecond")));
@end

@interface MultipazKotlinx_datetimeInstant (Extensions)
- (MultipazDataItem *)toDataItemDateTimeString __attribute__((swift_name("toDataItemDateTimeString()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/LocalDateIso8601Serializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDate")))
@interface MultipazKotlinx_datetimeLocalDate : MultipazBase <MultipazKotlinComparable>
- (instancetype)initWithYear:(int32_t)year monthNumber:(int32_t)monthNumber dayOfMonth:(int32_t)dayOfMonth __attribute__((swift_name("init(year:monthNumber:dayOfMonth:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithYear:(int32_t)year month:(MultipazKotlinx_datetimeMonth *)month dayOfMonth:(int32_t)dayOfMonth __attribute__((swift_name("init(year:month:dayOfMonth:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazKotlinx_datetimeLocalDateCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(MultipazKotlinx_datetimeLocalDate *)other __attribute__((swift_name("compareTo(other:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (int32_t)toEpochDays __attribute__((swift_name("toEpochDays()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t dayOfMonth __attribute__((swift_name("dayOfMonth")));
@property (readonly) MultipazKotlinx_datetimeDayOfWeek *dayOfWeek __attribute__((swift_name("dayOfWeek")));
@property (readonly) int32_t dayOfYear __attribute__((swift_name("dayOfYear")));
@property (readonly) MultipazKotlinx_datetimeMonth *month __attribute__((swift_name("month")));
@property (readonly) int32_t monthNumber __attribute__((swift_name("monthNumber")));
@property (readonly) int32_t year __attribute__((swift_name("year")));
@end

@interface MultipazKotlinx_datetimeLocalDate (Extensions)
- (NSString *)formatLocalizedDateStyle:(MultipazFormatStyle *)dateStyle __attribute__((swift_name("formatLocalized(dateStyle:)")));
- (MultipazDataItem *)toDataItemFullDate __attribute__((swift_name("toDataItemFullDate()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/LocalDateTimeIso8601Serializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDateTime")))
@interface MultipazKotlinx_datetimeLocalDateTime : MultipazBase <MultipazKotlinComparable>
- (instancetype)initWithDate:(MultipazKotlinx_datetimeLocalDate *)date time:(MultipazKotlinx_datetimeLocalTime *)time __attribute__((swift_name("init(date:time:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithYear:(int32_t)year monthNumber:(int32_t)monthNumber dayOfMonth:(int32_t)dayOfMonth hour:(int32_t)hour minute:(int32_t)minute second:(int32_t)second nanosecond:(int32_t)nanosecond __attribute__((swift_name("init(year:monthNumber:dayOfMonth:hour:minute:second:nanosecond:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithYear:(int32_t)year month:(MultipazKotlinx_datetimeMonth *)month dayOfMonth:(int32_t)dayOfMonth hour:(int32_t)hour minute:(int32_t)minute second:(int32_t)second nanosecond:(int32_t)nanosecond __attribute__((swift_name("init(year:month:dayOfMonth:hour:minute:second:nanosecond:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazKotlinx_datetimeLocalDateTimeCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(MultipazKotlinx_datetimeLocalDateTime *)other __attribute__((swift_name("compareTo(other:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKotlinx_datetimeLocalDate *date __attribute__((swift_name("date")));
@property (readonly) int32_t dayOfMonth __attribute__((swift_name("dayOfMonth")));
@property (readonly) MultipazKotlinx_datetimeDayOfWeek *dayOfWeek __attribute__((swift_name("dayOfWeek")));
@property (readonly) int32_t dayOfYear __attribute__((swift_name("dayOfYear")));
@property (readonly) int32_t hour __attribute__((swift_name("hour")));
@property (readonly) int32_t minute __attribute__((swift_name("minute")));
@property (readonly) MultipazKotlinx_datetimeMonth *month __attribute__((swift_name("month")));
@property (readonly) int32_t monthNumber __attribute__((swift_name("monthNumber")));
@property (readonly) int32_t nanosecond __attribute__((swift_name("nanosecond")));
@property (readonly) int32_t second __attribute__((swift_name("second")));
@property (readonly) MultipazKotlinx_datetimeLocalTime *time __attribute__((swift_name("time")));
@property (readonly) int32_t year __attribute__((swift_name("year")));
@end

@interface MultipazKotlinx_datetimeLocalDateTime (Extensions)
- (NSString *)formatLocalizedDateStyle:(MultipazFormatStyle *)dateStyle timeStyle:(MultipazFormatStyle *)timeStyle __attribute__((swift_name("formatLocalized(dateStyle:timeStyle:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_io_bytestringByteString")))
@interface MultipazKotlinx_io_bytestringByteString : MultipazBase <MultipazKotlinComparable>
- (instancetype)initWithData:(MultipazKotlinByteArray *)data startIndex:(int32_t)startIndex endIndex:(int32_t)endIndex __attribute__((swift_name("init(data:startIndex:endIndex:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazKotlinx_io_bytestringByteStringCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(MultipazKotlinx_io_bytestringByteString *)other __attribute__((swift_name("compareTo(other:)")));
- (void)doCopyIntoDestination:(MultipazKotlinByteArray *)destination destinationOffset:(int32_t)destinationOffset startIndex:(int32_t)startIndex endIndex:(int32_t)endIndex __attribute__((swift_name("doCopyInto(destination:destinationOffset:startIndex:endIndex:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (int8_t)getIndex:(int32_t)index __attribute__((swift_name("get(index:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (MultipazKotlinx_io_bytestringByteString *)substringStartIndex:(int32_t)startIndex endIndex:(int32_t)endIndex __attribute__((swift_name("substring(startIndex:endIndex:)")));
- (MultipazKotlinByteArray *)toByteArrayStartIndex:(int32_t)startIndex endIndex:(int32_t)endIndex __attribute__((swift_name("toByteArray(startIndex:endIndex:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t size __attribute__((swift_name("size")));
@end

@interface MultipazKotlinx_io_bytestringByteString (Extensions)
- (MultipazKotlinx_io_bytestringByteString *)concatBStr:(MultipazKotlinx_io_bytestringByteString *)bStr __attribute__((swift_name("concat(bStr:)")));
- (int16_t)getInt16Offset:(int32_t)offset __attribute__((swift_name("getInt16(offset:)")));
- (int16_t)getInt16LeOffset:(int32_t)offset __attribute__((swift_name("getInt16Le(offset:)")));
- (int32_t)getInt32Offset:(int32_t)offset __attribute__((swift_name("getInt32(offset:)")));
- (int32_t)getInt32LeOffset:(int32_t)offset __attribute__((swift_name("getInt32Le(offset:)")));
- (int64_t)getInt64Offset:(int32_t)offset __attribute__((swift_name("getInt64(offset:)")));
- (int64_t)getInt64LeOffset:(int32_t)offset __attribute__((swift_name("getInt64Le(offset:)")));
- (int8_t)getInt8Offset:(int32_t)offset __attribute__((swift_name("getInt8(offset:)")));
- (uint16_t)getUInt16Offset:(int32_t)offset __attribute__((swift_name("getUInt16(offset:)")));
- (uint16_t)getUInt16LeOffset:(int32_t)offset __attribute__((swift_name("getUInt16Le(offset:)")));
- (uint32_t)getUInt32Offset:(int32_t)offset __attribute__((swift_name("getUInt32(offset:)")));
- (uint32_t)getUInt32LeOffset:(int32_t)offset __attribute__((swift_name("getUInt32Le(offset:)")));
- (uint64_t)getUInt64Offset:(int32_t)offset __attribute__((swift_name("getUInt64(offset:)")));
- (uint64_t)getUInt64LeOffset:(int32_t)offset __attribute__((swift_name("getUInt64Le(offset:)")));
- (uint8_t)getUInt8Offset:(int32_t)offset __attribute__((swift_name("getUInt8(offset:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_io_bytestringByteStringBuilder")))
@interface MultipazKotlinx_io_bytestringByteStringBuilder : MultipazBase
- (instancetype)initWithInitialCapacity:(int32_t)initialCapacity __attribute__((swift_name("init(initialCapacity:)"))) __attribute__((objc_designated_initializer));
- (void)appendByte:(int8_t)byte __attribute__((swift_name("append(byte:)")));
- (void)appendArray:(MultipazKotlinByteArray *)array startIndex:(int32_t)startIndex endIndex:(int32_t)endIndex __attribute__((swift_name("append(array:startIndex:endIndex:)")));
- (MultipazKotlinx_io_bytestringByteString *)toByteString __attribute__((swift_name("toByteString()")));
@property (readonly) int32_t capacity __attribute__((swift_name("capacity")));
@property (readonly) int32_t size __attribute__((swift_name("size")));
@end

@interface MultipazKotlinx_io_bytestringByteStringBuilder (Extensions)
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendByteArrayBArray:(MultipazKotlinByteArray *)bArray __attribute__((swift_name("appendByteArray(bArray:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendByteStringBString:(MultipazKotlinx_io_bytestringByteString *)bString __attribute__((swift_name("appendByteString(bString:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendInt16Value:(int32_t)value validRange:(MultipazKotlinIntRange *)validRange __attribute__((swift_name("appendInt16(value:validRange:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendInt16LeValue:(int32_t)value validRange:(MultipazKotlinIntRange *)validRange __attribute__((swift_name("appendInt16Le(value:validRange:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendInt32Value:(int32_t)value validRange:(MultipazKotlinIntRange *)validRange __attribute__((swift_name("appendInt32(value:validRange:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendInt32LeValue:(int32_t)value validRange:(MultipazKotlinIntRange *)validRange __attribute__((swift_name("appendInt32Le(value:validRange:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendInt64Value:(int64_t)value validRange:(MultipazKotlinLongRange *)validRange __attribute__((swift_name("appendInt64(value:validRange:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendInt64LeValue:(int64_t)value validRange:(MultipazKotlinLongRange *)validRange __attribute__((swift_name("appendInt64Le(value:validRange:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendInt8Value:(int8_t)value validRange:(MultipazKotlinIntRange *)validRange __attribute__((swift_name("appendInt8(value:validRange:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendInt8Value:(int32_t)value validRange_:(MultipazKotlinIntRange *)validRange __attribute__((swift_name("appendInt8(value:validRange_:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendStringString:(NSString *)string __attribute__((swift_name("appendString(string:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendUInt16Value:(int32_t)value validRange:(MultipazKotlinUIntRange *)validRange __attribute__((swift_name("appendUInt16(value:validRange:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendUInt16Value:(uint32_t)value validRange_:(MultipazKotlinUIntRange *)validRange __attribute__((swift_name("appendUInt16(value:validRange_:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendUInt16LeValue:(int32_t)value validRange:(MultipazKotlinUIntRange *)validRange __attribute__((swift_name("appendUInt16Le(value:validRange:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendUInt16LeValue:(uint32_t)value validRange_:(MultipazKotlinUIntRange *)validRange __attribute__((swift_name("appendUInt16Le(value:validRange_:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendUInt32Value:(int32_t)value validRange:(MultipazKotlinUIntRange *)validRange __attribute__((swift_name("appendUInt32(value:validRange:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendUInt32Value:(uint32_t)value validRange_:(MultipazKotlinUIntRange *)validRange __attribute__((swift_name("appendUInt32(value:validRange_:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendUInt32LeValue:(int32_t)value validRange:(MultipazKotlinUIntRange *)validRange __attribute__((swift_name("appendUInt32Le(value:validRange:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendUInt32LeValue:(uint32_t)value validRange_:(MultipazKotlinUIntRange *)validRange __attribute__((swift_name("appendUInt32Le(value:validRange_:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendUInt64Value:(int64_t)value validRange:(MultipazKotlinULongRange *)validRange __attribute__((swift_name("appendUInt64(value:validRange:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendUInt64Value:(uint64_t)value validRange_:(MultipazKotlinULongRange *)validRange __attribute__((swift_name("appendUInt64(value:validRange_:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendUInt64LeValue:(int64_t)value validRange:(MultipazKotlinULongRange *)validRange __attribute__((swift_name("appendUInt64Le(value:validRange:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendUInt64LeValue:(uint64_t)value validRange_:(MultipazKotlinULongRange *)validRange __attribute__((swift_name("appendUInt64Le(value:validRange_:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendUInt8Value:(int32_t)value validRange:(MultipazKotlinUIntRange *)validRange __attribute__((swift_name("appendUInt8(value:validRange:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendUInt8Value:(uint8_t)value validRange_:(MultipazKotlinUIntRange *)validRange __attribute__((swift_name("appendUInt8(value:validRange_:)")));
- (MultipazKotlinx_io_bytestringByteStringBuilder *)appendUInt8Value:(uint32_t)value validRange__:(MultipazKotlinUIntRange *)validRange __attribute__((swift_name("appendUInt8(value:validRange__:)")));
@end

@interface MultipazArrayBuilder (Extensions)
- (void)addCborArrayBuilderAction:(void (^)(MultipazArrayBuilder<MultipazArrayBuilder<id> *> *))builderAction __attribute__((swift_name("addCborArray(builderAction:)")));
- (void)addCborMapBuilderAction:(void (^)(MultipazMapBuilder<MultipazArrayBuilder<id> *> *))builderAction __attribute__((swift_name("addCborMap(builderAction:)")));
@end

@interface MultipazMapBuilder (Extensions)
- (void)putCborArrayKey:(int64_t)key builderAction:(void (^)(MultipazArrayBuilder<MultipazMapBuilder<id> *> *))builderAction __attribute__((swift_name("putCborArray(key:builderAction:)")));
- (void)putCborArrayKey:(NSString *)key builderAction_:(void (^)(MultipazArrayBuilder<MultipazMapBuilder<id> *> *))builderAction __attribute__((swift_name("putCborArray(key:builderAction_:)")));
- (void)putCborArrayKey:(MultipazDataItem *)key builderAction__:(void (^)(MultipazArrayBuilder<MultipazMapBuilder<id> *> *))builderAction __attribute__((swift_name("putCborArray(key:builderAction__:)")));
- (void)putCborMapKey:(int64_t)key builderAction:(void (^)(MultipazMapBuilder<MultipazMapBuilder<id> *> *))builderAction __attribute__((swift_name("putCborMap(key:builderAction:)")));
- (void)putCborMapKey:(NSString *)key builderAction_:(void (^)(MultipazMapBuilder<MultipazMapBuilder<id> *> *))builderAction __attribute__((swift_name("putCborMap(key:builderAction_:)")));
- (void)putCborMapKey:(MultipazDataItem *)key builderAction__:(void (^)(MultipazMapBuilder<MultipazMapBuilder<id> *> *))builderAction __attribute__((swift_name("putCborMap(key:builderAction__:)")));
@end

@interface MultipazAssertion (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazAssertionCompanion (Extensions)
- (MultipazAssertion *)fromCborData:(MultipazKotlinByteArray *)data __attribute__((swift_name("fromCbor(data:)")));
- (MultipazAssertion *)fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("fromDataItem(dataItem:)")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *cborSchemaId __attribute__((swift_name("cborSchemaId")));
@end

@interface MultipazAssertionBindingKeys (Extensions)
- (MultipazKotlinByteArray *)toCbor_ __attribute__((swift_name("toCbor_()")));
- (MultipazDataItem *)toDataItem_ __attribute__((swift_name("toDataItem_()")));
@end

@interface MultipazAssertionGenericCbor (Extensions)
- (MultipazKotlinByteArray *)toCbor_ __attribute__((swift_name("toCbor_()")));
- (MultipazDataItem *)toDataItem_ __attribute__((swift_name("toDataItem_()")));
@end

@interface MultipazAssertionNonce (Extensions)
- (MultipazKotlinByteArray *)toCbor_ __attribute__((swift_name("toCbor_()")));
- (MultipazDataItem *)toDataItem_ __attribute__((swift_name("toDataItem_()")));
@end

@interface MultipazAssertionPoPKey (Extensions)
- (MultipazKotlinByteArray *)toCbor_ __attribute__((swift_name("toCbor_()")));
- (MultipazDataItem *)toDataItem_ __attribute__((swift_name("toDataItem_()")));
@end

@interface MultipazAssertionRpcAuth (Extensions)
- (MultipazKotlinByteArray *)toCbor_ __attribute__((swift_name("toCbor_()")));
- (MultipazDataItem *)toDataItem_ __attribute__((swift_name("toDataItem_()")));
@end

@interface MultipazDeviceAssertion (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazDeviceAssertionCompanion (Extensions)
- (MultipazDeviceAssertion *)fromCborData:(MultipazKotlinByteArray *)data __attribute__((swift_name("fromCbor(data:)")));
- (MultipazDeviceAssertion *)fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("fromDataItem(dataItem:)")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *cborSchemaId __attribute__((swift_name("cborSchemaId")));
@end

@interface MultipazDeviceAttestation (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazDeviceAttestationCompanion (Extensions)
- (MultipazDeviceAttestation *)fromCborData:(MultipazKotlinByteArray *)data __attribute__((swift_name("fromCbor(data:)")));
- (MultipazDeviceAttestation *)fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("fromDataItem(dataItem:)")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *cborSchemaId __attribute__((swift_name("cborSchemaId")));
@end

@interface MultipazDeviceAttestationAndroid (Extensions)
- (MultipazKotlinByteArray *)toCbor_ __attribute__((swift_name("toCbor_()")));
- (MultipazDataItem *)toDataItem_ __attribute__((swift_name("toDataItem_()")));
@end

@interface MultipazDeviceAttestationIos (Extensions)
- (MultipazKotlinByteArray *)toCbor_ __attribute__((swift_name("toCbor_()")));
- (MultipazDataItem *)toDataItem_ __attribute__((swift_name("toDataItem_()")));
@end

@interface MultipazDeviceAttestationIosCompanion (Extensions)
- (MultipazDeviceAttestationIos *)fromCborData:(MultipazKotlinByteArray *)data __attribute__((swift_name("fromCbor(data:)")));
- (MultipazDeviceAttestationIos *)fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("fromDataItem(dataItem:)")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *cborSchemaId __attribute__((swift_name("cborSchemaId")));
@end

@interface MultipazDeviceAttestationJvm (Extensions)
- (MultipazKotlinByteArray *)toCbor_ __attribute__((swift_name("toCbor_()")));
- (MultipazDataItem *)toDataItem_ __attribute__((swift_name("toDataItem_()")));
@end

@interface MultipazSimpleDocumentMetadataData (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazSimpleDocumentMetadataDataCompanion (Extensions)
- (MultipazSimpleDocumentMetadataData *)fromCborData:(MultipazKotlinByteArray *)data __attribute__((swift_name("fromCbor(data:)")));
- (MultipazSimpleDocumentMetadataData *)fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("fromDataItem(dataItem:)")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *cborSchemaId __attribute__((swift_name("cborSchemaId")));
@end

@interface MultipazDeviceRequestParserDocRequest (Extensions)
- (MultipazMdocRequest *)toMdocRequestDocumentTypeRepository:(MultipazDocumentTypeRepository *)documentTypeRepository mdocCredential:(MultipazMdocCredential * _Nullable)mdocCredential requesterAppId:(NSString * _Nullable)requesterAppId requesterWebsiteOrigin:(NSString * _Nullable)requesterWebsiteOrigin __attribute__((swift_name("toMdocRequest(documentTypeRepository:mdocCredential:requesterAppId:requesterWebsiteOrigin:)")));
@end

@interface MultipazBackendEnvironmentCompanion (Extensions)

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getTableTableSpec:(MultipazStorageTableSpec *)tableSpec completionHandler:(void (^)(id<MultipazStorageTable> _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getTable(tableSpec:completionHandler:)")));
@end

@interface MultipazInvalidRequestException (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazInvalidRequestExceptionCompanion (Extensions)
- (MultipazInvalidRequestException *)fromCborData:(MultipazKotlinByteArray *)data __attribute__((swift_name("fromCbor(data:)")));
- (MultipazInvalidRequestException *)fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("fromDataItem(dataItem:)")));
- (void)registerExceptionMapBuilder:(MultipazRpcExceptionMapBuilder *)exceptionMapBuilder __attribute__((swift_name("register(exceptionMapBuilder:)")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *cborSchemaId __attribute__((swift_name("cborSchemaId")));
@end

@interface MultipazRpcAuthException (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazRpcAuthExceptionCompanion (Extensions)
- (MultipazRpcAuthException *)fromCborData:(MultipazKotlinByteArray *)data __attribute__((swift_name("fromCbor(data:)")));
- (MultipazRpcAuthException *)fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("fromDataItem(dataItem:)")));
- (void)registerExceptionMapBuilder:(MultipazRpcExceptionMapBuilder *)exceptionMapBuilder __attribute__((swift_name("register(exceptionMapBuilder:)")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *cborSchemaId __attribute__((swift_name("cborSchemaId")));
@end

@interface MultipazTestState (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazTestStateCompanion (Extensions)
- (MultipazTestState *)fromCborData:(MultipazKotlinByteArray *)data __attribute__((swift_name("fromCbor(data:)")));
- (MultipazTestState *)fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("fromDataItem(dataItem:)")));
- (void)registerDispatcherBuilder:(MultipazRpcDispatcherLocalBuilder *)dispatcherBuilder __attribute__((swift_name("register(dispatcherBuilder:)")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *cborSchemaId __attribute__((swift_name("cborSchemaId")));
@end

@interface MultipazKeyAttestation (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazKeyAttestationCompanion (Extensions)
- (MultipazKeyAttestation *)fromCborData:(MultipazKotlinByteArray *)data __attribute__((swift_name("fromCbor(data:)")));
- (MultipazKeyAttestation *)fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("fromDataItem(dataItem:)")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *cborSchemaId __attribute__((swift_name("cborSchemaId")));
@end

@interface MultipazPassphraseConstraints (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazPassphraseConstraintsCompanion (Extensions)
- (MultipazPassphraseConstraints *)fromCborData:(MultipazKotlinByteArray *)data __attribute__((swift_name("fromCbor(data:)")));
- (MultipazPassphraseConstraints *)fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("fromDataItem(dataItem:)")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *cborSchemaId __attribute__((swift_name("cborSchemaId")));
@end

@interface MultipazCloudSecureAreaProtocolCheckPassphraseRequest (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolCheckPassphraseResponse (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolCommand (Extensions)
- (MultipazKotlinByteArray *)toCbor_ __attribute__((swift_name("toCbor_()")));
- (MultipazDataItem *)toDataItem_ __attribute__((swift_name("toDataItem_()")));
@end

@interface MultipazCloudSecureAreaProtocolCommandCompanion (Extensions)
- (MultipazCloudSecureAreaProtocolCommand *)fromCborData:(MultipazKotlinByteArray *)data __attribute__((swift_name("fromCbor(data:)")));
- (MultipazCloudSecureAreaProtocolCommand *)fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("fromDataItem(dataItem:)")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *cborSchemaId __attribute__((swift_name("cborSchemaId")));
@end

@interface MultipazCloudSecureAreaProtocolCreateKeyRequest0 (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolCreateKeyRequest1 (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolCreateKeyResponse0 (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolCreateKeyResponse1 (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolE2EERequest (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolE2EEResponse (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolE2EESetupRequest0 (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolE2EESetupRequest1 (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolE2EESetupResponse0 (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolE2EESetupResponse1 (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolKeyAgreementRequest0 (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolKeyAgreementRequest1 (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolKeyAgreementResponse0 (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolKeyAgreementResponse1 (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolRegisterRequest0 (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolRegisterRequest1 (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolRegisterResponse0 (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolRegisterResponse1 (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolRegisterStage2Request0 (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolRegisterStage2Response0 (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolSignRequest0 (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolSignRequest1 (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolSignResponse0 (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazCloudSecureAreaProtocolSignResponse1 (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazSecureAreaConfiguration (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazSecureAreaConfigurationCompanion (Extensions)
- (MultipazSecureAreaConfiguration *)fromCborData:(MultipazKotlinByteArray *)data __attribute__((swift_name("fromCbor(data:)")));
- (MultipazSecureAreaConfiguration *)fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("fromDataItem(dataItem:)")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *cborSchemaId __attribute__((swift_name("cborSchemaId")));
@end

@interface MultipazSecureAreaConfigurationAndroidKeystore (Extensions)
- (MultipazKotlinByteArray *)toCbor_ __attribute__((swift_name("toCbor_()")));
- (MultipazDataItem *)toDataItem_ __attribute__((swift_name("toDataItem_()")));
@end

@interface MultipazSecureAreaConfigurationCloud (Extensions)
- (MultipazKotlinByteArray *)toCbor_ __attribute__((swift_name("toCbor_()")));
- (MultipazDataItem *)toDataItem_ __attribute__((swift_name("toDataItem_()")));
@end

@interface MultipazSecureAreaConfigurationSoftware (Extensions)
- (MultipazKotlinByteArray *)toCbor_ __attribute__((swift_name("toCbor_()")));
- (MultipazDataItem *)toDataItem_ __attribute__((swift_name("toDataItem_()")));
@end

@interface MultipazEphemeralStorageItem (Extensions)
- (MultipazKotlinByteArray *)toCbor __attribute__((swift_name("toCbor()")));
- (MultipazDataItem *)toDataItem __attribute__((swift_name("toDataItem()")));
@end

@interface MultipazEphemeralStorageItemCompanion (Extensions)
- (MultipazEphemeralStorageItem *)fromCborData:(MultipazKotlinByteArray *)data __attribute__((swift_name("fromCbor(data:)")));
- (MultipazEphemeralStorageItem *)fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("fromDataItem(dataItem:)")));
@property (readonly) MultipazKotlinx_io_bytestringByteString *cborSchemaId __attribute__((swift_name("cborSchemaId")));
@end

@interface MultipazUUID (Extensions)
- (NSUUID *)toNSUUID __attribute__((swift_name("toNSUUID()")));
@end

@interface MultipazUUIDCompanion (Extensions)
- (MultipazUUID *)fromNSUUIDNsUUID:(NSUUID *)nsUUID __attribute__((swift_name("fromNSUUID(nsUUID:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AssertionBindingKeys_CborKt")))
@interface MultipazAssertionBindingKeys_CborKt : MultipazBase
+ (MultipazAssertionBindingKeys *)AssertionBindingKeys_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("AssertionBindingKeys_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *AssertionBindingKeys_cborSchemaId __attribute__((swift_name("AssertionBindingKeys_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AssertionGenericCbor_CborKt")))
@interface MultipazAssertionGenericCbor_CborKt : MultipazBase
+ (MultipazAssertionGenericCbor *)AssertionGenericCbor_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("AssertionGenericCbor_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *AssertionGenericCbor_cborSchemaId __attribute__((swift_name("AssertionGenericCbor_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AssertionNonce_CborKt")))
@interface MultipazAssertionNonce_CborKt : MultipazBase
+ (MultipazAssertionNonce *)AssertionNonce_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("AssertionNonce_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *AssertionNonce_cborSchemaId __attribute__((swift_name("AssertionNonce_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AssertionPoPKey_CborKt")))
@interface MultipazAssertionPoPKey_CborKt : MultipazBase
+ (MultipazAssertionPoPKey *)AssertionPoPKey_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("AssertionPoPKey_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *AssertionPoPKey_cborSchemaId __attribute__((swift_name("AssertionPoPKey_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AssertionRpcAuth_CborKt")))
@interface MultipazAssertionRpcAuth_CborKt : MultipazBase
+ (MultipazAssertionRpcAuth *)AssertionRpcAuth_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("AssertionRpcAuth_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *AssertionRpcAuth_cborSchemaId __attribute__((swift_name("AssertionRpcAuth_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Assertion_CborKt")))
@interface MultipazAssertion_CborKt : MultipazBase
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *Assertion_cborSchemaId __attribute__((swift_name("Assertion_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BackendEnvironmentStorageExtKt")))
@interface MultipazBackendEnvironmentStorageExtKt : MultipazBase

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
+ (void)getTable:(id<MultipazBackendEnvironment>)receiver tableSpec:(MultipazStorageTableSpec *)tableSpec completionHandler:(void (^)(id<MultipazStorageTable> _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getTable(_:tableSpec:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Base64UtilKt")))
@interface MultipazBase64UtilKt : MultipazBase
+ (MultipazKotlinByteArray *)fromBase64:(NSString *)receiver __attribute__((swift_name("fromBase64(_:)")));
+ (MultipazKotlinByteArray *)fromBase64Url:(NSString *)receiver __attribute__((swift_name("fromBase64Url(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CborArrayKt")))
@interface MultipazCborArrayKt : MultipazBase
+ (MultipazDataItem *)buildCborArrayBuilderAction:(void (^)(MultipazArrayBuilder<MultipazCborBuilder *> *))builderAction __attribute__((swift_name("buildCborArray(builderAction:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CborMapKt")))
@interface MultipazCborMapKt : MultipazBase
+ (MultipazDataItem *)buildCborMapBuilderAction:(void (^)(MultipazMapBuilder<MultipazCborBuilder *> *))builderAction __attribute__((swift_name("buildCborMap(builderAction:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CheckPassphraseRequest_CborKt")))
@interface MultipazCheckPassphraseRequest_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolCheckPassphraseRequest *)CheckPassphraseRequest_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("CheckPassphraseRequest_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *CheckPassphraseRequest_cborSchemaId __attribute__((swift_name("CheckPassphraseRequest_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CheckPassphraseResponse_CborKt")))
@interface MultipazCheckPassphraseResponse_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolCheckPassphraseResponse *)CheckPassphraseResponse_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("CheckPassphraseResponse_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *CheckPassphraseResponse_cborSchemaId __attribute__((swift_name("CheckPassphraseResponse_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Command_CborKt")))
@interface MultipazCommand_CborKt : MultipazBase
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *Command_cborSchemaId __attribute__((swift_name("Command_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Compression_iosKt")))
@interface MultipazCompression_iosKt : MultipazBase
+ (MultipazKotlinByteArray *)deflateData:(MultipazKotlinByteArray *)data compressionLevel:(int32_t)compressionLevel __attribute__((swift_name("deflate(data:compressionLevel:)")));
+ (MultipazKotlinByteArray *)inflateCompressedData:(MultipazKotlinByteArray *)compressedData __attribute__((swift_name("inflate(compressedData:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CoseNumberLabelKt")))
@interface MultipazCoseNumberLabelKt : MultipazBase
+ (MultipazCoseNumberLabel *)toCoseLabel:(int64_t)receiver __attribute__((swift_name("toCoseLabel(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CoseTextLabelKt")))
@interface MultipazCoseTextLabelKt : MultipazBase
+ (MultipazCoseTextLabel *)toCoseLabel:(NSString *)receiver __attribute__((swift_name("toCoseLabel(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CreateKeyRequest0_CborKt")))
@interface MultipazCreateKeyRequest0_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolCreateKeyRequest0 *)CreateKeyRequest0_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("CreateKeyRequest0_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *CreateKeyRequest0_cborSchemaId __attribute__((swift_name("CreateKeyRequest0_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CreateKeyRequest1_CborKt")))
@interface MultipazCreateKeyRequest1_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolCreateKeyRequest1 *)CreateKeyRequest1_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("CreateKeyRequest1_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *CreateKeyRequest1_cborSchemaId __attribute__((swift_name("CreateKeyRequest1_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CreateKeyResponse0_CborKt")))
@interface MultipazCreateKeyResponse0_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolCreateKeyResponse0 *)CreateKeyResponse0_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("CreateKeyResponse0_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *CreateKeyResponse0_cborSchemaId __attribute__((swift_name("CreateKeyResponse0_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CreateKeyResponse1_CborKt")))
@interface MultipazCreateKeyResponse1_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolCreateKeyResponse1 *)CreateKeyResponse1_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("CreateKeyResponse1_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *CreateKeyResponse1_cborSchemaId __attribute__((swift_name("CreateKeyResponse1_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DataItemExtensionsKt")))
@interface MultipazDataItemExtensionsKt : MultipazBase
+ (MultipazSimple *)toDataItem:(BOOL)receiver __attribute__((swift_name("toDataItem(_:)")));
+ (MultipazCborInt *)toDataItem_:(int8_t)receiver __attribute__((swift_name("toDataItem(__:)")));
+ (MultipazCborDouble *)toDataItem__:(double)receiver __attribute__((swift_name("toDataItem(___:)")));
+ (MultipazCborFloat *)toDataItem___:(float)receiver __attribute__((swift_name("toDataItem(____:)")));
+ (MultipazCborInt *)toDataItem____:(int32_t)receiver __attribute__((swift_name("toDataItem(_____:)")));
+ (MultipazCborInt *)toDataItem_____:(int64_t)receiver __attribute__((swift_name("toDataItem(______:)")));
+ (MultipazCborInt *)toDataItem______:(int16_t)receiver __attribute__((swift_name("toDataItem(_______:)")));
+ (MultipazTstr *)toDataItem_______:(NSString *)receiver __attribute__((swift_name("toDataItem(________:)")));
+ (MultipazDataItem *)toDataItemDateTimeString:(int64_t)receiver __attribute__((swift_name("toDataItemDateTimeString(_:)")));
+ (MultipazDataItem *)toDataItemDateTimeString_:(NSString *)receiver __attribute__((swift_name("toDataItemDateTimeString(__:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Data_CborKt")))
@interface MultipazData_CborKt : MultipazBase
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *Data_cborSchemaId __attribute__((swift_name("Data_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceAssertion_CborKt")))
@interface MultipazDeviceAssertion_CborKt : MultipazBase
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *DeviceAssertion_cborSchemaId __attribute__((swift_name("DeviceAssertion_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceAttestationAndroid_CborKt")))
@interface MultipazDeviceAttestationAndroid_CborKt : MultipazBase
+ (MultipazDeviceAttestationAndroid *)DeviceAttestationAndroid_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("DeviceAttestationAndroid_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *DeviceAttestationAndroid_cborSchemaId __attribute__((swift_name("DeviceAttestationAndroid_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceAttestationIos_CborKt")))
@interface MultipazDeviceAttestationIos_CborKt : MultipazBase
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *DeviceAttestationIos_cborSchemaId __attribute__((swift_name("DeviceAttestationIos_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceAttestationJvm_CborKt")))
@interface MultipazDeviceAttestationJvm_CborKt : MultipazBase
+ (MultipazDeviceAttestationJvm *)DeviceAttestationJvm_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("DeviceAttestationJvm_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *DeviceAttestationJvm_cborSchemaId __attribute__((swift_name("DeviceAttestationJvm_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DeviceAttestation_CborKt")))
@interface MultipazDeviceAttestation_CborKt : MultipazBase
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *DeviceAttestation_cborSchemaId __attribute__((swift_name("DeviceAttestation_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("E2EERequest_CborKt")))
@interface MultipazE2EERequest_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolE2EERequest *)E2EERequest_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("E2EERequest_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *E2EERequest_cborSchemaId __attribute__((swift_name("E2EERequest_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("E2EEResponse_CborKt")))
@interface MultipazE2EEResponse_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolE2EEResponse *)E2EEResponse_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("E2EEResponse_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *E2EEResponse_cborSchemaId __attribute__((swift_name("E2EEResponse_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("E2EESetupRequest0_CborKt")))
@interface MultipazE2EESetupRequest0_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolE2EESetupRequest0 *)E2EESetupRequest0_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("E2EESetupRequest0_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *E2EESetupRequest0_cborSchemaId __attribute__((swift_name("E2EESetupRequest0_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("E2EESetupRequest1_CborKt")))
@interface MultipazE2EESetupRequest1_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolE2EESetupRequest1 *)E2EESetupRequest1_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("E2EESetupRequest1_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *E2EESetupRequest1_cborSchemaId __attribute__((swift_name("E2EESetupRequest1_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("E2EESetupResponse0_CborKt")))
@interface MultipazE2EESetupResponse0_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolE2EESetupResponse0 *)E2EESetupResponse0_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("E2EESetupResponse0_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *E2EESetupResponse0_cborSchemaId __attribute__((swift_name("E2EESetupResponse0_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("E2EESetupResponse1_CborKt")))
@interface MultipazE2EESetupResponse1_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolE2EESetupResponse1 *)E2EESetupResponse1_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("E2EESetupResponse1_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *E2EESetupResponse1_cborSchemaId __attribute__((swift_name("E2EESetupResponse1_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EphemeralStorageItem_CborKt")))
@interface MultipazEphemeralStorageItem_CborKt : MultipazBase
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *EphemeralStorageItem_cborSchemaId __attribute__((swift_name("EphemeralStorageItem_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("HexUtilKt")))
@interface MultipazHexUtilKt : MultipazBase
+ (MultipazKotlinByteArray *)fromHex:(NSString *)receiver __attribute__((swift_name("fromHex(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("HtmlUtilKt")))
@interface MultipazHtmlUtilKt : MultipazBase
+ (NSString *)htmlEscape:(NSString *)receiver __attribute__((swift_name("htmlEscape(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("InvalidRequestException_CborKt")))
@interface MultipazInvalidRequestException_CborKt : MultipazBase
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *InvalidRequestException_cborSchemaId __attribute__((swift_name("InvalidRequestException_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IosUtilKt")))
@interface MultipazIosUtilKt : MultipazBase
+ (MultipazKotlinByteArray *)toByteArray:(NSData *)receiver __attribute__((swift_name("toByteArray(_:)")));
+ (MultipazKotlinError *)toKotlinError:(NSError *)receiver __attribute__((swift_name("toKotlinError(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IssuerNamespacesBuilderKt")))
@interface MultipazIssuerNamespacesBuilderKt : MultipazBase
+ (MultipazIssuerNamespaces *)buildIssuerNamespacesDataElementRandomSize:(int32_t)dataElementRandomSize randomProvider:(MultipazKotlinRandom *)randomProvider builderAction:(void (^)(MultipazIssuerNamespacesBuilder *))builderAction __attribute__((swift_name("buildIssuerNamespaces(dataElementRandomSize:randomProvider:builderAction:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KeyAgreementRequest0_CborKt")))
@interface MultipazKeyAgreementRequest0_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolKeyAgreementRequest0 *)KeyAgreementRequest0_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("KeyAgreementRequest0_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *KeyAgreementRequest0_cborSchemaId __attribute__((swift_name("KeyAgreementRequest0_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KeyAgreementRequest1_CborKt")))
@interface MultipazKeyAgreementRequest1_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolKeyAgreementRequest1 *)KeyAgreementRequest1_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("KeyAgreementRequest1_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *KeyAgreementRequest1_cborSchemaId __attribute__((swift_name("KeyAgreementRequest1_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KeyAgreementResponse0_CborKt")))
@interface MultipazKeyAgreementResponse0_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolKeyAgreementResponse0 *)KeyAgreementResponse0_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("KeyAgreementResponse0_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *KeyAgreementResponse0_cborSchemaId __attribute__((swift_name("KeyAgreementResponse0_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KeyAgreementResponse1_CborKt")))
@interface MultipazKeyAgreementResponse1_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolKeyAgreementResponse1 *)KeyAgreementResponse1_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("KeyAgreementResponse1_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *KeyAgreementResponse1_cborSchemaId __attribute__((swift_name("KeyAgreementResponse1_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KeyAttestation_CborKt")))
@interface MultipazKeyAttestation_CborKt : MultipazBase
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *KeyAttestation_cborSchemaId __attribute__((swift_name("KeyAttestation_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocClaimKt")))
@interface MultipazMdocClaimKt : MultipazBase
+ (NSDictionary<NSString *, NSArray<MultipazMdocClaim *> *> *)organizeByNamespace:(NSArray<MultipazMdocClaim *> *)receiver __attribute__((swift_name("organizeByNamespace(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PassphraseConstraints_CborKt")))
@interface MultipazPassphraseConstraints_CborKt : MultipazBase
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *PassphraseConstraints_cborSchemaId __attribute__((swift_name("PassphraseConstraints_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PromptModelKt")))
@interface MultipazPromptModelKt : MultipazBase

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
+ (void)requestPassphraseTitle:(NSString *)title subtitle:(NSString *)subtitle passphraseConstraints:(MultipazPassphraseConstraints *)passphraseConstraints passphraseEvaluator:(id<MultipazKotlinSuspendFunction1> _Nullable)passphraseEvaluator completionHandler:(void (^)(NSString * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("requestPassphrase(title:subtitle:passphraseConstraints:passphraseEvaluator:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RegisterRequest0_CborKt")))
@interface MultipazRegisterRequest0_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolRegisterRequest0 *)RegisterRequest0_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("RegisterRequest0_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *RegisterRequest0_cborSchemaId __attribute__((swift_name("RegisterRequest0_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RegisterRequest1_CborKt")))
@interface MultipazRegisterRequest1_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolRegisterRequest1 *)RegisterRequest1_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("RegisterRequest1_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *RegisterRequest1_cborSchemaId __attribute__((swift_name("RegisterRequest1_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RegisterResponse0_CborKt")))
@interface MultipazRegisterResponse0_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolRegisterResponse0 *)RegisterResponse0_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("RegisterResponse0_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *RegisterResponse0_cborSchemaId __attribute__((swift_name("RegisterResponse0_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RegisterResponse1_CborKt")))
@interface MultipazRegisterResponse1_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolRegisterResponse1 *)RegisterResponse1_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("RegisterResponse1_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *RegisterResponse1_cborSchemaId __attribute__((swift_name("RegisterResponse1_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RegisterStage2Request0_CborKt")))
@interface MultipazRegisterStage2Request0_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolRegisterStage2Request0 *)RegisterStage2Request0_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("RegisterStage2Request0_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *RegisterStage2Request0_cborSchemaId __attribute__((swift_name("RegisterStage2Request0_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RegisterStage2Response0_CborKt")))
@interface MultipazRegisterStage2Response0_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolRegisterStage2Response0 *)RegisterStage2Response0_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("RegisterStage2Response0_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *RegisterStage2Response0_cborSchemaId __attribute__((swift_name("RegisterStage2Response0_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RpcAuthException_CborKt")))
@interface MultipazRpcAuthException_CborKt : MultipazBase
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *RpcAuthException_cborSchemaId __attribute__((swift_name("RpcAuthException_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SecureAreaConfigurationAndroidKeystore_CborKt")))
@interface MultipazSecureAreaConfigurationAndroidKeystore_CborKt : MultipazBase
+ (MultipazSecureAreaConfigurationAndroidKeystore *)SecureAreaConfigurationAndroidKeystore_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("SecureAreaConfigurationAndroidKeystore_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *SecureAreaConfigurationAndroidKeystore_cborSchemaId __attribute__((swift_name("SecureAreaConfigurationAndroidKeystore_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SecureAreaConfigurationCloud_CborKt")))
@interface MultipazSecureAreaConfigurationCloud_CborKt : MultipazBase
+ (MultipazSecureAreaConfigurationCloud *)SecureAreaConfigurationCloud_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("SecureAreaConfigurationCloud_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *SecureAreaConfigurationCloud_cborSchemaId __attribute__((swift_name("SecureAreaConfigurationCloud_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SecureAreaConfigurationSoftware_CborKt")))
@interface MultipazSecureAreaConfigurationSoftware_CborKt : MultipazBase
+ (MultipazSecureAreaConfigurationSoftware *)SecureAreaConfigurationSoftware_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("SecureAreaConfigurationSoftware_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *SecureAreaConfigurationSoftware_cborSchemaId __attribute__((swift_name("SecureAreaConfigurationSoftware_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SecureAreaConfiguration_CborKt")))
@interface MultipazSecureAreaConfiguration_CborKt : MultipazBase
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *SecureAreaConfiguration_cborSchemaId __attribute__((swift_name("SecureAreaConfiguration_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SecureEnclaveUserAuthTypeKt")))
@interface MultipazSecureEnclaveUserAuthTypeKt : MultipazBase
+ (NSSet<MultipazSecureEnclaveUserAuthType *> *)secureEnclaveUserAuthType:(int64_t)receiver __attribute__((swift_name("secureEnclaveUserAuthType(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SignRequest0_CborKt")))
@interface MultipazSignRequest0_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolSignRequest0 *)SignRequest0_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("SignRequest0_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *SignRequest0_cborSchemaId __attribute__((swift_name("SignRequest0_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SignRequest1_CborKt")))
@interface MultipazSignRequest1_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolSignRequest1 *)SignRequest1_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("SignRequest1_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *SignRequest1_cborSchemaId __attribute__((swift_name("SignRequest1_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SignResponse0_CborKt")))
@interface MultipazSignResponse0_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolSignResponse0 *)SignResponse0_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("SignResponse0_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *SignResponse0_cborSchemaId __attribute__((swift_name("SignResponse0_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SignResponse1_CborKt")))
@interface MultipazSignResponse1_CborKt : MultipazBase
+ (MultipazCloudSecureAreaProtocolSignResponse1 *)SignResponse1_fromDataItemDataItem:(MultipazDataItem *)dataItem __attribute__((swift_name("SignResponse1_fromDataItem(dataItem:)")));
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *SignResponse1_cborSchemaId __attribute__((swift_name("SignResponse1_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TestState_CborKt")))
@interface MultipazTestState_CborKt : MultipazBase
@property (class, readonly) MultipazKotlinx_io_bytestringByteString *TestState_cborSchemaId __attribute__((swift_name("TestState_cborSchemaId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ConnectionHelperKt")))
@interface MultipazConnectionHelperKt : MultipazBase

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
+ (void)advertiseAndWait:(NSArray<MultipazMdocConnectionMethod *> *)receiver role:(MultipazMdocRole *)role transportFactory:(id<MultipazMdocTransportFactory>)transportFactory options:(MultipazMdocTransportOptions *)options eSenderKey:(MultipazEcPublicKey *)eSenderKey onConnectionMethodsReady:(id<MultipazKotlinSuspendFunction1>)onConnectionMethodsReady completionHandler:(void (^)(MultipazMdocTransport * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("advertiseAndWait(_:role:transportFactory:options:eSenderKey:onConnectionMethodsReady:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MdocReaderNfcHandoverKt")))
@interface MultipazMdocReaderNfcHandoverKt : MultipazBase

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
+ (void)mdocReaderNfcHandoverTag:(MultipazNfcIsoTag *)tag negotiatedHandoverConnectionMethods:(NSArray<MultipazMdocConnectionMethod *> *)negotiatedHandoverConnectionMethods completionHandler:(void (^)(MultipazMdocReaderNfcHandoverResult * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("mdocReaderNfcHandover(tag:negotiatedHandoverConnectionMethods:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ScanNfcMdocReaderKt")))
@interface MultipazScanNfcMdocReaderKt : MultipazBase

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
+ (void)scanNfcMdocReaderMessage:(NSString *)message options:(MultipazMdocTransportOptions *)options transportFactory:(id<MultipazMdocTransportFactory>)transportFactory selectConnectionMethod:(id<MultipazKotlinSuspendFunction1>)selectConnectionMethod negotiatedHandoverConnectionMethods:(NSArray<MultipazMdocConnectionMethod *> *)negotiatedHandoverConnectionMethods onHandover:(id<MultipazKotlinSuspendFunction4>)onHandover completionHandler:(void (^)(MultipazBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("scanNfcMdocReader(message:options:transportFactory:selectConnectionMethod:negotiatedHandoverConnectionMethods:onHandover:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ScanNfcTag_iosKt")))
@interface MultipazScanNfcTag_iosKt : MultipazBase

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
+ (void)scanNfcTagMessage:(NSString *)message tagInteractionFunc:(id<MultipazKotlinSuspendFunction2>)tagInteractionFunc completionHandler:(void (^)(id _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("scanNfcTag(message:tagInteractionFunc:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ValidateAndroidKeyAttestationKt")))
@interface MultipazValidateAndroidKeyAttestationKt : MultipazBase
+ (void)validateAndroidKeyAttestationChain:(MultipazX509CertChain *)chain challenge:(MultipazKotlinx_io_bytestringByteString * _Nullable)challenge requireGmsAttestation:(BOOL)requireGmsAttestation requireVerifiedBootGreen:(BOOL)requireVerifiedBootGreen requireAppSignatureCertificateDigests:(NSArray<MultipazKotlinx_io_bytestringByteString *> *)requireAppSignatureCertificateDigests __attribute__((swift_name("validateAndroidKeyAttestation(chain:challenge:requireGmsAttestation:requireVerifiedBootGreen:requireAppSignatureCertificateDigests:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ValidateCloudSecureAreaAttestationKt")))
@interface MultipazValidateCloudSecureAreaAttestationKt : MultipazBase
+ (BOOL)isCloudKeyAttestationChain:(MultipazX509CertChain *)chain __attribute__((swift_name("isCloudKeyAttestation(chain:)")));
+ (void)validateCloudKeyAttestationChain:(MultipazX509CertChain *)chain nonce:(MultipazKotlinx_io_bytestringByteString *)nonce trustedRootKeys:(NSSet<MultipazKotlinx_io_bytestringByteString *> *)trustedRootKeys __attribute__((swift_name("validateCloudKeyAttestation(chain:nonce:trustedRootKeys:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinBooleanArray")))
@interface MultipazKotlinBooleanArray : MultipazBase
+ (instancetype)arrayWithSize:(int32_t)size __attribute__((swift_name("init(size:)")));
+ (instancetype)arrayWithSize:(int32_t)size init:(MultipazBoolean *(^)(MultipazInt *))init __attribute__((swift_name("init(size:init:)")));
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (BOOL)getIndex:(int32_t)index __attribute__((swift_name("get(index:)")));
- (MultipazKotlinBooleanIterator *)iterator __attribute__((swift_name("iterator()")));
- (void)setIndex:(int32_t)index value:(BOOL)value __attribute__((swift_name("set(index:value:)")));
@property (readonly) int32_t size __attribute__((swift_name("size")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinEnumCompanion")))
@interface MultipazKotlinEnumCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinEnumCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinArray")))
@interface MultipazKotlinArray<T> : MultipazBase
+ (instancetype)arrayWithSize:(int32_t)size init:(T _Nullable (^)(MultipazInt *))init __attribute__((swift_name("init(size:init:)")));
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (T _Nullable)getIndex:(int32_t)index __attribute__((swift_name("get(index:)")));
- (id<MultipazKotlinIterator>)iterator __attribute__((swift_name("iterator()")));
- (void)setIndex:(int32_t)index value:(T _Nullable)value __attribute__((swift_name("set(index:value:)")));
@property (readonly) int32_t size __attribute__((swift_name("size")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.3")
*/
__attribute__((swift_name("KotlinRandom")))
@interface MultipazKotlinRandom : MultipazBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (class, readonly, getter=companion) MultipazKotlinRandomDefault *companion __attribute__((swift_name("companion")));
- (int32_t)nextBitsBitCount:(int32_t)bitCount __attribute__((swift_name("nextBits(bitCount:)")));
- (BOOL)nextBoolean __attribute__((swift_name("nextBoolean()")));
- (MultipazKotlinByteArray *)nextBytesArray:(MultipazKotlinByteArray *)array __attribute__((swift_name("nextBytes(array:)")));
- (MultipazKotlinByteArray *)nextBytesSize:(int32_t)size __attribute__((swift_name("nextBytes(size:)")));
- (MultipazKotlinByteArray *)nextBytesArray:(MultipazKotlinByteArray *)array fromIndex:(int32_t)fromIndex toIndex:(int32_t)toIndex __attribute__((swift_name("nextBytes(array:fromIndex:toIndex:)")));
- (double)nextDouble __attribute__((swift_name("nextDouble()")));
- (double)nextDoubleUntil:(double)until __attribute__((swift_name("nextDouble(until:)")));
- (double)nextDoubleFrom:(double)from until:(double)until __attribute__((swift_name("nextDouble(from:until:)")));
- (float)nextFloat __attribute__((swift_name("nextFloat()")));
- (int32_t)nextInt __attribute__((swift_name("nextInt()")));
- (int32_t)nextIntUntil:(int32_t)until __attribute__((swift_name("nextInt(until:)")));
- (int32_t)nextIntFrom:(int32_t)from until:(int32_t)until __attribute__((swift_name("nextInt(from:until:)")));
- (int64_t)nextLong __attribute__((swift_name("nextLong()")));
- (int64_t)nextLongUntil:(int64_t)until __attribute__((swift_name("nextLong(until:)")));
- (int64_t)nextLongFrom:(int64_t)from until:(int64_t)until __attribute__((swift_name("nextLong(from:until:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinPair")))
@interface MultipazKotlinPair<__covariant A, __covariant B> : MultipazBase
- (instancetype)initWithFirst:(A _Nullable)first second:(B _Nullable)second __attribute__((swift_name("init(first:second:)"))) __attribute__((objc_designated_initializer));
- (MultipazKotlinPair<A, B> *)doCopyFirst:(A _Nullable)first second:(B _Nullable)second __attribute__((swift_name("doCopy(first:second:)")));
- (BOOL)equalsOther:(id _Nullable)other __attribute__((swift_name("equals(other:)")));
- (int32_t)hashCode __attribute__((swift_name("hashCode()")));
- (NSString *)toString __attribute__((swift_name("toString()")));
@property (readonly) A _Nullable first __attribute__((swift_name("first")));
@property (readonly) B _Nullable second __attribute__((swift_name("second")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/TimeZoneSerializer))
*/
__attribute__((swift_name("Kotlinx_datetimeTimeZone")))
@interface MultipazKotlinx_datetimeTimeZone : MultipazBase
@property (class, readonly, getter=companion) MultipazKotlinx_datetimeTimeZoneCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (MultipazKotlinx_datetimeInstant *)toInstant:(MultipazKotlinx_datetimeLocalDateTime *)receiver __attribute__((swift_name("toInstant(_:)")));
- (MultipazKotlinx_datetimeLocalDateTime *)toLocalDateTime:(MultipazKotlinx_datetimeInstant *)receiver __attribute__((swift_name("toLocalDateTime(_:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *id __attribute__((swift_name("id")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/serialization/json/JsonElementSerializer))
*/
__attribute__((swift_name("Kotlinx_serialization_jsonJsonElement")))
@interface MultipazKotlinx_serialization_jsonJsonElement : MultipazBase
@property (class, readonly, getter=companion) MultipazKotlinx_serialization_jsonJsonElementCompanion *companion __attribute__((swift_name("companion")));
@end

__attribute__((swift_name("KotlinIllegalStateException")))
@interface MultipazKotlinIllegalStateException : MultipazKotlinRuntimeException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.4")
*/
__attribute__((swift_name("KotlinCancellationException")))
@interface MultipazKotlinCancellationException : MultipazKotlinIllegalStateException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((swift_name("KotlinFunction")))
@protocol MultipazKotlinFunction
@required
@end

__attribute__((swift_name("KotlinSuspendFunction1")))
@protocol MultipazKotlinSuspendFunction1 <MultipazKotlinFunction>
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)invokeP1:(id _Nullable)p1 completionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("invoke(p1:completionHandler:)")));
@end

__attribute__((swift_name("KotlinSuspendFunction3")))
@protocol MultipazKotlinSuspendFunction3 <MultipazKotlinFunction>
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)invokeP1:(id _Nullable)p1 p2:(id _Nullable)p2 p3:(id _Nullable)p3 completionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("invoke(p1:p2:p3:completionHandler:)")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreFlow")))
@protocol MultipazKotlinx_coroutines_coreFlow
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)collectCollector:(id<MultipazKotlinx_coroutines_coreFlowCollector>)collector completionHandler_:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("collect(collector:completionHandler_:)")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreSharedFlow")))
@protocol MultipazKotlinx_coroutines_coreSharedFlow <MultipazKotlinx_coroutines_coreFlow>
@required
@property (readonly) NSArray<id> *replayCache __attribute__((swift_name("replayCache")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreStateFlow")))
@protocol MultipazKotlinx_coroutines_coreStateFlow <MultipazKotlinx_coroutines_coreSharedFlow>
@required
@property (readonly) id _Nullable value_ __attribute__((swift_name("value_")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreCoroutineScope")))
@protocol MultipazKotlinx_coroutines_coreCoroutineScope
@required
@property (readonly) id<MultipazKotlinCoroutineContext> coroutineContext __attribute__((swift_name("coroutineContext")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreSendChannel")))
@protocol MultipazKotlinx_coroutines_coreSendChannel
@required
- (BOOL)closeCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("close(cause:)")));
- (void)invokeOnCloseHandler:(void (^)(MultipazKotlinThrowable * _Nullable))handler __attribute__((swift_name("invokeOnClose(handler:)")));
- (BOOL)offerElement:(id _Nullable)element __attribute__((swift_name("offer(element:)"))) __attribute__((unavailable("Deprecated in the favour of 'trySend' method")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)sendElement:(id _Nullable)element completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("send(element:completionHandler:)")));
- (id _Nullable)trySendElement:(id _Nullable)element __attribute__((swift_name("trySend(element:)")));

/**
 * @note annotations
 *   kotlinx.coroutines.DelicateCoroutinesApi
*/
@property (readonly) BOOL isClosedForSend __attribute__((swift_name("isClosedForSend")));
@property (readonly) id<MultipazKotlinx_coroutines_coreSelectClause2> onSend __attribute__((swift_name("onSend")));
@end

__attribute__((swift_name("KotlinKDeclarationContainer")))
@protocol MultipazKotlinKDeclarationContainer
@required
@end

__attribute__((swift_name("KotlinKAnnotatedElement")))
@protocol MultipazKotlinKAnnotatedElement
@required
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
__attribute__((swift_name("KotlinKClassifier")))
@protocol MultipazKotlinKClassifier
@required
@end

__attribute__((swift_name("KotlinKClass")))
@protocol MultipazKotlinKClass <MultipazKotlinKDeclarationContainer, MultipazKotlinKAnnotatedElement, MultipazKotlinKClassifier>
@required

/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
- (BOOL)isInstanceValue:(id _Nullable)value __attribute__((swift_name("isInstance(value:)")));
@property (readonly) NSString * _Nullable qualifiedName __attribute__((swift_name("qualifiedName")));
@property (readonly) NSString * _Nullable simpleName __attribute__((swift_name("simpleName")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreFlowCollector")))
@protocol MultipazKotlinx_coroutines_coreFlowCollector
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)emitValue:(id _Nullable)value completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("emit(value:completionHandler:)")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreMutex")))
@protocol MultipazKotlinx_coroutines_coreMutex
@required
- (BOOL)holdsLockOwner:(id)owner __attribute__((swift_name("holdsLock(owner:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)lockOwner:(id _Nullable)owner completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("lock(owner:completionHandler:)")));
- (BOOL)tryLockOwner:(id _Nullable)owner __attribute__((swift_name("tryLock(owner:)")));
- (void)unlockOwner:(id _Nullable)owner __attribute__((swift_name("unlock(owner:)")));
@property (readonly) BOOL isLocked __attribute__((swift_name("isLocked")));
@property (readonly) id<MultipazKotlinx_coroutines_coreSelectClause2> onLock __attribute__((swift_name("onLock"))) __attribute__((deprecated("Mutex.onLock deprecated without replacement. For additional details please refer to #2794")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreMutableSharedFlow")))
@protocol MultipazKotlinx_coroutines_coreMutableSharedFlow <MultipazKotlinx_coroutines_coreSharedFlow, MultipazKotlinx_coroutines_coreFlowCollector>
@required

/**
 * @note annotations
 *   kotlinx.coroutines.ExperimentalCoroutinesApi
*/
- (void)resetReplayCache __attribute__((swift_name("resetReplayCache()")));
- (BOOL)tryEmitValue:(id _Nullable)value __attribute__((swift_name("tryEmit(value:)")));
@property (readonly) id<MultipazKotlinx_coroutines_coreStateFlow> subscriptionCount __attribute__((swift_name("subscriptionCount")));
@end

__attribute__((swift_name("Ktor_client_coreHttpClientEngineFactory")))
@protocol MultipazKtor_client_coreHttpClientEngineFactory
@required
- (id<MultipazKtor_client_coreHttpClientEngine>)createBlock:(void (^)(MultipazKtor_client_coreHttpClientEngineConfig *))block __attribute__((swift_name("create(block:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_io_corePath")))
@interface MultipazKotlinx_io_corePath : MultipazBase
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) BOOL isAbsolute __attribute__((swift_name("isAbsolute")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@property (readonly) MultipazKotlinx_io_corePath * _Nullable parent __attribute__((swift_name("parent")));
@end

__attribute__((swift_name("SqliteSQLiteConnection")))
@protocol MultipazSqliteSQLiteConnection
@required
- (void)close __attribute__((swift_name("close()")));
- (id<MultipazSqliteSQLiteStatement>)prepareSql:(NSString *)sql __attribute__((swift_name("prepare(sql:)")));
@end

__attribute__((swift_name("KotlinIterator")))
@protocol MultipazKotlinIterator
@required
- (BOOL)hasNext __attribute__((swift_name("hasNext()")));
- (id _Nullable)next __attribute__((swift_name("next()")));
@end

__attribute__((swift_name("KotlinByteIterator")))
@interface MultipazKotlinByteIterator : MultipazBase <MultipazKotlinIterator>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (MultipazByte *)next __attribute__((swift_name("next()")));
- (int8_t)nextByte __attribute__((swift_name("nextByte()")));
@end

__attribute__((swift_name("KotlinIterable")))
@protocol MultipazKotlinIterable
@required
- (id<MultipazKotlinIterator>)iterator __attribute__((swift_name("iterator()")));
@end

__attribute__((swift_name("KotlinIntProgression")))
@interface MultipazKotlinIntProgression : MultipazBase <MultipazKotlinIterable>
@property (class, readonly, getter=companion) MultipazKotlinIntProgressionCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (BOOL)isEmpty __attribute__((swift_name("isEmpty()")));
- (MultipazKotlinIntIterator *)iterator __attribute__((swift_name("iterator()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t first __attribute__((swift_name("first")));
@property (readonly) int32_t last __attribute__((swift_name("last")));
@property (readonly) int32_t step __attribute__((swift_name("step")));
@end

__attribute__((swift_name("KotlinClosedRange")))
@protocol MultipazKotlinClosedRange
@required
- (BOOL)containsValue:(id)value __attribute__((swift_name("contains(value:)")));
- (BOOL)isEmpty __attribute__((swift_name("isEmpty()")));
@property (readonly) id endInclusive __attribute__((swift_name("endInclusive")));
@property (readonly) id start __attribute__((swift_name("start")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.9")
*/
__attribute__((swift_name("KotlinOpenEndRange")))
@protocol MultipazKotlinOpenEndRange
@required
- (BOOL)containsValue_:(id)value __attribute__((swift_name("contains(value_:)")));
- (BOOL)isEmpty __attribute__((swift_name("isEmpty()")));
@property (readonly) id endExclusive __attribute__((swift_name("endExclusive")));
@property (readonly) id start __attribute__((swift_name("start")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinIntRange")))
@interface MultipazKotlinIntRange : MultipazKotlinIntProgression <MultipazKotlinClosedRange, MultipazKotlinOpenEndRange>
- (instancetype)initWithStart:(int32_t)start endInclusive:(int32_t)endInclusive __attribute__((swift_name("init(start:endInclusive:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazKotlinIntRangeCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)containsValue:(MultipazInt *)value __attribute__((swift_name("contains(value:)")));
- (BOOL)containsValue_:(MultipazInt *)value __attribute__((swift_name("contains(value_:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (BOOL)isEmpty __attribute__((swift_name("isEmpty()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.9")
*/
@property (readonly) MultipazInt *endExclusive __attribute__((swift_name("endExclusive"))) __attribute__((deprecated("Can throw an exception when it's impossible to represent the value with Int type, for example, when the range includes MAX_VALUE. It's recommended to use 'endInclusive' property that doesn't throw.")));
@property (readonly) MultipazInt *endInclusive __attribute__((swift_name("endInclusive")));
@property (readonly) MultipazInt *start __attribute__((swift_name("start")));
@end

__attribute__((swift_name("KotlinLongProgression")))
@interface MultipazKotlinLongProgression : MultipazBase <MultipazKotlinIterable>
@property (class, readonly, getter=companion) MultipazKotlinLongProgressionCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (BOOL)isEmpty __attribute__((swift_name("isEmpty()")));
- (MultipazKotlinLongIterator *)iterator __attribute__((swift_name("iterator()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int64_t first __attribute__((swift_name("first")));
@property (readonly) int64_t last __attribute__((swift_name("last")));
@property (readonly) int64_t step __attribute__((swift_name("step")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinLongRange")))
@interface MultipazKotlinLongRange : MultipazKotlinLongProgression <MultipazKotlinClosedRange, MultipazKotlinOpenEndRange>
- (instancetype)initWithStart:(int64_t)start endInclusive:(int64_t)endInclusive __attribute__((swift_name("init(start:endInclusive:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazKotlinLongRangeCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)containsValue:(MultipazLong *)value __attribute__((swift_name("contains(value:)")));
- (BOOL)containsValue_:(MultipazLong *)value __attribute__((swift_name("contains(value_:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (BOOL)isEmpty __attribute__((swift_name("isEmpty()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.9")
*/
@property (readonly) MultipazLong *endExclusive __attribute__((swift_name("endExclusive"))) __attribute__((deprecated("Can throw an exception when it's impossible to represent the value with Long type, for example, when the range includes MAX_VALUE. It's recommended to use 'endInclusive' property that doesn't throw.")));
@property (readonly) MultipazLong *endInclusive __attribute__((swift_name("endInclusive")));
@property (readonly) MultipazLong *start __attribute__((swift_name("start")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.5")
*/
__attribute__((swift_name("KotlinUIntProgression")))
@interface MultipazKotlinUIntProgression : MultipazBase <MultipazKotlinIterable>
@property (class, readonly, getter=companion) MultipazKotlinUIntProgressionCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (BOOL)isEmpty __attribute__((swift_name("isEmpty()")));
- (id<MultipazKotlinIterator>)iterator __attribute__((swift_name("iterator()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) uint32_t first __attribute__((swift_name("first")));
@property (readonly) uint32_t last __attribute__((swift_name("last")));
@property (readonly) int32_t step __attribute__((swift_name("step")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.5")
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinUIntRange")))
@interface MultipazKotlinUIntRange : MultipazKotlinUIntProgression <MultipazKotlinClosedRange, MultipazKotlinOpenEndRange>
- (instancetype)initWithStart:(uint32_t)start endInclusive:(uint32_t)endInclusive __attribute__((swift_name("init(start:endInclusive:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazKotlinUIntRangeCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)containsValue:(MultipazUInt *)value __attribute__((swift_name("contains(value:)")));
- (BOOL)containsValue_:(MultipazUInt *)value __attribute__((swift_name("contains(value_:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (BOOL)isEmpty __attribute__((swift_name("isEmpty()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.9")
*/
@property (readonly) MultipazUInt *endExclusive __attribute__((swift_name("endExclusive"))) __attribute__((deprecated("Can throw an exception when it's impossible to represent the value with UInt type, for example, when the range includes MAX_VALUE. It's recommended to use 'endInclusive' property that doesn't throw.")));
@property (readonly) MultipazUInt *endInclusive __attribute__((swift_name("endInclusive")));
@property (readonly) MultipazUInt *start __attribute__((swift_name("start")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.5")
*/
__attribute__((swift_name("KotlinULongProgression")))
@interface MultipazKotlinULongProgression : MultipazBase <MultipazKotlinIterable>
@property (class, readonly, getter=companion) MultipazKotlinULongProgressionCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (BOOL)isEmpty __attribute__((swift_name("isEmpty()")));
- (id<MultipazKotlinIterator>)iterator __attribute__((swift_name("iterator()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) uint64_t first __attribute__((swift_name("first")));
@property (readonly) uint64_t last __attribute__((swift_name("last")));
@property (readonly) int64_t step __attribute__((swift_name("step")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.5")
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinULongRange")))
@interface MultipazKotlinULongRange : MultipazKotlinULongProgression <MultipazKotlinClosedRange, MultipazKotlinOpenEndRange>
- (instancetype)initWithStart:(uint64_t)start endInclusive:(uint64_t)endInclusive __attribute__((swift_name("init(start:endInclusive:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazKotlinULongRangeCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)containsValue:(MultipazULong *)value __attribute__((swift_name("contains(value:)")));
- (BOOL)containsValue_:(MultipazULong *)value __attribute__((swift_name("contains(value_:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (BOOL)isEmpty __attribute__((swift_name("isEmpty()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.9")
*/
@property (readonly) MultipazULong *endExclusive __attribute__((swift_name("endExclusive"))) __attribute__((deprecated("Can throw an exception when it's impossible to represent the value with ULong type, for example, when the range includes MAX_VALUE. It's recommended to use 'endInclusive' property that doesn't throw.")));
@property (readonly) MultipazULong *endInclusive __attribute__((swift_name("endInclusive")));
@property (readonly) MultipazULong *start __attribute__((swift_name("start")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.6")
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinDurationUnit")))
@interface MultipazKotlinDurationUnit : MultipazKotlinEnum<MultipazKotlinDurationUnit *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) MultipazKotlinDurationUnit *nanoseconds __attribute__((swift_name("nanoseconds")));
@property (class, readonly) MultipazKotlinDurationUnit *microseconds __attribute__((swift_name("microseconds")));
@property (class, readonly) MultipazKotlinDurationUnit *milliseconds __attribute__((swift_name("milliseconds")));
@property (class, readonly) MultipazKotlinDurationUnit *seconds __attribute__((swift_name("seconds")));
@property (class, readonly) MultipazKotlinDurationUnit *minutes __attribute__((swift_name("minutes")));
@property (class, readonly) MultipazKotlinDurationUnit *hours __attribute__((swift_name("hours")));
@property (class, readonly) MultipazKotlinDurationUnit *days __attribute__((swift_name("days")));
+ (MultipazKotlinArray<MultipazKotlinDurationUnit *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazKotlinDurationUnit *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeInstant.Companion")))
@interface MultipazKotlinx_datetimeInstantCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinx_datetimeInstantCompanion *shared __attribute__((swift_name("shared")));
- (MultipazKotlinx_datetimeInstant *)fromEpochMillisecondsEpochMilliseconds:(int64_t)epochMilliseconds __attribute__((swift_name("fromEpochMilliseconds(epochMilliseconds:)")));
- (MultipazKotlinx_datetimeInstant *)fromEpochSecondsEpochSeconds:(int64_t)epochSeconds nanosecondAdjustment:(int32_t)nanosecondAdjustment __attribute__((swift_name("fromEpochSeconds(epochSeconds:nanosecondAdjustment:)")));
- (MultipazKotlinx_datetimeInstant *)fromEpochSecondsEpochSeconds:(int64_t)epochSeconds nanosecondAdjustment_:(int64_t)nanosecondAdjustment __attribute__((swift_name("fromEpochSeconds(epochSeconds:nanosecondAdjustment_:)")));
- (MultipazKotlinx_datetimeInstant *)now __attribute__((swift_name("now()"))) __attribute__((unavailable("Use Clock.System.now() instead")));
- (MultipazKotlinx_datetimeInstant *)parseInput:(id)input format:(id<MultipazKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("parse(input:format:)")));
- (id<MultipazKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@property (readonly) MultipazKotlinx_datetimeInstant *DISTANT_FUTURE __attribute__((swift_name("DISTANT_FUTURE")));
@property (readonly) MultipazKotlinx_datetimeInstant *DISTANT_PAST __attribute__((swift_name("DISTANT_PAST")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeMonth")))
@interface MultipazKotlinx_datetimeMonth : MultipazKotlinEnum<MultipazKotlinx_datetimeMonth *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) MultipazKotlinx_datetimeMonth *january __attribute__((swift_name("january")));
@property (class, readonly) MultipazKotlinx_datetimeMonth *february __attribute__((swift_name("february")));
@property (class, readonly) MultipazKotlinx_datetimeMonth *march __attribute__((swift_name("march")));
@property (class, readonly) MultipazKotlinx_datetimeMonth *april __attribute__((swift_name("april")));
@property (class, readonly) MultipazKotlinx_datetimeMonth *may __attribute__((swift_name("may")));
@property (class, readonly) MultipazKotlinx_datetimeMonth *june __attribute__((swift_name("june")));
@property (class, readonly) MultipazKotlinx_datetimeMonth *july __attribute__((swift_name("july")));
@property (class, readonly) MultipazKotlinx_datetimeMonth *august __attribute__((swift_name("august")));
@property (class, readonly) MultipazKotlinx_datetimeMonth *september __attribute__((swift_name("september")));
@property (class, readonly) MultipazKotlinx_datetimeMonth *october __attribute__((swift_name("october")));
@property (class, readonly) MultipazKotlinx_datetimeMonth *november __attribute__((swift_name("november")));
@property (class, readonly) MultipazKotlinx_datetimeMonth *december __attribute__((swift_name("december")));
+ (MultipazKotlinArray<MultipazKotlinx_datetimeMonth *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazKotlinx_datetimeMonth *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDate.Companion")))
@interface MultipazKotlinx_datetimeLocalDateCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinx_datetimeLocalDateCompanion *shared __attribute__((swift_name("shared")));
- (id<MultipazKotlinx_datetimeDateTimeFormat>)FormatBlock:(void (^)(id<MultipazKotlinx_datetimeDateTimeFormatBuilderWithDate>))block __attribute__((swift_name("Format(block:)")));
- (MultipazKotlinx_datetimeLocalDate *)fromEpochDaysEpochDays:(int32_t)epochDays __attribute__((swift_name("fromEpochDays(epochDays:)")));
- (MultipazKotlinx_datetimeLocalDate *)parseInput:(id)input format:(id<MultipazKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("parse(input:format:)")));
- (id<MultipazKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeDayOfWeek")))
@interface MultipazKotlinx_datetimeDayOfWeek : MultipazKotlinEnum<MultipazKotlinx_datetimeDayOfWeek *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) MultipazKotlinx_datetimeDayOfWeek *monday __attribute__((swift_name("monday")));
@property (class, readonly) MultipazKotlinx_datetimeDayOfWeek *tuesday __attribute__((swift_name("tuesday")));
@property (class, readonly) MultipazKotlinx_datetimeDayOfWeek *wednesday __attribute__((swift_name("wednesday")));
@property (class, readonly) MultipazKotlinx_datetimeDayOfWeek *thursday __attribute__((swift_name("thursday")));
@property (class, readonly) MultipazKotlinx_datetimeDayOfWeek *friday __attribute__((swift_name("friday")));
@property (class, readonly) MultipazKotlinx_datetimeDayOfWeek *saturday __attribute__((swift_name("saturday")));
@property (class, readonly) MultipazKotlinx_datetimeDayOfWeek *sunday __attribute__((swift_name("sunday")));
+ (MultipazKotlinArray<MultipazKotlinx_datetimeDayOfWeek *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazKotlinx_datetimeDayOfWeek *> *entries __attribute__((swift_name("entries")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/LocalTimeIso8601Serializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalTime")))
@interface MultipazKotlinx_datetimeLocalTime : MultipazBase <MultipazKotlinComparable>
- (instancetype)initWithHour:(int32_t)hour minute:(int32_t)minute second:(int32_t)second nanosecond:(int32_t)nanosecond __attribute__((swift_name("init(hour:minute:second:nanosecond:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazKotlinx_datetimeLocalTimeCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(MultipazKotlinx_datetimeLocalTime *)other __attribute__((swift_name("compareTo(other:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (int32_t)toMillisecondOfDay __attribute__((swift_name("toMillisecondOfDay()")));
- (int64_t)toNanosecondOfDay __attribute__((swift_name("toNanosecondOfDay()")));
- (int32_t)toSecondOfDay __attribute__((swift_name("toSecondOfDay()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t hour __attribute__((swift_name("hour")));
@property (readonly) int32_t minute __attribute__((swift_name("minute")));
@property (readonly) int32_t nanosecond __attribute__((swift_name("nanosecond")));
@property (readonly) int32_t second __attribute__((swift_name("second")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDateTime.Companion")))
@interface MultipazKotlinx_datetimeLocalDateTimeCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinx_datetimeLocalDateTimeCompanion *shared __attribute__((swift_name("shared")));
- (id<MultipazKotlinx_datetimeDateTimeFormat>)FormatBuilder:(void (^)(id<MultipazKotlinx_datetimeDateTimeFormatBuilderWithDateTime>))builder __attribute__((swift_name("Format(builder:)")));
- (MultipazKotlinx_datetimeLocalDateTime *)parseInput:(id)input format:(id<MultipazKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("parse(input:format:)")));
- (id<MultipazKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_io_bytestringByteString.Companion")))
@interface MultipazKotlinx_io_bytestringByteStringCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinx_io_bytestringByteStringCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((swift_name("KotlinError")))
@interface MultipazKotlinError : MultipazKotlinThrowable
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((swift_name("KotlinSuspendFunction4")))
@protocol MultipazKotlinSuspendFunction4 <MultipazKotlinFunction>
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)invokeP1:(id _Nullable)p1 p2:(id _Nullable)p2 p3:(id _Nullable)p3 p4:(id _Nullable)p4 completionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("invoke(p1:p2:p3:p4:completionHandler:)")));
@end

__attribute__((swift_name("KotlinSuspendFunction2")))
@protocol MultipazKotlinSuspendFunction2 <MultipazKotlinFunction>
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)invokeP1:(id _Nullable)p1 p2:(id _Nullable)p2 completionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("invoke(p1:p2:completionHandler:)")));
@end

__attribute__((swift_name("KotlinBooleanIterator")))
@interface MultipazKotlinBooleanIterator : MultipazBase <MultipazKotlinIterator>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (MultipazBoolean *)next __attribute__((swift_name("next()")));
- (BOOL)nextBoolean __attribute__((swift_name("nextBoolean()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinRandom.Default")))
@interface MultipazKotlinRandomDefault : MultipazKotlinRandom
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)default_ __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinRandomDefault *shared __attribute__((swift_name("shared")));
- (int32_t)nextBitsBitCount:(int32_t)bitCount __attribute__((swift_name("nextBits(bitCount:)")));
- (BOOL)nextBoolean __attribute__((swift_name("nextBoolean()")));
- (MultipazKotlinByteArray *)nextBytesArray:(MultipazKotlinByteArray *)array __attribute__((swift_name("nextBytes(array:)")));
- (MultipazKotlinByteArray *)nextBytesSize:(int32_t)size __attribute__((swift_name("nextBytes(size:)")));
- (MultipazKotlinByteArray *)nextBytesArray:(MultipazKotlinByteArray *)array fromIndex:(int32_t)fromIndex toIndex:(int32_t)toIndex __attribute__((swift_name("nextBytes(array:fromIndex:toIndex:)")));
- (double)nextDouble __attribute__((swift_name("nextDouble()")));
- (double)nextDoubleUntil:(double)until __attribute__((swift_name("nextDouble(until:)")));
- (double)nextDoubleFrom:(double)from until:(double)until __attribute__((swift_name("nextDouble(from:until:)")));
- (float)nextFloat __attribute__((swift_name("nextFloat()")));
- (int32_t)nextInt __attribute__((swift_name("nextInt()")));
- (int32_t)nextIntUntil:(int32_t)until __attribute__((swift_name("nextInt(until:)")));
- (int32_t)nextIntFrom:(int32_t)from until:(int32_t)until __attribute__((swift_name("nextInt(from:until:)")));
- (int64_t)nextLong __attribute__((swift_name("nextLong()")));
- (int64_t)nextLongUntil:(int64_t)until __attribute__((swift_name("nextLong(until:)")));
- (int64_t)nextLongFrom:(int64_t)from until:(int64_t)until __attribute__((swift_name("nextLong(from:until:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeTimeZone.Companion")))
@interface MultipazKotlinx_datetimeTimeZoneCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinx_datetimeTimeZoneCompanion *shared __attribute__((swift_name("shared")));
- (MultipazKotlinx_datetimeTimeZone *)currentSystemDefault __attribute__((swift_name("currentSystemDefault()")));
- (MultipazKotlinx_datetimeTimeZone *)ofZoneId:(NSString *)zoneId __attribute__((swift_name("of(zoneId:)")));
- (id<MultipazKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@property (readonly) MultipazKotlinx_datetimeFixedOffsetTimeZone *UTC __attribute__((swift_name("UTC")));
@property (readonly) NSSet<NSString *> *availableZoneIds __attribute__((swift_name("availableZoneIds")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_serialization_jsonJsonElement.Companion")))
@interface MultipazKotlinx_serialization_jsonJsonElementCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinx_serialization_jsonJsonElementCompanion *shared __attribute__((swift_name("shared")));
- (id<MultipazKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreSelectClause")))
@protocol MultipazKotlinx_coroutines_coreSelectClause
@required
@property (readonly) id clauseObject __attribute__((swift_name("clauseObject")));
@property (readonly) MultipazKotlinUnit *(^(^ _Nullable onCancellationConstructor)(id<MultipazKotlinx_coroutines_coreSelectInstance>, id _Nullable, id _Nullable))(MultipazKotlinThrowable *) __attribute__((swift_name("onCancellationConstructor")));
@property (readonly) id _Nullable (^processResFunc)(id, id _Nullable, id _Nullable) __attribute__((swift_name("processResFunc")));
@property (readonly) void (^regFunc)(id, id<MultipazKotlinx_coroutines_coreSelectInstance>, id _Nullable) __attribute__((swift_name("regFunc")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreSelectClause2")))
@protocol MultipazKotlinx_coroutines_coreSelectClause2 <MultipazKotlinx_coroutines_coreSelectClause>
@required
@end

__attribute__((swift_name("Ktor_ioCloseable")))
@protocol MultipazKtor_ioCloseable
@required
- (void)close __attribute__((swift_name("close()")));
@end

__attribute__((swift_name("Ktor_client_coreHttpClientEngine")))
@protocol MultipazKtor_client_coreHttpClientEngine <MultipazKotlinx_coroutines_coreCoroutineScope, MultipazKtor_ioCloseable>
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)executeData:(MultipazKtor_client_coreHttpRequestData *)data completionHandler:(void (^)(MultipazKtor_client_coreHttpResponseData * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("execute(data:completionHandler:)")));
- (void)installClient:(MultipazKtor_client_coreHttpClient *)client __attribute__((swift_name("install(client:)")));
@property (readonly) MultipazKtor_client_coreHttpClientEngineConfig *config __attribute__((swift_name("config")));
@property (readonly) MultipazKotlinx_coroutines_coreCoroutineDispatcher *dispatcher __attribute__((swift_name("dispatcher")));
@property (readonly) NSSet<id<MultipazKtor_client_coreHttpClientEngineCapability>> *supportedCapabilities __attribute__((swift_name("supportedCapabilities")));
@end

__attribute__((swift_name("Ktor_client_coreHttpClientEngineConfig")))
@interface MultipazKtor_client_coreHttpClientEngineConfig : MultipazBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property BOOL pipelining __attribute__((swift_name("pipelining")));
@property MultipazKtor_client_coreProxyConfig * _Nullable proxy __attribute__((swift_name("proxy")));
@property int32_t threadsCount __attribute__((swift_name("threadsCount"))) __attribute__((deprecated("The [threadsCount] property is deprecated. The [Dispatchers.IO] is used by default.")));
@end

__attribute__((swift_name("SqliteSQLiteStatement")))
@protocol MultipazSqliteSQLiteStatement
@required

/**
 * @param index annotations androidx.annotation.IntRange(from=1.toLong())
*/
- (void)bindBlobIndex:(int32_t)index value:(MultipazKotlinByteArray *)value __attribute__((swift_name("bindBlob(index:value:)")));

/**
 * @param index annotations androidx.annotation.IntRange(from=1.toLong())
*/
- (void)bindBooleanIndex:(int32_t)index value:(BOOL)value __attribute__((swift_name("bindBoolean(index:value:)")));

/**
 * @param index annotations androidx.annotation.IntRange(from=1.toLong())
*/
- (void)bindDoubleIndex:(int32_t)index value:(double)value __attribute__((swift_name("bindDouble(index:value:)")));

/**
 * @param index annotations androidx.annotation.IntRange(from=1.toLong())
*/
- (void)bindFloatIndex:(int32_t)index value:(float)value __attribute__((swift_name("bindFloat(index:value:)")));

/**
 * @param index annotations androidx.annotation.IntRange(from=1.toLong())
*/
- (void)bindIntIndex:(int32_t)index value:(int32_t)value __attribute__((swift_name("bindInt(index:value:)")));

/**
 * @param index annotations androidx.annotation.IntRange(from=1.toLong())
*/
- (void)bindLongIndex:(int32_t)index value:(int64_t)value __attribute__((swift_name("bindLong(index:value:)")));

/**
 * @param index annotations androidx.annotation.IntRange(from=1.toLong())
*/
- (void)bindNullIndex:(int32_t)index __attribute__((swift_name("bindNull(index:)")));

/**
 * @param index annotations androidx.annotation.IntRange(from=1.toLong())
*/
- (void)bindTextIndex:(int32_t)index value:(NSString *)value __attribute__((swift_name("bindText(index:value:)")));
- (void)clearBindings __attribute__((swift_name("clearBindings()")));
- (void)close __attribute__((swift_name("close()")));

/**
 * @param index annotations androidx.annotation.IntRange(from=0.toLong())
*/
- (MultipazKotlinByteArray *)getBlobIndex:(int32_t)index __attribute__((swift_name("getBlob(index:)")));

/**
 * @param index annotations androidx.annotation.IntRange(from=0.toLong())
*/
- (BOOL)getBooleanIndex:(int32_t)index __attribute__((swift_name("getBoolean(index:)")));
- (int32_t)getColumnCount __attribute__((swift_name("getColumnCount()")));

/**
 * @param index annotations androidx.annotation.IntRange(from=0.toLong())
*/
- (NSString *)getColumnNameIndex:(int32_t)index __attribute__((swift_name("getColumnName(index:)")));
- (NSArray<NSString *> *)getColumnNames __attribute__((swift_name("getColumnNames()")));

/**
 * @param index annotations androidx.annotation.IntRange(from=0.toLong())
*/
- (int32_t)getColumnTypeIndex:(int32_t)index __attribute__((swift_name("getColumnType(index:)")));

/**
 * @param index annotations androidx.annotation.IntRange(from=0.toLong())
*/
- (double)getDoubleIndex:(int32_t)index __attribute__((swift_name("getDouble(index:)")));

/**
 * @param index annotations androidx.annotation.IntRange(from=0.toLong())
*/
- (float)getFloatIndex:(int32_t)index __attribute__((swift_name("getFloat(index:)")));

/**
 * @param index annotations androidx.annotation.IntRange(from=0.toLong())
*/
- (int32_t)getIntIndex:(int32_t)index __attribute__((swift_name("getInt(index:)")));

/**
 * @param index annotations androidx.annotation.IntRange(from=0.toLong())
*/
- (int64_t)getLongIndex:(int32_t)index __attribute__((swift_name("getLong(index:)")));

/**
 * @param index annotations androidx.annotation.IntRange(from=0.toLong())
*/
- (NSString *)getTextIndex:(int32_t)index __attribute__((swift_name("getText(index:)")));

/**
 * @param index annotations androidx.annotation.IntRange(from=0.toLong())
*/
- (BOOL)isNullIndex:(int32_t)index __attribute__((swift_name("isNull(index:)")));
- (void)reset __attribute__((swift_name("reset()")));
- (BOOL)step_ __attribute__((swift_name("step()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinIntProgression.Companion")))
@interface MultipazKotlinIntProgressionCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinIntProgressionCompanion *shared __attribute__((swift_name("shared")));
- (MultipazKotlinIntProgression *)fromClosedRangeRangeStart:(int32_t)rangeStart rangeEnd:(int32_t)rangeEnd step:(int32_t)step __attribute__((swift_name("fromClosedRange(rangeStart:rangeEnd:step:)")));
@end

__attribute__((swift_name("KotlinIntIterator")))
@interface MultipazKotlinIntIterator : MultipazBase <MultipazKotlinIterator>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (MultipazInt *)next __attribute__((swift_name("next()")));
- (int32_t)nextInt __attribute__((swift_name("nextInt()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinIntRange.Companion")))
@interface MultipazKotlinIntRangeCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinIntRangeCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) MultipazKotlinIntRange *EMPTY __attribute__((swift_name("EMPTY")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinLongProgression.Companion")))
@interface MultipazKotlinLongProgressionCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinLongProgressionCompanion *shared __attribute__((swift_name("shared")));
- (MultipazKotlinLongProgression *)fromClosedRangeRangeStart:(int64_t)rangeStart rangeEnd:(int64_t)rangeEnd step:(int64_t)step __attribute__((swift_name("fromClosedRange(rangeStart:rangeEnd:step:)")));
@end

__attribute__((swift_name("KotlinLongIterator")))
@interface MultipazKotlinLongIterator : MultipazBase <MultipazKotlinIterator>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (MultipazLong *)next __attribute__((swift_name("next()")));
- (int64_t)nextLong __attribute__((swift_name("nextLong()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinLongRange.Companion")))
@interface MultipazKotlinLongRangeCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinLongRangeCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) MultipazKotlinLongRange *EMPTY __attribute__((swift_name("EMPTY")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinUIntProgression.Companion")))
@interface MultipazKotlinUIntProgressionCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinUIntProgressionCompanion *shared __attribute__((swift_name("shared")));
- (MultipazKotlinUIntProgression *)fromClosedRangeRangeStart:(uint32_t)rangeStart rangeEnd:(uint32_t)rangeEnd step:(int32_t)step __attribute__((swift_name("fromClosedRange(rangeStart:rangeEnd:step:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinUIntRange.Companion")))
@interface MultipazKotlinUIntRangeCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinUIntRangeCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) MultipazKotlinUIntRange *EMPTY __attribute__((swift_name("EMPTY")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinULongProgression.Companion")))
@interface MultipazKotlinULongProgressionCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinULongProgressionCompanion *shared __attribute__((swift_name("shared")));
- (MultipazKotlinULongProgression *)fromClosedRangeRangeStart:(uint64_t)rangeStart rangeEnd:(uint64_t)rangeEnd step:(int64_t)step __attribute__((swift_name("fromClosedRange(rangeStart:rangeEnd:step:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinULongRange.Companion")))
@interface MultipazKotlinULongRangeCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinULongRangeCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) MultipazKotlinULongRange *EMPTY __attribute__((swift_name("EMPTY")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormat")))
@protocol MultipazKotlinx_datetimeDateTimeFormat
@required
- (NSString *)formatValue:(id _Nullable)value __attribute__((swift_name("format(value:)")));
- (id<MultipazKotlinAppendable>)formatToAppendable:(id<MultipazKotlinAppendable>)appendable value:(id _Nullable)value __attribute__((swift_name("formatTo(appendable:value:)")));
- (id _Nullable)parseInput:(id)input __attribute__((swift_name("parse(input:)")));
- (id _Nullable)parseOrNullInput:(id)input __attribute__((swift_name("parseOrNull(input:)")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreSerializationStrategy")))
@protocol MultipazKotlinx_serialization_coreSerializationStrategy
@required
- (void)serializeEncoder:(id<MultipazKotlinx_serialization_coreEncoder>)encoder value:(id _Nullable)value __attribute__((swift_name("serialize(encoder:value:)")));
@property (readonly) id<MultipazKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreDeserializationStrategy")))
@protocol MultipazKotlinx_serialization_coreDeserializationStrategy
@required
- (id _Nullable)deserializeDecoder:(id<MultipazKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
@property (readonly) id<MultipazKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreKSerializer")))
@protocol MultipazKotlinx_serialization_coreKSerializer <MultipazKotlinx_serialization_coreSerializationStrategy, MultipazKotlinx_serialization_coreDeserializationStrategy>
@required
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilder")))
@protocol MultipazKotlinx_datetimeDateTimeFormatBuilder
@required
- (void)charsValue:(NSString *)value __attribute__((swift_name("chars(value:)")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilderWithDate")))
@protocol MultipazKotlinx_datetimeDateTimeFormatBuilderWithDate <MultipazKotlinx_datetimeDateTimeFormatBuilder>
@required
- (void)dateFormat:(id<MultipazKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("date(format:)")));
- (void)dayOfMonthPadding:(MultipazKotlinx_datetimePadding *)padding __attribute__((swift_name("dayOfMonth(padding:)")));
- (void)dayOfWeekNames:(MultipazKotlinx_datetimeDayOfWeekNames *)names __attribute__((swift_name("dayOfWeek(names:)")));
- (void)monthNameNames:(MultipazKotlinx_datetimeMonthNames *)names __attribute__((swift_name("monthName(names:)")));
- (void)monthNumberPadding:(MultipazKotlinx_datetimePadding *)padding __attribute__((swift_name("monthNumber(padding:)")));
- (void)yearPadding:(MultipazKotlinx_datetimePadding *)padding __attribute__((swift_name("year(padding:)")));
- (void)yearTwoDigitsBaseYear:(int32_t)baseYear __attribute__((swift_name("yearTwoDigits(baseYear:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalTime.Companion")))
@interface MultipazKotlinx_datetimeLocalTimeCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinx_datetimeLocalTimeCompanion *shared __attribute__((swift_name("shared")));
- (id<MultipazKotlinx_datetimeDateTimeFormat>)FormatBuilder:(void (^)(id<MultipazKotlinx_datetimeDateTimeFormatBuilderWithTime>))builder __attribute__((swift_name("Format(builder:)")));
- (MultipazKotlinx_datetimeLocalTime *)fromMillisecondOfDayMillisecondOfDay:(int32_t)millisecondOfDay __attribute__((swift_name("fromMillisecondOfDay(millisecondOfDay:)")));
- (MultipazKotlinx_datetimeLocalTime *)fromNanosecondOfDayNanosecondOfDay:(int64_t)nanosecondOfDay __attribute__((swift_name("fromNanosecondOfDay(nanosecondOfDay:)")));
- (MultipazKotlinx_datetimeLocalTime *)fromSecondOfDaySecondOfDay:(int32_t)secondOfDay __attribute__((swift_name("fromSecondOfDay(secondOfDay:)")));
- (MultipazKotlinx_datetimeLocalTime *)parseInput:(id)input format:(id<MultipazKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("parse(input:format:)")));
- (id<MultipazKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilderWithTime")))
@protocol MultipazKotlinx_datetimeDateTimeFormatBuilderWithTime <MultipazKotlinx_datetimeDateTimeFormatBuilder>
@required
- (void)amPmHourPadding:(MultipazKotlinx_datetimePadding *)padding __attribute__((swift_name("amPmHour(padding:)")));
- (void)amPmMarkerAm:(NSString *)am pm:(NSString *)pm __attribute__((swift_name("amPmMarker(am:pm:)")));
- (void)hourPadding:(MultipazKotlinx_datetimePadding *)padding __attribute__((swift_name("hour(padding:)")));
- (void)minutePadding:(MultipazKotlinx_datetimePadding *)padding __attribute__((swift_name("minute(padding:)")));
- (void)secondPadding:(MultipazKotlinx_datetimePadding *)padding __attribute__((swift_name("second(padding:)")));
- (void)secondFractionFixedLength:(int32_t)fixedLength __attribute__((swift_name("secondFraction(fixedLength:)")));
- (void)secondFractionMinLength:(int32_t)minLength maxLength:(int32_t)maxLength __attribute__((swift_name("secondFraction(minLength:maxLength:)")));
- (void)timeFormat:(id<MultipazKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("time(format:)")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilderWithDateTime")))
@protocol MultipazKotlinx_datetimeDateTimeFormatBuilderWithDateTime <MultipazKotlinx_datetimeDateTimeFormatBuilderWithDate, MultipazKotlinx_datetimeDateTimeFormatBuilderWithTime>
@required
- (void)dateTimeFormat:(id<MultipazKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("dateTime(format:)")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/FixedOffsetTimeZoneSerializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeFixedOffsetTimeZone")))
@interface MultipazKotlinx_datetimeFixedOffsetTimeZone : MultipazKotlinx_datetimeTimeZone
- (instancetype)initWithOffset:(MultipazKotlinx_datetimeUtcOffset *)offset __attribute__((swift_name("init(offset:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazKotlinx_datetimeFixedOffsetTimeZoneCompanion *companion __attribute__((swift_name("companion")));
@property (readonly) NSString *id __attribute__((swift_name("id")));
@property (readonly) MultipazKotlinx_datetimeUtcOffset *offset __attribute__((swift_name("offset")));
@property (readonly) int32_t totalSeconds __attribute__((swift_name("totalSeconds"))) __attribute__((deprecated("Use offset.totalSeconds")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinUnit")))
@interface MultipazKotlinUnit : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)unit __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinUnit *shared __attribute__((swift_name("shared")));
- (NSString *)description __attribute__((swift_name("description()")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreSelectInstance")))
@protocol MultipazKotlinx_coroutines_coreSelectInstance
@required
- (void)disposeOnCompletionDisposableHandle:(id<MultipazKotlinx_coroutines_coreDisposableHandle>)disposableHandle __attribute__((swift_name("disposeOnCompletion(disposableHandle:)")));
- (void)selectInRegistrationPhaseInternalResult:(id _Nullable)internalResult __attribute__((swift_name("selectInRegistrationPhase(internalResult:)")));
- (BOOL)trySelectClauseObject:(id)clauseObject result:(id _Nullable)result __attribute__((swift_name("trySelect(clauseObject:result:)")));
@property (readonly) id<MultipazKotlinCoroutineContext> context __attribute__((swift_name("context")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpRequestData")))
@interface MultipazKtor_client_coreHttpRequestData : MultipazBase
- (instancetype)initWithUrl:(MultipazKtor_httpUrl *)url method:(MultipazKtor_httpHttpMethod *)method headers:(id<MultipazKtor_httpHeaders>)headers body:(MultipazKtor_httpOutgoingContent *)body executionContext:(id<MultipazKotlinx_coroutines_coreJob>)executionContext attributes:(id<MultipazKtor_utilsAttributes>)attributes __attribute__((swift_name("init(url:method:headers:body:executionContext:attributes:)"))) __attribute__((objc_designated_initializer));
- (id _Nullable)getCapabilityOrNullKey:(id<MultipazKtor_client_coreHttpClientEngineCapability>)key __attribute__((swift_name("getCapabilityOrNull(key:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) id<MultipazKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));
@property (readonly) MultipazKtor_httpOutgoingContent *body __attribute__((swift_name("body")));
@property (readonly) id<MultipazKotlinx_coroutines_coreJob> executionContext __attribute__((swift_name("executionContext")));
@property (readonly) id<MultipazKtor_httpHeaders> headers __attribute__((swift_name("headers")));
@property (readonly) MultipazKtor_httpHttpMethod *method __attribute__((swift_name("method")));
@property (readonly) MultipazKtor_httpUrl *url __attribute__((swift_name("url")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpResponseData")))
@interface MultipazKtor_client_coreHttpResponseData : MultipazBase
- (instancetype)initWithStatusCode:(MultipazKtor_httpHttpStatusCode *)statusCode requestTime:(MultipazKtor_utilsGMTDate *)requestTime headers:(id<MultipazKtor_httpHeaders>)headers version:(MultipazKtor_httpHttpProtocolVersion *)version body:(id)body callContext:(id<MultipazKotlinCoroutineContext>)callContext __attribute__((swift_name("init(statusCode:requestTime:headers:version:body:callContext:)"))) __attribute__((objc_designated_initializer));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) id body __attribute__((swift_name("body")));
@property (readonly) id<MultipazKotlinCoroutineContext> callContext __attribute__((swift_name("callContext")));
@property (readonly) id<MultipazKtor_httpHeaders> headers __attribute__((swift_name("headers")));
@property (readonly) MultipazKtor_utilsGMTDate *requestTime __attribute__((swift_name("requestTime")));
@property (readonly) MultipazKtor_utilsGMTDate *responseTime __attribute__((swift_name("responseTime")));
@property (readonly) MultipazKtor_httpHttpStatusCode *statusCode __attribute__((swift_name("statusCode")));
@property (readonly) MultipazKtor_httpHttpProtocolVersion *version __attribute__((swift_name("version")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpClient")))
@interface MultipazKtor_client_coreHttpClient : MultipazBase <MultipazKotlinx_coroutines_coreCoroutineScope, MultipazKtor_ioCloseable>
- (instancetype)initWithEngine:(id<MultipazKtor_client_coreHttpClientEngine>)engine userConfig:(MultipazKtor_client_coreHttpClientConfig<MultipazKtor_client_coreHttpClientEngineConfig *> *)userConfig __attribute__((swift_name("init(engine:userConfig:)"))) __attribute__((objc_designated_initializer));
- (void)close __attribute__((swift_name("close()")));
- (MultipazKtor_client_coreHttpClient *)configBlock:(void (^)(MultipazKtor_client_coreHttpClientConfig<id> *))block __attribute__((swift_name("config(block:)")));
- (BOOL)isSupportedCapability:(id<MultipazKtor_client_coreHttpClientEngineCapability>)capability __attribute__((swift_name("isSupported(capability:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) id<MultipazKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));
@property (readonly) id<MultipazKotlinCoroutineContext> coroutineContext __attribute__((swift_name("coroutineContext")));
@property (readonly) id<MultipazKtor_client_coreHttpClientEngine> engine __attribute__((swift_name("engine")));
@property (readonly) MultipazKtor_client_coreHttpClientEngineConfig *engineConfig __attribute__((swift_name("engineConfig")));
@property (readonly) MultipazKtor_eventsEvents *monitor __attribute__((swift_name("monitor")));
@property (readonly) MultipazKtor_client_coreHttpReceivePipeline *receivePipeline __attribute__((swift_name("receivePipeline")));
@property (readonly) MultipazKtor_client_coreHttpRequestPipeline *requestPipeline __attribute__((swift_name("requestPipeline")));
@property (readonly) MultipazKtor_client_coreHttpResponsePipeline *responsePipeline __attribute__((swift_name("responsePipeline")));
@property (readonly) MultipazKtor_client_coreHttpSendPipeline *sendPipeline __attribute__((swift_name("sendPipeline")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.3")
*/
__attribute__((swift_name("KotlinAbstractCoroutineContextElement")))
@interface MultipazKotlinAbstractCoroutineContextElement : MultipazBase <MultipazKotlinCoroutineContextElement>
- (instancetype)initWithKey:(id<MultipazKotlinCoroutineContextKey>)key __attribute__((swift_name("init(key:)"))) __attribute__((objc_designated_initializer));
@property (readonly) id<MultipazKotlinCoroutineContextKey> key __attribute__((swift_name("key")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.3")
*/
__attribute__((swift_name("KotlinContinuationInterceptor")))
@protocol MultipazKotlinContinuationInterceptor <MultipazKotlinCoroutineContextElement>
@required
- (id<MultipazKotlinContinuation>)interceptContinuationContinuation:(id<MultipazKotlinContinuation>)continuation __attribute__((swift_name("interceptContinuation(continuation:)")));
- (void)releaseInterceptedContinuationContinuation:(id<MultipazKotlinContinuation>)continuation __attribute__((swift_name("releaseInterceptedContinuation(continuation:)")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreCoroutineDispatcher")))
@interface MultipazKotlinx_coroutines_coreCoroutineDispatcher : MultipazKotlinAbstractCoroutineContextElement <MultipazKotlinContinuationInterceptor>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithKey:(id<MultipazKotlinCoroutineContextKey>)key __attribute__((swift_name("init(key:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazKotlinx_coroutines_coreCoroutineDispatcherKey *companion __attribute__((swift_name("companion")));
- (void)dispatchContext:(id<MultipazKotlinCoroutineContext>)context block:(id<MultipazKotlinx_coroutines_coreRunnable>)block __attribute__((swift_name("dispatch(context:block:)")));
- (void)dispatchYieldContext:(id<MultipazKotlinCoroutineContext>)context block:(id<MultipazKotlinx_coroutines_coreRunnable>)block __attribute__((swift_name("dispatchYield(context:block:)")));
- (id<MultipazKotlinContinuation>)interceptContinuationContinuation:(id<MultipazKotlinContinuation>)continuation __attribute__((swift_name("interceptContinuation(continuation:)")));
- (BOOL)isDispatchNeededContext:(id<MultipazKotlinCoroutineContext>)context __attribute__((swift_name("isDispatchNeeded(context:)")));

/**
 * @note annotations
 *   kotlinx.coroutines.ExperimentalCoroutinesApi
*/
- (MultipazKotlinx_coroutines_coreCoroutineDispatcher *)limitedParallelismParallelism:(int32_t)parallelism __attribute__((swift_name("limitedParallelism(parallelism:)")));
- (MultipazKotlinx_coroutines_coreCoroutineDispatcher *)plusOther:(MultipazKotlinx_coroutines_coreCoroutineDispatcher *)other __attribute__((swift_name("plus(other:)"))) __attribute__((unavailable("Operator '+' on two CoroutineDispatcher objects is meaningless. CoroutineDispatcher is a coroutine context element and `+` is a set-sum operator for coroutine contexts. The dispatcher to the right of `+` just replaces the dispatcher to the left.")));
- (void)releaseInterceptedContinuationContinuation:(id<MultipazKotlinContinuation>)continuation __attribute__((swift_name("releaseInterceptedContinuation(continuation:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@end

__attribute__((swift_name("Ktor_client_coreHttpClientEngineCapability")))
@protocol MultipazKtor_client_coreHttpClientEngineCapability
@required
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreProxyConfig")))
@interface MultipazKtor_client_coreProxyConfig : MultipazBase
- (instancetype)initWithUrl:(MultipazKtor_httpUrl *)url __attribute__((swift_name("init(url:)"))) __attribute__((objc_designated_initializer));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKtor_httpUrl *url __attribute__((swift_name("url")));
@end

__attribute__((swift_name("KotlinAppendable")))
@protocol MultipazKotlinAppendable
@required
- (id<MultipazKotlinAppendable>)appendValue:(unichar)value __attribute__((swift_name("append(value:)")));
- (id<MultipazKotlinAppendable>)appendValue_:(id _Nullable)value __attribute__((swift_name("append(value_:)")));
- (id<MultipazKotlinAppendable>)appendValue:(id _Nullable)value startIndex:(int32_t)startIndex endIndex:(int32_t)endIndex __attribute__((swift_name("append(value:startIndex:endIndex:)")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreEncoder")))
@protocol MultipazKotlinx_serialization_coreEncoder
@required
- (id<MultipazKotlinx_serialization_coreCompositeEncoder>)beginCollectionDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor collectionSize:(int32_t)collectionSize __attribute__((swift_name("beginCollection(descriptor:collectionSize:)")));
- (id<MultipazKotlinx_serialization_coreCompositeEncoder>)beginStructureDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("beginStructure(descriptor:)")));
- (void)encodeBooleanValue:(BOOL)value __attribute__((swift_name("encodeBoolean(value:)")));
- (void)encodeByteValue:(int8_t)value __attribute__((swift_name("encodeByte(value:)")));
- (void)encodeCharValue:(unichar)value __attribute__((swift_name("encodeChar(value:)")));
- (void)encodeDoubleValue:(double)value __attribute__((swift_name("encodeDouble(value:)")));
- (void)encodeEnumEnumDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)enumDescriptor index:(int32_t)index __attribute__((swift_name("encodeEnum(enumDescriptor:index:)")));
- (void)encodeFloatValue:(float)value __attribute__((swift_name("encodeFloat(value:)")));
- (id<MultipazKotlinx_serialization_coreEncoder>)encodeInlineDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("encodeInline(descriptor:)")));
- (void)encodeIntValue:(int32_t)value __attribute__((swift_name("encodeInt(value:)")));
- (void)encodeLongValue:(int64_t)value __attribute__((swift_name("encodeLong(value:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (void)encodeNotNullMark __attribute__((swift_name("encodeNotNullMark()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (void)encodeNull __attribute__((swift_name("encodeNull()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (void)encodeNullableSerializableValueSerializer:(id<MultipazKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeNullableSerializableValue(serializer:value:)")));
- (void)encodeSerializableValueSerializer:(id<MultipazKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeSerializableValue(serializer:value:)")));
- (void)encodeShortValue:(int16_t)value __attribute__((swift_name("encodeShort(value:)")));
- (void)encodeStringValue:(NSString *)value __attribute__((swift_name("encodeString(value:)")));
@property (readonly) MultipazKotlinx_serialization_coreSerializersModule *serializersModule __attribute__((swift_name("serializersModule")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreSerialDescriptor")))
@protocol MultipazKotlinx_serialization_coreSerialDescriptor
@required

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (NSArray<id<MultipazKotlinAnnotation>> *)getElementAnnotationsIndex:(int32_t)index __attribute__((swift_name("getElementAnnotations(index:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (id<MultipazKotlinx_serialization_coreSerialDescriptor>)getElementDescriptorIndex:(int32_t)index __attribute__((swift_name("getElementDescriptor(index:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (int32_t)getElementIndexName:(NSString *)name __attribute__((swift_name("getElementIndex(name:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (NSString *)getElementNameIndex:(int32_t)index __attribute__((swift_name("getElementName(index:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (BOOL)isElementOptionalIndex:(int32_t)index __attribute__((swift_name("isElementOptional(index:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property (readonly) NSArray<id<MultipazKotlinAnnotation>> *annotations __attribute__((swift_name("annotations")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property (readonly) int32_t elementsCount __attribute__((swift_name("elementsCount")));
@property (readonly) BOOL isInline __attribute__((swift_name("isInline")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property (readonly) BOOL isNullable __attribute__((swift_name("isNullable")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property (readonly) MultipazKotlinx_serialization_coreSerialKind *kind __attribute__((swift_name("kind")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property (readonly) NSString *serialName __attribute__((swift_name("serialName")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreDecoder")))
@protocol MultipazKotlinx_serialization_coreDecoder
@required
- (id<MultipazKotlinx_serialization_coreCompositeDecoder>)beginStructureDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("beginStructure(descriptor:)")));
- (BOOL)decodeBoolean __attribute__((swift_name("decodeBoolean()")));
- (int8_t)decodeByte __attribute__((swift_name("decodeByte()")));
- (unichar)decodeChar __attribute__((swift_name("decodeChar()")));
- (double)decodeDouble __attribute__((swift_name("decodeDouble()")));
- (int32_t)decodeEnumEnumDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)enumDescriptor __attribute__((swift_name("decodeEnum(enumDescriptor:)")));
- (float)decodeFloat __attribute__((swift_name("decodeFloat()")));
- (id<MultipazKotlinx_serialization_coreDecoder>)decodeInlineDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("decodeInline(descriptor:)")));
- (int32_t)decodeInt __attribute__((swift_name("decodeInt()")));
- (int64_t)decodeLong __attribute__((swift_name("decodeLong()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (BOOL)decodeNotNullMark __attribute__((swift_name("decodeNotNullMark()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (MultipazKotlinNothing * _Nullable)decodeNull __attribute__((swift_name("decodeNull()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (id _Nullable)decodeNullableSerializableValueDeserializer:(id<MultipazKotlinx_serialization_coreDeserializationStrategy>)deserializer __attribute__((swift_name("decodeNullableSerializableValue(deserializer:)")));
- (id _Nullable)decodeSerializableValueDeserializer:(id<MultipazKotlinx_serialization_coreDeserializationStrategy>)deserializer __attribute__((swift_name("decodeSerializableValue(deserializer:)")));
- (int16_t)decodeShort __attribute__((swift_name("decodeShort()")));
- (NSString *)decodeString __attribute__((swift_name("decodeString()")));
@property (readonly) MultipazKotlinx_serialization_coreSerializersModule *serializersModule __attribute__((swift_name("serializersModule")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimePadding")))
@interface MultipazKotlinx_datetimePadding : MultipazKotlinEnum<MultipazKotlinx_datetimePadding *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) MultipazKotlinx_datetimePadding *none __attribute__((swift_name("none")));
@property (class, readonly) MultipazKotlinx_datetimePadding *zero __attribute__((swift_name("zero")));
@property (class, readonly) MultipazKotlinx_datetimePadding *space __attribute__((swift_name("space")));
+ (MultipazKotlinArray<MultipazKotlinx_datetimePadding *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazKotlinx_datetimePadding *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeDayOfWeekNames")))
@interface MultipazKotlinx_datetimeDayOfWeekNames : MultipazBase
- (instancetype)initWithNames:(NSArray<NSString *> *)names __attribute__((swift_name("init(names:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMonday:(NSString *)monday tuesday:(NSString *)tuesday wednesday:(NSString *)wednesday thursday:(NSString *)thursday friday:(NSString *)friday saturday:(NSString *)saturday sunday:(NSString *)sunday __attribute__((swift_name("init(monday:tuesday:wednesday:thursday:friday:saturday:sunday:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazKotlinx_datetimeDayOfWeekNamesCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSArray<NSString *> *names __attribute__((swift_name("names")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeMonthNames")))
@interface MultipazKotlinx_datetimeMonthNames : MultipazBase
- (instancetype)initWithNames:(NSArray<NSString *> *)names __attribute__((swift_name("init(names:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithJanuary:(NSString *)january february:(NSString *)february march:(NSString *)march april:(NSString *)april may:(NSString *)may june:(NSString *)june july:(NSString *)july august:(NSString *)august september:(NSString *)september october:(NSString *)october november:(NSString *)november december:(NSString *)december __attribute__((swift_name("init(january:february:march:april:may:june:july:august:september:october:november:december:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazKotlinx_datetimeMonthNamesCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSArray<NSString *> *names __attribute__((swift_name("names")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/UtcOffsetSerializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeUtcOffset")))
@interface MultipazKotlinx_datetimeUtcOffset : MultipazBase
@property (class, readonly, getter=companion) MultipazKotlinx_datetimeUtcOffsetCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t totalSeconds __attribute__((swift_name("totalSeconds")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeFixedOffsetTimeZone.Companion")))
@interface MultipazKotlinx_datetimeFixedOffsetTimeZoneCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinx_datetimeFixedOffsetTimeZoneCompanion *shared __attribute__((swift_name("shared")));
- (id<MultipazKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreDisposableHandle")))
@protocol MultipazKotlinx_coroutines_coreDisposableHandle
@required
- (void)dispose __attribute__((swift_name("dispose()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpUrl")))
@interface MultipazKtor_httpUrl : MultipazBase
@property (class, readonly, getter=companion) MultipazKtor_httpUrlCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *encodedFragment __attribute__((swift_name("encodedFragment")));
@property (readonly) NSString * _Nullable encodedPassword __attribute__((swift_name("encodedPassword")));
@property (readonly) NSString *encodedPath __attribute__((swift_name("encodedPath")));
@property (readonly) NSString *encodedPathAndQuery __attribute__((swift_name("encodedPathAndQuery")));
@property (readonly) NSString *encodedQuery __attribute__((swift_name("encodedQuery")));
@property (readonly) NSString * _Nullable encodedUser __attribute__((swift_name("encodedUser")));
@property (readonly) NSString *fragment __attribute__((swift_name("fragment")));
@property (readonly) NSString *host __attribute__((swift_name("host")));
@property (readonly) id<MultipazKtor_httpParameters> parameters __attribute__((swift_name("parameters")));
@property (readonly) NSString * _Nullable password __attribute__((swift_name("password")));
@property (readonly) NSArray<NSString *> *pathSegments __attribute__((swift_name("pathSegments")));
@property (readonly) int32_t port __attribute__((swift_name("port")));
@property (readonly) MultipazKtor_httpURLProtocol *protocol __attribute__((swift_name("protocol")));
@property (readonly) int32_t specifiedPort __attribute__((swift_name("specifiedPort")));
@property (readonly) BOOL trailingQuery __attribute__((swift_name("trailingQuery")));
@property (readonly) NSString * _Nullable user __attribute__((swift_name("user")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpMethod")))
@interface MultipazKtor_httpHttpMethod : MultipazBase
- (instancetype)initWithValue:(NSString *)value __attribute__((swift_name("init(value:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazKtor_httpHttpMethodCompanion *companion __attribute__((swift_name("companion")));
- (MultipazKtor_httpHttpMethod *)doCopyValue:(NSString *)value __attribute__((swift_name("doCopy(value:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((swift_name("Ktor_utilsStringValues")))
@protocol MultipazKtor_utilsStringValues
@required
- (BOOL)containsName:(NSString *)name __attribute__((swift_name("contains(name:)")));
- (BOOL)containsName:(NSString *)name value:(NSString *)value __attribute__((swift_name("contains(name:value:)")));
- (NSSet<id<MultipazKotlinMapEntry>> *)entries __attribute__((swift_name("entries()")));
- (void)forEachBody:(void (^)(NSString *, NSArray<NSString *> *))body __attribute__((swift_name("forEach(body:)")));
- (NSString * _Nullable)getName:(NSString *)name __attribute__((swift_name("get(name:)")));
- (NSArray<NSString *> * _Nullable)getAllName:(NSString *)name __attribute__((swift_name("getAll(name:)")));
- (BOOL)isEmpty __attribute__((swift_name("isEmpty()")));
- (NSSet<NSString *> *)names __attribute__((swift_name("names()")));
@property (readonly) BOOL caseInsensitiveName __attribute__((swift_name("caseInsensitiveName")));
@end

__attribute__((swift_name("Ktor_httpHeaders")))
@protocol MultipazKtor_httpHeaders <MultipazKtor_utilsStringValues>
@required
@end

__attribute__((swift_name("Ktor_httpOutgoingContent")))
@interface MultipazKtor_httpOutgoingContent : MultipazBase
- (id _Nullable)getPropertyKey:(MultipazKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("getProperty(key:)")));
- (void)setPropertyKey:(MultipazKtor_utilsAttributeKey<id> *)key value:(id _Nullable)value __attribute__((swift_name("setProperty(key:value:)")));
- (id<MultipazKtor_httpHeaders> _Nullable)trailers __attribute__((swift_name("trailers()")));
@property (readonly) MultipazLong * _Nullable contentLength __attribute__((swift_name("contentLength")));
@property (readonly) MultipazKtor_httpContentType * _Nullable contentType __attribute__((swift_name("contentType")));
@property (readonly) id<MultipazKtor_httpHeaders> headers __attribute__((swift_name("headers")));
@property (readonly) MultipazKtor_httpHttpStatusCode * _Nullable status __attribute__((swift_name("status")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreJob")))
@protocol MultipazKotlinx_coroutines_coreJob <MultipazKotlinCoroutineContextElement>
@required
- (id<MultipazKotlinx_coroutines_coreChildHandle>)attachChildChild:(id<MultipazKotlinx_coroutines_coreChildJob>)child __attribute__((swift_name("attachChild(child:)")));
- (void)cancelCause:(MultipazKotlinCancellationException * _Nullable)cause __attribute__((swift_name("cancel(cause:)")));
- (MultipazKotlinCancellationException *)getCancellationException __attribute__((swift_name("getCancellationException()")));
- (id<MultipazKotlinx_coroutines_coreDisposableHandle>)invokeOnCompletionHandler:(void (^)(MultipazKotlinThrowable * _Nullable))handler __attribute__((swift_name("invokeOnCompletion(handler:)")));
- (id<MultipazKotlinx_coroutines_coreDisposableHandle>)invokeOnCompletionOnCancelling:(BOOL)onCancelling invokeImmediately:(BOOL)invokeImmediately handler:(void (^)(MultipazKotlinThrowable * _Nullable))handler __attribute__((swift_name("invokeOnCompletion(onCancelling:invokeImmediately:handler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)joinWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("join(completionHandler:)")));
- (id<MultipazKotlinx_coroutines_coreJob>)plusOther_:(id<MultipazKotlinx_coroutines_coreJob>)other __attribute__((swift_name("plus(other_:)"))) __attribute__((unavailable("Operator '+' on two Job objects is meaningless. Job is a coroutine context element and `+` is a set-sum operator for coroutine contexts. The job to the right of `+` just replaces the job the left of `+`.")));
- (BOOL)start_ __attribute__((swift_name("start()")));
@property (readonly) id<MultipazKotlinSequence> children __attribute__((swift_name("children")));
@property (readonly) BOOL isActive __attribute__((swift_name("isActive")));
@property (readonly) BOOL isCancelled __attribute__((swift_name("isCancelled")));
@property (readonly) BOOL isCompleted __attribute__((swift_name("isCompleted")));
@property (readonly) id<MultipazKotlinx_coroutines_coreSelectClause0> onJoin __attribute__((swift_name("onJoin")));

/**
 * @note annotations
 *   kotlinx.coroutines.ExperimentalCoroutinesApi
*/
@property (readonly) id<MultipazKotlinx_coroutines_coreJob> _Nullable parent __attribute__((swift_name("parent")));
@end

__attribute__((swift_name("Ktor_utilsAttributes")))
@protocol MultipazKtor_utilsAttributes
@required
- (id)computeIfAbsentKey:(MultipazKtor_utilsAttributeKey<id> *)key block:(id (^)(void))block __attribute__((swift_name("computeIfAbsent(key:block:)")));
- (BOOL)containsKey:(MultipazKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("contains(key:)")));
- (id)getKey____:(MultipazKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("get(key____:)")));
- (id _Nullable)getOrNullKey___:(MultipazKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("getOrNull(key___:)")));
- (void)putKey:(MultipazKtor_utilsAttributeKey<id> *)key value:(id)value __attribute__((swift_name("put(key:value:)")));
- (void)removeKey:(MultipazKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("remove(key:)")));
- (id)takeKey:(MultipazKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("take(key:)")));
- (id _Nullable)takeOrNullKey:(MultipazKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("takeOrNull(key:)")));
@property (readonly) NSArray<MultipazKtor_utilsAttributeKey<id> *> *allKeys __attribute__((swift_name("allKeys")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpStatusCode")))
@interface MultipazKtor_httpHttpStatusCode : MultipazBase <MultipazKotlinComparable>
- (instancetype)initWithValue:(int32_t)value description:(NSString *)description __attribute__((swift_name("init(value:description:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazKtor_httpHttpStatusCodeCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(MultipazKtor_httpHttpStatusCode *)other __attribute__((swift_name("compareTo(other:)")));
- (MultipazKtor_httpHttpStatusCode *)doCopyValue:(int32_t)value description:(NSString *)description __attribute__((swift_name("doCopy(value:description:)")));
- (MultipazKtor_httpHttpStatusCode *)descriptionValue:(NSString *)value __attribute__((swift_name("description(value:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *description_ __attribute__((swift_name("description_")));
@property (readonly) int32_t value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsGMTDate")))
@interface MultipazKtor_utilsGMTDate : MultipazBase <MultipazKotlinComparable>
@property (class, readonly, getter=companion) MultipazKtor_utilsGMTDateCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(MultipazKtor_utilsGMTDate *)other __attribute__((swift_name("compareTo(other:)")));
- (MultipazKtor_utilsGMTDate *)doCopySeconds:(int32_t)seconds minutes:(int32_t)minutes hours:(int32_t)hours dayOfWeek:(MultipazKtor_utilsWeekDay *)dayOfWeek dayOfMonth:(int32_t)dayOfMonth dayOfYear:(int32_t)dayOfYear month:(MultipazKtor_utilsMonth *)month year:(int32_t)year timestamp:(int64_t)timestamp __attribute__((swift_name("doCopy(seconds:minutes:hours:dayOfWeek:dayOfMonth:dayOfYear:month:year:timestamp:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t dayOfMonth __attribute__((swift_name("dayOfMonth")));
@property (readonly) MultipazKtor_utilsWeekDay *dayOfWeek __attribute__((swift_name("dayOfWeek")));
@property (readonly) int32_t dayOfYear __attribute__((swift_name("dayOfYear")));
@property (readonly) int32_t hours __attribute__((swift_name("hours")));
@property (readonly) int32_t minutes __attribute__((swift_name("minutes")));
@property (readonly) MultipazKtor_utilsMonth *month __attribute__((swift_name("month")));
@property (readonly) int32_t seconds __attribute__((swift_name("seconds")));
@property (readonly) int64_t timestamp __attribute__((swift_name("timestamp")));
@property (readonly) int32_t year __attribute__((swift_name("year")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpProtocolVersion")))
@interface MultipazKtor_httpHttpProtocolVersion : MultipazBase
- (instancetype)initWithName:(NSString *)name major:(int32_t)major minor:(int32_t)minor __attribute__((swift_name("init(name:major:minor:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazKtor_httpHttpProtocolVersionCompanion *companion __attribute__((swift_name("companion")));
- (MultipazKtor_httpHttpProtocolVersion *)doCopyName:(NSString *)name major:(int32_t)major minor:(int32_t)minor __attribute__((swift_name("doCopy(name:major:minor:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t major __attribute__((swift_name("major")));
@property (readonly) int32_t minor __attribute__((swift_name("minor")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpClientConfig")))
@interface MultipazKtor_client_coreHttpClientConfig<T> : MultipazBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (MultipazKtor_client_coreHttpClientConfig<T> *)clone __attribute__((swift_name("clone()")));
- (void)engineBlock:(void (^)(T))block __attribute__((swift_name("engine(block:)")));
- (void)installClient:(MultipazKtor_client_coreHttpClient *)client __attribute__((swift_name("install(client:)")));
- (void)installPlugin:(id<MultipazKtor_client_coreHttpClientPlugin>)plugin configure:(void (^)(id))configure __attribute__((swift_name("install(plugin:configure:)")));
- (void)installKey:(NSString *)key block:(void (^)(MultipazKtor_client_coreHttpClient *))block __attribute__((swift_name("install(key:block:)")));
- (void)plusAssignOther:(MultipazKtor_client_coreHttpClientConfig<T> *)other __attribute__((swift_name("plusAssign(other:)")));
@property BOOL developmentMode __attribute__((swift_name("developmentMode")));
@property BOOL expectSuccess __attribute__((swift_name("expectSuccess")));
@property BOOL followRedirects __attribute__((swift_name("followRedirects")));
@property BOOL useDefaultTransformers __attribute__((swift_name("useDefaultTransformers")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_eventsEvents")))
@interface MultipazKtor_eventsEvents : MultipazBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (void)raiseDefinition:(MultipazKtor_eventsEventDefinition<id> *)definition value:(id _Nullable)value __attribute__((swift_name("raise(definition:value:)")));
- (id<MultipazKotlinx_coroutines_coreDisposableHandle>)subscribeDefinition:(MultipazKtor_eventsEventDefinition<id> *)definition handler:(void (^)(id _Nullable))handler __attribute__((swift_name("subscribe(definition:handler:)")));
- (void)unsubscribeDefinition:(MultipazKtor_eventsEventDefinition<id> *)definition handler:(void (^)(id _Nullable))handler __attribute__((swift_name("unsubscribe(definition:handler:)")));
@end

__attribute__((swift_name("Ktor_utilsPipeline")))
@interface MultipazKtor_utilsPipeline<TSubject, TContext> : MultipazBase
- (instancetype)initWithPhases:(MultipazKotlinArray<MultipazKtor_utilsPipelinePhase *> *)phases __attribute__((swift_name("init(phases:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithPhase:(MultipazKtor_utilsPipelinePhase *)phase interceptors:(NSArray<id<MultipazKotlinSuspendFunction2>> *)interceptors __attribute__((swift_name("init(phase:interceptors:)"))) __attribute__((objc_designated_initializer));
- (void)addPhasePhase:(MultipazKtor_utilsPipelinePhase *)phase __attribute__((swift_name("addPhase(phase:)")));
- (void)afterIntercepted __attribute__((swift_name("afterIntercepted()")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)executeContext:(TContext)context subject:(TSubject)subject completionHandler:(void (^)(TSubject _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("execute(context:subject:completionHandler:)")));
- (void)insertPhaseAfterReference:(MultipazKtor_utilsPipelinePhase *)reference phase:(MultipazKtor_utilsPipelinePhase *)phase __attribute__((swift_name("insertPhaseAfter(reference:phase:)")));
- (void)insertPhaseBeforeReference:(MultipazKtor_utilsPipelinePhase *)reference phase:(MultipazKtor_utilsPipelinePhase *)phase __attribute__((swift_name("insertPhaseBefore(reference:phase:)")));
- (void)interceptPhase:(MultipazKtor_utilsPipelinePhase *)phase block:(id<MultipazKotlinSuspendFunction2>)block __attribute__((swift_name("intercept(phase:block:)")));
- (NSArray<id<MultipazKotlinSuspendFunction2>> *)interceptorsForPhasePhase:(MultipazKtor_utilsPipelinePhase *)phase __attribute__((swift_name("interceptorsForPhase(phase:)")));
- (void)mergeFrom:(MultipazKtor_utilsPipeline<TSubject, TContext> *)from __attribute__((swift_name("merge(from:)")));
- (void)mergePhasesFrom:(MultipazKtor_utilsPipeline<TSubject, TContext> *)from __attribute__((swift_name("mergePhases(from:)")));
- (void)resetFromFrom:(MultipazKtor_utilsPipeline<TSubject, TContext> *)from __attribute__((swift_name("resetFrom(from:)")));
@property (readonly) id<MultipazKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));
@property (readonly) BOOL developmentMode __attribute__((swift_name("developmentMode")));
@property (readonly, getter=isEmpty_) BOOL isEmpty __attribute__((swift_name("isEmpty")));
@property (readonly) NSArray<MultipazKtor_utilsPipelinePhase *> *items __attribute__((swift_name("items")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpReceivePipeline")))
@interface MultipazKtor_client_coreHttpReceivePipeline : MultipazKtor_utilsPipeline<MultipazKtor_client_coreHttpResponse *, MultipazKotlinUnit *>
- (instancetype)initWithDevelopmentMode:(BOOL)developmentMode __attribute__((swift_name("init(developmentMode:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithPhases:(MultipazKotlinArray<MultipazKtor_utilsPipelinePhase *> *)phases __attribute__((swift_name("init(phases:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithPhase:(MultipazKtor_utilsPipelinePhase *)phase interceptors:(NSArray<id<MultipazKotlinSuspendFunction2>> *)interceptors __attribute__((swift_name("init(phase:interceptors:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazKtor_client_coreHttpReceivePipelinePhases *companion __attribute__((swift_name("companion")));
@property (readonly) BOOL developmentMode __attribute__((swift_name("developmentMode")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpRequestPipeline")))
@interface MultipazKtor_client_coreHttpRequestPipeline : MultipazKtor_utilsPipeline<id, MultipazKtor_client_coreHttpRequestBuilder *>
- (instancetype)initWithDevelopmentMode:(BOOL)developmentMode __attribute__((swift_name("init(developmentMode:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithPhases:(MultipazKotlinArray<MultipazKtor_utilsPipelinePhase *> *)phases __attribute__((swift_name("init(phases:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithPhase:(MultipazKtor_utilsPipelinePhase *)phase interceptors:(NSArray<id<MultipazKotlinSuspendFunction2>> *)interceptors __attribute__((swift_name("init(phase:interceptors:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazKtor_client_coreHttpRequestPipelinePhases *companion __attribute__((swift_name("companion")));
@property (readonly) BOOL developmentMode __attribute__((swift_name("developmentMode")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpResponsePipeline")))
@interface MultipazKtor_client_coreHttpResponsePipeline : MultipazKtor_utilsPipeline<MultipazKtor_client_coreHttpResponseContainer *, MultipazKtor_client_coreHttpClientCall *>
- (instancetype)initWithDevelopmentMode:(BOOL)developmentMode __attribute__((swift_name("init(developmentMode:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithPhases:(MultipazKotlinArray<MultipazKtor_utilsPipelinePhase *> *)phases __attribute__((swift_name("init(phases:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithPhase:(MultipazKtor_utilsPipelinePhase *)phase interceptors:(NSArray<id<MultipazKotlinSuspendFunction2>> *)interceptors __attribute__((swift_name("init(phase:interceptors:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazKtor_client_coreHttpResponsePipelinePhases *companion __attribute__((swift_name("companion")));
@property (readonly) BOOL developmentMode __attribute__((swift_name("developmentMode")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpSendPipeline")))
@interface MultipazKtor_client_coreHttpSendPipeline : MultipazKtor_utilsPipeline<id, MultipazKtor_client_coreHttpRequestBuilder *>
- (instancetype)initWithDevelopmentMode:(BOOL)developmentMode __attribute__((swift_name("init(developmentMode:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithPhases:(MultipazKotlinArray<MultipazKtor_utilsPipelinePhase *> *)phases __attribute__((swift_name("init(phases:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithPhase:(MultipazKtor_utilsPipelinePhase *)phase interceptors:(NSArray<id<MultipazKotlinSuspendFunction2>> *)interceptors __attribute__((swift_name("init(phase:interceptors:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazKtor_client_coreHttpSendPipelinePhases *companion __attribute__((swift_name("companion")));
@property (readonly) BOOL developmentMode __attribute__((swift_name("developmentMode")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.3")
*/
__attribute__((swift_name("KotlinContinuation")))
@protocol MultipazKotlinContinuation
@required
- (void)resumeWithResult:(id _Nullable)result __attribute__((swift_name("resumeWith(result:)")));
@property (readonly) id<MultipazKotlinCoroutineContext> context __attribute__((swift_name("context")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.3")
 *   kotlin.ExperimentalStdlibApi
*/
__attribute__((swift_name("KotlinAbstractCoroutineContextKey")))
@interface MultipazKotlinAbstractCoroutineContextKey<B, E> : MultipazBase <MultipazKotlinCoroutineContextKey>
- (instancetype)initWithBaseKey:(id<MultipazKotlinCoroutineContextKey>)baseKey safeCast:(E _Nullable (^)(id<MultipazKotlinCoroutineContextElement>))safeCast __attribute__((swift_name("init(baseKey:safeCast:)"))) __attribute__((objc_designated_initializer));
@end


/**
 * @note annotations
 *   kotlin.ExperimentalStdlibApi
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_coroutines_coreCoroutineDispatcher.Key")))
@interface MultipazKotlinx_coroutines_coreCoroutineDispatcherKey : MultipazKotlinAbstractCoroutineContextKey<id<MultipazKotlinContinuationInterceptor>, MultipazKotlinx_coroutines_coreCoroutineDispatcher *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithBaseKey:(id<MultipazKotlinCoroutineContextKey>)baseKey safeCast:(id<MultipazKotlinCoroutineContextElement> _Nullable (^)(id<MultipazKotlinCoroutineContextElement>))safeCast __attribute__((swift_name("init(baseKey:safeCast:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)key __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinx_coroutines_coreCoroutineDispatcherKey *shared __attribute__((swift_name("shared")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreRunnable")))
@protocol MultipazKotlinx_coroutines_coreRunnable
@required
- (void)run __attribute__((swift_name("run()")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreCompositeEncoder")))
@protocol MultipazKotlinx_serialization_coreCompositeEncoder
@required
- (void)encodeBooleanElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(BOOL)value __attribute__((swift_name("encodeBooleanElement(descriptor:index:value:)")));
- (void)encodeByteElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(int8_t)value __attribute__((swift_name("encodeByteElement(descriptor:index:value:)")));
- (void)encodeCharElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(unichar)value __attribute__((swift_name("encodeCharElement(descriptor:index:value:)")));
- (void)encodeDoubleElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(double)value __attribute__((swift_name("encodeDoubleElement(descriptor:index:value:)")));
- (void)encodeFloatElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(float)value __attribute__((swift_name("encodeFloatElement(descriptor:index:value:)")));
- (id<MultipazKotlinx_serialization_coreEncoder>)encodeInlineElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("encodeInlineElement(descriptor:index:)")));
- (void)encodeIntElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(int32_t)value __attribute__((swift_name("encodeIntElement(descriptor:index:value:)")));
- (void)encodeLongElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(int64_t)value __attribute__((swift_name("encodeLongElement(descriptor:index:value:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (void)encodeNullableSerializableElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index serializer:(id<MultipazKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeNullableSerializableElement(descriptor:index:serializer:value:)")));
- (void)encodeSerializableElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index serializer:(id<MultipazKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeSerializableElement(descriptor:index:serializer:value:)")));
- (void)encodeShortElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(int16_t)value __attribute__((swift_name("encodeShortElement(descriptor:index:value:)")));
- (void)encodeStringElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(NSString *)value __attribute__((swift_name("encodeStringElement(descriptor:index:value:)")));
- (void)endStructureDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("endStructure(descriptor:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (BOOL)shouldEncodeElementDefaultDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("shouldEncodeElementDefault(descriptor:index:)")));
@property (readonly) MultipazKotlinx_serialization_coreSerializersModule *serializersModule __attribute__((swift_name("serializersModule")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreSerializersModule")))
@interface MultipazKotlinx_serialization_coreSerializersModule : MultipazBase

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (void)dumpToCollector:(id<MultipazKotlinx_serialization_coreSerializersModuleCollector>)collector __attribute__((swift_name("dumpTo(collector:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (id<MultipazKotlinx_serialization_coreKSerializer> _Nullable)getContextualKClass:(id<MultipazKotlinKClass>)kClass typeArgumentsSerializers:(NSArray<id<MultipazKotlinx_serialization_coreKSerializer>> *)typeArgumentsSerializers __attribute__((swift_name("getContextual(kClass:typeArgumentsSerializers:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (id<MultipazKotlinx_serialization_coreSerializationStrategy> _Nullable)getPolymorphicBaseClass:(id<MultipazKotlinKClass>)baseClass value:(id)value __attribute__((swift_name("getPolymorphic(baseClass:value:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (id<MultipazKotlinx_serialization_coreDeserializationStrategy> _Nullable)getPolymorphicBaseClass:(id<MultipazKotlinKClass>)baseClass serializedClassName:(NSString * _Nullable)serializedClassName __attribute__((swift_name("getPolymorphic(baseClass:serializedClassName:)")));
@end

__attribute__((swift_name("KotlinAnnotation")))
@protocol MultipazKotlinAnnotation
@required
@end


/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
__attribute__((swift_name("Kotlinx_serialization_coreSerialKind")))
@interface MultipazKotlinx_serialization_coreSerialKind : MultipazBase
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreCompositeDecoder")))
@protocol MultipazKotlinx_serialization_coreCompositeDecoder
@required
- (BOOL)decodeBooleanElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeBooleanElement(descriptor:index:)")));
- (int8_t)decodeByteElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeByteElement(descriptor:index:)")));
- (unichar)decodeCharElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeCharElement(descriptor:index:)")));
- (int32_t)decodeCollectionSizeDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("decodeCollectionSize(descriptor:)")));
- (double)decodeDoubleElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeDoubleElement(descriptor:index:)")));
- (int32_t)decodeElementIndexDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("decodeElementIndex(descriptor:)")));
- (float)decodeFloatElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeFloatElement(descriptor:index:)")));
- (id<MultipazKotlinx_serialization_coreDecoder>)decodeInlineElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeInlineElement(descriptor:index:)")));
- (int32_t)decodeIntElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeIntElement(descriptor:index:)")));
- (int64_t)decodeLongElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeLongElement(descriptor:index:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (id _Nullable)decodeNullableSerializableElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index deserializer:(id<MultipazKotlinx_serialization_coreDeserializationStrategy>)deserializer previousValue:(id _Nullable)previousValue __attribute__((swift_name("decodeNullableSerializableElement(descriptor:index:deserializer:previousValue:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (BOOL)decodeSequentially __attribute__((swift_name("decodeSequentially()")));
- (id _Nullable)decodeSerializableElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index deserializer:(id<MultipazKotlinx_serialization_coreDeserializationStrategy>)deserializer previousValue:(id _Nullable)previousValue __attribute__((swift_name("decodeSerializableElement(descriptor:index:deserializer:previousValue:)")));
- (int16_t)decodeShortElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeShortElement(descriptor:index:)")));
- (NSString *)decodeStringElementDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeStringElement(descriptor:index:)")));
- (void)endStructureDescriptor:(id<MultipazKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("endStructure(descriptor:)")));
@property (readonly) MultipazKotlinx_serialization_coreSerializersModule *serializersModule __attribute__((swift_name("serializersModule")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinNothing")))
@interface MultipazKotlinNothing : MultipazBase
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeDayOfWeekNames.Companion")))
@interface MultipazKotlinx_datetimeDayOfWeekNamesCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinx_datetimeDayOfWeekNamesCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) MultipazKotlinx_datetimeDayOfWeekNames *ENGLISH_ABBREVIATED __attribute__((swift_name("ENGLISH_ABBREVIATED")));
@property (readonly) MultipazKotlinx_datetimeDayOfWeekNames *ENGLISH_FULL __attribute__((swift_name("ENGLISH_FULL")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeMonthNames.Companion")))
@interface MultipazKotlinx_datetimeMonthNamesCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinx_datetimeMonthNamesCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) MultipazKotlinx_datetimeMonthNames *ENGLISH_ABBREVIATED __attribute__((swift_name("ENGLISH_ABBREVIATED")));
@property (readonly) MultipazKotlinx_datetimeMonthNames *ENGLISH_FULL __attribute__((swift_name("ENGLISH_FULL")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeUtcOffset.Companion")))
@interface MultipazKotlinx_datetimeUtcOffsetCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinx_datetimeUtcOffsetCompanion *shared __attribute__((swift_name("shared")));
- (id<MultipazKotlinx_datetimeDateTimeFormat>)FormatBlock:(void (^)(id<MultipazKotlinx_datetimeDateTimeFormatBuilderWithUtcOffset>))block __attribute__((swift_name("Format(block:)")));
- (MultipazKotlinx_datetimeUtcOffset *)parseInput:(id)input format:(id<MultipazKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("parse(input:format:)")));
- (id<MultipazKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@property (readonly) MultipazKotlinx_datetimeUtcOffset *ZERO __attribute__((swift_name("ZERO")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpUrl.Companion")))
@interface MultipazKtor_httpUrlCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKtor_httpUrlCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((swift_name("Ktor_httpParameters")))
@protocol MultipazKtor_httpParameters <MultipazKtor_utilsStringValues>
@required
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpURLProtocol")))
@interface MultipazKtor_httpURLProtocol : MultipazBase
- (instancetype)initWithName:(NSString *)name defaultPort:(int32_t)defaultPort __attribute__((swift_name("init(name:defaultPort:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazKtor_httpURLProtocolCompanion *companion __attribute__((swift_name("companion")));
- (MultipazKtor_httpURLProtocol *)doCopyName:(NSString *)name defaultPort:(int32_t)defaultPort __attribute__((swift_name("doCopy(name:defaultPort:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t defaultPort __attribute__((swift_name("defaultPort")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpMethod.Companion")))
@interface MultipazKtor_httpHttpMethodCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKtor_httpHttpMethodCompanion *shared __attribute__((swift_name("shared")));
- (MultipazKtor_httpHttpMethod *)parseMethod:(NSString *)method __attribute__((swift_name("parse(method:)")));
@property (readonly) NSArray<MultipazKtor_httpHttpMethod *> *DefaultMethods __attribute__((swift_name("DefaultMethods")));
@property (readonly) MultipazKtor_httpHttpMethod *Delete __attribute__((swift_name("Delete")));
@property (readonly) MultipazKtor_httpHttpMethod *Get __attribute__((swift_name("Get")));
@property (readonly) MultipazKtor_httpHttpMethod *Head __attribute__((swift_name("Head")));
@property (readonly) MultipazKtor_httpHttpMethod *Options __attribute__((swift_name("Options")));
@property (readonly) MultipazKtor_httpHttpMethod *Patch __attribute__((swift_name("Patch")));
@property (readonly) MultipazKtor_httpHttpMethod *Post __attribute__((swift_name("Post")));
@property (readonly) MultipazKtor_httpHttpMethod *Put __attribute__((swift_name("Put")));
@end

__attribute__((swift_name("KotlinMapEntry")))
@protocol MultipazKotlinMapEntry
@required
@property (readonly) id _Nullable key __attribute__((swift_name("key")));
@property (readonly) id _Nullable value_ __attribute__((swift_name("value_")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsAttributeKey")))
@interface MultipazKtor_utilsAttributeKey<T> : MultipazBase
- (instancetype)initWithName:(NSString *)name __attribute__((swift_name("init(name:)"))) __attribute__((objc_designated_initializer));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end

__attribute__((swift_name("Ktor_httpHeaderValueWithParameters")))
@interface MultipazKtor_httpHeaderValueWithParameters : MultipazBase
- (instancetype)initWithContent:(NSString *)content parameters:(NSArray<MultipazKtor_httpHeaderValueParam *> *)parameters __attribute__((swift_name("init(content:parameters:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazKtor_httpHeaderValueWithParametersCompanion *companion __attribute__((swift_name("companion")));
- (NSString * _Nullable)parameterName:(NSString *)name __attribute__((swift_name("parameter(name:)")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) NSString *content __attribute__((swift_name("content")));
@property (readonly) NSArray<MultipazKtor_httpHeaderValueParam *> *parameters __attribute__((swift_name("parameters")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpContentType")))
@interface MultipazKtor_httpContentType : MultipazKtor_httpHeaderValueWithParameters
- (instancetype)initWithContentType:(NSString *)contentType contentSubtype:(NSString *)contentSubtype parameters:(NSArray<MultipazKtor_httpHeaderValueParam *> *)parameters __attribute__((swift_name("init(contentType:contentSubtype:parameters:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithContent:(NSString *)content parameters:(NSArray<MultipazKtor_httpHeaderValueParam *> *)parameters __attribute__((swift_name("init(content:parameters:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazKtor_httpContentTypeCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (BOOL)matchPattern:(MultipazKtor_httpContentType *)pattern __attribute__((swift_name("match(pattern:)")));
- (BOOL)matchPattern_:(NSString *)pattern __attribute__((swift_name("match(pattern_:)")));
- (MultipazKtor_httpContentType *)withParameterName:(NSString *)name value:(NSString *)value __attribute__((swift_name("withParameter(name:value:)")));
- (MultipazKtor_httpContentType *)withoutParameters __attribute__((swift_name("withoutParameters()")));
@property (readonly) NSString *contentSubtype __attribute__((swift_name("contentSubtype")));
@property (readonly) NSString *contentType __attribute__((swift_name("contentType")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreChildHandle")))
@protocol MultipazKotlinx_coroutines_coreChildHandle <MultipazKotlinx_coroutines_coreDisposableHandle>
@required
- (BOOL)childCancelledCause:(MultipazKotlinThrowable *)cause __attribute__((swift_name("childCancelled(cause:)")));
@property (readonly) id<MultipazKotlinx_coroutines_coreJob> _Nullable parent __attribute__((swift_name("parent")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreChildJob")))
@protocol MultipazKotlinx_coroutines_coreChildJob <MultipazKotlinx_coroutines_coreJob>
@required
- (void)parentCancelledParentJob:(id<MultipazKotlinx_coroutines_coreParentJob>)parentJob __attribute__((swift_name("parentCancelled(parentJob:)")));
@end

__attribute__((swift_name("KotlinSequence")))
@protocol MultipazKotlinSequence
@required
- (id<MultipazKotlinIterator>)iterator __attribute__((swift_name("iterator()")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreSelectClause0")))
@protocol MultipazKotlinx_coroutines_coreSelectClause0 <MultipazKotlinx_coroutines_coreSelectClause>
@required
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpStatusCode.Companion")))
@interface MultipazKtor_httpHttpStatusCodeCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKtor_httpHttpStatusCodeCompanion *shared __attribute__((swift_name("shared")));
- (MultipazKtor_httpHttpStatusCode *)fromValueValue:(int32_t)value __attribute__((swift_name("fromValue(value:)")));
@property (readonly) MultipazKtor_httpHttpStatusCode *Accepted __attribute__((swift_name("Accepted")));
@property (readonly) MultipazKtor_httpHttpStatusCode *BadGateway __attribute__((swift_name("BadGateway")));
@property (readonly) MultipazKtor_httpHttpStatusCode *BadRequest __attribute__((swift_name("BadRequest")));
@property (readonly) MultipazKtor_httpHttpStatusCode *Conflict __attribute__((swift_name("Conflict")));
@property (readonly) MultipazKtor_httpHttpStatusCode *Continue __attribute__((swift_name("Continue")));
@property (readonly) MultipazKtor_httpHttpStatusCode *Created __attribute__((swift_name("Created")));
@property (readonly) MultipazKtor_httpHttpStatusCode *ExpectationFailed __attribute__((swift_name("ExpectationFailed")));
@property (readonly) MultipazKtor_httpHttpStatusCode *FailedDependency __attribute__((swift_name("FailedDependency")));
@property (readonly) MultipazKtor_httpHttpStatusCode *Forbidden __attribute__((swift_name("Forbidden")));
@property (readonly) MultipazKtor_httpHttpStatusCode *Found __attribute__((swift_name("Found")));
@property (readonly) MultipazKtor_httpHttpStatusCode *GatewayTimeout __attribute__((swift_name("GatewayTimeout")));
@property (readonly) MultipazKtor_httpHttpStatusCode *Gone __attribute__((swift_name("Gone")));
@property (readonly) MultipazKtor_httpHttpStatusCode *InsufficientStorage __attribute__((swift_name("InsufficientStorage")));
@property (readonly) MultipazKtor_httpHttpStatusCode *InternalServerError __attribute__((swift_name("InternalServerError")));
@property (readonly) MultipazKtor_httpHttpStatusCode *LengthRequired __attribute__((swift_name("LengthRequired")));
@property (readonly) MultipazKtor_httpHttpStatusCode *Locked __attribute__((swift_name("Locked")));
@property (readonly) MultipazKtor_httpHttpStatusCode *MethodNotAllowed __attribute__((swift_name("MethodNotAllowed")));
@property (readonly) MultipazKtor_httpHttpStatusCode *MovedPermanently __attribute__((swift_name("MovedPermanently")));
@property (readonly) MultipazKtor_httpHttpStatusCode *MultiStatus __attribute__((swift_name("MultiStatus")));
@property (readonly) MultipazKtor_httpHttpStatusCode *MultipleChoices __attribute__((swift_name("MultipleChoices")));
@property (readonly) MultipazKtor_httpHttpStatusCode *NoContent __attribute__((swift_name("NoContent")));
@property (readonly) MultipazKtor_httpHttpStatusCode *NonAuthoritativeInformation __attribute__((swift_name("NonAuthoritativeInformation")));
@property (readonly) MultipazKtor_httpHttpStatusCode *NotAcceptable __attribute__((swift_name("NotAcceptable")));
@property (readonly) MultipazKtor_httpHttpStatusCode *NotFound __attribute__((swift_name("NotFound")));
@property (readonly) MultipazKtor_httpHttpStatusCode *NotImplemented __attribute__((swift_name("NotImplemented")));
@property (readonly) MultipazKtor_httpHttpStatusCode *NotModified __attribute__((swift_name("NotModified")));
@property (readonly) MultipazKtor_httpHttpStatusCode *OK __attribute__((swift_name("OK")));
@property (readonly) MultipazKtor_httpHttpStatusCode *PartialContent __attribute__((swift_name("PartialContent")));
@property (readonly) MultipazKtor_httpHttpStatusCode *PayloadTooLarge __attribute__((swift_name("PayloadTooLarge")));
@property (readonly) MultipazKtor_httpHttpStatusCode *PaymentRequired __attribute__((swift_name("PaymentRequired")));
@property (readonly) MultipazKtor_httpHttpStatusCode *PermanentRedirect __attribute__((swift_name("PermanentRedirect")));
@property (readonly) MultipazKtor_httpHttpStatusCode *PreconditionFailed __attribute__((swift_name("PreconditionFailed")));
@property (readonly) MultipazKtor_httpHttpStatusCode *Processing __attribute__((swift_name("Processing")));
@property (readonly) MultipazKtor_httpHttpStatusCode *ProxyAuthenticationRequired __attribute__((swift_name("ProxyAuthenticationRequired")));
@property (readonly) MultipazKtor_httpHttpStatusCode *RequestHeaderFieldTooLarge __attribute__((swift_name("RequestHeaderFieldTooLarge")));
@property (readonly) MultipazKtor_httpHttpStatusCode *RequestTimeout __attribute__((swift_name("RequestTimeout")));
@property (readonly) MultipazKtor_httpHttpStatusCode *RequestURITooLong __attribute__((swift_name("RequestURITooLong")));
@property (readonly) MultipazKtor_httpHttpStatusCode *RequestedRangeNotSatisfiable __attribute__((swift_name("RequestedRangeNotSatisfiable")));
@property (readonly) MultipazKtor_httpHttpStatusCode *ResetContent __attribute__((swift_name("ResetContent")));
@property (readonly) MultipazKtor_httpHttpStatusCode *SeeOther __attribute__((swift_name("SeeOther")));
@property (readonly) MultipazKtor_httpHttpStatusCode *ServiceUnavailable __attribute__((swift_name("ServiceUnavailable")));
@property (readonly) MultipazKtor_httpHttpStatusCode *SwitchProxy __attribute__((swift_name("SwitchProxy")));
@property (readonly) MultipazKtor_httpHttpStatusCode *SwitchingProtocols __attribute__((swift_name("SwitchingProtocols")));
@property (readonly) MultipazKtor_httpHttpStatusCode *TemporaryRedirect __attribute__((swift_name("TemporaryRedirect")));
@property (readonly) MultipazKtor_httpHttpStatusCode *TooEarly __attribute__((swift_name("TooEarly")));
@property (readonly) MultipazKtor_httpHttpStatusCode *TooManyRequests __attribute__((swift_name("TooManyRequests")));
@property (readonly) MultipazKtor_httpHttpStatusCode *Unauthorized __attribute__((swift_name("Unauthorized")));
@property (readonly) MultipazKtor_httpHttpStatusCode *UnprocessableEntity __attribute__((swift_name("UnprocessableEntity")));
@property (readonly) MultipazKtor_httpHttpStatusCode *UnsupportedMediaType __attribute__((swift_name("UnsupportedMediaType")));
@property (readonly) MultipazKtor_httpHttpStatusCode *UpgradeRequired __attribute__((swift_name("UpgradeRequired")));
@property (readonly) MultipazKtor_httpHttpStatusCode *UseProxy __attribute__((swift_name("UseProxy")));
@property (readonly) MultipazKtor_httpHttpStatusCode *VariantAlsoNegotiates __attribute__((swift_name("VariantAlsoNegotiates")));
@property (readonly) MultipazKtor_httpHttpStatusCode *VersionNotSupported __attribute__((swift_name("VersionNotSupported")));
@property (readonly) NSArray<MultipazKtor_httpHttpStatusCode *> *allStatusCodes __attribute__((swift_name("allStatusCodes")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsGMTDate.Companion")))
@interface MultipazKtor_utilsGMTDateCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKtor_utilsGMTDateCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) MultipazKtor_utilsGMTDate *START __attribute__((swift_name("START")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsWeekDay")))
@interface MultipazKtor_utilsWeekDay : MultipazKotlinEnum<MultipazKtor_utilsWeekDay *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazKtor_utilsWeekDayCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) MultipazKtor_utilsWeekDay *monday __attribute__((swift_name("monday")));
@property (class, readonly) MultipazKtor_utilsWeekDay *tuesday __attribute__((swift_name("tuesday")));
@property (class, readonly) MultipazKtor_utilsWeekDay *wednesday __attribute__((swift_name("wednesday")));
@property (class, readonly) MultipazKtor_utilsWeekDay *thursday __attribute__((swift_name("thursday")));
@property (class, readonly) MultipazKtor_utilsWeekDay *friday __attribute__((swift_name("friday")));
@property (class, readonly) MultipazKtor_utilsWeekDay *saturday __attribute__((swift_name("saturday")));
@property (class, readonly) MultipazKtor_utilsWeekDay *sunday __attribute__((swift_name("sunday")));
+ (MultipazKotlinArray<MultipazKtor_utilsWeekDay *> *)values __attribute__((swift_name("values()")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsMonth")))
@interface MultipazKtor_utilsMonth : MultipazKotlinEnum<MultipazKtor_utilsMonth *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazKtor_utilsMonthCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) MultipazKtor_utilsMonth *january __attribute__((swift_name("january")));
@property (class, readonly) MultipazKtor_utilsMonth *february __attribute__((swift_name("february")));
@property (class, readonly) MultipazKtor_utilsMonth *march __attribute__((swift_name("march")));
@property (class, readonly) MultipazKtor_utilsMonth *april __attribute__((swift_name("april")));
@property (class, readonly) MultipazKtor_utilsMonth *may __attribute__((swift_name("may")));
@property (class, readonly) MultipazKtor_utilsMonth *june __attribute__((swift_name("june")));
@property (class, readonly) MultipazKtor_utilsMonth *july __attribute__((swift_name("july")));
@property (class, readonly) MultipazKtor_utilsMonth *august __attribute__((swift_name("august")));
@property (class, readonly) MultipazKtor_utilsMonth *september __attribute__((swift_name("september")));
@property (class, readonly) MultipazKtor_utilsMonth *october __attribute__((swift_name("october")));
@property (class, readonly) MultipazKtor_utilsMonth *november __attribute__((swift_name("november")));
@property (class, readonly) MultipazKtor_utilsMonth *december __attribute__((swift_name("december")));
+ (MultipazKotlinArray<MultipazKtor_utilsMonth *> *)values __attribute__((swift_name("values()")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpProtocolVersion.Companion")))
@interface MultipazKtor_httpHttpProtocolVersionCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKtor_httpHttpProtocolVersionCompanion *shared __attribute__((swift_name("shared")));
- (MultipazKtor_httpHttpProtocolVersion *)fromValueName:(NSString *)name major:(int32_t)major minor:(int32_t)minor __attribute__((swift_name("fromValue(name:major:minor:)")));
- (MultipazKtor_httpHttpProtocolVersion *)parseValue:(id)value __attribute__((swift_name("parse(value:)")));
@property (readonly) MultipazKtor_httpHttpProtocolVersion *HTTP_1_0 __attribute__((swift_name("HTTP_1_0")));
@property (readonly) MultipazKtor_httpHttpProtocolVersion *HTTP_1_1 __attribute__((swift_name("HTTP_1_1")));
@property (readonly) MultipazKtor_httpHttpProtocolVersion *HTTP_2_0 __attribute__((swift_name("HTTP_2_0")));
@property (readonly) MultipazKtor_httpHttpProtocolVersion *QUIC __attribute__((swift_name("QUIC")));
@property (readonly) MultipazKtor_httpHttpProtocolVersion *SPDY_3 __attribute__((swift_name("SPDY_3")));
@end

__attribute__((swift_name("Ktor_client_coreHttpClientPlugin")))
@protocol MultipazKtor_client_coreHttpClientPlugin
@required
- (void)installPlugin:(id)plugin scope:(MultipazKtor_client_coreHttpClient *)scope __attribute__((swift_name("install(plugin:scope:)")));
- (id)prepareBlock:(void (^)(id))block __attribute__((swift_name("prepare(block:)")));
@property (readonly) MultipazKtor_utilsAttributeKey<id> *key __attribute__((swift_name("key")));
@end

__attribute__((swift_name("Ktor_eventsEventDefinition")))
@interface MultipazKtor_eventsEventDefinition<T> : MultipazBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsPipelinePhase")))
@interface MultipazKtor_utilsPipelinePhase : MultipazBase
- (instancetype)initWithName:(NSString *)name __attribute__((swift_name("init(name:)"))) __attribute__((objc_designated_initializer));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpReceivePipeline.Phases")))
@interface MultipazKtor_client_coreHttpReceivePipelinePhases : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)phases __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKtor_client_coreHttpReceivePipelinePhases *shared __attribute__((swift_name("shared")));
@property (readonly) MultipazKtor_utilsPipelinePhase *After __attribute__((swift_name("After")));
@property (readonly) MultipazKtor_utilsPipelinePhase *Before __attribute__((swift_name("Before")));
@property (readonly) MultipazKtor_utilsPipelinePhase *State __attribute__((swift_name("State")));
@end

__attribute__((swift_name("Ktor_httpHttpMessage")))
@protocol MultipazKtor_httpHttpMessage
@required
@property (readonly) id<MultipazKtor_httpHeaders> headers __attribute__((swift_name("headers")));
@end

__attribute__((swift_name("Ktor_client_coreHttpResponse")))
@interface MultipazKtor_client_coreHttpResponse : MultipazBase <MultipazKtor_httpHttpMessage, MultipazKotlinx_coroutines_coreCoroutineScope>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKtor_client_coreHttpClientCall *call __attribute__((swift_name("call")));
@property (readonly) id<MultipazKtor_ioByteReadChannel> content __attribute__((swift_name("content")));
@property (readonly) MultipazKtor_utilsGMTDate *requestTime __attribute__((swift_name("requestTime")));
@property (readonly) MultipazKtor_utilsGMTDate *responseTime __attribute__((swift_name("responseTime")));
@property (readonly) MultipazKtor_httpHttpStatusCode *status __attribute__((swift_name("status")));
@property (readonly) MultipazKtor_httpHttpProtocolVersion *version __attribute__((swift_name("version")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpRequestPipeline.Phases")))
@interface MultipazKtor_client_coreHttpRequestPipelinePhases : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)phases __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKtor_client_coreHttpRequestPipelinePhases *shared __attribute__((swift_name("shared")));
@property (readonly) MultipazKtor_utilsPipelinePhase *Before __attribute__((swift_name("Before")));
@property (readonly) MultipazKtor_utilsPipelinePhase *Render __attribute__((swift_name("Render")));
@property (readonly) MultipazKtor_utilsPipelinePhase *Send __attribute__((swift_name("Send")));
@property (readonly) MultipazKtor_utilsPipelinePhase *State __attribute__((swift_name("State")));
@property (readonly) MultipazKtor_utilsPipelinePhase *Transform __attribute__((swift_name("Transform")));
@end

__attribute__((swift_name("Ktor_httpHttpMessageBuilder")))
@protocol MultipazKtor_httpHttpMessageBuilder
@required
@property (readonly) MultipazKtor_httpHeadersBuilder *headers __attribute__((swift_name("headers")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpRequestBuilder")))
@interface MultipazKtor_client_coreHttpRequestBuilder : MultipazBase <MultipazKtor_httpHttpMessageBuilder>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (class, readonly, getter=companion) MultipazKtor_client_coreHttpRequestBuilderCompanion *companion __attribute__((swift_name("companion")));
- (MultipazKtor_client_coreHttpRequestData *)build __attribute__((swift_name("build()")));
- (id _Nullable)getCapabilityOrNullKey:(id<MultipazKtor_client_coreHttpClientEngineCapability>)key __attribute__((swift_name("getCapabilityOrNull(key:)")));
- (void)setAttributesBlock:(void (^)(id<MultipazKtor_utilsAttributes>))block __attribute__((swift_name("setAttributes(block:)")));
- (void)setCapabilityKey:(id<MultipazKtor_client_coreHttpClientEngineCapability>)key capability:(id)capability __attribute__((swift_name("setCapability(key:capability:)")));
- (MultipazKtor_client_coreHttpRequestBuilder *)takeFromBuilder:(MultipazKtor_client_coreHttpRequestBuilder *)builder __attribute__((swift_name("takeFrom(builder:)")));
- (MultipazKtor_client_coreHttpRequestBuilder *)takeFromWithExecutionContextBuilder:(MultipazKtor_client_coreHttpRequestBuilder *)builder __attribute__((swift_name("takeFromWithExecutionContext(builder:)")));
- (void)urlBlock:(void (^)(MultipazKtor_httpURLBuilder *, MultipazKtor_httpURLBuilder *))block __attribute__((swift_name("url(block:)")));
@property (readonly) id<MultipazKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));
@property id body __attribute__((swift_name("body")));
@property MultipazKtor_utilsTypeInfo * _Nullable bodyType __attribute__((swift_name("bodyType")));
@property (readonly) id<MultipazKotlinx_coroutines_coreJob> executionContext __attribute__((swift_name("executionContext")));
@property (readonly) MultipazKtor_httpHeadersBuilder *headers __attribute__((swift_name("headers")));
@property MultipazKtor_httpHttpMethod *method __attribute__((swift_name("method")));
@property (readonly) MultipazKtor_httpURLBuilder *url __attribute__((swift_name("url")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpResponsePipeline.Phases")))
@interface MultipazKtor_client_coreHttpResponsePipelinePhases : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)phases __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKtor_client_coreHttpResponsePipelinePhases *shared __attribute__((swift_name("shared")));
@property (readonly) MultipazKtor_utilsPipelinePhase *After __attribute__((swift_name("After")));
@property (readonly) MultipazKtor_utilsPipelinePhase *Parse __attribute__((swift_name("Parse")));
@property (readonly) MultipazKtor_utilsPipelinePhase *Receive __attribute__((swift_name("Receive")));
@property (readonly) MultipazKtor_utilsPipelinePhase *State __attribute__((swift_name("State")));
@property (readonly) MultipazKtor_utilsPipelinePhase *Transform __attribute__((swift_name("Transform")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpResponseContainer")))
@interface MultipazKtor_client_coreHttpResponseContainer : MultipazBase
- (instancetype)initWithExpectedType:(MultipazKtor_utilsTypeInfo *)expectedType response:(id)response __attribute__((swift_name("init(expectedType:response:)"))) __attribute__((objc_designated_initializer));
- (MultipazKtor_client_coreHttpResponseContainer *)doCopyExpectedType:(MultipazKtor_utilsTypeInfo *)expectedType response:(id)response __attribute__((swift_name("doCopy(expectedType:response:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) MultipazKtor_utilsTypeInfo *expectedType __attribute__((swift_name("expectedType")));
@property (readonly) id response __attribute__((swift_name("response")));
@end

__attribute__((swift_name("Ktor_client_coreHttpClientCall")))
@interface MultipazKtor_client_coreHttpClientCall : MultipazBase <MultipazKotlinx_coroutines_coreCoroutineScope>
- (instancetype)initWithClient:(MultipazKtor_client_coreHttpClient *)client __attribute__((swift_name("init(client:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithClient:(MultipazKtor_client_coreHttpClient *)client requestData:(MultipazKtor_client_coreHttpRequestData *)requestData responseData:(MultipazKtor_client_coreHttpResponseData *)responseData __attribute__((swift_name("init(client:requestData:responseData:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazKtor_client_coreHttpClientCallCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)bodyInfo:(MultipazKtor_utilsTypeInfo *)info completionHandler:(void (^)(id _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("body(info:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)bodyNullableInfo:(MultipazKtor_utilsTypeInfo *)info completionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("bodyNullable(info:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)getResponseContentWithCompletionHandler:(void (^)(id<MultipazKtor_ioByteReadChannel> _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getResponseContent(completionHandler:)")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) BOOL allowDoubleReceive __attribute__((swift_name("allowDoubleReceive")));
@property (readonly) id<MultipazKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));
@property (readonly) MultipazKtor_client_coreHttpClient *client __attribute__((swift_name("client")));
@property (readonly) id<MultipazKotlinCoroutineContext> coroutineContext __attribute__((swift_name("coroutineContext")));
@property id<MultipazKtor_client_coreHttpRequest> request __attribute__((swift_name("request")));
@property MultipazKtor_client_coreHttpResponse *response __attribute__((swift_name("response")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpSendPipeline.Phases")))
@interface MultipazKtor_client_coreHttpSendPipelinePhases : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)phases __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKtor_client_coreHttpSendPipelinePhases *shared __attribute__((swift_name("shared")));
@property (readonly) MultipazKtor_utilsPipelinePhase *Before __attribute__((swift_name("Before")));
@property (readonly) MultipazKtor_utilsPipelinePhase *Engine __attribute__((swift_name("Engine")));
@property (readonly) MultipazKtor_utilsPipelinePhase *Monitoring __attribute__((swift_name("Monitoring")));
@property (readonly) MultipazKtor_utilsPipelinePhase *Receive __attribute__((swift_name("Receive")));
@property (readonly) MultipazKtor_utilsPipelinePhase *State __attribute__((swift_name("State")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
__attribute__((swift_name("Kotlinx_serialization_coreSerializersModuleCollector")))
@protocol MultipazKotlinx_serialization_coreSerializersModuleCollector
@required
- (void)contextualKClass:(id<MultipazKotlinKClass>)kClass provider:(id<MultipazKotlinx_serialization_coreKSerializer> (^)(NSArray<id<MultipazKotlinx_serialization_coreKSerializer>> *))provider __attribute__((swift_name("contextual(kClass:provider:)")));
- (void)contextualKClass:(id<MultipazKotlinKClass>)kClass serializer:(id<MultipazKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("contextual(kClass:serializer:)")));
- (void)polymorphicBaseClass:(id<MultipazKotlinKClass>)baseClass actualClass:(id<MultipazKotlinKClass>)actualClass actualSerializer:(id<MultipazKotlinx_serialization_coreKSerializer>)actualSerializer __attribute__((swift_name("polymorphic(baseClass:actualClass:actualSerializer:)")));
- (void)polymorphicDefaultBaseClass:(id<MultipazKotlinKClass>)baseClass defaultDeserializerProvider:(id<MultipazKotlinx_serialization_coreDeserializationStrategy> _Nullable (^)(NSString * _Nullable))defaultDeserializerProvider __attribute__((swift_name("polymorphicDefault(baseClass:defaultDeserializerProvider:)"))) __attribute__((deprecated("Deprecated in favor of function with more precise name: polymorphicDefaultDeserializer")));
- (void)polymorphicDefaultDeserializerBaseClass:(id<MultipazKotlinKClass>)baseClass defaultDeserializerProvider:(id<MultipazKotlinx_serialization_coreDeserializationStrategy> _Nullable (^)(NSString * _Nullable))defaultDeserializerProvider __attribute__((swift_name("polymorphicDefaultDeserializer(baseClass:defaultDeserializerProvider:)")));
- (void)polymorphicDefaultSerializerBaseClass:(id<MultipazKotlinKClass>)baseClass defaultSerializerProvider:(id<MultipazKotlinx_serialization_coreSerializationStrategy> _Nullable (^)(id))defaultSerializerProvider __attribute__((swift_name("polymorphicDefaultSerializer(baseClass:defaultSerializerProvider:)")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilderWithUtcOffset")))
@protocol MultipazKotlinx_datetimeDateTimeFormatBuilderWithUtcOffset <MultipazKotlinx_datetimeDateTimeFormatBuilder>
@required
- (void)offsetFormat:(id<MultipazKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("offset(format:)")));
- (void)offsetHoursPadding:(MultipazKotlinx_datetimePadding *)padding __attribute__((swift_name("offsetHours(padding:)")));
- (void)offsetMinutesOfHourPadding:(MultipazKotlinx_datetimePadding *)padding __attribute__((swift_name("offsetMinutesOfHour(padding:)")));
- (void)offsetSecondsOfMinutePadding:(MultipazKotlinx_datetimePadding *)padding __attribute__((swift_name("offsetSecondsOfMinute(padding:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpURLProtocol.Companion")))
@interface MultipazKtor_httpURLProtocolCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKtor_httpURLProtocolCompanion *shared __attribute__((swift_name("shared")));
- (MultipazKtor_httpURLProtocol *)createOrDefaultName:(NSString *)name __attribute__((swift_name("createOrDefault(name:)")));
@property (readonly) MultipazKtor_httpURLProtocol *HTTP __attribute__((swift_name("HTTP")));
@property (readonly) MultipazKtor_httpURLProtocol *HTTPS __attribute__((swift_name("HTTPS")));
@property (readonly) MultipazKtor_httpURLProtocol *SOCKS __attribute__((swift_name("SOCKS")));
@property (readonly) MultipazKtor_httpURLProtocol *WS __attribute__((swift_name("WS")));
@property (readonly) MultipazKtor_httpURLProtocol *WSS __attribute__((swift_name("WSS")));
@property (readonly) NSDictionary<NSString *, MultipazKtor_httpURLProtocol *> *byName __attribute__((swift_name("byName")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHeaderValueParam")))
@interface MultipazKtor_httpHeaderValueParam : MultipazBase
- (instancetype)initWithName:(NSString *)name value:(NSString *)value __attribute__((swift_name("init(name:value:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithName:(NSString *)name value:(NSString *)value escapeValue:(BOOL)escapeValue __attribute__((swift_name("init(name:value:escapeValue:)"))) __attribute__((objc_designated_initializer));
- (MultipazKtor_httpHeaderValueParam *)doCopyName:(NSString *)name value:(NSString *)value escapeValue:(BOOL)escapeValue __attribute__((swift_name("doCopy(name:value:escapeValue:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) BOOL escapeValue __attribute__((swift_name("escapeValue")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHeaderValueWithParameters.Companion")))
@interface MultipazKtor_httpHeaderValueWithParametersCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKtor_httpHeaderValueWithParametersCompanion *shared __attribute__((swift_name("shared")));
- (id _Nullable)parseValue:(NSString *)value init:(id _Nullable (^)(NSString *, NSArray<MultipazKtor_httpHeaderValueParam *> *))init __attribute__((swift_name("parse(value:init:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpContentType.Companion")))
@interface MultipazKtor_httpContentTypeCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKtor_httpContentTypeCompanion *shared __attribute__((swift_name("shared")));
- (MultipazKtor_httpContentType *)parseValue:(NSString *)value __attribute__((swift_name("parse(value:)")));
@property (readonly) MultipazKtor_httpContentType *Any __attribute__((swift_name("Any")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreParentJob")))
@protocol MultipazKotlinx_coroutines_coreParentJob <MultipazKotlinx_coroutines_coreJob>
@required
- (MultipazKotlinCancellationException *)getChildJobCancellationCause __attribute__((swift_name("getChildJobCancellationCause()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsWeekDay.Companion")))
@interface MultipazKtor_utilsWeekDayCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKtor_utilsWeekDayCompanion *shared __attribute__((swift_name("shared")));
- (MultipazKtor_utilsWeekDay *)fromOrdinal:(int32_t)ordinal __attribute__((swift_name("from(ordinal:)")));
- (MultipazKtor_utilsWeekDay *)fromValue:(NSString *)value __attribute__((swift_name("from(value:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsMonth.Companion")))
@interface MultipazKtor_utilsMonthCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKtor_utilsMonthCompanion *shared __attribute__((swift_name("shared")));
- (MultipazKtor_utilsMonth *)fromOrdinal:(int32_t)ordinal __attribute__((swift_name("from(ordinal:)")));
- (MultipazKtor_utilsMonth *)fromValue:(NSString *)value __attribute__((swift_name("from(value:)")));
@end

__attribute__((swift_name("Ktor_ioByteReadChannel")))
@protocol MultipazKtor_ioByteReadChannel
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)awaitContentWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("awaitContent(completionHandler:)")));
- (BOOL)cancelCause_:(MultipazKotlinThrowable * _Nullable)cause __attribute__((swift_name("cancel(cause_:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)discardMax:(int64_t)max completionHandler:(void (^)(MultipazLong * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("discard(max:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)peekToDestination:(MultipazKtor_ioMemory *)destination destinationOffset:(int64_t)destinationOffset offset:(int64_t)offset min:(int64_t)min max:(int64_t)max completionHandler:(void (^)(MultipazLong * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("peekTo(destination:destinationOffset:offset:min:max:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)readAvailableDst:(MultipazKtor_ioChunkBuffer *)dst completionHandler:(void (^)(MultipazInt * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("readAvailable(dst:completionHandler:)")));
- (int32_t)readAvailableMin:(int32_t)min block:(void (^)(MultipazKtor_ioBuffer *))block __attribute__((swift_name("readAvailable(min:block:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)readAvailableDst:(MultipazKotlinByteArray *)dst offset:(int32_t)offset length:(int32_t)length completionHandler:(void (^)(MultipazInt * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("readAvailable(dst:offset:length:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)readAvailableDst:(void *)dst offset:(int32_t)offset length:(int32_t)length completionHandler_:(void (^)(MultipazInt * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("readAvailable(dst:offset:length:completionHandler_:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)readAvailableDst:(void *)dst offset:(int64_t)offset length:(int64_t)length completionHandler__:(void (^)(MultipazInt * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("readAvailable(dst:offset:length:completionHandler__:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)readBooleanWithCompletionHandler:(void (^)(MultipazBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("readBoolean(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)readByteWithCompletionHandler:(void (^)(MultipazByte * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("readByte(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)readDoubleWithCompletionHandler:(void (^)(MultipazDouble * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("readDouble(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)readFloatWithCompletionHandler:(void (^)(MultipazFloat * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("readFloat(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)readFullyDst:(MultipazKtor_ioChunkBuffer *)dst n:(int32_t)n completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("readFully(dst:n:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)readFullyDst:(MultipazKotlinByteArray *)dst offset:(int32_t)offset length:(int32_t)length completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("readFully(dst:offset:length:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)readFullyDst:(void *)dst offset:(int32_t)offset length:(int32_t)length completionHandler_:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("readFully(dst:offset:length:completionHandler_:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)readFullyDst:(void *)dst offset:(int64_t)offset length:(int64_t)length completionHandler__:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("readFully(dst:offset:length:completionHandler__:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)readIntWithCompletionHandler:(void (^)(MultipazInt * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("readInt(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)readLongWithCompletionHandler:(void (^)(MultipazLong * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("readLong(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)readPacketSize:(int32_t)size completionHandler:(void (^)(MultipazKtor_ioByteReadPacket * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("readPacket(size:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)readRemainingLimit:(int64_t)limit completionHandler:(void (^)(MultipazKtor_ioByteReadPacket * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("readRemaining(limit:completionHandler:)")));
- (void)readSessionConsumer:(void (^)(id<MultipazKtor_ioReadSession>))consumer __attribute__((swift_name("readSession(consumer:)"))) __attribute__((deprecated("Use read { } instead.")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)readShortWithCompletionHandler:(void (^)(MultipazShort * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("readShort(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)readSuspendableSessionConsumer:(id<MultipazKotlinSuspendFunction1>)consumer completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("readSuspendableSession(consumer:completionHandler:)"))) __attribute__((deprecated("Use read { } instead.")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)readUTF8LineLimit:(int32_t)limit completionHandler:(void (^)(NSString * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("readUTF8Line(limit:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)readUTF8LineToOut:(id<MultipazKotlinAppendable>)out limit:(int32_t)limit completionHandler:(void (^)(MultipazBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("readUTF8LineTo(out:limit:completionHandler:)")));
@property (readonly) int32_t availableForRead __attribute__((swift_name("availableForRead")));
@property (readonly) MultipazKotlinThrowable * _Nullable closedCause __attribute__((swift_name("closedCause")));
@property (readonly) BOOL isClosedForRead __attribute__((swift_name("isClosedForRead")));
@property (readonly) BOOL isClosedForWrite __attribute__((swift_name("isClosedForWrite")));
@property (readonly) int64_t totalBytesRead __attribute__((swift_name("totalBytesRead")));
@end

__attribute__((swift_name("Ktor_utilsStringValuesBuilder")))
@protocol MultipazKtor_utilsStringValuesBuilder
@required
- (void)appendName:(NSString *)name value:(NSString *)value __attribute__((swift_name("append(name:value:)")));
- (void)appendAllStringValues:(id<MultipazKtor_utilsStringValues>)stringValues __attribute__((swift_name("appendAll(stringValues:)")));
- (void)appendAllName:(NSString *)name values:(id)values __attribute__((swift_name("appendAll(name:values:)")));
- (void)appendMissingStringValues:(id<MultipazKtor_utilsStringValues>)stringValues __attribute__((swift_name("appendMissing(stringValues:)")));
- (void)appendMissingName:(NSString *)name values:(id)values __attribute__((swift_name("appendMissing(name:values:)")));
- (id<MultipazKtor_utilsStringValues>)build __attribute__((swift_name("build()")));
- (void)clear __attribute__((swift_name("clear()")));
- (BOOL)containsName:(NSString *)name __attribute__((swift_name("contains(name:)")));
- (BOOL)containsName:(NSString *)name value:(NSString *)value __attribute__((swift_name("contains(name:value:)")));
- (NSSet<id<MultipazKotlinMapEntry>> *)entries __attribute__((swift_name("entries()")));
- (NSString * _Nullable)getName:(NSString *)name __attribute__((swift_name("get(name:)")));
- (NSArray<NSString *> * _Nullable)getAllName:(NSString *)name __attribute__((swift_name("getAll(name:)")));
- (BOOL)isEmpty __attribute__((swift_name("isEmpty()")));
- (NSSet<NSString *> *)names __attribute__((swift_name("names()")));
- (void)removeName:(NSString *)name __attribute__((swift_name("remove(name:)")));
- (BOOL)removeName:(NSString *)name value:(NSString *)value __attribute__((swift_name("remove(name:value:)")));
- (void)removeKeysWithNoEntries __attribute__((swift_name("removeKeysWithNoEntries()")));
- (void)setName:(NSString *)name value:(NSString *)value __attribute__((swift_name("set(name:value:)")));
@property (readonly) BOOL caseInsensitiveName __attribute__((swift_name("caseInsensitiveName")));
@end

__attribute__((swift_name("Ktor_utilsStringValuesBuilderImpl")))
@interface MultipazKtor_utilsStringValuesBuilderImpl : MultipazBase <MultipazKtor_utilsStringValuesBuilder>
- (instancetype)initWithCaseInsensitiveName:(BOOL)caseInsensitiveName size:(int32_t)size __attribute__((swift_name("init(caseInsensitiveName:size:)"))) __attribute__((objc_designated_initializer));
- (void)appendName:(NSString *)name value:(NSString *)value __attribute__((swift_name("append(name:value:)")));
- (void)appendAllStringValues:(id<MultipazKtor_utilsStringValues>)stringValues __attribute__((swift_name("appendAll(stringValues:)")));
- (void)appendAllName:(NSString *)name values:(id)values __attribute__((swift_name("appendAll(name:values:)")));
- (void)appendMissingStringValues:(id<MultipazKtor_utilsStringValues>)stringValues __attribute__((swift_name("appendMissing(stringValues:)")));
- (void)appendMissingName:(NSString *)name values:(id)values __attribute__((swift_name("appendMissing(name:values:)")));
- (id<MultipazKtor_utilsStringValues>)build __attribute__((swift_name("build()")));
- (void)clear __attribute__((swift_name("clear()")));
- (BOOL)containsName:(NSString *)name __attribute__((swift_name("contains(name:)")));
- (BOOL)containsName:(NSString *)name value:(NSString *)value __attribute__((swift_name("contains(name:value:)")));
- (NSSet<id<MultipazKotlinMapEntry>> *)entries __attribute__((swift_name("entries()")));
- (NSString * _Nullable)getName:(NSString *)name __attribute__((swift_name("get(name:)")));
- (NSArray<NSString *> * _Nullable)getAllName:(NSString *)name __attribute__((swift_name("getAll(name:)")));
- (BOOL)isEmpty __attribute__((swift_name("isEmpty()")));
- (NSSet<NSString *> *)names __attribute__((swift_name("names()")));
- (void)removeName:(NSString *)name __attribute__((swift_name("remove(name:)")));
- (BOOL)removeName:(NSString *)name value:(NSString *)value __attribute__((swift_name("remove(name:value:)")));
- (void)removeKeysWithNoEntries __attribute__((swift_name("removeKeysWithNoEntries()")));
- (void)setName:(NSString *)name value:(NSString *)value __attribute__((swift_name("set(name:value:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)validateNameName:(NSString *)name __attribute__((swift_name("validateName(name:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)validateValueValue:(NSString *)value __attribute__((swift_name("validateValue(value:)")));
@property (readonly) BOOL caseInsensitiveName __attribute__((swift_name("caseInsensitiveName")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) MultipazMutableDictionary<NSString *, NSMutableArray<NSString *> *> *values __attribute__((swift_name("values")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHeadersBuilder")))
@interface MultipazKtor_httpHeadersBuilder : MultipazKtor_utilsStringValuesBuilderImpl
- (instancetype)initWithSize:(int32_t)size __attribute__((swift_name("init(size:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCaseInsensitiveName:(BOOL)caseInsensitiveName size:(int32_t)size __attribute__((swift_name("init(caseInsensitiveName:size:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (id<MultipazKtor_httpHeaders>)build __attribute__((swift_name("build()")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)validateNameName:(NSString *)name __attribute__((swift_name("validateName(name:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)validateValueValue:(NSString *)value __attribute__((swift_name("validateValue(value:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpRequestBuilder.Companion")))
@interface MultipazKtor_client_coreHttpRequestBuilderCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKtor_client_coreHttpRequestBuilderCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpURLBuilder")))
@interface MultipazKtor_httpURLBuilder : MultipazBase
- (instancetype)initWithProtocol:(MultipazKtor_httpURLProtocol *)protocol host:(NSString *)host port:(int32_t)port user:(NSString * _Nullable)user password:(NSString * _Nullable)password pathSegments:(NSArray<NSString *> *)pathSegments parameters:(id<MultipazKtor_httpParameters>)parameters fragment:(NSString *)fragment trailingQuery:(BOOL)trailingQuery __attribute__((swift_name("init(protocol:host:port:user:password:pathSegments:parameters:fragment:trailingQuery:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazKtor_httpURLBuilderCompanion *companion __attribute__((swift_name("companion")));
- (MultipazKtor_httpUrl *)build __attribute__((swift_name("build()")));
- (NSString *)buildString __attribute__((swift_name("buildString()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property NSString *encodedFragment __attribute__((swift_name("encodedFragment")));
@property id<MultipazKtor_httpParametersBuilder> encodedParameters __attribute__((swift_name("encodedParameters")));
@property NSString * _Nullable encodedPassword __attribute__((swift_name("encodedPassword")));
@property NSArray<NSString *> *encodedPathSegments __attribute__((swift_name("encodedPathSegments")));
@property NSString * _Nullable encodedUser __attribute__((swift_name("encodedUser")));
@property NSString *fragment __attribute__((swift_name("fragment")));
@property NSString *host __attribute__((swift_name("host")));
@property (readonly) id<MultipazKtor_httpParametersBuilder> parameters __attribute__((swift_name("parameters")));
@property NSString * _Nullable password __attribute__((swift_name("password")));
@property NSArray<NSString *> *pathSegments __attribute__((swift_name("pathSegments")));
@property int32_t port __attribute__((swift_name("port")));
@property MultipazKtor_httpURLProtocol *protocol __attribute__((swift_name("protocol")));
@property BOOL trailingQuery __attribute__((swift_name("trailingQuery")));
@property NSString * _Nullable user __attribute__((swift_name("user")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsTypeInfo")))
@interface MultipazKtor_utilsTypeInfo : MultipazBase
- (instancetype)initWithType:(id<MultipazKotlinKClass>)type reifiedType:(id<MultipazKotlinKType>)reifiedType kotlinType:(id<MultipazKotlinKType> _Nullable)kotlinType __attribute__((swift_name("init(type:reifiedType:kotlinType:)"))) __attribute__((objc_designated_initializer));
- (MultipazKtor_utilsTypeInfo *)doCopyType:(id<MultipazKotlinKClass>)type reifiedType:(id<MultipazKotlinKType>)reifiedType kotlinType:(id<MultipazKotlinKType> _Nullable)kotlinType __attribute__((swift_name("doCopy(type:reifiedType:kotlinType:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) id<MultipazKotlinKType> _Nullable kotlinType __attribute__((swift_name("kotlinType")));
@property (readonly) id<MultipazKotlinKType> reifiedType __attribute__((swift_name("reifiedType")));
@property (readonly) id<MultipazKotlinKClass> type __attribute__((swift_name("type")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpClientCall.Companion")))
@interface MultipazKtor_client_coreHttpClientCallCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKtor_client_coreHttpClientCallCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) MultipazKtor_utilsAttributeKey<id> *CustomResponse __attribute__((swift_name("CustomResponse"))) __attribute__((unavailable("This is going to be removed. Please file a ticket with clarification why and what for do you need it.")));
@end

__attribute__((swift_name("Ktor_client_coreHttpRequest")))
@protocol MultipazKtor_client_coreHttpRequest <MultipazKtor_httpHttpMessage, MultipazKotlinx_coroutines_coreCoroutineScope>
@required
@property (readonly) id<MultipazKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));
@property (readonly) MultipazKtor_client_coreHttpClientCall *call __attribute__((swift_name("call")));
@property (readonly) MultipazKtor_httpOutgoingContent *content __attribute__((swift_name("content")));
@property (readonly) MultipazKtor_httpHttpMethod *method __attribute__((swift_name("method")));
@property (readonly) MultipazKtor_httpUrl *url __attribute__((swift_name("url")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_ioMemory")))
@interface MultipazKtor_ioMemory : MultipazBase
- (instancetype)initWithPointer:(void *)pointer size:(int64_t)size __attribute__((swift_name("init(pointer:size:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazKtor_ioMemoryCompanion *companion __attribute__((swift_name("companion")));
- (void)doCopyToDestination:(MultipazKtor_ioMemory *)destination offset:(int32_t)offset length:(int32_t)length destinationOffset:(int32_t)destinationOffset __attribute__((swift_name("doCopyTo(destination:offset:length:destinationOffset:)")));
- (void)doCopyToDestination:(MultipazKtor_ioMemory *)destination offset:(int64_t)offset length:(int64_t)length destinationOffset_:(int64_t)destinationOffset __attribute__((swift_name("doCopyTo(destination:offset:length:destinationOffset_:)")));
- (int8_t)loadAtIndex:(int32_t)index __attribute__((swift_name("loadAt(index:)")));
- (int8_t)loadAtIndex_:(int64_t)index __attribute__((swift_name("loadAt(index_:)")));
- (MultipazKtor_ioMemory *)sliceOffset:(int32_t)offset length:(int32_t)length __attribute__((swift_name("slice(offset:length:)")));
- (MultipazKtor_ioMemory *)sliceOffset:(int64_t)offset length_:(int64_t)length __attribute__((swift_name("slice(offset:length_:)")));
- (void)storeAtIndex:(int32_t)index value:(int8_t)value __attribute__((swift_name("storeAt(index:value:)")));
- (void)storeAtIndex:(int64_t)index value_:(int8_t)value __attribute__((swift_name("storeAt(index:value_:)")));
@property (readonly) void *pointer __attribute__((swift_name("pointer")));
@property (readonly) int64_t size __attribute__((swift_name("size")));
@property (readonly) int32_t size32 __attribute__((swift_name("size32")));
@end

__attribute__((swift_name("Ktor_ioBuffer")))
@interface MultipazKtor_ioBuffer : MultipazBase
- (instancetype)initWithMemory:(MultipazKtor_ioMemory *)memory __attribute__((swift_name("init(memory:)"))) __attribute__((objc_designated_initializer)) __attribute__((deprecated("\n    We're migrating to the new kotlinx-io library.\n    This declaration is deprecated and will be removed in Ktor 4.0.0\n    If you have any problems with migration, please contact us in \n    https://youtrack.jetbrains.com/issue/KTOR-6030/Migrate-to-new-kotlinx.io-library\n    ")));
@property (class, readonly, getter=companion) MultipazKtor_ioBufferCompanion *companion __attribute__((swift_name("companion")));
- (void)commitWrittenCount:(int32_t)count __attribute__((swift_name("commitWritten(count:)")));
- (void)discardExactCount:(int32_t)count __attribute__((swift_name("discardExact(count:)")));
- (MultipazKtor_ioBuffer *)duplicate __attribute__((swift_name("duplicate()")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)duplicateToCopy:(MultipazKtor_ioBuffer *)copy __attribute__((swift_name("duplicateTo(copy:)")));
- (int8_t)readByte __attribute__((swift_name("readByte()")));
- (void)reserveEndGapEndGap:(int32_t)endGap __attribute__((swift_name("reserveEndGap(endGap:)")));
- (void)reserveStartGapStartGap:(int32_t)startGap __attribute__((swift_name("reserveStartGap(startGap:)")));
- (void)reset __attribute__((swift_name("reset()")));
- (void)resetForRead __attribute__((swift_name("resetForRead()")));
- (void)resetForWrite __attribute__((swift_name("resetForWrite()")));
- (void)resetForWriteLimit:(int32_t)limit __attribute__((swift_name("resetForWrite(limit:)")));
- (void)rewindCount:(int32_t)count __attribute__((swift_name("rewind(count:)")));
- (NSString *)description __attribute__((swift_name("description()")));
- (int32_t)tryPeekByte __attribute__((swift_name("tryPeekByte()")));
- (int32_t)tryReadByte __attribute__((swift_name("tryReadByte()")));
- (void)writeByteValue:(int8_t)value __attribute__((swift_name("writeByte(value:)")));
@property (readonly) int32_t capacity __attribute__((swift_name("capacity")));
@property (readonly) int32_t endGap __attribute__((swift_name("endGap")));
@property (readonly) int32_t limit __attribute__((swift_name("limit")));
@property (readonly) MultipazKtor_ioMemory *memory __attribute__((swift_name("memory")));
@property (readonly) int32_t readPosition __attribute__((swift_name("readPosition")));
@property (readonly) int32_t readRemaining __attribute__((swift_name("readRemaining")));
@property (readonly) int32_t startGap __attribute__((swift_name("startGap")));
@property (readonly) int32_t writePosition __attribute__((swift_name("writePosition")));
@property (readonly) int32_t writeRemaining __attribute__((swift_name("writeRemaining")));
@end

__attribute__((swift_name("Ktor_ioChunkBuffer")))
@interface MultipazKtor_ioChunkBuffer : MultipazKtor_ioBuffer
- (instancetype)initWithMemory:(MultipazKtor_ioMemory *)memory origin:(MultipazKtor_ioChunkBuffer * _Nullable)origin parentPool:(id<MultipazKtor_ioObjectPool> _Nullable)parentPool __attribute__((swift_name("init(memory:origin:parentPool:)"))) __attribute__((objc_designated_initializer)) __attribute__((deprecated("\n    We're migrating to the new kotlinx-io library.\n    This declaration is deprecated and will be removed in Ktor 4.0.0\n    If you have any problems with migration, please contact us in \n    https://youtrack.jetbrains.com/issue/KTOR-6030/Migrate-to-new-kotlinx.io-library\n    ")));
- (instancetype)initWithMemory:(MultipazKtor_ioMemory *)memory __attribute__((swift_name("init(memory:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazKtor_ioChunkBufferCompanion *companion __attribute__((swift_name("companion")));
- (MultipazKtor_ioChunkBuffer * _Nullable)cleanNext __attribute__((swift_name("cleanNext()")));
- (MultipazKtor_ioChunkBuffer *)duplicate __attribute__((swift_name("duplicate()")));
- (void)releasePool:(id<MultipazKtor_ioObjectPool>)pool __attribute__((swift_name("release(pool:)")));
- (void)reset __attribute__((swift_name("reset()")));
@property (getter=next_) MultipazKtor_ioChunkBuffer * _Nullable next __attribute__((swift_name("next")));
@property (readonly) MultipazKtor_ioChunkBuffer * _Nullable origin __attribute__((swift_name("origin")));
@property (readonly) int32_t referenceCount __attribute__((swift_name("referenceCount")));
@end

__attribute__((swift_name("Ktor_ioInput")))
@interface MultipazKtor_ioInput : MultipazBase <MultipazKtor_ioCloseable>
- (instancetype)initWithHead:(MultipazKtor_ioChunkBuffer *)head remaining:(int64_t)remaining pool:(id<MultipazKtor_ioObjectPool>)pool __attribute__((swift_name("init(head:remaining:pool:)"))) __attribute__((objc_designated_initializer)) __attribute__((deprecated("\n    We're migrating to the new kotlinx-io library.\n    This declaration is deprecated and will be removed in Ktor 4.0.0\n    If you have any problems with migration, please contact us in \n    https://youtrack.jetbrains.com/issue/KTOR-6030/Migrate-to-new-kotlinx.io-library\n    ")));
@property (class, readonly, getter=companion) MultipazKtor_ioInputCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)canRead __attribute__((swift_name("canRead()")));
- (void)close __attribute__((swift_name("close()")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)closeSource __attribute__((swift_name("closeSource()")));
- (int32_t)discardN:(int32_t)n __attribute__((swift_name("discard(n:)")));
- (int64_t)discardN_:(int64_t)n __attribute__((swift_name("discard(n_:)")));
- (void)discardExactN:(int32_t)n __attribute__((swift_name("discardExact(n:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (MultipazKtor_ioChunkBuffer * _Nullable)fill __attribute__((swift_name("fill()")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (int32_t)fillDestination:(MultipazKtor_ioMemory *)destination offset:(int32_t)offset length:(int32_t)length __attribute__((swift_name("fill(destination:offset:length:)")));
- (BOOL)hasBytesN:(int32_t)n __attribute__((swift_name("hasBytes(n:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)markNoMoreChunksAvailable __attribute__((swift_name("markNoMoreChunksAvailable()")));
- (int32_t)peekToBuffer:(MultipazKtor_ioChunkBuffer *)buffer __attribute__((swift_name("peekTo(buffer:)")));
- (int64_t)peekToDestination:(MultipazKtor_ioMemory *)destination destinationOffset:(int64_t)destinationOffset offset:(int64_t)offset min:(int64_t)min max:(int64_t)max __attribute__((swift_name("peekTo(destination:destinationOffset:offset:min:max:)")));
- (int8_t)readByte __attribute__((swift_name("readByte()")));
- (NSString *)readTextMin:(int32_t)min max:(int32_t)max __attribute__((swift_name("readText(min:max:)")));
- (int32_t)readTextOut:(id<MultipazKotlinAppendable>)out min:(int32_t)min max:(int32_t)max __attribute__((swift_name("readText(out:min:max:)")));
- (NSString *)readTextExactExactCharacters:(int32_t)exactCharacters __attribute__((swift_name("readTextExact(exactCharacters:)")));
- (void)readTextExactOut:(id<MultipazKotlinAppendable>)out exactCharacters:(int32_t)exactCharacters __attribute__((swift_name("readTextExact(out:exactCharacters:)")));
- (void)release_ __attribute__((swift_name("release()")));
- (int32_t)tryPeek __attribute__((swift_name("tryPeek()")));
@property (readonly) BOOL endOfInput __attribute__((swift_name("endOfInput")));
@property (readonly) id<MultipazKtor_ioObjectPool> pool __attribute__((swift_name("pool")));
@property (readonly) int64_t remaining __attribute__((swift_name("remaining")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_ioByteReadPacket")))
@interface MultipazKtor_ioByteReadPacket : MultipazKtor_ioInput
- (instancetype)initWithHead:(MultipazKtor_ioChunkBuffer *)head pool:(id<MultipazKtor_ioObjectPool>)pool __attribute__((swift_name("init(head:pool:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithHead:(MultipazKtor_ioChunkBuffer *)head remaining:(int64_t)remaining pool:(id<MultipazKtor_ioObjectPool>)pool __attribute__((swift_name("init(head:remaining:pool:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) MultipazKtor_ioByteReadPacketCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)closeSource __attribute__((swift_name("closeSource()")));
- (MultipazKtor_ioByteReadPacket *)doCopy __attribute__((swift_name("doCopy()")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (MultipazKtor_ioChunkBuffer * _Nullable)fill __attribute__((swift_name("fill()")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (int32_t)fillDestination:(MultipazKtor_ioMemory *)destination offset:(int32_t)offset length:(int32_t)length __attribute__((swift_name("fill(destination:offset:length:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@end

__attribute__((swift_name("Ktor_ioReadSession")))
@protocol MultipazKtor_ioReadSession
@required
- (int32_t)discardN:(int32_t)n __attribute__((swift_name("discard(n:)")));
- (MultipazKtor_ioChunkBuffer * _Nullable)requestAtLeast:(int32_t)atLeast __attribute__((swift_name("request(atLeast:)")));
@property (readonly) int32_t availableForRead __attribute__((swift_name("availableForRead")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpURLBuilder.Companion")))
@interface MultipazKtor_httpURLBuilderCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKtor_httpURLBuilderCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((swift_name("Ktor_httpParametersBuilder")))
@protocol MultipazKtor_httpParametersBuilder <MultipazKtor_utilsStringValuesBuilder>
@required
@end

__attribute__((swift_name("KotlinKType")))
@protocol MultipazKotlinKType
@required

/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
@property (readonly) NSArray<MultipazKotlinKTypeProjection *> *arguments __attribute__((swift_name("arguments")));

/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
@property (readonly) id<MultipazKotlinKClassifier> _Nullable classifier __attribute__((swift_name("classifier")));
@property (readonly) BOOL isMarkedNullable __attribute__((swift_name("isMarkedNullable")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_ioMemory.Companion")))
@interface MultipazKtor_ioMemoryCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKtor_ioMemoryCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) MultipazKtor_ioMemory *Empty __attribute__((swift_name("Empty")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_ioBuffer.Companion")))
@interface MultipazKtor_ioBufferCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKtor_ioBufferCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) MultipazKtor_ioBuffer *Empty __attribute__((swift_name("Empty")));
@property (readonly) int32_t ReservedSize __attribute__((swift_name("ReservedSize")));
@end

__attribute__((swift_name("Ktor_ioObjectPool")))
@protocol MultipazKtor_ioObjectPool <MultipazKtor_ioCloseable>
@required
- (id)borrow __attribute__((swift_name("borrow()")));
- (void)dispose __attribute__((swift_name("dispose()")));
- (void)recycleInstance:(id)instance __attribute__((swift_name("recycle(instance:)")));
@property (readonly) int32_t capacity __attribute__((swift_name("capacity")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_ioChunkBuffer.Companion")))
@interface MultipazKtor_ioChunkBufferCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKtor_ioChunkBufferCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) MultipazKtor_ioChunkBuffer *Empty __attribute__((swift_name("Empty")));
@property (readonly) id<MultipazKtor_ioObjectPool> EmptyPool __attribute__((swift_name("EmptyPool")));
@property (readonly) id<MultipazKtor_ioObjectPool> Pool __attribute__((swift_name("Pool")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_ioInput.Companion")))
@interface MultipazKtor_ioInputCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKtor_ioInputCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_ioByteReadPacket.Companion")))
@interface MultipazKtor_ioByteReadPacketCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKtor_ioByteReadPacketCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) MultipazKtor_ioByteReadPacket *Empty __attribute__((swift_name("Empty")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinKTypeProjection")))
@interface MultipazKotlinKTypeProjection : MultipazBase
- (instancetype)initWithVariance:(MultipazKotlinKVariance * _Nullable)variance type:(id<MultipazKotlinKType> _Nullable)type __attribute__((swift_name("init(variance:type:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) MultipazKotlinKTypeProjectionCompanion *companion __attribute__((swift_name("companion")));
- (MultipazKotlinKTypeProjection *)doCopyVariance:(MultipazKotlinKVariance * _Nullable)variance type:(id<MultipazKotlinKType> _Nullable)type __attribute__((swift_name("doCopy(variance:type:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) id<MultipazKotlinKType> _Nullable type __attribute__((swift_name("type")));
@property (readonly) MultipazKotlinKVariance * _Nullable variance __attribute__((swift_name("variance")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinKVariance")))
@interface MultipazKotlinKVariance : MultipazKotlinEnum<MultipazKotlinKVariance *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) MultipazKotlinKVariance *invariant __attribute__((swift_name("invariant")));
@property (class, readonly) MultipazKotlinKVariance *in __attribute__((swift_name("in")));
@property (class, readonly) MultipazKotlinKVariance *out __attribute__((swift_name("out")));
+ (MultipazKotlinArray<MultipazKotlinKVariance *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<MultipazKotlinKVariance *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinKTypeProjection.Companion")))
@interface MultipazKotlinKTypeProjectionCompanion : MultipazBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) MultipazKotlinKTypeProjectionCompanion *shared __attribute__((swift_name("shared")));

/**
 * @note annotations
 *   kotlin.jvm.JvmStatic
*/
- (MultipazKotlinKTypeProjection *)contravariantType:(id<MultipazKotlinKType>)type __attribute__((swift_name("contravariant(type:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmStatic
*/
- (MultipazKotlinKTypeProjection *)covariantType:(id<MultipazKotlinKType>)type __attribute__((swift_name("covariant(type:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmStatic
*/
- (MultipazKotlinKTypeProjection *)invariantType:(id<MultipazKotlinKType>)type __attribute__((swift_name("invariant(type:)")));
@property (readonly) MultipazKotlinKTypeProjection *STAR __attribute__((swift_name("STAR")));
@end

#pragma pop_macro("_Nullable_result")
#pragma clang diagnostic pop
NS_ASSUME_NONNULL_END
